/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.jsoup.helper;

import io.quarkus.launcher.shaded.javax.xml.parsers.DocumentBuilder;
import io.quarkus.launcher.shaded.javax.xml.parsers.DocumentBuilderFactory;
import io.quarkus.launcher.shaded.javax.xml.parsers.ParserConfigurationException;
import io.quarkus.launcher.shaded.javax.xml.transform.Result;
import io.quarkus.launcher.shaded.javax.xml.transform.Source;
import io.quarkus.launcher.shaded.javax.xml.transform.Transformer;
import io.quarkus.launcher.shaded.javax.xml.transform.TransformerException;
import io.quarkus.launcher.shaded.javax.xml.transform.TransformerFactory;
import io.quarkus.launcher.shaded.javax.xml.transform.dom.DOMSource;
import io.quarkus.launcher.shaded.javax.xml.transform.stream.StreamResult;
import io.quarkus.launcher.shaded.org.jsoup.helper.StringUtil;
import io.quarkus.launcher.shaded.org.jsoup.helper.Validate;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Attribute;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Attributes;
import io.quarkus.launcher.shaded.org.jsoup.nodes.DataNode;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Element;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Node;
import io.quarkus.launcher.shaded.org.jsoup.nodes.TextNode;
import io.quarkus.launcher.shaded.org.jsoup.select.NodeTraversor;
import io.quarkus.launcher.shaded.org.jsoup.select.NodeVisitor;
import io.quarkus.launcher.shaded.org.w3c.dom.Comment;
import io.quarkus.launcher.shaded.org.w3c.dom.Document;
import io.quarkus.launcher.shaded.org.w3c.dom.Text;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Stack;

public class W3CDom {
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public Document fromJsoup(io.quarkus.launcher.shaded.org.jsoup.nodes.Document in) {
        Validate.notNull(in);
        try {
            this.factory.setNamespaceAware(true);
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            Document out = builder.newDocument();
            this.convert(in, out);
            return out;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public void convert(io.quarkus.launcher.shaded.org.jsoup.nodes.Document in, Document out) {
        if (!StringUtil.isBlank(in.location())) {
            out.setDocumentURI(in.location());
        }
        Element rootEl = in.child(0);
        NodeTraversor.traverse((NodeVisitor)new W3CBuilder(out), rootEl);
    }

    public String asString(Document doc) {
        try {
            DOMSource domSource = new DOMSource((io.quarkus.launcher.shaded.org.w3c.dom.Node)doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult((Writer)writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform((Source)domSource, (Result)result);
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static class W3CBuilder
    implements NodeVisitor {
        private static final String xmlnsKey = "io.quarkus.launcher.shaded.xmlns";
        private static final String xmlnsPrefix = "io.quarkus.launcher.shaded.xmlns:";
        private final Document doc;
        private final Stack<HashMap<String, String>> namespacesStack = new Stack();
        private io.quarkus.launcher.shaded.org.w3c.dom.Element dest;

        public W3CBuilder(Document doc) {
            this.doc = doc;
            this.namespacesStack.push(new HashMap());
        }

        @Override
        public void head(Node source, int depth) {
            this.namespacesStack.push(new HashMap(this.namespacesStack.peek()));
            if (source instanceof Element) {
                Element sourceEl = (Element)source;
                String prefix = this.updateNamespaces(sourceEl);
                String namespace = this.namespacesStack.peek().get(prefix);
                io.quarkus.launcher.shaded.org.w3c.dom.Element el = this.doc.createElementNS(namespace, sourceEl.tagName());
                this.copyAttributes(sourceEl, el);
                if (this.dest == null) {
                    this.doc.appendChild((io.quarkus.launcher.shaded.org.w3c.dom.Node)el);
                } else {
                    this.dest.appendChild((io.quarkus.launcher.shaded.org.w3c.dom.Node)el);
                }
                this.dest = el;
            } else if (source instanceof TextNode) {
                TextNode sourceText = (TextNode)source;
                Text text = this.doc.createTextNode(sourceText.getWholeText());
                this.dest.appendChild((io.quarkus.launcher.shaded.org.w3c.dom.Node)text);
            } else if (source instanceof io.quarkus.launcher.shaded.org.jsoup.nodes.Comment) {
                io.quarkus.launcher.shaded.org.jsoup.nodes.Comment sourceComment = (io.quarkus.launcher.shaded.org.jsoup.nodes.Comment)source;
                Comment comment = this.doc.createComment(sourceComment.getData());
                this.dest.appendChild((io.quarkus.launcher.shaded.org.w3c.dom.Node)comment);
            } else if (source instanceof DataNode) {
                DataNode sourceData = (DataNode)source;
                Text node = this.doc.createTextNode(sourceData.getWholeData());
                this.dest.appendChild((io.quarkus.launcher.shaded.org.w3c.dom.Node)node);
            }
        }

        @Override
        public void tail(Node source, int depth) {
            if (source instanceof Element && this.dest.getParentNode() instanceof io.quarkus.launcher.shaded.org.w3c.dom.Element) {
                this.dest = (io.quarkus.launcher.shaded.org.w3c.dom.Element)this.dest.getParentNode();
            }
            this.namespacesStack.pop();
        }

        private void copyAttributes(Node source, io.quarkus.launcher.shaded.org.w3c.dom.Element el) {
            for (Attribute attribute : source.attributes()) {
                String key = attribute.getKey().replaceAll("io.quarkus.launcher.shaded.[^-a-zA-Z0-9_:.]", "io.quarkus.launcher.shaded.");
                if (!key.matches("io.quarkus.launcher.shaded.[a-zA-Z_:][-a-zA-Z0-9_:.]*")) continue;
                el.setAttribute(key, attribute.getValue());
            }
        }

        private String updateNamespaces(Element el) {
            Attributes attributes = el.attributes();
            for (Attribute attr : attributes) {
                String prefix;
                String key = attr.getKey();
                if (key.equals(xmlnsKey)) {
                    prefix = "io.quarkus.launcher.shaded.";
                } else {
                    if (!key.startsWith(xmlnsPrefix)) continue;
                    prefix = key.substring(xmlnsPrefix.length());
                }
                this.namespacesStack.peek().put(prefix, attr.getValue());
            }
            int pos = el.tagName().indexOf("io.quarkus.launcher.shaded.:");
            return pos > 0 ? el.tagName().substring(0, pos) : "io.quarkus.launcher.shaded.";
        }
    }
}

