/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.jsoup.nodes;

import io.quarkus.launcher.shaded.org.jsoup.SerializationException;
import io.quarkus.launcher.shaded.org.jsoup.helper.Validate;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Attributes;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Document;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Entities;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class Attribute
implements Map.Entry<String, String>,
Cloneable {
    private static final String[] booleanAttributes = new String[]{"io.quarkus.launcher.shaded.allowfullscreen", "io.quarkus.launcher.shaded.async", "io.quarkus.launcher.shaded.autofocus", "io.quarkus.launcher.shaded.checked", "io.quarkus.launcher.shaded.compact", "io.quarkus.launcher.shaded.declare", "io.quarkus.launcher.shaded.default", "io.quarkus.launcher.shaded.defer", "io.quarkus.launcher.shaded.disabled", "io.quarkus.launcher.shaded.formnovalidate", "io.quarkus.launcher.shaded.hidden", "io.quarkus.launcher.shaded.inert", "io.quarkus.launcher.shaded.ismap", "io.quarkus.launcher.shaded.itemscope", "io.quarkus.launcher.shaded.multiple", "io.quarkus.launcher.shaded.muted", "io.quarkus.launcher.shaded.nohref", "io.quarkus.launcher.shaded.noresize", "io.quarkus.launcher.shaded.noshade", "io.quarkus.launcher.shaded.novalidate", "io.quarkus.launcher.shaded.nowrap", "io.quarkus.launcher.shaded.open", "io.quarkus.launcher.shaded.readonly", "io.quarkus.launcher.shaded.required", "io.quarkus.launcher.shaded.reversed", "io.quarkus.launcher.shaded.seamless", "io.quarkus.launcher.shaded.selected", "io.quarkus.launcher.shaded.sortable", "io.quarkus.launcher.shaded.truespeed", "io.quarkus.launcher.shaded.typemustmatch"};
    private String key;
    private String val;
    Attributes parent;

    public Attribute(String key, String value) {
        this(key, value, null);
    }

    public Attribute(String key, String val, Attributes parent) {
        Validate.notNull(key);
        this.key = key.trim();
        Validate.notEmpty(key);
        this.val = val;
        this.parent = parent;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        int i;
        Validate.notNull(key);
        key = key.trim();
        Validate.notEmpty(key);
        if (this.parent != null && (i = this.parent.indexOfKey(this.key)) != -1) {
            this.parent.keys[i] = key;
        }
        this.key = key;
    }

    @Override
    public String getValue() {
        return this.val;
    }

    @Override
    public String setValue(String val) {
        int i;
        String oldVal = this.parent.get(this.key);
        if (this.parent != null && (i = this.parent.indexOfKey(this.key)) != -1) {
            this.parent.vals[i] = val;
        }
        this.val = val;
        return oldVal;
    }

    public String html() {
        StringBuilder accum = new StringBuilder();
        try {
            this.html(accum, new Document("io.quarkus.launcher.shaded.").outputSettings());
        }
        catch (IOException exception) {
            throw new SerializationException(exception);
        }
        return accum.toString();
    }

    protected static void html(String key, String val, Appendable accum, Document.OutputSettings out) throws IOException {
        accum.append(key);
        if (!Attribute.shouldCollapseAttribute(key, val, out)) {
            accum.append("io.quarkus.launcher.shaded.=\"");
            Entities.escape(accum, Attributes.checkNotNull(val), out, true, false, false);
            accum.append('\"');
        }
    }

    protected void html(Appendable accum, Document.OutputSettings out) throws IOException {
        Attribute.html(this.key, this.val, accum, out);
    }

    public String toString() {
        return this.html();
    }

    public static Attribute createFromEncoded(String unencodedKey, String encodedValue) {
        String value = Entities.unescape(encodedValue, true);
        return new Attribute(unencodedKey, value, null);
    }

    protected boolean isDataAttribute() {
        return Attribute.isDataAttribute(this.key);
    }

    protected static boolean isDataAttribute(String key) {
        return key.startsWith("io.quarkus.launcher.shaded.data-") && key.length() > "io.quarkus.launcher.shaded.data-".length();
    }

    protected final boolean shouldCollapseAttribute(Document.OutputSettings out) {
        return Attribute.shouldCollapseAttribute(this.key, this.val, out);
    }

    protected static boolean shouldCollapseAttribute(String key, String val, Document.OutputSettings out) {
        return out.syntax() == Document.OutputSettings.Syntax.html && (val == null || ("io.quarkus.launcher.shaded.".equals(val) || val.equalsIgnoreCase(key)) && Attribute.isBooleanAttribute(key));
    }

    protected boolean isBooleanAttribute() {
        return Arrays.binarySearch(booleanAttributes, this.key) >= 0 || this.val == null;
    }

    protected static boolean isBooleanAttribute(String key) {
        return Arrays.binarySearch(booleanAttributes, key) >= 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (this.key != null ? !this.key.equals(attribute.key) : attribute.key != null) {
            return false;
        }
        return this.val != null ? this.val.equals(attribute.val) : attribute.val == null;
    }

    @Override
    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.val != null ? this.val.hashCode() : 0);
        return result;
    }

    public Attribute clone() {
        try {
            return (Attribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

