/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.jsoup.nodes;

import io.quarkus.launcher.shaded.org.jsoup.helper.StringUtil;
import io.quarkus.launcher.shaded.org.jsoup.helper.Validate;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Element;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Entities;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Node;
import io.quarkus.launcher.shaded.org.jsoup.nodes.TextNode;
import io.quarkus.launcher.shaded.org.jsoup.nodes.XmlDeclaration;
import io.quarkus.launcher.shaded.org.jsoup.parser.ParseSettings;
import io.quarkus.launcher.shaded.org.jsoup.parser.Tag;
import io.quarkus.launcher.shaded.org.jsoup.select.Elements;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;

public class Document
extends Element {
    private OutputSettings outputSettings = new OutputSettings();
    private QuirksMode quirksMode = QuirksMode.noQuirks;
    private String location;
    private boolean updateMetaCharset = false;

    public Document(String baseUri) {
        super(Tag.valueOf("io.quarkus.launcher.shaded.#root", ParseSettings.htmlDefault), baseUri);
        this.location = baseUri;
    }

    public static Document createShell(String baseUri) {
        Validate.notNull(baseUri);
        Document doc = new Document(baseUri);
        Element html = doc.appendElement("io.quarkus.launcher.shaded.html");
        html.appendElement("io.quarkus.launcher.shaded.head");
        html.appendElement("io.quarkus.launcher.shaded.body");
        return doc;
    }

    public String location() {
        return this.location;
    }

    public Element head() {
        return this.findFirstElementByTagName("io.quarkus.launcher.shaded.head", this);
    }

    public Element body() {
        return this.findFirstElementByTagName("io.quarkus.launcher.shaded.body", this);
    }

    public String title() {
        Element titleEl = this.getElementsByTag("io.quarkus.launcher.shaded.title").first();
        return titleEl != null ? StringUtil.normaliseWhitespace(titleEl.text()).trim() : "io.quarkus.launcher.shaded.";
    }

    public void title(String title) {
        Validate.notNull(title);
        Element titleEl = this.getElementsByTag("io.quarkus.launcher.shaded.title").first();
        if (titleEl == null) {
            this.head().appendElement("io.quarkus.launcher.shaded.title").text(title);
        } else {
            titleEl.text(title);
        }
    }

    public Element createElement(String tagName) {
        return new Element(Tag.valueOf(tagName, ParseSettings.preserveCase), this.baseUri());
    }

    public Document normalise() {
        Element htmlEl = this.findFirstElementByTagName("io.quarkus.launcher.shaded.html", this);
        if (htmlEl == null) {
            htmlEl = this.appendElement("io.quarkus.launcher.shaded.html");
        }
        if (this.head() == null) {
            htmlEl.prependElement("io.quarkus.launcher.shaded.head");
        }
        if (this.body() == null) {
            htmlEl.appendElement("io.quarkus.launcher.shaded.body");
        }
        this.normaliseTextNodes(this.head());
        this.normaliseTextNodes(htmlEl);
        this.normaliseTextNodes(this);
        this.normaliseStructure("io.quarkus.launcher.shaded.head", htmlEl);
        this.normaliseStructure("io.quarkus.launcher.shaded.body", htmlEl);
        this.ensureMetaCharsetElement();
        return this;
    }

    private void normaliseTextNodes(Element element) {
        ArrayList<TextNode> toMove = new ArrayList<TextNode>();
        for (Node node : element.childNodes) {
            TextNode tn;
            if (!(node instanceof TextNode) || (tn = (TextNode)node).isBlank()) continue;
            toMove.add(tn);
        }
        for (int i = toMove.size() - 1; i >= 0; --i) {
            Node node;
            node = (Node)toMove.get(i);
            element.removeChild(node);
            this.body().prependChild(new TextNode("io.quarkus.launcher.shaded. "));
            this.body().prependChild(node);
        }
    }

    private void normaliseStructure(String tag, Element htmlEl) {
        Elements elements = this.getElementsByTag(tag);
        Element master = elements.first();
        if (elements.size() > 1) {
            ArrayList<Node> toMove = new ArrayList<Node>();
            for (int i = 1; i < elements.size(); ++i) {
                Node dupe = (Node)elements.get(i);
                toMove.addAll(dupe.ensureChildNodes());
                dupe.remove();
            }
            for (Node dupe : toMove) {
                master.appendChild(dupe);
            }
        }
        if (!master.parent().equals(htmlEl)) {
            htmlEl.appendChild(master);
        }
    }

    private Element findFirstElementByTagName(String tag, Node node) {
        if (node.nodeName().equals(tag)) {
            return (Element)node;
        }
        int size = node.childNodeSize();
        for (int i = 0; i < size; ++i) {
            Element found = this.findFirstElementByTagName(tag, node.childNode(i));
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public String outerHtml() {
        return super.html();
    }

    @Override
    public Element text(String text) {
        this.body().text(text);
        return this;
    }

    @Override
    public String nodeName() {
        return "io.quarkus.launcher.shaded.#document";
    }

    public void charset(Charset charset) {
        this.updateMetaCharsetElement(true);
        this.outputSettings.charset(charset);
        this.ensureMetaCharsetElement();
    }

    public Charset charset() {
        return this.outputSettings.charset();
    }

    public void updateMetaCharsetElement(boolean update) {
        this.updateMetaCharset = update;
    }

    public boolean updateMetaCharsetElement() {
        return this.updateMetaCharset;
    }

    @Override
    public Document clone() {
        Document clone = (Document)super.clone();
        clone.outputSettings = this.outputSettings.clone();
        return clone;
    }

    private void ensureMetaCharsetElement() {
        if (this.updateMetaCharset) {
            OutputSettings.Syntax syntax = this.outputSettings().syntax();
            if (syntax == OutputSettings.Syntax.html) {
                Element metaCharset = this.select("io.quarkus.launcher.shaded.meta[charset]").first();
                if (metaCharset != null) {
                    metaCharset.attr("io.quarkus.launcher.shaded.charset", this.charset().displayName());
                } else {
                    Element head = this.head();
                    if (head != null) {
                        head.appendElement("io.quarkus.launcher.shaded.meta").attr("io.quarkus.launcher.shaded.charset", this.charset().displayName());
                    }
                }
                this.select("io.quarkus.launcher.shaded.meta[name=charset]").remove();
            } else if (syntax == OutputSettings.Syntax.xml) {
                Node node = this.childNodes().get(0);
                if (node instanceof XmlDeclaration) {
                    XmlDeclaration decl = (XmlDeclaration)node;
                    if (decl.name().equals("io.quarkus.launcher.shaded.xml")) {
                        decl.attr("io.quarkus.launcher.shaded.encoding", this.charset().displayName());
                        String version = decl.attr("io.quarkus.launcher.shaded.version");
                        if (version != null) {
                            decl.attr("io.quarkus.launcher.shaded.version", "io.quarkus.launcher.shaded.1.0");
                        }
                    } else {
                        decl = new XmlDeclaration("io.quarkus.launcher.shaded.xml", false);
                        decl.attr("io.quarkus.launcher.shaded.version", "io.quarkus.launcher.shaded.1.0");
                        decl.attr("io.quarkus.launcher.shaded.encoding", this.charset().displayName());
                        this.prependChild(decl);
                    }
                } else {
                    XmlDeclaration decl = new XmlDeclaration("io.quarkus.launcher.shaded.xml", false);
                    decl.attr("io.quarkus.launcher.shaded.version", "io.quarkus.launcher.shaded.1.0");
                    decl.attr("io.quarkus.launcher.shaded.encoding", this.charset().displayName());
                    this.prependChild(decl);
                }
            }
        }
    }

    public OutputSettings outputSettings() {
        return this.outputSettings;
    }

    public Document outputSettings(OutputSettings outputSettings) {
        Validate.notNull(outputSettings);
        this.outputSettings = outputSettings;
        return this;
    }

    public QuirksMode quirksMode() {
        return this.quirksMode;
    }

    public Document quirksMode(QuirksMode quirksMode) {
        this.quirksMode = quirksMode;
        return this;
    }

    public static enum QuirksMode {
        noQuirks,
        quirks,
        limitedQuirks;

    }

    public static class OutputSettings
    implements Cloneable {
        private Entities.EscapeMode escapeMode = Entities.EscapeMode.base;
        private Charset charset;
        private ThreadLocal<CharsetEncoder> encoderThreadLocal = new ThreadLocal();
        Entities.CoreCharset coreCharset;
        private boolean prettyPrint = true;
        private boolean outline = false;
        private int indentAmount = 1;
        private Syntax syntax = Syntax.html;

        public OutputSettings() {
            this.charset(Charset.forName("io.quarkus.launcher.shaded.UTF8"));
        }

        public Entities.EscapeMode escapeMode() {
            return this.escapeMode;
        }

        public OutputSettings escapeMode(Entities.EscapeMode escapeMode) {
            this.escapeMode = escapeMode;
            return this;
        }

        public Charset charset() {
            return this.charset;
        }

        public OutputSettings charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public OutputSettings charset(String charset) {
            this.charset(Charset.forName(charset));
            return this;
        }

        CharsetEncoder prepareEncoder() {
            CharsetEncoder encoder = this.charset.newEncoder();
            this.encoderThreadLocal.set(encoder);
            this.coreCharset = Entities.CoreCharset.byName(encoder.charset().name());
            return encoder;
        }

        CharsetEncoder encoder() {
            CharsetEncoder encoder = this.encoderThreadLocal.get();
            return encoder != null ? encoder : this.prepareEncoder();
        }

        public Syntax syntax() {
            return this.syntax;
        }

        public OutputSettings syntax(Syntax syntax) {
            this.syntax = syntax;
            return this;
        }

        public boolean prettyPrint() {
            return this.prettyPrint;
        }

        public OutputSettings prettyPrint(boolean pretty) {
            this.prettyPrint = pretty;
            return this;
        }

        public boolean outline() {
            return this.outline;
        }

        public OutputSettings outline(boolean outlineMode) {
            this.outline = outlineMode;
            return this;
        }

        public int indentAmount() {
            return this.indentAmount;
        }

        public OutputSettings indentAmount(int indentAmount) {
            Validate.isTrue(indentAmount >= 0);
            this.indentAmount = indentAmount;
            return this;
        }

        public OutputSettings clone() {
            OutputSettings clone;
            try {
                clone = (OutputSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            clone.charset(this.charset.name());
            clone.escapeMode = Entities.EscapeMode.valueOf(this.escapeMode.name());
            return clone;
        }

        public static enum Syntax {
            html,
            xml;

        }
    }
}

