/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.jsoup.nodes;

import io.quarkus.launcher.shaded.org.jsoup.helper.StringUtil;
import io.quarkus.launcher.shaded.org.jsoup.helper.Validate;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Document;
import io.quarkus.launcher.shaded.org.jsoup.nodes.LeafNode;
import java.io.IOException;

public class DocumentType
extends LeafNode {
    public static final String PUBLIC_KEY = "io.quarkus.launcher.shaded.PUBLIC";
    public static final String SYSTEM_KEY = "io.quarkus.launcher.shaded.SYSTEM";
    private static final String NAME = "io.quarkus.launcher.shaded.name";
    private static final String PUB_SYS_KEY = "io.quarkus.launcher.shaded.pubSysKey";
    private static final String PUBLIC_ID = "io.quarkus.launcher.shaded.publicId";
    private static final String SYSTEM_ID = "io.quarkus.launcher.shaded.systemId";

    public DocumentType(String name, String publicId, String systemId) {
        Validate.notNull(name);
        Validate.notNull(publicId);
        Validate.notNull(systemId);
        this.attr(NAME, name);
        this.attr(PUBLIC_ID, publicId);
        if (this.has(PUBLIC_ID)) {
            this.attr(PUB_SYS_KEY, PUBLIC_KEY);
        }
        this.attr(SYSTEM_ID, systemId);
    }

    public DocumentType(String name, String publicId, String systemId, String baseUri) {
        this.attr(NAME, name);
        this.attr(PUBLIC_ID, publicId);
        if (this.has(PUBLIC_ID)) {
            this.attr(PUB_SYS_KEY, PUBLIC_KEY);
        }
        this.attr(SYSTEM_ID, systemId);
    }

    public DocumentType(String name, String pubSysKey, String publicId, String systemId, String baseUri) {
        this.attr(NAME, name);
        if (pubSysKey != null) {
            this.attr(PUB_SYS_KEY, pubSysKey);
        }
        this.attr(PUBLIC_ID, publicId);
        this.attr(SYSTEM_ID, systemId);
    }

    public void setPubSysKey(String value) {
        if (value != null) {
            this.attr(PUB_SYS_KEY, value);
        }
    }

    @Override
    public String nodeName() {
        return "io.quarkus.launcher.shaded.#doctype";
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (out.syntax() == Document.OutputSettings.Syntax.html && !this.has(PUBLIC_ID) && !this.has(SYSTEM_ID)) {
            accum.append("io.quarkus.launcher.shaded.<!doctype");
        } else {
            accum.append("io.quarkus.launcher.shaded.<!DOCTYPE");
        }
        if (this.has(NAME)) {
            accum.append("io.quarkus.launcher.shaded. ").append(this.attr(NAME));
        }
        if (this.has(PUB_SYS_KEY)) {
            accum.append("io.quarkus.launcher.shaded. ").append(this.attr(PUB_SYS_KEY));
        }
        if (this.has(PUBLIC_ID)) {
            accum.append("io.quarkus.launcher.shaded. \"").append(this.attr(PUBLIC_ID)).append('\"');
        }
        if (this.has(SYSTEM_ID)) {
            accum.append("io.quarkus.launcher.shaded. \"").append(this.attr(SYSTEM_ID)).append('\"');
        }
        accum.append('>');
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) {
    }

    private boolean has(String attribute) {
        return !StringUtil.isBlank(this.attr(attribute));
    }
}

