/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.jsoup.nodes;

import io.quarkus.launcher.shaded.org.jsoup.Connection;
import io.quarkus.launcher.shaded.org.jsoup.Jsoup;
import io.quarkus.launcher.shaded.org.jsoup.helper.HttpConnection;
import io.quarkus.launcher.shaded.org.jsoup.helper.Validate;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Attributes;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Element;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Node;
import io.quarkus.launcher.shaded.org.jsoup.parser.Tag;
import io.quarkus.launcher.shaded.org.jsoup.select.Elements;
import java.util.ArrayList;
import java.util.List;

public class FormElement
extends Element {
    private final Elements elements = new Elements();

    public FormElement(Tag tag, String baseUri, Attributes attributes) {
        super(tag, baseUri, attributes);
    }

    public Elements elements() {
        return this.elements;
    }

    public FormElement addElement(Element element) {
        this.elements.add(element);
        return this;
    }

    @Override
    protected void removeChild(Node out) {
        super.removeChild(out);
        this.elements.remove(out);
    }

    public Connection submit() {
        String action = this.hasAttr("io.quarkus.launcher.shaded.action") ? this.absUrl("io.quarkus.launcher.shaded.action") : this.baseUri();
        Validate.notEmpty(action, "io.quarkus.launcher.shaded.Could not determine a form action URL for submit. Ensure you set a base URI when parsing.");
        Connection.Method method = this.attr("io.quarkus.launcher.shaded.method").toUpperCase().equals("io.quarkus.launcher.shaded.POST") ? Connection.Method.POST : Connection.Method.GET;
        return Jsoup.connect(action).data(this.formData()).method(method);
    }

    public List<Connection.KeyVal> formData() {
        ArrayList<Connection.KeyVal> data = new ArrayList<Connection.KeyVal>();
        for (Element el : this.elements) {
            String name;
            if (!el.tag().isFormSubmittable() || el.hasAttr("io.quarkus.launcher.shaded.disabled") || (name = el.attr("io.quarkus.launcher.shaded.name")).length() == 0) continue;
            String type = el.attr("io.quarkus.launcher.shaded.type");
            if ("io.quarkus.launcher.shaded.select".equals(el.tagName())) {
                Element option;
                Elements options = el.select("io.quarkus.launcher.shaded.option[selected]");
                boolean set = false;
                for (Element option2 : options) {
                    data.add(HttpConnection.KeyVal.create(name, option2.val()));
                    set = true;
                }
                if (set || (option = el.select("io.quarkus.launcher.shaded.option").first()) == null) continue;
                data.add(HttpConnection.KeyVal.create(name, option.val()));
                continue;
            }
            if ("io.quarkus.launcher.shaded.checkbox".equalsIgnoreCase(type) || "io.quarkus.launcher.shaded.radio".equalsIgnoreCase(type)) {
                if (!el.hasAttr("io.quarkus.launcher.shaded.checked")) continue;
                String val = el.val().length() > 0 ? el.val() : "io.quarkus.launcher.shaded.on";
                data.add(HttpConnection.KeyVal.create(name, val));
                continue;
            }
            data.add(HttpConnection.KeyVal.create(name, el.val()));
        }
        return data;
    }
}

