/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.jsoup.nodes;

import io.quarkus.launcher.shaded.org.jsoup.SerializationException;
import io.quarkus.launcher.shaded.org.jsoup.helper.Validate;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Attribute;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Document;
import io.quarkus.launcher.shaded.org.jsoup.nodes.LeafNode;
import java.io.IOException;

public class XmlDeclaration
extends LeafNode {
    private final boolean isProcessingInstruction;

    public XmlDeclaration(String name, boolean isProcessingInstruction) {
        Validate.notNull(name);
        this.value = name;
        this.isProcessingInstruction = isProcessingInstruction;
    }

    public XmlDeclaration(String name, String baseUri, boolean isProcessingInstruction) {
        this(name, isProcessingInstruction);
    }

    @Override
    public String nodeName() {
        return "io.quarkus.launcher.shaded.#declaration";
    }

    public String name() {
        return this.coreValue();
    }

    public String getWholeDeclaration() {
        StringBuilder sb = new StringBuilder();
        try {
            this.getWholeDeclaration(sb, new Document.OutputSettings());
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        return sb.toString().trim();
    }

    private void getWholeDeclaration(Appendable accum, Document.OutputSettings out) throws IOException {
        for (Attribute attribute : this.attributes()) {
            if (attribute.getKey().equals(this.nodeName())) continue;
            accum.append(' ');
            attribute.html(accum, out);
        }
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        accum.append("io.quarkus.launcher.shaded.<").append(this.isProcessingInstruction ? "io.quarkus.launcher.shaded.!" : "io.quarkus.launcher.shaded.?").append(this.coreValue());
        this.getWholeDeclaration(accum, out);
        accum.append(this.isProcessingInstruction ? "io.quarkus.launcher.shaded.!" : "io.quarkus.launcher.shaded.?").append("io.quarkus.launcher.shaded.>");
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) {
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }
}

