/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.jsoup.parser;

import io.quarkus.launcher.shaded.org.jsoup.helper.Validate;
import io.quarkus.launcher.shaded.org.jsoup.parser.ParseSettings;
import java.util.HashMap;
import java.util.Map;

public class Tag {
    private static final Map<String, Tag> tags;
    private String tagName;
    private boolean isBlock = true;
    private boolean formatAsBlock = true;
    private boolean canContainInline = true;
    private boolean empty = false;
    private boolean selfClosing = false;
    private boolean preserveWhitespace = false;
    private boolean formList = false;
    private boolean formSubmit = false;
    private static final String[] blockTags;
    private static final String[] inlineTags;
    private static final String[] emptyTags;
    private static final String[] formatAsInlineTags;
    private static final String[] preserveWhitespaceTags;
    private static final String[] formListedTags;
    private static final String[] formSubmitTags;

    private Tag(String tagName) {
        this.tagName = tagName;
    }

    public String getName() {
        return this.tagName;
    }

    public static Tag valueOf(String tagName, ParseSettings settings) {
        Validate.notNull(tagName);
        Tag tag = tags.get(tagName);
        if (tag == null) {
            tagName = settings.normalizeTag(tagName);
            Validate.notEmpty(tagName);
            tag = tags.get(tagName);
            if (tag == null) {
                tag = new Tag(tagName);
                tag.isBlock = false;
            }
        }
        return tag;
    }

    public static Tag valueOf(String tagName) {
        return Tag.valueOf(tagName, ParseSettings.preserveCase);
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public boolean formatAsBlock() {
        return this.formatAsBlock;
    }

    public boolean canContainBlock() {
        return this.isBlock;
    }

    public boolean isInline() {
        return !this.isBlock;
    }

    public boolean isData() {
        return !this.canContainInline && !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isSelfClosing() {
        return this.empty || this.selfClosing;
    }

    public boolean isKnownTag() {
        return tags.containsKey(this.tagName);
    }

    public static boolean isKnownTag(String tagName) {
        return tags.containsKey(tagName);
    }

    public boolean preserveWhitespace() {
        return this.preserveWhitespace;
    }

    public boolean isFormListed() {
        return this.formList;
    }

    public boolean isFormSubmittable() {
        return this.formSubmit;
    }

    Tag setSelfClosing() {
        this.selfClosing = true;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)o;
        if (!this.tagName.equals(tag.tagName)) {
            return false;
        }
        if (this.canContainInline != tag.canContainInline) {
            return false;
        }
        if (this.empty != tag.empty) {
            return false;
        }
        if (this.formatAsBlock != tag.formatAsBlock) {
            return false;
        }
        if (this.isBlock != tag.isBlock) {
            return false;
        }
        if (this.preserveWhitespace != tag.preserveWhitespace) {
            return false;
        }
        if (this.selfClosing != tag.selfClosing) {
            return false;
        }
        if (this.formList != tag.formList) {
            return false;
        }
        return this.formSubmit == tag.formSubmit;
    }

    public int hashCode() {
        int result = this.tagName.hashCode();
        result = 31 * result + (this.isBlock ? 1 : 0);
        result = 31 * result + (this.formatAsBlock ? 1 : 0);
        result = 31 * result + (this.canContainInline ? 1 : 0);
        result = 31 * result + (this.empty ? 1 : 0);
        result = 31 * result + (this.selfClosing ? 1 : 0);
        result = 31 * result + (this.preserveWhitespace ? 1 : 0);
        result = 31 * result + (this.formList ? 1 : 0);
        result = 31 * result + (this.formSubmit ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.tagName;
    }

    private static void register(Tag tag) {
        tags.put(tag.tagName, tag);
    }

    static {
        Tag tag;
        tags = new HashMap<String, Tag>();
        blockTags = new String[]{"io.quarkus.launcher.shaded.html", "io.quarkus.launcher.shaded.head", "io.quarkus.launcher.shaded.body", "io.quarkus.launcher.shaded.frameset", "io.quarkus.launcher.shaded.script", "io.quarkus.launcher.shaded.noscript", "io.quarkus.launcher.shaded.style", "io.quarkus.launcher.shaded.meta", "io.quarkus.launcher.shaded.link", "io.quarkus.launcher.shaded.title", "io.quarkus.launcher.shaded.frame", "io.quarkus.launcher.shaded.noframes", "io.quarkus.launcher.shaded.section", "io.quarkus.launcher.shaded.nav", "io.quarkus.launcher.shaded.aside", "io.quarkus.launcher.shaded.hgroup", "io.quarkus.launcher.shaded.header", "io.quarkus.launcher.shaded.footer", "io.quarkus.launcher.shaded.p", "io.quarkus.launcher.shaded.h1", "io.quarkus.launcher.shaded.h2", "io.quarkus.launcher.shaded.h3", "io.quarkus.launcher.shaded.h4", "io.quarkus.launcher.shaded.h5", "io.quarkus.launcher.shaded.h6", "io.quarkus.launcher.shaded.ul", "io.quarkus.launcher.shaded.ol", "io.quarkus.launcher.shaded.pre", "io.quarkus.launcher.shaded.div", "io.quarkus.launcher.shaded.blockquote", "io.quarkus.launcher.shaded.hr", "io.quarkus.launcher.shaded.address", "io.quarkus.launcher.shaded.figure", "io.quarkus.launcher.shaded.figcaption", "io.quarkus.launcher.shaded.form", "io.quarkus.launcher.shaded.fieldset", "io.quarkus.launcher.shaded.ins", "io.quarkus.launcher.shaded.del", "io.quarkus.launcher.shaded.dl", "io.quarkus.launcher.shaded.dt", "io.quarkus.launcher.shaded.dd", "io.quarkus.launcher.shaded.li", "io.quarkus.launcher.shaded.table", "io.quarkus.launcher.shaded.caption", "io.quarkus.launcher.shaded.thead", "io.quarkus.launcher.shaded.tfoot", "io.quarkus.launcher.shaded.tbody", "io.quarkus.launcher.shaded.colgroup", "io.quarkus.launcher.shaded.col", "io.quarkus.launcher.shaded.tr", "io.quarkus.launcher.shaded.th", "io.quarkus.launcher.shaded.td", "io.quarkus.launcher.shaded.video", "io.quarkus.launcher.shaded.audio", "io.quarkus.launcher.shaded.canvas", "io.quarkus.launcher.shaded.details", "io.quarkus.launcher.shaded.menu", "io.quarkus.launcher.shaded.plaintext", "io.quarkus.launcher.shaded.template", "io.quarkus.launcher.shaded.article", "io.quarkus.launcher.shaded.main", "io.quarkus.launcher.shaded.svg", "io.quarkus.launcher.shaded.math"};
        inlineTags = new String[]{"io.quarkus.launcher.shaded.object", "io.quarkus.launcher.shaded.base", "io.quarkus.launcher.shaded.font", "io.quarkus.launcher.shaded.tt", "io.quarkus.launcher.shaded.i", "io.quarkus.launcher.shaded.b", "io.quarkus.launcher.shaded.u", "io.quarkus.launcher.shaded.big", "io.quarkus.launcher.shaded.small", "io.quarkus.launcher.shaded.em", "io.quarkus.launcher.shaded.strong", "io.quarkus.launcher.shaded.dfn", "io.quarkus.launcher.shaded.code", "io.quarkus.launcher.shaded.samp", "io.quarkus.launcher.shaded.kbd", "io.quarkus.launcher.shaded.var", "io.quarkus.launcher.shaded.cite", "io.quarkus.launcher.shaded.abbr", "io.quarkus.launcher.shaded.time", "io.quarkus.launcher.shaded.acronym", "io.quarkus.launcher.shaded.mark", "io.quarkus.launcher.shaded.ruby", "io.quarkus.launcher.shaded.rt", "io.quarkus.launcher.shaded.rp", "io.quarkus.launcher.shaded.a", "io.quarkus.launcher.shaded.img", "io.quarkus.launcher.shaded.br", "io.quarkus.launcher.shaded.wbr", "io.quarkus.launcher.shaded.map", "io.quarkus.launcher.shaded.q", "io.quarkus.launcher.shaded.sub", "io.quarkus.launcher.shaded.sup", "io.quarkus.launcher.shaded.bdo", "io.quarkus.launcher.shaded.iframe", "io.quarkus.launcher.shaded.embed", "io.quarkus.launcher.shaded.span", "io.quarkus.launcher.shaded.input", "io.quarkus.launcher.shaded.select", "io.quarkus.launcher.shaded.textarea", "io.quarkus.launcher.shaded.label", "io.quarkus.launcher.shaded.button", "io.quarkus.launcher.shaded.optgroup", "io.quarkus.launcher.shaded.option", "io.quarkus.launcher.shaded.legend", "io.quarkus.launcher.shaded.datalist", "io.quarkus.launcher.shaded.keygen", "io.quarkus.launcher.shaded.output", "io.quarkus.launcher.shaded.progress", "io.quarkus.launcher.shaded.meter", "io.quarkus.launcher.shaded.area", "io.quarkus.launcher.shaded.param", "io.quarkus.launcher.shaded.source", "io.quarkus.launcher.shaded.track", "io.quarkus.launcher.shaded.summary", "io.quarkus.launcher.shaded.command", "io.quarkus.launcher.shaded.device", "io.quarkus.launcher.shaded.area", "io.quarkus.launcher.shaded.basefont", "io.quarkus.launcher.shaded.bgsound", "io.quarkus.launcher.shaded.menuitem", "io.quarkus.launcher.shaded.param", "io.quarkus.launcher.shaded.source", "io.quarkus.launcher.shaded.track", "io.quarkus.launcher.shaded.data", "io.quarkus.launcher.shaded.bdi", "io.quarkus.launcher.shaded.s"};
        emptyTags = new String[]{"io.quarkus.launcher.shaded.meta", "io.quarkus.launcher.shaded.link", "io.quarkus.launcher.shaded.base", "io.quarkus.launcher.shaded.frame", "io.quarkus.launcher.shaded.img", "io.quarkus.launcher.shaded.br", "io.quarkus.launcher.shaded.wbr", "io.quarkus.launcher.shaded.embed", "io.quarkus.launcher.shaded.hr", "io.quarkus.launcher.shaded.input", "io.quarkus.launcher.shaded.keygen", "io.quarkus.launcher.shaded.col", "io.quarkus.launcher.shaded.command", "io.quarkus.launcher.shaded.device", "io.quarkus.launcher.shaded.area", "io.quarkus.launcher.shaded.basefont", "io.quarkus.launcher.shaded.bgsound", "io.quarkus.launcher.shaded.menuitem", "io.quarkus.launcher.shaded.param", "io.quarkus.launcher.shaded.source", "io.quarkus.launcher.shaded.track"};
        formatAsInlineTags = new String[]{"io.quarkus.launcher.shaded.title", "io.quarkus.launcher.shaded.a", "io.quarkus.launcher.shaded.p", "io.quarkus.launcher.shaded.h1", "io.quarkus.launcher.shaded.h2", "io.quarkus.launcher.shaded.h3", "io.quarkus.launcher.shaded.h4", "io.quarkus.launcher.shaded.h5", "io.quarkus.launcher.shaded.h6", "io.quarkus.launcher.shaded.pre", "io.quarkus.launcher.shaded.address", "io.quarkus.launcher.shaded.li", "io.quarkus.launcher.shaded.th", "io.quarkus.launcher.shaded.td", "io.quarkus.launcher.shaded.script", "io.quarkus.launcher.shaded.style", "io.quarkus.launcher.shaded.ins", "io.quarkus.launcher.shaded.del", "io.quarkus.launcher.shaded.s"};
        preserveWhitespaceTags = new String[]{"io.quarkus.launcher.shaded.pre", "io.quarkus.launcher.shaded.plaintext", "io.quarkus.launcher.shaded.title", "io.quarkus.launcher.shaded.textarea"};
        formListedTags = new String[]{"io.quarkus.launcher.shaded.button", "io.quarkus.launcher.shaded.fieldset", "io.quarkus.launcher.shaded.input", "io.quarkus.launcher.shaded.keygen", "io.quarkus.launcher.shaded.object", "io.quarkus.launcher.shaded.output", "io.quarkus.launcher.shaded.select", "io.quarkus.launcher.shaded.textarea"};
        formSubmitTags = new String[]{"io.quarkus.launcher.shaded.input", "io.quarkus.launcher.shaded.keygen", "io.quarkus.launcher.shaded.object", "io.quarkus.launcher.shaded.select", "io.quarkus.launcher.shaded.textarea"};
        for (String tagName : blockTags) {
            tag = new Tag(tagName);
            Tag.register(tag);
        }
        for (String tagName : inlineTags) {
            tag = new Tag(tagName);
            tag.isBlock = false;
            tag.formatAsBlock = false;
            Tag.register(tag);
        }
        for (String tagName : emptyTags) {
            tag = tags.get(tagName);
            Validate.notNull(tag);
            tag.canContainInline = false;
            tag.empty = true;
        }
        for (String tagName : formatAsInlineTags) {
            tag = tags.get(tagName);
            Validate.notNull(tag);
            tag.formatAsBlock = false;
        }
        for (String tagName : preserveWhitespaceTags) {
            tag = tags.get(tagName);
            Validate.notNull(tag);
            tag.preserveWhitespace = true;
        }
        for (String tagName : formListedTags) {
            tag = tags.get(tagName);
            Validate.notNull(tag);
            tag.formList = true;
        }
        for (String tagName : formSubmitTags) {
            tag = tags.get(tagName);
            Validate.notNull(tag);
            tag.formSubmit = true;
        }
    }
}

