/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.jsoup.safety;

import io.quarkus.launcher.shaded.org.jsoup.helper.Validate;
import io.quarkus.launcher.shaded.org.jsoup.internal.Normalizer;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Attribute;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Attributes;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Element;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Whitelist {
    private Set<TagName> tagNames = new HashSet<TagName>();
    private Map<TagName, Set<AttributeKey>> attributes = new HashMap<TagName, Set<AttributeKey>>();
    private Map<TagName, Map<AttributeKey, AttributeValue>> enforcedAttributes = new HashMap<TagName, Map<AttributeKey, AttributeValue>>();
    private Map<TagName, Map<AttributeKey, Set<Protocol>>> protocols = new HashMap<TagName, Map<AttributeKey, Set<Protocol>>>();
    private boolean preserveRelativeLinks = false;

    public static Whitelist none() {
        return new Whitelist();
    }

    public static Whitelist simpleText() {
        return new Whitelist().addTags("io.quarkus.launcher.shaded.b", "io.quarkus.launcher.shaded.em", "io.quarkus.launcher.shaded.i", "io.quarkus.launcher.shaded.strong", "io.quarkus.launcher.shaded.u");
    }

    public static Whitelist basic() {
        return new Whitelist().addTags("io.quarkus.launcher.shaded.a", "io.quarkus.launcher.shaded.b", "io.quarkus.launcher.shaded.blockquote", "io.quarkus.launcher.shaded.br", "io.quarkus.launcher.shaded.cite", "io.quarkus.launcher.shaded.code", "io.quarkus.launcher.shaded.dd", "io.quarkus.launcher.shaded.dl", "io.quarkus.launcher.shaded.dt", "io.quarkus.launcher.shaded.em", "io.quarkus.launcher.shaded.i", "io.quarkus.launcher.shaded.li", "io.quarkus.launcher.shaded.ol", "io.quarkus.launcher.shaded.p", "io.quarkus.launcher.shaded.pre", "io.quarkus.launcher.shaded.q", "io.quarkus.launcher.shaded.small", "io.quarkus.launcher.shaded.span", "io.quarkus.launcher.shaded.strike", "io.quarkus.launcher.shaded.strong", "io.quarkus.launcher.shaded.sub", "io.quarkus.launcher.shaded.sup", "io.quarkus.launcher.shaded.u", "io.quarkus.launcher.shaded.ul").addAttributes("io.quarkus.launcher.shaded.a", "io.quarkus.launcher.shaded.href").addAttributes("io.quarkus.launcher.shaded.blockquote", "io.quarkus.launcher.shaded.cite").addAttributes("io.quarkus.launcher.shaded.q", "io.quarkus.launcher.shaded.cite").addProtocols("io.quarkus.launcher.shaded.a", "io.quarkus.launcher.shaded.href", "io.quarkus.launcher.shaded.ftp", "io.quarkus.launcher.shaded.http", "io.quarkus.launcher.shaded.https", "io.quarkus.launcher.shaded.mailto").addProtocols("io.quarkus.launcher.shaded.blockquote", "io.quarkus.launcher.shaded.cite", "io.quarkus.launcher.shaded.http", "io.quarkus.launcher.shaded.https").addProtocols("io.quarkus.launcher.shaded.cite", "io.quarkus.launcher.shaded.cite", "io.quarkus.launcher.shaded.http", "io.quarkus.launcher.shaded.https").addEnforcedAttribute("io.quarkus.launcher.shaded.a", "io.quarkus.launcher.shaded.rel", "io.quarkus.launcher.shaded.nofollow");
    }

    public static Whitelist basicWithImages() {
        return Whitelist.basic().addTags("io.quarkus.launcher.shaded.img").addAttributes("io.quarkus.launcher.shaded.img", "io.quarkus.launcher.shaded.align", "io.quarkus.launcher.shaded.alt", "io.quarkus.launcher.shaded.height", "io.quarkus.launcher.shaded.src", "io.quarkus.launcher.shaded.title", "io.quarkus.launcher.shaded.width").addProtocols("io.quarkus.launcher.shaded.img", "io.quarkus.launcher.shaded.src", "io.quarkus.launcher.shaded.http", "io.quarkus.launcher.shaded.https");
    }

    public static Whitelist relaxed() {
        return new Whitelist().addTags("io.quarkus.launcher.shaded.a", "io.quarkus.launcher.shaded.b", "io.quarkus.launcher.shaded.blockquote", "io.quarkus.launcher.shaded.br", "io.quarkus.launcher.shaded.caption", "io.quarkus.launcher.shaded.cite", "io.quarkus.launcher.shaded.code", "io.quarkus.launcher.shaded.col", "io.quarkus.launcher.shaded.colgroup", "io.quarkus.launcher.shaded.dd", "io.quarkus.launcher.shaded.div", "io.quarkus.launcher.shaded.dl", "io.quarkus.launcher.shaded.dt", "io.quarkus.launcher.shaded.em", "io.quarkus.launcher.shaded.h1", "io.quarkus.launcher.shaded.h2", "io.quarkus.launcher.shaded.h3", "io.quarkus.launcher.shaded.h4", "io.quarkus.launcher.shaded.h5", "io.quarkus.launcher.shaded.h6", "io.quarkus.launcher.shaded.i", "io.quarkus.launcher.shaded.img", "io.quarkus.launcher.shaded.li", "io.quarkus.launcher.shaded.ol", "io.quarkus.launcher.shaded.p", "io.quarkus.launcher.shaded.pre", "io.quarkus.launcher.shaded.q", "io.quarkus.launcher.shaded.small", "io.quarkus.launcher.shaded.span", "io.quarkus.launcher.shaded.strike", "io.quarkus.launcher.shaded.strong", "io.quarkus.launcher.shaded.sub", "io.quarkus.launcher.shaded.sup", "io.quarkus.launcher.shaded.table", "io.quarkus.launcher.shaded.tbody", "io.quarkus.launcher.shaded.td", "io.quarkus.launcher.shaded.tfoot", "io.quarkus.launcher.shaded.th", "io.quarkus.launcher.shaded.thead", "io.quarkus.launcher.shaded.tr", "io.quarkus.launcher.shaded.u", "io.quarkus.launcher.shaded.ul").addAttributes("io.quarkus.launcher.shaded.a", "io.quarkus.launcher.shaded.href", "io.quarkus.launcher.shaded.title").addAttributes("io.quarkus.launcher.shaded.blockquote", "io.quarkus.launcher.shaded.cite").addAttributes("io.quarkus.launcher.shaded.col", "io.quarkus.launcher.shaded.span", "io.quarkus.launcher.shaded.width").addAttributes("io.quarkus.launcher.shaded.colgroup", "io.quarkus.launcher.shaded.span", "io.quarkus.launcher.shaded.width").addAttributes("io.quarkus.launcher.shaded.img", "io.quarkus.launcher.shaded.align", "io.quarkus.launcher.shaded.alt", "io.quarkus.launcher.shaded.height", "io.quarkus.launcher.shaded.src", "io.quarkus.launcher.shaded.title", "io.quarkus.launcher.shaded.width").addAttributes("io.quarkus.launcher.shaded.ol", "io.quarkus.launcher.shaded.start", "io.quarkus.launcher.shaded.type").addAttributes("io.quarkus.launcher.shaded.q", "io.quarkus.launcher.shaded.cite").addAttributes("io.quarkus.launcher.shaded.table", "io.quarkus.launcher.shaded.summary", "io.quarkus.launcher.shaded.width").addAttributes("io.quarkus.launcher.shaded.td", "io.quarkus.launcher.shaded.abbr", "io.quarkus.launcher.shaded.axis", "io.quarkus.launcher.shaded.colspan", "io.quarkus.launcher.shaded.rowspan", "io.quarkus.launcher.shaded.width").addAttributes("io.quarkus.launcher.shaded.th", "io.quarkus.launcher.shaded.abbr", "io.quarkus.launcher.shaded.axis", "io.quarkus.launcher.shaded.colspan", "io.quarkus.launcher.shaded.rowspan", "io.quarkus.launcher.shaded.scope", "io.quarkus.launcher.shaded.width").addAttributes("io.quarkus.launcher.shaded.ul", "io.quarkus.launcher.shaded.type").addProtocols("io.quarkus.launcher.shaded.a", "io.quarkus.launcher.shaded.href", "io.quarkus.launcher.shaded.ftp", "io.quarkus.launcher.shaded.http", "io.quarkus.launcher.shaded.https", "io.quarkus.launcher.shaded.mailto").addProtocols("io.quarkus.launcher.shaded.blockquote", "io.quarkus.launcher.shaded.cite", "io.quarkus.launcher.shaded.http", "io.quarkus.launcher.shaded.https").addProtocols("io.quarkus.launcher.shaded.cite", "io.quarkus.launcher.shaded.cite", "io.quarkus.launcher.shaded.http", "io.quarkus.launcher.shaded.https").addProtocols("io.quarkus.launcher.shaded.img", "io.quarkus.launcher.shaded.src", "io.quarkus.launcher.shaded.http", "io.quarkus.launcher.shaded.https").addProtocols("io.quarkus.launcher.shaded.q", "io.quarkus.launcher.shaded.cite", "io.quarkus.launcher.shaded.http", "io.quarkus.launcher.shaded.https");
    }

    public Whitelist addTags(String ... tags) {
        Validate.notNull(tags);
        for (String tagName : tags) {
            Validate.notEmpty(tagName);
            this.tagNames.add(TagName.valueOf(tagName));
        }
        return this;
    }

    public Whitelist removeTags(String ... tags) {
        Validate.notNull(tags);
        for (String tag : tags) {
            Validate.notEmpty(tag);
            TagName tagName = TagName.valueOf(tag);
            if (!this.tagNames.remove(tagName)) continue;
            this.attributes.remove(tagName);
            this.enforcedAttributes.remove(tagName);
            this.protocols.remove(tagName);
        }
        return this;
    }

    public Whitelist addAttributes(String tag, String ... attributes) {
        Validate.notEmpty(tag);
        Validate.notNull(attributes);
        Validate.isTrue(attributes.length > 0, "io.quarkus.launcher.shaded.No attribute names supplied.");
        TagName tagName = TagName.valueOf(tag);
        if (!this.tagNames.contains(tagName)) {
            this.tagNames.add(tagName);
        }
        HashSet<AttributeKey> attributeSet = new HashSet<AttributeKey>();
        for (String key : attributes) {
            Validate.notEmpty(key);
            attributeSet.add(AttributeKey.valueOf(key));
        }
        if (this.attributes.containsKey(tagName)) {
            Set<AttributeKey> currentSet = this.attributes.get(tagName);
            currentSet.addAll(attributeSet);
        } else {
            this.attributes.put(tagName, attributeSet);
        }
        return this;
    }

    public Whitelist removeAttributes(String tag, String ... attributes) {
        Validate.notEmpty(tag);
        Validate.notNull(attributes);
        Validate.isTrue(attributes.length > 0, "io.quarkus.launcher.shaded.No attribute names supplied.");
        TagName tagName = TagName.valueOf(tag);
        HashSet<AttributeKey> attributeSet = new HashSet<AttributeKey>();
        for (String key : attributes) {
            Validate.notEmpty(key);
            attributeSet.add(AttributeKey.valueOf(key));
        }
        if (this.tagNames.contains(tagName) && this.attributes.containsKey(tagName)) {
            Set<AttributeKey> currentSet = this.attributes.get(tagName);
            currentSet.removeAll(attributeSet);
            if (currentSet.isEmpty()) {
                this.attributes.remove(tagName);
            }
        }
        if (tag.equals("io.quarkus.launcher.shaded.:all")) {
            for (TagName name : this.attributes.keySet()) {
                Set<AttributeKey> currentSet = this.attributes.get(name);
                currentSet.removeAll(attributeSet);
                if (!currentSet.isEmpty()) continue;
                this.attributes.remove(name);
            }
        }
        return this;
    }

    public Whitelist addEnforcedAttribute(String tag, String attribute, String value) {
        Validate.notEmpty(tag);
        Validate.notEmpty(attribute);
        Validate.notEmpty(value);
        TagName tagName = TagName.valueOf(tag);
        if (!this.tagNames.contains(tagName)) {
            this.tagNames.add(tagName);
        }
        AttributeKey attrKey = AttributeKey.valueOf(attribute);
        AttributeValue attrVal = AttributeValue.valueOf(value);
        if (this.enforcedAttributes.containsKey(tagName)) {
            this.enforcedAttributes.get(tagName).put(attrKey, attrVal);
        } else {
            HashMap<AttributeKey, AttributeValue> attrMap = new HashMap<AttributeKey, AttributeValue>();
            attrMap.put(attrKey, attrVal);
            this.enforcedAttributes.put(tagName, attrMap);
        }
        return this;
    }

    public Whitelist removeEnforcedAttribute(String tag, String attribute) {
        Validate.notEmpty(tag);
        Validate.notEmpty(attribute);
        TagName tagName = TagName.valueOf(tag);
        if (this.tagNames.contains(tagName) && this.enforcedAttributes.containsKey(tagName)) {
            AttributeKey attrKey = AttributeKey.valueOf(attribute);
            Map<AttributeKey, AttributeValue> attrMap = this.enforcedAttributes.get(tagName);
            attrMap.remove(attrKey);
            if (attrMap.isEmpty()) {
                this.enforcedAttributes.remove(tagName);
            }
        }
        return this;
    }

    public Whitelist preserveRelativeLinks(boolean preserve) {
        this.preserveRelativeLinks = preserve;
        return this;
    }

    public Whitelist addProtocols(String tag, String attribute, String ... protocols) {
        Set<Protocol> protSet;
        Map<Object, Object> attrMap;
        Validate.notEmpty(tag);
        Validate.notEmpty(attribute);
        Validate.notNull(protocols);
        TagName tagName = TagName.valueOf(tag);
        AttributeKey attrKey = AttributeKey.valueOf(attribute);
        if (this.protocols.containsKey(tagName)) {
            attrMap = this.protocols.get(tagName);
        } else {
            attrMap = new HashMap();
            this.protocols.put(tagName, attrMap);
        }
        if (attrMap.containsKey(attrKey)) {
            protSet = (Set)attrMap.get(attrKey);
        } else {
            protSet = new HashSet();
            attrMap.put(attrKey, protSet);
        }
        for (String protocol : protocols) {
            Validate.notEmpty(protocol);
            Protocol prot = Protocol.valueOf(protocol);
            protSet.add(prot);
        }
        return this;
    }

    public Whitelist removeProtocols(String tag, String attribute, String ... removeProtocols) {
        Validate.notEmpty(tag);
        Validate.notEmpty(attribute);
        Validate.notNull(removeProtocols);
        TagName tagName = TagName.valueOf(tag);
        AttributeKey attr = AttributeKey.valueOf(attribute);
        Validate.isTrue(this.protocols.containsKey(tagName), "io.quarkus.launcher.shaded.Cannot remove a protocol that is not set.");
        Map<AttributeKey, Set<Protocol>> tagProtocols = this.protocols.get(tagName);
        Validate.isTrue(tagProtocols.containsKey(attr), "io.quarkus.launcher.shaded.Cannot remove a protocol that is not set.");
        Set<Protocol> attrProtocols = tagProtocols.get(attr);
        for (String protocol : removeProtocols) {
            Validate.notEmpty(protocol);
            attrProtocols.remove(Protocol.valueOf(protocol));
        }
        if (attrProtocols.isEmpty()) {
            tagProtocols.remove(attr);
            if (tagProtocols.isEmpty()) {
                this.protocols.remove(tagName);
            }
        }
        return this;
    }

    protected boolean isSafeTag(String tag) {
        return this.tagNames.contains(TagName.valueOf(tag));
    }

    protected boolean isSafeAttribute(String tagName, Element el, Attribute attr) {
        String attrKey;
        Attributes expect;
        TagName tag = TagName.valueOf(tagName);
        AttributeKey key = AttributeKey.valueOf(attr.getKey());
        Set<AttributeKey> okSet = this.attributes.get(tag);
        if (okSet != null && okSet.contains(key)) {
            if (this.protocols.containsKey(tag)) {
                Map<AttributeKey, Set<Protocol>> attrProts = this.protocols.get(tag);
                return !attrProts.containsKey(key) || this.testValidProtocol(el, attr, attrProts.get(key));
            }
            return true;
        }
        Map<AttributeKey, AttributeValue> enforcedSet = this.enforcedAttributes.get(tag);
        if (enforcedSet != null && (expect = this.getEnforcedAttributes(tagName)).hasKeyIgnoreCase(attrKey = attr.getKey())) {
            return expect.getIgnoreCase(attrKey).equals(attr.getValue());
        }
        return !tagName.equals("io.quarkus.launcher.shaded.:all") && this.isSafeAttribute("io.quarkus.launcher.shaded.:all", el, attr);
    }

    private boolean testValidProtocol(Element el, Attribute attr, Set<Protocol> protocols) {
        String value = el.absUrl(attr.getKey());
        if (value.length() == 0) {
            value = attr.getValue();
        }
        if (!this.preserveRelativeLinks) {
            attr.setValue(value);
        }
        for (Protocol protocol : protocols) {
            String prot = protocol.toString();
            if (prot.equals("io.quarkus.launcher.shaded.#")) {
                if (!this.isValidAnchor(value)) continue;
                return true;
            }
            prot = prot + "io.quarkus.launcher.shaded.:";
            if (!Normalizer.lowerCase(value).startsWith(prot)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidAnchor(String value) {
        return value.startsWith("io.quarkus.launcher.shaded.#") && !value.matches("io.quarkus.launcher.shaded..*\\s.*");
    }

    Attributes getEnforcedAttributes(String tagName) {
        Attributes attrs = new Attributes();
        TagName tag = TagName.valueOf(tagName);
        if (this.enforcedAttributes.containsKey(tag)) {
            Map<AttributeKey, AttributeValue> keyVals = this.enforcedAttributes.get(tag);
            for (Map.Entry<AttributeKey, AttributeValue> entry : keyVals.entrySet()) {
                attrs.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return attrs;
    }

    static abstract class TypedValue {
        private String value;

        TypedValue(String value) {
            Validate.notNull(value);
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypedValue other = (TypedValue)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return this.value;
        }
    }

    static class Protocol
    extends TypedValue {
        Protocol(String value) {
            super(value);
        }

        static Protocol valueOf(String value) {
            return new Protocol(value);
        }
    }

    static class AttributeValue
    extends TypedValue {
        AttributeValue(String value) {
            super(value);
        }

        static AttributeValue valueOf(String value) {
            return new AttributeValue(value);
        }
    }

    static class AttributeKey
    extends TypedValue {
        AttributeKey(String value) {
            super(value);
        }

        static AttributeKey valueOf(String value) {
            return new AttributeKey(value);
        }
    }

    static class TagName
    extends TypedValue {
        TagName(String value) {
            super(value);
        }

        static TagName valueOf(String value) {
            return new TagName(value);
        }
    }
}

