/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.jsoup.select;

import io.quarkus.launcher.shaded.org.jsoup.helper.StringUtil;
import io.quarkus.launcher.shaded.org.jsoup.helper.Validate;
import io.quarkus.launcher.shaded.org.jsoup.internal.Normalizer;
import io.quarkus.launcher.shaded.org.jsoup.parser.TokenQueue;
import io.quarkus.launcher.shaded.org.jsoup.select.CombiningEvaluator;
import io.quarkus.launcher.shaded.org.jsoup.select.Evaluator;
import io.quarkus.launcher.shaded.org.jsoup.select.Selector;
import io.quarkus.launcher.shaded.org.jsoup.select.StructuralEvaluator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryParser {
    private static final String[] combinators = new String[]{"io.quarkus.launcher.shaded.,", "io.quarkus.launcher.shaded.>", "io.quarkus.launcher.shaded.+", "io.quarkus.launcher.shaded.~", "io.quarkus.launcher.shaded. "};
    private static final String[] AttributeEvals = new String[]{"io.quarkus.launcher.shaded.=", "io.quarkus.launcher.shaded.!=", "io.quarkus.launcher.shaded.^=", "io.quarkus.launcher.shaded.$=", "io.quarkus.launcher.shaded.*=", "io.quarkus.launcher.shaded.~="};
    private TokenQueue tq;
    private String query;
    private List<Evaluator> evals = new ArrayList<Evaluator>();
    private static final Pattern NTH_AB = Pattern.compile("io.quarkus.launcher.shaded.(([+-])?(\\d+)?)n(\\s*([+-])?\\s*\\d+)?", 2);
    private static final Pattern NTH_B = Pattern.compile("io.quarkus.launcher.shaded.([+-])?(\\d+)");

    private QueryParser(String query) {
        this.query = query;
        this.tq = new TokenQueue(query);
    }

    public static Evaluator parse(String query) {
        try {
            QueryParser p = new QueryParser(query);
            return p.parse();
        }
        catch (IllegalArgumentException e) {
            throw new Selector.SelectorParseException(e.getMessage(), new Object[0]);
        }
    }

    Evaluator parse() {
        this.tq.consumeWhitespace();
        if (this.tq.matchesAny(combinators)) {
            this.evals.add(new StructuralEvaluator.Root());
            this.combinator(this.tq.consume());
        } else {
            this.findElements();
        }
        while (!this.tq.isEmpty()) {
            boolean seenWhite = this.tq.consumeWhitespace();
            if (this.tq.matchesAny(combinators)) {
                this.combinator(this.tq.consume());
                continue;
            }
            if (seenWhite) {
                this.combinator(' ');
                continue;
            }
            this.findElements();
        }
        if (this.evals.size() == 1) {
            return this.evals.get(0);
        }
        return new CombiningEvaluator.And(this.evals);
    }

    private void combinator(char combinator) {
        Evaluator rootEval;
        Evaluator currentEval;
        this.tq.consumeWhitespace();
        String subQuery = this.consumeSubQuery();
        Evaluator newEval = QueryParser.parse(subQuery);
        boolean replaceRightMost = false;
        if (this.evals.size() == 1) {
            currentEval = this.evals.get(0);
            rootEval = currentEval;
            if (rootEval instanceof CombiningEvaluator.Or && combinator != ',') {
                currentEval = ((CombiningEvaluator.Or)currentEval).rightMostEvaluator();
                replaceRightMost = true;
            }
        } else {
            rootEval = currentEval = new CombiningEvaluator.And(this.evals);
        }
        this.evals.clear();
        if (combinator == '>') {
            currentEval = new CombiningEvaluator.And(newEval, new StructuralEvaluator.ImmediateParent(currentEval));
        } else if (combinator == ' ') {
            currentEval = new CombiningEvaluator.And(newEval, new StructuralEvaluator.Parent(currentEval));
        } else if (combinator == '+') {
            currentEval = new CombiningEvaluator.And(newEval, new StructuralEvaluator.ImmediatePreviousSibling(currentEval));
        } else if (combinator == '~') {
            currentEval = new CombiningEvaluator.And(newEval, new StructuralEvaluator.PreviousSibling(currentEval));
        } else if (combinator == ',') {
            CombiningEvaluator.Or or;
            if (currentEval instanceof CombiningEvaluator.Or) {
                or = (CombiningEvaluator.Or)currentEval;
                or.add(newEval);
            } else {
                or = new CombiningEvaluator.Or();
                or.add(currentEval);
                or.add(newEval);
            }
            currentEval = or;
        } else {
            throw new Selector.SelectorParseException("io.quarkus.launcher.shaded.Unknown combinator: " + combinator, new Object[0]);
        }
        if (replaceRightMost) {
            ((CombiningEvaluator.Or)rootEval).replaceRightMostEvaluator(currentEval);
        } else {
            rootEval = currentEval;
        }
        this.evals.add(rootEval);
    }

    private String consumeSubQuery() {
        StringBuilder sq = new StringBuilder();
        while (!this.tq.isEmpty()) {
            if (this.tq.matches("io.quarkus.launcher.shaded.(")) {
                sq.append("io.quarkus.launcher.shaded.(").append(this.tq.chompBalanced('(', ')')).append("io.quarkus.launcher.shaded.)");
                continue;
            }
            if (this.tq.matches("io.quarkus.launcher.shaded.[")) {
                sq.append("io.quarkus.launcher.shaded.[").append(this.tq.chompBalanced('[', ']')).append("io.quarkus.launcher.shaded.]");
                continue;
            }
            if (this.tq.matchesAny(combinators)) break;
            sq.append(this.tq.consume());
        }
        return sq.toString();
    }

    private void findElements() {
        if (this.tq.matchChomp("io.quarkus.launcher.shaded.#")) {
            this.byId();
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded..")) {
            this.byClass();
        } else if (this.tq.matchesWord() || this.tq.matches("io.quarkus.launcher.shaded.*|")) {
            this.byTag();
        } else if (this.tq.matches("io.quarkus.launcher.shaded.[")) {
            this.byAttribute();
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.*")) {
            this.allElements();
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:lt(")) {
            this.indexLessThan();
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:gt(")) {
            this.indexGreaterThan();
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:eq(")) {
            this.indexEquals();
        } else if (this.tq.matches("io.quarkus.launcher.shaded.:has(")) {
            this.has();
        } else if (this.tq.matches("io.quarkus.launcher.shaded.:contains(")) {
            this.contains(false);
        } else if (this.tq.matches("io.quarkus.launcher.shaded.:containsOwn(")) {
            this.contains(true);
        } else if (this.tq.matches("io.quarkus.launcher.shaded.:containsData(")) {
            this.containsData();
        } else if (this.tq.matches("io.quarkus.launcher.shaded.:matches(")) {
            this.matches(false);
        } else if (this.tq.matches("io.quarkus.launcher.shaded.:matchesOwn(")) {
            this.matches(true);
        } else if (this.tq.matches("io.quarkus.launcher.shaded.:not(")) {
            this.not();
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:nth-child(")) {
            this.cssNthChild(false, false);
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:nth-last-child(")) {
            this.cssNthChild(true, false);
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:nth-of-type(")) {
            this.cssNthChild(false, true);
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:nth-last-of-type(")) {
            this.cssNthChild(true, true);
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:first-child")) {
            this.evals.add(new Evaluator.IsFirstChild());
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:last-child")) {
            this.evals.add(new Evaluator.IsLastChild());
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:first-of-type")) {
            this.evals.add(new Evaluator.IsFirstOfType());
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:last-of-type")) {
            this.evals.add(new Evaluator.IsLastOfType());
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:only-child")) {
            this.evals.add(new Evaluator.IsOnlyChild());
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:only-of-type")) {
            this.evals.add(new Evaluator.IsOnlyOfType());
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:empty")) {
            this.evals.add(new Evaluator.IsEmpty());
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:root")) {
            this.evals.add(new Evaluator.IsRoot());
        } else if (this.tq.matchChomp("io.quarkus.launcher.shaded.:matchText")) {
            this.evals.add(new Evaluator.MatchText());
        } else {
            throw new Selector.SelectorParseException("io.quarkus.launcher.shaded.Could not parse query '%s': unexpected token at '%s'", this.query, this.tq.remainder());
        }
    }

    private void byId() {
        String id = this.tq.consumeCssIdentifier();
        Validate.notEmpty(id);
        this.evals.add(new Evaluator.Id(id));
    }

    private void byClass() {
        String className = this.tq.consumeCssIdentifier();
        Validate.notEmpty(className);
        this.evals.add(new Evaluator.Class(className.trim()));
    }

    private void byTag() {
        String tagName = this.tq.consumeElementSelector();
        Validate.notEmpty(tagName);
        if (tagName.startsWith("io.quarkus.launcher.shaded.*|")) {
            this.evals.add(new CombiningEvaluator.Or(new Evaluator.Tag(Normalizer.normalize(tagName)), new Evaluator.TagEndsWith(Normalizer.normalize(tagName.replace("io.quarkus.launcher.shaded.*|", "io.quarkus.launcher.shaded.:")))));
        } else {
            if (tagName.contains("io.quarkus.launcher.shaded.|")) {
                tagName = tagName.replace("io.quarkus.launcher.shaded.|", "io.quarkus.launcher.shaded.:");
            }
            this.evals.add(new Evaluator.Tag(tagName.trim()));
        }
    }

    private void byAttribute() {
        TokenQueue cq = new TokenQueue(this.tq.chompBalanced('[', ']'));
        String key = cq.consumeToAny(AttributeEvals);
        Validate.notEmpty(key);
        cq.consumeWhitespace();
        if (cq.isEmpty()) {
            if (key.startsWith("io.quarkus.launcher.shaded.^")) {
                this.evals.add(new Evaluator.AttributeStarting(key.substring(1)));
            } else {
                this.evals.add(new Evaluator.Attribute(key));
            }
        } else if (cq.matchChomp("io.quarkus.launcher.shaded.=")) {
            this.evals.add(new Evaluator.AttributeWithValue(key, cq.remainder()));
        } else if (cq.matchChomp("io.quarkus.launcher.shaded.!=")) {
            this.evals.add(new Evaluator.AttributeWithValueNot(key, cq.remainder()));
        } else if (cq.matchChomp("io.quarkus.launcher.shaded.^=")) {
            this.evals.add(new Evaluator.AttributeWithValueStarting(key, cq.remainder()));
        } else if (cq.matchChomp("io.quarkus.launcher.shaded.$=")) {
            this.evals.add(new Evaluator.AttributeWithValueEnding(key, cq.remainder()));
        } else if (cq.matchChomp("io.quarkus.launcher.shaded.*=")) {
            this.evals.add(new Evaluator.AttributeWithValueContaining(key, cq.remainder()));
        } else if (cq.matchChomp("io.quarkus.launcher.shaded.~=")) {
            this.evals.add(new Evaluator.AttributeWithValueMatching(key, Pattern.compile(cq.remainder())));
        } else {
            throw new Selector.SelectorParseException("io.quarkus.launcher.shaded.Could not parse attribute query '%s': unexpected token at '%s'", this.query, cq.remainder());
        }
    }

    private void allElements() {
        this.evals.add(new Evaluator.AllElements());
    }

    private void indexLessThan() {
        this.evals.add(new Evaluator.IndexLessThan(this.consumeIndex()));
    }

    private void indexGreaterThan() {
        this.evals.add(new Evaluator.IndexGreaterThan(this.consumeIndex()));
    }

    private void indexEquals() {
        this.evals.add(new Evaluator.IndexEquals(this.consumeIndex()));
    }

    private void cssNthChild(boolean backwards, boolean ofType) {
        int b;
        int a;
        String argS = Normalizer.normalize(this.tq.chompTo("io.quarkus.launcher.shaded.)"));
        Matcher mAB = NTH_AB.matcher(argS);
        Matcher mB = NTH_B.matcher(argS);
        if ("io.quarkus.launcher.shaded.odd".equals(argS)) {
            a = 2;
            b = 1;
        } else if ("io.quarkus.launcher.shaded.even".equals(argS)) {
            a = 2;
            b = 0;
        } else if (mAB.matches()) {
            a = mAB.group(3) != null ? Integer.parseInt(mAB.group(1).replaceFirst("io.quarkus.launcher.shaded.^\\+", "io.quarkus.launcher.shaded.")) : 1;
            b = mAB.group(4) != null ? Integer.parseInt(mAB.group(4).replaceFirst("io.quarkus.launcher.shaded.^\\+", "io.quarkus.launcher.shaded.")) : 0;
        } else if (mB.matches()) {
            a = 0;
            b = Integer.parseInt(mB.group().replaceFirst("io.quarkus.launcher.shaded.^\\+", "io.quarkus.launcher.shaded."));
        } else {
            throw new Selector.SelectorParseException("io.quarkus.launcher.shaded.Could not parse nth-index '%s': unexpected format", argS);
        }
        if (ofType) {
            if (backwards) {
                this.evals.add(new Evaluator.IsNthLastOfType(a, b));
            } else {
                this.evals.add(new Evaluator.IsNthOfType(a, b));
            }
        } else if (backwards) {
            this.evals.add(new Evaluator.IsNthLastChild(a, b));
        } else {
            this.evals.add(new Evaluator.IsNthChild(a, b));
        }
    }

    private int consumeIndex() {
        String indexS = this.tq.chompTo("io.quarkus.launcher.shaded.)").trim();
        Validate.isTrue(StringUtil.isNumeric(indexS), "io.quarkus.launcher.shaded.Index must be numeric");
        return Integer.parseInt(indexS);
    }

    private void has() {
        this.tq.consume("io.quarkus.launcher.shaded.:has");
        String subQuery = this.tq.chompBalanced('(', ')');
        Validate.notEmpty(subQuery, "io.quarkus.launcher.shaded.:has(el) subselect must not be empty");
        this.evals.add(new StructuralEvaluator.Has(QueryParser.parse(subQuery)));
    }

    private void contains(boolean own) {
        this.tq.consume(own ? "io.quarkus.launcher.shaded.:containsOwn" : "io.quarkus.launcher.shaded.:contains");
        String searchText = TokenQueue.unescape(this.tq.chompBalanced('(', ')'));
        Validate.notEmpty(searchText, "io.quarkus.launcher.shaded.:contains(text) query must not be empty");
        if (own) {
            this.evals.add(new Evaluator.ContainsOwnText(searchText));
        } else {
            this.evals.add(new Evaluator.ContainsText(searchText));
        }
    }

    private void containsData() {
        this.tq.consume("io.quarkus.launcher.shaded.:containsData");
        String searchText = TokenQueue.unescape(this.tq.chompBalanced('(', ')'));
        Validate.notEmpty(searchText, "io.quarkus.launcher.shaded.:containsData(text) query must not be empty");
        this.evals.add(new Evaluator.ContainsData(searchText));
    }

    private void matches(boolean own) {
        this.tq.consume(own ? "io.quarkus.launcher.shaded.:matchesOwn" : "io.quarkus.launcher.shaded.:matches");
        String regex = this.tq.chompBalanced('(', ')');
        Validate.notEmpty(regex, "io.quarkus.launcher.shaded.:matches(regex) query must not be empty");
        if (own) {
            this.evals.add(new Evaluator.MatchesOwn(Pattern.compile(regex)));
        } else {
            this.evals.add(new Evaluator.Matches(Pattern.compile(regex)));
        }
    }

    private void not() {
        this.tq.consume("io.quarkus.launcher.shaded.:not");
        String subQuery = this.tq.chompBalanced('(', ')');
        Validate.notEmpty(subQuery, "io.quarkus.launcher.shaded.:not(selector) subselect must not be empty");
        this.evals.add(new StructuralEvaluator.Not(QueryParser.parse(subQuery)));
    }
}

