/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.objectweb.asm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;

final class Constants {
    static final String CONSTANT_VALUE = "io.quarkus.launcher.shaded.ConstantValue";
    static final String CODE = "io.quarkus.launcher.shaded.Code";
    static final String STACK_MAP_TABLE = "io.quarkus.launcher.shaded.StackMapTable";
    static final String EXCEPTIONS = "io.quarkus.launcher.shaded.Exceptions";
    static final String INNER_CLASSES = "io.quarkus.launcher.shaded.InnerClasses";
    static final String ENCLOSING_METHOD = "io.quarkus.launcher.shaded.EnclosingMethod";
    static final String SYNTHETIC = "io.quarkus.launcher.shaded.Synthetic";
    static final String SIGNATURE = "io.quarkus.launcher.shaded.Signature";
    static final String SOURCE_FILE = "io.quarkus.launcher.shaded.SourceFile";
    static final String SOURCE_DEBUG_EXTENSION = "io.quarkus.launcher.shaded.SourceDebugExtension";
    static final String LINE_NUMBER_TABLE = "io.quarkus.launcher.shaded.LineNumberTable";
    static final String LOCAL_VARIABLE_TABLE = "io.quarkus.launcher.shaded.LocalVariableTable";
    static final String LOCAL_VARIABLE_TYPE_TABLE = "io.quarkus.launcher.shaded.LocalVariableTypeTable";
    static final String DEPRECATED = "io.quarkus.launcher.shaded.Deprecated";
    static final String RUNTIME_VISIBLE_ANNOTATIONS = "io.quarkus.launcher.shaded.RuntimeVisibleAnnotations";
    static final String RUNTIME_INVISIBLE_ANNOTATIONS = "io.quarkus.launcher.shaded.RuntimeInvisibleAnnotations";
    static final String RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS = "io.quarkus.launcher.shaded.RuntimeVisibleParameterAnnotations";
    static final String RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS = "io.quarkus.launcher.shaded.RuntimeInvisibleParameterAnnotations";
    static final String RUNTIME_VISIBLE_TYPE_ANNOTATIONS = "io.quarkus.launcher.shaded.RuntimeVisibleTypeAnnotations";
    static final String RUNTIME_INVISIBLE_TYPE_ANNOTATIONS = "io.quarkus.launcher.shaded.RuntimeInvisibleTypeAnnotations";
    static final String ANNOTATION_DEFAULT = "io.quarkus.launcher.shaded.AnnotationDefault";
    static final String BOOTSTRAP_METHODS = "io.quarkus.launcher.shaded.BootstrapMethods";
    static final String METHOD_PARAMETERS = "io.quarkus.launcher.shaded.MethodParameters";
    static final String MODULE = "io.quarkus.launcher.shaded.Module";
    static final String MODULE_PACKAGES = "io.quarkus.launcher.shaded.ModulePackages";
    static final String MODULE_MAIN_CLASS = "io.quarkus.launcher.shaded.ModuleMainClass";
    static final String NEST_HOST = "io.quarkus.launcher.shaded.NestHost";
    static final String NEST_MEMBERS = "io.quarkus.launcher.shaded.NestMembers";
    static final String PERMITTED_SUBTYPES = "io.quarkus.launcher.shaded.PermittedSubtypes";
    static final String RECORD = "io.quarkus.launcher.shaded.Record";
    static final int ACC_CONSTRUCTOR = 262144;
    static final int F_INSERT = 256;
    static final int LDC_W = 19;
    static final int LDC2_W = 20;
    static final int ILOAD_0 = 26;
    static final int ILOAD_1 = 27;
    static final int ILOAD_2 = 28;
    static final int ILOAD_3 = 29;
    static final int LLOAD_0 = 30;
    static final int LLOAD_1 = 31;
    static final int LLOAD_2 = 32;
    static final int LLOAD_3 = 33;
    static final int FLOAD_0 = 34;
    static final int FLOAD_1 = 35;
    static final int FLOAD_2 = 36;
    static final int FLOAD_3 = 37;
    static final int DLOAD_0 = 38;
    static final int DLOAD_1 = 39;
    static final int DLOAD_2 = 40;
    static final int DLOAD_3 = 41;
    static final int ALOAD_0 = 42;
    static final int ALOAD_1 = 43;
    static final int ALOAD_2 = 44;
    static final int ALOAD_3 = 45;
    static final int ISTORE_0 = 59;
    static final int ISTORE_1 = 60;
    static final int ISTORE_2 = 61;
    static final int ISTORE_3 = 62;
    static final int LSTORE_0 = 63;
    static final int LSTORE_1 = 64;
    static final int LSTORE_2 = 65;
    static final int LSTORE_3 = 66;
    static final int FSTORE_0 = 67;
    static final int FSTORE_1 = 68;
    static final int FSTORE_2 = 69;
    static final int FSTORE_3 = 70;
    static final int DSTORE_0 = 71;
    static final int DSTORE_1 = 72;
    static final int DSTORE_2 = 73;
    static final int DSTORE_3 = 74;
    static final int ASTORE_0 = 75;
    static final int ASTORE_1 = 76;
    static final int ASTORE_2 = 77;
    static final int ASTORE_3 = 78;
    static final int WIDE = 196;
    static final int GOTO_W = 200;
    static final int JSR_W = 201;
    static final int WIDE_JUMP_OPCODE_DELTA = 33;
    static final int ASM_OPCODE_DELTA = 49;
    static final int ASM_IFNULL_OPCODE_DELTA = 20;
    static final int ASM_IFEQ = 202;
    static final int ASM_IFNE = 203;
    static final int ASM_IFLT = 204;
    static final int ASM_IFGE = 205;
    static final int ASM_IFGT = 206;
    static final int ASM_IFLE = 207;
    static final int ASM_IF_ICMPEQ = 208;
    static final int ASM_IF_ICMPNE = 209;
    static final int ASM_IF_ICMPLT = 210;
    static final int ASM_IF_ICMPGE = 211;
    static final int ASM_IF_ICMPGT = 212;
    static final int ASM_IF_ICMPLE = 213;
    static final int ASM_IF_ACMPEQ = 214;
    static final int ASM_IF_ACMPNE = 215;
    static final int ASM_GOTO = 216;
    static final int ASM_JSR = 217;
    static final int ASM_IFNULL = 218;
    static final int ASM_IFNONNULL = 219;
    static final int ASM_GOTO_W = 220;

    private Constants() {
    }

    static void checkAsmExperimental(Object caller) {
        Class<?> callerClass = caller.getClass();
        String internalName = callerClass.getName().replace('.', '/');
        if (!Constants.isWhitelisted(internalName)) {
            Constants.checkIsPreview(callerClass.getClassLoader().getResourceAsStream(internalName + "io.quarkus.launcher.shaded..class"));
        }
    }

    static boolean isWhitelisted(String internalName) {
        if (!internalName.startsWith("io/quarkus/launcher/shaded/org/objectweb/asm/")) {
            return false;
        }
        String member = "io.quarkus.launcher.shaded.(Annotation|Class|Field|Method|Module|RecordComponent|Signature)";
        return internalName.contains("io.quarkus.launcher.shaded.Test$") || Pattern.matches("io/quarkus/launcher/shaded/org/objectweb/asm/util/Trace" + member + "io.quarkus.launcher.shaded.Visitor(\\$.*)?", internalName) || Pattern.matches("io/quarkus/launcher/shaded/org/objectweb/asm/util/Check" + member + "io.quarkus.launcher.shaded.Adapter(\\$.*)?", internalName);
    }

    static void checkIsPreview(InputStream classInputStream) {
        int minorVersion;
        if (classInputStream == null) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Bytecode not available, can't check class version");
        }
        try {
            DataInputStream callerClassStream = new DataInputStream(classInputStream);
            Throwable throwable = null;
            try {
                callerClassStream.readInt();
                minorVersion = callerClassStream.readUnsignedShort();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (callerClassStream != null) {
                    if (throwable != null) {
                        try {
                            callerClassStream.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        callerClassStream.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("io/quarkus/launcher/shaded/I/O error, can't check class version", ioe);
        }
        if (minorVersion != 65535) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.ASM9_EXPERIMENTAL can only be used by classes compiled with --enable-preview");
        }
    }
}

