/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.sonatype.plexus.components.cipher;

import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.AbstractLogEnabled;
import io.quarkus.launcher.shaded.org.sonatype.plexus.components.cipher.PBECipher;
import io.quarkus.launcher.shaded.org.sonatype.plexus.components.cipher.PlexusCipher;
import io.quarkus.launcher.shaded.org.sonatype.plexus.components.cipher.PlexusCipherException;
import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultPlexusCipher
extends AbstractLogEnabled
implements PlexusCipher {
    private static final Pattern ENCRYPTED_STRING_PATTERN = Pattern.compile("io.quarkus.launcher.shaded..*?[^\\\\]?\\{(.*?[^\\\\])\\}.*");
    private final PBECipher _cipher = new PBECipher();

    public String encrypt(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        return this._cipher.encrypt64(str, passPhrase);
    }

    public String encryptAndDecorate(String str, String passPhrase) throws PlexusCipherException {
        return this.decorate(this.encrypt(str, passPhrase));
    }

    public String decrypt(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        return this._cipher.decrypt64(str, passPhrase);
    }

    public String decryptDecorated(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        if (this.isEncryptedString(str)) {
            return this.decrypt(this.unDecorate(str), passPhrase);
        }
        return this.decrypt(str, passPhrase);
    }

    public boolean isEncryptedString(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(str);
        return matcher.matches() || matcher.find();
    }

    public String unDecorate(String str) throws PlexusCipherException {
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(str);
        if (matcher.matches() || matcher.find()) {
            return matcher.group(1);
        }
        throw new PlexusCipherException("io.quarkus.launcher.shaded.default.plexus.cipher.badEncryptedPassword");
    }

    public String decorate(String str) {
        return '{' + (str == null ? "io.quarkus.launcher.shaded." : str) + '}';
    }

    public static String[] getServiceTypes() {
        HashSet<String> result = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys = providers[i].keySet();
            Iterator<Object> it = keys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if ((key = key.split("io.quarkus.launcher.shaded. ")[0]).startsWith("io.quarkus.launcher.shaded.Alg.Alias.")) {
                    key = key.substring(10);
                }
                int ix = key.indexOf(46);
                result.add(key.substring(0, ix));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getCryptoImpls(String serviceType) {
        HashSet<String> result = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys = providers[i].keySet();
            Iterator<Object> it = keys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if ((key = key.split("io.quarkus.launcher.shaded. ")[0]).startsWith(serviceType + "io.quarkus.launcher.shaded..")) {
                    result.add(key.substring(serviceType.length() + 1));
                    continue;
                }
                if (!key.startsWith("io.quarkus.launcher.shaded.Alg.Alias." + serviceType + "io.quarkus.launcher.shaded..")) continue;
                result.add(key.substring(serviceType.length() + 11));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static void main(String[] args) {
        String[] serviceTypes = DefaultPlexusCipher.getServiceTypes();
        if (serviceTypes != null) {
            for (int i = 0; i < serviceTypes.length; ++i) {
                String serviceType = serviceTypes[i];
                String[] serviceProviders = DefaultPlexusCipher.getCryptoImpls(serviceType);
                if (serviceProviders != null) {
                    System.out.println(serviceType + "io.quarkus.launcher.shaded.: provider list");
                    for (int j = 0; j < serviceProviders.length; ++j) {
                        String provider = serviceProviders[j];
                        System.out.println("io.quarkus.launcher.shaded.        " + provider);
                    }
                    continue;
                }
                System.out.println(serviceType + "io.quarkus.launcher.shaded.: does not have any providers in this environment");
            }
        }
    }
}

