/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher;

import io.quarkus.launcher.RuntimeLaunchClassLoader;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class JBangIntegration {
    public static final String CONFIG = "//Q:CONFIG";

    public static Map<String, Object> postBuild(Path appClasses, Path pomFile, List<Map.Entry<String, String>> repositories, List<Map.Entry<String, Path>> dependencies, List<String> comments, boolean nativeImage) {
        for (String comment : comments) {
            if (!comment.startsWith(CONFIG)) continue;
            String conf = comment.substring(CONFIG.length()).trim();
            int equals = conf.indexOf("=");
            if (equals == -1) {
                throw new RuntimeException("invalid config  " + comment);
            }
            System.setProperty(conf.substring(0, equals), conf.substring(equals + 1));
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            RuntimeLaunchClassLoader loader = new RuntimeLaunchClassLoader(new ClassLoader(JBangIntegration.class.getClassLoader()){

                @Override
                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    return this.loadClass(name, false);
                }

                @Override
                protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    if (name.startsWith("org.")) {
                        throw new ClassNotFoundException();
                    }
                    return super.loadClass(name, resolve);
                }

                @Override
                public URL getResource(String name) {
                    if (name.startsWith("org/")) {
                        return null;
                    }
                    return super.getResource(name);
                }

                @Override
                public Enumeration<URL> getResources(String name) throws IOException {
                    if (name.startsWith("org/")) {
                        return Collections.emptyEnumeration();
                    }
                    return super.getResources(name);
                }
            });
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> launcher = loader.loadClass("io.quarkus.bootstrap.JBangBuilderImpl");
            Map map = (Map)launcher.getDeclaredMethod("postBuild", Path.class, Path.class, List.class, List.class, Boolean.TYPE).invoke(null, appClasses, pomFile, repositories, dependencies, nativeImage);
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            System.clearProperty("quarkus-internal.serialized-app-model.path");
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

