/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.infinispan.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.cache.Cache;
import io.quarkus.cache.infinispan.runtime.InfinispanCacheInfo;
import io.quarkus.cache.runtime.AbstractCache;
import io.quarkus.infinispan.client.runtime.InfinispanClientProducer;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.util.NullValue;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class InfinispanCacheImpl
extends AbstractCache
implements Cache {
    private final RemoteCache remoteCache;
    private final InfinispanCacheInfo cacheInfo;
    private final Map<Object, CompletableFuture> computationResults = new ConcurrentHashMap<Object, CompletableFuture>();
    private final long lifespan;
    private final long maxIdle;

    public InfinispanCacheImpl(InfinispanCacheInfo cacheInfo, RemoteCache remoteCache) {
        this.cacheInfo = cacheInfo;
        this.remoteCache = remoteCache;
        this.lifespan = cacheInfo.lifespan.map(l -> l.toMillis()).orElse(-1L);
        this.maxIdle = cacheInfo.maxIdle.map(m -> m.toMillis()).orElse(-1L);
    }

    public InfinispanCacheImpl(InfinispanCacheInfo cacheInfo, Optional<String> infinispanClientName) {
        this(cacheInfo, InfinispanCacheImpl.determineInfinispanClient(infinispanClientName, cacheInfo.name));
    }

    private static RemoteCache determineInfinispanClient(Optional<String> infinispanCacheName, String cacheName) {
        ArcContainer container = Arc.container();
        InfinispanClientProducer producer = (InfinispanClientProducer)container.instance(InfinispanClientProducer.class, new Annotation[0]).get();
        return producer.getRemoteCache(infinispanCacheName.orElse("<default>"), cacheName);
    }

    public String getName() {
        return Objects.requireNonNullElse(this.cacheInfo.name, "default-infinispan-cache");
    }

    public Object getDefaultKey() {
        return "default-key";
    }

    private Object encodeNull(Object value) {
        return value != null ? value : NullValue.NULL;
    }

    private <T> T decodeNull(Object value) {
        return (T)(value != NullValue.NULL ? value : null);
    }

    public <K, V> Uni<V> get(K key, Function<K, V> valueLoader) {
        return Uni.createFrom().completionStage(() -> CompletionStages.handleAndCompose((CompletionStage)this.remoteCache.getAsync(key), (v1, ex1) -> {
            if (ex1 != null) {
                return CompletableFuture.failedFuture(ex1);
            }
            if (v1 != null) {
                return CompletableFuture.completedFuture(this.decodeNull(v1));
            }
            CompletableFuture resultAsync = new CompletableFuture();
            CompletableFuture computedValue = this.computationResults.putIfAbsent(key, resultAsync);
            if (computedValue != null) {
                return computedValue;
            }
            Object newValue = valueLoader.apply(key);
            this.remoteCache.putIfAbsentAsync(key, this.encodeNull(newValue), this.lifespan, TimeUnit.MILLISECONDS, this.maxIdle, TimeUnit.MILLISECONDS).whenComplete((existing, ex2) -> {
                if (ex2 != null) {
                    resultAsync.completeExceptionally((Throwable)ex2);
                } else if (existing == null) {
                    resultAsync.complete(newValue);
                } else {
                    resultAsync.complete(this.decodeNull(existing));
                }
                this.computationResults.remove(key);
            });
            return resultAsync;
        }));
    }

    public <K, V> Uni<V> getAsync(K key, Function<K, Uni<V>> valueLoader) {
        return Uni.createFrom().completionStage(CompletionStages.handleAndCompose((CompletionStage)this.remoteCache.getAsync(key), (v1, ex1) -> {
            if (ex1 != null) {
                return CompletableFuture.failedFuture(ex1);
            }
            if (v1 != null) {
                return CompletableFuture.completedFuture(this.decodeNull(v1));
            }
            CompletableFuture resultAsync = new CompletableFuture();
            CompletableFuture computedValue = this.computationResults.putIfAbsent(key, resultAsync);
            if (computedValue != null) {
                return computedValue;
            }
            ((Uni)valueLoader.apply(key)).convert().toCompletionStage().whenComplete((newValue, ex2) -> {
                if (ex2 != null) {
                    resultAsync.completeExceptionally((Throwable)ex2);
                    this.computationResults.remove(key);
                } else {
                    this.remoteCache.putIfAbsentAsync(key, this.encodeNull(newValue), this.lifespan, TimeUnit.MILLISECONDS, this.maxIdle, TimeUnit.MILLISECONDS).whenComplete((existing, ex3) -> {
                        if (ex3 != null) {
                            resultAsync.completeExceptionally((Throwable)ex3);
                        } else if (existing == null) {
                            resultAsync.complete(newValue);
                        } else {
                            resultAsync.complete(this.decodeNull(existing));
                        }
                        this.computationResults.remove(key);
                    });
                }
            });
            return resultAsync;
        }));
    }

    public Uni<Void> invalidate(Object key) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.removeAsync(key));
    }

    public Uni<Void> invalidateAll() {
        return Uni.createFrom().completionStage(() -> this.remoteCache.clearAsync());
    }

    public Uni<Void> invalidateIf(Predicate<Object> predicate) {
        Flow.Publisher entriesPublisher = FlowAdapters.toFlowPublisher((Publisher)this.remoteCache.publishEntries("org.infinispan.server.hotrod.HotRodServer$ToEmptyBytesKeyValueFilterConverter", null, null, 512));
        return Uni.createFrom().multi(Multi.createFrom().publisher(entriesPublisher).map(e -> e.getKey()).filter(key -> predicate.test(key)).onItem().call(key -> Uni.createFrom().completionStage((CompletionStage)this.remoteCache.removeAsync(key)))).replaceWithVoid();
    }

    public <T extends Cache> T as(Class<T> type) {
        if (type.getTypeName().equals(InfinispanCacheImpl.class.getTypeName())) {
            return (T)((Object)this);
        }
        throw new IllegalArgumentException("Class type not supported : " + type);
    }
}

