/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.infinispan.client.deployment.InfinispanPropertiesBuildItem;
import io.quarkus.infinispan.client.runtime.InfinispanClientBuildTimeConfig;
import io.quarkus.infinispan.client.runtime.InfinispanClientProducer;
import io.quarkus.infinispan.client.runtime.InfinispanClientRuntimeConfig;
import io.quarkus.infinispan.client.runtime.InfinispanRecorder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.SerializationContextInitializer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Type;

class InfinispanClientProcessor {
    private static final Log log = LogFactory.getLog(InfinispanClientProcessor.class);
    private static final String META_INF = "META-INF";
    private static final String HOTROD_CLIENT_PROPERTIES = "META-INF" + File.separator + "/hotrod-client.properties";
    private static final String PROTO_EXTENSION = ".proto";
    InfinispanClientBuildTimeConfig infinispanClient;
    private static final Set<DotName> UNREMOVABLE_BEANS = Collections.unmodifiableSet(new HashSet<DotName>(Arrays.asList(DotName.createSimple((String)BaseMarshaller.class.getName()), DotName.createSimple((String)EnumMarshaller.class.getName()), DotName.createSimple((String)MessageMarshaller.class.getName()), DotName.createSimple((String)RawProtobufMarshaller.class.getName()), DotName.createSimple((String)FileDescriptorSource.class.getName()))));

    InfinispanClientProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BuildStep
    InfinispanPropertiesBuildItem setup(ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeployment, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<FeatureBuildItem> feature, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, BuildProducer<NativeImageConfigBuildItem> nativeImageConfig, ApplicationIndexBuildItem applicationIndexBuildItem) throws ClassNotFoundException, IOException {
        Properties properties;
        feature.produce((BuildItem)new FeatureBuildItem("infinispan-client"));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(InfinispanClientProducer.class));
        systemProperties.produce((BuildItem)new SystemPropertyBuildItem("io.netty.noUnsafe", "true"));
        hotDeployment.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(HOTROD_CLIENT_PROPERTIES));
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem("infinispan-client"));
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream stream = cl.getResourceAsStream(HOTROD_CLIENT_PROPERTIES);
        if (stream == null) {
            properties = new Properties();
            if (log.isTraceEnabled()) {
                log.tracef("There was no hotrod-client.properties file found - using defaults", new Object[0]);
            }
        } else {
            try {
                properties = this.loadFromStream(stream);
                if (log.isDebugEnabled()) {
                    log.debugf("Found HotRod properties of %s", (Object)properties);
                }
            }
            finally {
                Util.close((AutoCloseable)stream);
            }
            if (properties.containsKey("infinispan.client.hotrod.near_cache.max_entries")) {
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"com.github.benmanes.caffeine.cache.SSMS"}));
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"com.github.benmanes.caffeine.cache.PSMS"}));
            }
        }
        InfinispanClientProducer.replaceProperties((Properties)properties);
        Index index = applicationIndexBuildItem.getIndex();
        Object marshaller = properties.get("infinispan.client.hotrod.marshaller");
        if (marshaller instanceof ProtoStreamMarshaller) {
            ApplicationArchive applicationArchive = applicationArchivesBuildItem.getRootArchive();
            Path metaPath = applicationArchive.getChildPath(META_INF);
            if (metaPath != null) {
                Iterator protoFiles = Files.list(metaPath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(PROTO_EXTENSION)).iterator();
                if (protoFiles.hasNext()) {
                    // empty if block
                }
                while (protoFiles.hasNext()) {
                    Path path = (Path)protoFiles.next();
                    byte[] bytes = Files.readAllBytes(path);
                    properties.put("infinispan.client.hotrod.protofile." + path.getFileName().toString(), new String(bytes, StandardCharsets.UTF_8));
                }
            }
            InfinispanClientProducer.handleProtoStreamRequirements((Properties)properties);
            Set initializerClasses = index.getAllKnownImplementors(DotName.createSimple((String)SerializationContextInitializer.class.getName()));
            HashSet<SerializationContextInitializer> initializers = new HashSet<SerializationContextInitializer>(initializerClasses.size());
            for (ClassInfo ci : initializerClasses) {
                Class<?> initializerClass = Class.forName(ci.toString());
                try {
                    SerializationContextInitializer sci = (SerializationContextInitializer)initializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    initializers.add(sci);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!initializers.isEmpty()) {
                properties.put("infinispan.client.hotrod.proto-initializers", initializers);
            }
        }
        List listenerInstances = index.getAnnotations(DotName.createSimple((String)ClientListener.class.getName()));
        for (AnnotationInstance instance : listenerInstances) {
            AnnotationTarget target = instance.target();
            if (target.kind() != AnnotationTarget.Kind.CLASS) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{target.asClass().name().toString()}));
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"io.netty.channel.socket.nio.NioSocketChannel"}));
        nativeImageConfig.produce((BuildItem)NativeImageConfigBuildItem.builder().addRuntimeInitializedClass("org.infinispan.client.hotrod.impl.transport.netty.TransportHelper").build());
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.infinispan.client.hotrod.event.impl.ContinuousQueryImpl$ClientEntryListener"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.infinispan.client.hotrod.near.NearCacheService$InvalidatedNearCacheListener"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash"}));
        return new InfinispanPropertiesBuildItem(properties);
    }

    private Properties loadFromStream(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new HotRodClientException("Issues configuring from client hotrod-client.properties", (Throwable)e);
        }
        return properties;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    BeanContainerListenerBuildItem build(InfinispanRecorder recorder, InfinispanPropertiesBuildItem builderBuildItem) {
        int maxEntries;
        Properties properties = builderBuildItem.getProperties();
        InfinispanClientBuildTimeConfig conf = this.infinispanClient;
        if (log.isDebugEnabled()) {
            log.debugf("Applying micro profile configuration: %s", (Object)conf);
        }
        if ((maxEntries = conf.nearCacheMaxEntries) > 0 && !properties.containsKey("infinispan.client.hotrod.near_cache.mode")) {
            properties.put("infinispan.client.hotrod.near_cache.mode", NearCacheMode.INVALIDATED.toString());
            properties.putIfAbsent("infinispan.client.hotrod.near_cache.max_entries", (Object)maxEntries);
        }
        return new BeanContainerListenerBuildItem(recorder.configureInfinispan(properties));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void configureRuntimeProperties(InfinispanRecorder recorder, InfinispanClientRuntimeConfig infinispanClientRuntimeConfig) {
        recorder.configureRuntimeProperties(infinispanClientRuntimeConfig);
    }

    @BuildStep
    UnremovableBeanBuildItem ensureBeanLookupAvailable() {
        return new UnremovableBeanBuildItem(beanInfo -> {
            Set types = beanInfo.getTypes();
            for (Type t : types) {
                if (!UNREMOVABLE_BEANS.contains(t.name())) continue;
                return true;
            }
            return false;
        });
    }
}

