/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.deployment.devservices;

import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.infinispan.client.deployment.InfinispanClientDevServiceBuildTimeConfig;
import io.quarkus.infinispan.client.deployment.devservices.InfinispanDevServicesConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.commons.util.Version;
import org.infinispan.server.test.core.InfinispanContainer;
import org.jboss.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.GenericContainer;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class InfinispanDevServiceProcessor {
    private static final Logger log = Logger.getLogger(InfinispanDevServiceProcessor.class);
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-infinispan";
    public static final int DEFAULT_INFINISPAN_PORT = 11222;
    private static final ContainerLocator infinispanContainerLocator = new ContainerLocator("quarkus-dev-service-infinispan", 11222);
    private static final String DEFAULT_PASSWORD = "password";
    private static final String QUARKUS = "quarkus.";
    private static final String DOT = ".";
    private static volatile List<DevServicesResultBuildItem.RunningDevService> devServices;
    private static volatile InfinispanClientDevServiceBuildTimeConfig.DevServiceConfiguration capturedDevServicesConfiguration;
    private static volatile boolean first;

    @BuildStep
    public List<DevServicesResultBuildItem> startInfinispanContainers(LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, InfinispanClientDevServiceBuildTimeConfig config, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        if (devServices != null) {
            boolean restartRequired;
            boolean bl = restartRequired = !config.devService.equals(capturedDevServicesConfiguration);
            if (!restartRequired) {
                return devServices.stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
            }
            for (Closeable closeable : devServices) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop infinispan container", e);
                }
            }
            devServices = null;
            capturedDevServicesConfiguration = null;
        }
        capturedDevServicesConfiguration = config.devService;
        ArrayList<DevServicesResultBuildItem.RunningDevService> newDevServices = new ArrayList<DevServicesResultBuildItem.RunningDevService>();
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Infinispan Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            DevServicesResultBuildItem.RunningDevService runningDevService = this.startContainer(dockerStatusBuildItem, config.devService.devservices, launchMode.getLaunchMode(), !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
            if (runningDevService == null) {
                compressor.closeAndDumpCaptured();
                return null;
            }
            newDevServices.add(runningDevService);
            log.infof("The infinispan server is ready to accept connections on %s", runningDevService.getConfig().get(this.getConfigPrefix() + "hosts"));
            compressor.close();
        }
        catch (Throwable throwable) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(throwable);
        }
        devServices = newDevServices;
        if (first) {
            first = false;
            Runnable runnable = () -> {
                if (devServices != null) {
                    for (Closeable closeable : devServices) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable t) {
                            log.error((Object)"Failed to stop infinispan", t);
                        }
                    }
                }
                first = true;
                devServices = null;
                capturedDevServicesConfiguration = null;
            };
            closeBuildItem.addCloseTask(runnable, true);
        }
        return devServices.stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, InfinispanDevServicesConfig devServicesConfig, LaunchMode launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        boolean needToStart;
        if (!devServicesConfig.enabled) {
            log.debug((Object)"Not starting devservices for Infinispan as it has been disabled in the config");
            return null;
        }
        String configPrefix = this.getConfigPrefix();
        boolean bl = needToStart = !ConfigUtils.isPropertyPresent((String)(configPrefix + "hosts")) && !ConfigUtils.isPropertyPresent((String)(configPrefix + "server-list"));
        if (!needToStart) {
            log.debug((Object)"Not starting devservices for Infinispan as 'hosts', 'uri' or 'server-list' have been provided");
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warn((Object)"Please configure 'quarkus.infinispan-client.hosts' or 'quarkus.infinispan-client.uri' or get a working docker instance");
            return null;
        }
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultInfinispanServerSupplier = () -> {
            QuarkusInfinispanContainer infinispanContainer = new QuarkusInfinispanContainer(devServicesConfig, launchMode, useSharedNetwork);
            timeout.ifPresent(arg_0 -> ((QuarkusInfinispanContainer)infinispanContainer).withStartupTimeout(arg_0));
            infinispanContainer.start();
            return this.getRunningDevService(infinispanContainer.getContainerId(), () -> ((QuarkusInfinispanContainer)infinispanContainer).close(), infinispanContainer.getHost() + ":" + infinispanContainer.getPort(), infinispanContainer.getUser(), infinispanContainer.getPassword());
        };
        return infinispanContainerLocator.locateContainer(devServicesConfig.serviceName, devServicesConfig.shared, launchMode).map(containerAddress -> this.getRunningDevService(containerAddress.getId(), null, containerAddress.getUrl(), "admin", DEFAULT_PASSWORD)).orElseGet(defaultInfinispanServerSupplier);
    }

    @NotNull
    private DevServicesResultBuildItem.RunningDevService getRunningDevService(String containerId, Closeable closeable, String serverList, String username, String password) {
        HashMap<CallSite, String> config = new HashMap<CallSite, String>();
        config.put((CallSite)((Object)(this.getConfigPrefix() + "hosts")), serverList);
        config.put((CallSite)((Object)(this.getConfigPrefix() + "client-intelligence")), "BASIC");
        config.put((CallSite)((Object)(this.getConfigPrefix() + "username")), username);
        config.put((CallSite)((Object)(this.getConfigPrefix() + DEFAULT_PASSWORD)), password);
        return new DevServicesResultBuildItem.RunningDevService(Feature.INFINISPAN_CLIENT.getName(), containerId, closeable, config);
    }

    private String getConfigPrefix() {
        return "quarkus.infinispan-client.";
    }

    static {
        first = true;
    }

    private static class QuarkusInfinispanContainer
    extends InfinispanContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusInfinispanContainer(InfinispanDevServicesConfig config, LaunchMode launchMode, boolean useSharedNetwork) {
            super(config.imageName.orElse("quay.io/infinispan/server:" + Version.getMajorMinor()));
            this.fixedExposedPort = config.port;
            this.useSharedNetwork = useSharedNetwork;
            if (launchMode == LaunchMode.DEVELOPMENT) {
                this.withLabel(InfinispanDevServiceProcessor.DEV_SERVICE_LABEL, config.serviceName);
            }
            this.withUser("admin");
            this.withPassword(InfinispanDevServiceProcessor.DEFAULT_PASSWORD);
            config.artifacts.ifPresent(a -> this.withArtifacts(a.toArray(new String[0])));
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"infinispan");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 11222);
            } else {
                this.addExposedPort(11222);
            }
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 11222;
            }
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getFirstMappedPort();
        }

        public String getUser() {
            return "admin";
        }

        public String getPassword() {
            return InfinispanDevServiceProcessor.DEFAULT_PASSWORD;
        }

        public String getHost() {
            return this.useSharedNetwork ? this.hostName : super.getHost();
        }
    }
}

