/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime;

import io.quarkus.infinispan.client.Remote;
import io.quarkus.infinispan.client.runtime.InfinispanClientRuntimeConfig;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;

@ApplicationScoped
public class InfinispanClientProducer {
    private static final Log log = LogFactory.getLog(InfinispanClientProducer.class);
    public static final String PROTOBUF_FILE_PREFIX = "infinispan.client.hotrod.protofile.";
    public static final String PROTOBUF_INITIALIZERS = "infinispan.client.hotrod.proto-initializers";
    @Inject
    private BeanManager beanManager;
    private volatile Properties properties;
    private volatile RemoteCacheManager cacheManager;
    @Inject
    private Instance<InfinispanClientRuntimeConfig> infinispanClientRuntimeConfig;

    private void initialize() {
        log.debug((Object)"Initializing CacheManager");
        if (this.properties == null) {
            return;
        }
        Configuration conf = this.builderFromProperties(this.properties).build();
        this.cacheManager = new RemoteCacheManager(conf);
        InfinispanClientRuntimeConfig infinispanClientRuntimeConfig = (InfinispanClientRuntimeConfig)this.infinispanClientRuntimeConfig.get();
        if (infinispanClientRuntimeConfig.useSchemaRegistration.orElse(Boolean.TRUE).booleanValue()) {
            RemoteCache protobufMetadataCache = null;
            Set initializers = (Set)this.properties.remove(PROTOBUF_INITIALIZERS);
            if (initializers != null) {
                for (SerializationContextInitializer serializationContextInitializer : initializers) {
                    if (protobufMetadataCache == null) {
                        protobufMetadataCache = this.cacheManager.getCache("___protobuf_metadata");
                    }
                    protobufMetadataCache.put((Object)serializationContextInitializer.getProtoFileName(), (Object)serializationContextInitializer.getProtoFile());
                }
            }
            for (Map.Entry entry : this.properties.entrySet()) {
                String keyString;
                Object key = entry.getKey();
                if (!(key instanceof String) || !(keyString = (String)key).startsWith(PROTOBUF_FILE_PREFIX)) continue;
                String fileName = keyString.substring(PROTOBUF_FILE_PREFIX.length());
                String fileContents = (String)entry.getValue();
                if (protobufMetadataCache == null) {
                    protobufMetadataCache = this.cacheManager.getCache("___protobuf_metadata");
                }
                protobufMetadataCache.put((Object)fileName, (Object)fileContents);
            }
        }
    }

    public static void replaceProperties(Properties properties) throws ClassNotFoundException {
        String marshallerClassName = (String)properties.get("infinispan.client.hotrod.marshaller");
        if (marshallerClassName != null) {
            Class<?> marshallerClass = Class.forName(marshallerClassName, false, Thread.currentThread().getContextClassLoader());
            properties.put("infinispan.client.hotrod.marshaller", Util.getInstance(marshallerClass));
        } else {
            properties.put("infinispan.client.hotrod.marshaller", new ProtoStreamMarshaller());
        }
    }

    public static void handleProtoStreamRequirements(Properties properties) {
        properties.put("infinispan.client.hotrod.protofile.org/infinispan/protostream/message-wrapping.proto", InfinispanClientProducer.getContents("/org/infinispan/protostream/message-wrapping.proto"));
        String queryProtoFile = "org/infinispan/query/remote/client/query.proto";
        properties.put(PROTOBUF_FILE_PREFIX + queryProtoFile, InfinispanClientProducer.getContents("/" + queryProtoFile));
    }

    private static String getContents(String fileName) {
        InputStream stream = InfinispanClientProducer.class.getResourceAsStream(fileName);
        try (Scanner scanner = new Scanner(stream, "UTF-8");){
            String string = scanner.useDelimiter("\\A").next();
            return string;
        }
    }

    private ConfigurationBuilder builderFromProperties(Properties properties) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Object marshallerInstance = properties.remove("infinispan.client.hotrod.marshaller");
        if (marshallerInstance != null) {
            if (marshallerInstance instanceof ProtoStreamMarshaller) {
                InfinispanClientProducer.handleProtoStreamMarshaller((ProtoStreamMarshaller)marshallerInstance, properties, this.beanManager);
            }
            builder.marshaller((Marshaller)marshallerInstance);
        }
        InfinispanClientRuntimeConfig infinispanClientRuntimeConfig = (InfinispanClientRuntimeConfig)this.infinispanClientRuntimeConfig.get();
        if (infinispanClientRuntimeConfig.serverList.isPresent()) {
            properties.put("infinispan.client.hotrod.server_list", infinispanClientRuntimeConfig.serverList.get());
        }
        if (infinispanClientRuntimeConfig.clientIntelligence.isPresent()) {
            properties.put("infinispan.client.hotrod.client_intelligence", infinispanClientRuntimeConfig.clientIntelligence.get());
        }
        if (infinispanClientRuntimeConfig.useAuth.isPresent()) {
            properties.put("infinispan.client.hotrod.use_auth", infinispanClientRuntimeConfig.useAuth.get());
        }
        if (infinispanClientRuntimeConfig.authUsername.isPresent()) {
            properties.put("infinispan.client.hotrod.auth_username", infinispanClientRuntimeConfig.authUsername.get());
        }
        if (infinispanClientRuntimeConfig.authPassword.isPresent()) {
            properties.put("infinispan.client.hotrod.auth_password", infinispanClientRuntimeConfig.authPassword.get());
        }
        if (infinispanClientRuntimeConfig.authRealm.isPresent()) {
            properties.put("infinispan.client.hotrod.auth_realm", infinispanClientRuntimeConfig.authRealm.get());
        }
        if (infinispanClientRuntimeConfig.authServerName.isPresent()) {
            properties.put("infinispan.client.hotrod.auth_server_name", infinispanClientRuntimeConfig.authServerName.get());
        }
        if (infinispanClientRuntimeConfig.authClientSubject.isPresent()) {
            properties.put("infinispan.client.hotrod.auth_client_subject", infinispanClientRuntimeConfig.authClientSubject.get());
        }
        if (infinispanClientRuntimeConfig.authCallbackHandler.isPresent()) {
            properties.put("infinispan.client.hotrod.auth_callback_handler", infinispanClientRuntimeConfig.authCallbackHandler.get());
        }
        if (infinispanClientRuntimeConfig.saslMechanism.isPresent()) {
            properties.put("infinispan.client.hotrod.sasl_mechanism", infinispanClientRuntimeConfig.saslMechanism.get());
        }
        if (infinispanClientRuntimeConfig.trustStore.isPresent()) {
            properties.put("infinispan.client.hotrod.trust_store_file_name", infinispanClientRuntimeConfig.trustStore.get());
        }
        if (infinispanClientRuntimeConfig.trustStorePassword.isPresent()) {
            properties.put("infinispan.client.hotrod.trust_store_password", infinispanClientRuntimeConfig.trustStorePassword.get());
        }
        if (infinispanClientRuntimeConfig.trustStoreType.isPresent()) {
            properties.put("infinispan.client.hotrod.trust_store_type", infinispanClientRuntimeConfig.trustStoreType.get());
        }
        builder.withProperties(properties);
        return builder;
    }

    private static void handleProtoStreamMarshaller(ProtoStreamMarshaller marshaller, Properties properties, BeanManager beanManager) {
        SerializationContext serializationContext = marshaller.getSerializationContext();
        Set initializers = (Set)properties.get(PROTOBUF_INITIALIZERS);
        if (initializers != null) {
            for (SerializationContextInitializer initializer : initializers) {
                initializer.registerSchema(serializationContext);
                initializer.registerMarshallers(serializationContext);
            }
        }
        FileDescriptorSource fileDescriptorSource = null;
        for (Map.Entry entry : properties.entrySet()) {
            String keyString;
            Object key = entry.getKey();
            if (!(key instanceof String) || !(keyString = (String)key).startsWith(PROTOBUF_FILE_PREFIX)) continue;
            String fileName = keyString.substring(PROTOBUF_FILE_PREFIX.length());
            String fileContents = (String)entry.getValue();
            if (fileDescriptorSource == null) {
                fileDescriptorSource = new FileDescriptorSource();
            }
            fileDescriptorSource.addProtoFile(fileName, fileContents);
        }
        if (fileDescriptorSource != null) {
            serializationContext.registerProtoFiles(fileDescriptorSource);
        }
        Set protoFileBeans = beanManager.getBeans(FileDescriptorSource.class, new Annotation[0]);
        for (Bean bean : protoFileBeans) {
            CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
            FileDescriptorSource fds = (FileDescriptorSource)beanManager.getReference(bean, FileDescriptorSource.class, ctx);
            serializationContext.registerProtoFiles(fds);
            for (Map.Entry entry : fds.getFileDescriptors().entrySet()) {
                properties.put(PROTOBUF_FILE_PREFIX + (String)entry.getKey(), new String((char[])entry.getValue()));
            }
        }
        Set set = beanManager.getBeans(BaseMarshaller.class, new Annotation[0]);
        for (Bean bean : set) {
            CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
            BaseMarshaller messageMarshaller = (BaseMarshaller)beanManager.getReference(bean, BaseMarshaller.class, ctx);
            serializationContext.registerMarshaller(messageMarshaller);
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
    }

    @Remote
    @Produces
    public <K, V> RemoteCache<K, V> getRemoteCache(InjectionPoint injectionPoint, RemoteCacheManager cacheManager) {
        Set annotationSet = injectionPoint.getQualifiers();
        Remote remote = this.getRemoteAnnotation(annotationSet);
        if (remote != null && !remote.value().isEmpty()) {
            return cacheManager.getCache(remote.value());
        }
        return cacheManager.getCache();
    }

    @Produces
    public CounterManager counterManager() {
        return RemoteCounterManagerFactory.asCounterManager((RemoteCacheManager)this.remoteCacheManager());
    }

    @Produces
    public synchronized RemoteCacheManager remoteCacheManager() {
        if (this.cacheManager != null) {
            return this.cacheManager;
        }
        this.initialize();
        return this.cacheManager;
    }

    void configure(Properties properties) {
        this.properties = properties;
    }

    private Remote getRemoteAnnotation(Set<Annotation> annotationSet) {
        for (Annotation annotation : annotationSet) {
            if (!(annotation instanceof Remote)) continue;
            return (Remote)annotation;
        }
        return null;
    }
}

