/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime.cache;

import io.quarkus.infinispan.client.CacheInvalidate;
import io.quarkus.infinispan.client.runtime.cache.CacheInterceptionContext;
import io.quarkus.infinispan.client.runtime.cache.CacheInterceptor;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.CacheException;
import org.jboss.logging.Logger;

@CacheInvalidate(cacheName="")
@Interceptor
@Priority(value=1)
public class CacheInvalidateInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheInvalidateInterceptor.class);
    private static final String INTERCEPTOR_BINDINGS_ERROR_MSG = "The Quarkus Infinispan Client extension is not working properly (CacheInvalidate interceptor bindings retrieval failed), please create a GitHub issue in the Quarkus repository to help the maintainers fix this bug";

    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        CacheInterceptionContext<CacheInvalidate> interceptionContext = this.getInterceptionContext(invocationContext, CacheInvalidate.class);
        if (interceptionContext.getInterceptorBindings().isEmpty()) {
            LOGGER.warn((Object)INTERCEPTOR_BINDINGS_ERROR_MSG);
            return invocationContext.proceed();
        }
        CacheInterceptor.ReturnType returnType = CacheInvalidateInterceptor.determineReturnType(invocationContext.getMethod().getReturnType());
        if (returnType == CacheInterceptor.ReturnType.NonAsync) {
            return this.invalidateBlocking(invocationContext, interceptionContext);
        }
        return this.invalidateNonBlocking(invocationContext, interceptionContext, returnType);
    }

    private Object invalidateNonBlocking(final InvocationContext invocationContext, CacheInterceptionContext<CacheInvalidate> interceptionContext, final CacheInterceptor.ReturnType returnType) {
        LOGGER.trace((Object)"Invalidating cache entries in a non-blocking way");
        Uni uni = Multi.createFrom().iterable(interceptionContext.getInterceptorBindings()).onItem().transformToUniAndMerge((Function)new Function<CacheInvalidate, Uni<? extends Void>>(){

            @Override
            public Uni<Void> apply(CacheInvalidate binding) {
                return CacheInvalidateInterceptor.this.invalidate(binding, invocationContext.getParameters());
            }
        }).onItem().ignoreAsUni().onItem().transformToUni(new Function<Object, Uni<?>>(){

            @Override
            public Uni<?> apply(Object ignored) {
                try {
                    return CacheInvalidateInterceptor.this.asyncInvocationResultToUni(invocationContext.proceed(), returnType);
                }
                catch (Exception e) {
                    throw new CacheException((Throwable)e);
                }
            }
        });
        return this.createAsyncResult((Uni<Object>)uni, returnType);
    }

    private Object invalidateBlocking(InvocationContext invocationContext, CacheInterceptionContext<CacheInvalidate> interceptionContext) throws Exception {
        LOGGER.trace((Object)"Invalidating cache entries in a blocking way");
        for (CacheInvalidate binding : interceptionContext.getInterceptorBindings()) {
            this.invalidate(binding, invocationContext.getParameters()).await().indefinitely();
        }
        return invocationContext.proceed();
    }

    private Uni<Void> invalidate(CacheInvalidate binding, Object[] parameters) {
        final RemoteCache cache = this.cacheManager.getCache(binding.cacheName());
        final Object key = this.getCacheKey(parameters);
        LOGGER.debugf("Invalidating entry with key [%s] from cache [%s]", key, (Object)binding.cacheName());
        return Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<? extends Void>>(){

            @Override
            public CompletionStage<Void> get() {
                return cache.removeAsync(key);
            }
        });
    }
}

