/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime.cache;

import io.quarkus.infinispan.client.CacheInvalidateAll;
import io.quarkus.infinispan.client.runtime.cache.CacheInterceptionContext;
import io.quarkus.infinispan.client.runtime.cache.CacheInterceptor;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.CacheException;
import org.jboss.logging.Logger;

@CacheInvalidateAll(cacheName="")
@Interceptor
@Priority(value=0)
public class CacheInvalidateAllInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheInvalidateAllInterceptor.class);
    private static final String INTERCEPTOR_BINDINGS_ERROR_MSG = "The Quarkus Infinispan Client extension is not working properly (CacheInvalidateAll interceptor bindings retrieval failed), please create a GitHub issue in the Quarkus repository to help the maintainers fix this bug";

    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        CacheInterceptionContext<CacheInvalidateAll> interceptionContext = this.getInterceptionContext(invocationContext, CacheInvalidateAll.class);
        if (interceptionContext.getInterceptorBindings().isEmpty()) {
            LOGGER.warn((Object)INTERCEPTOR_BINDINGS_ERROR_MSG);
            return invocationContext.proceed();
        }
        CacheInterceptor.ReturnType returnType = CacheInvalidateAllInterceptor.determineReturnType(invocationContext.getMethod().getReturnType());
        if (returnType == CacheInterceptor.ReturnType.NonAsync) {
            return this.invalidateAllBlocking(invocationContext, interceptionContext);
        }
        return this.invalidateAllNonBlocking(invocationContext, interceptionContext, returnType);
    }

    private Object invalidateAllNonBlocking(final InvocationContext invocationContext, CacheInterceptionContext<CacheInvalidateAll> interceptionContext, final CacheInterceptor.ReturnType returnType) {
        LOGGER.trace((Object)"Invalidating all cache entries in a non-blocking way");
        Uni uni = Multi.createFrom().iterable(interceptionContext.getInterceptorBindings()).onItem().transformToUniAndMerge((Function)new Function<CacheInvalidateAll, Uni<? extends Void>>(){

            @Override
            public Uni<Void> apply(CacheInvalidateAll binding) {
                return CacheInvalidateAllInterceptor.this.invalidateAll(binding);
            }
        }).onItem().ignoreAsUni().onItem().transformToUni(new Function<Object, Uni<?>>(){

            @Override
            public Uni<?> apply(Object ignored) {
                try {
                    return CacheInvalidateAllInterceptor.this.asyncInvocationResultToUni(invocationContext.proceed(), returnType);
                }
                catch (Exception e) {
                    throw new CacheException((Throwable)e);
                }
            }
        });
        return this.createAsyncResult((Uni<Object>)uni, returnType);
    }

    private Object invalidateAllBlocking(InvocationContext invocationContext, CacheInterceptionContext<CacheInvalidateAll> interceptionContext) throws Exception {
        LOGGER.trace((Object)"Invalidating all cache entries in a blocking way");
        for (CacheInvalidateAll binding : interceptionContext.getInterceptorBindings()) {
            this.invalidateAll(binding).await().indefinitely();
        }
        return invocationContext.proceed();
    }

    private Uni<Void> invalidateAll(CacheInvalidateAll binding) {
        final RemoteCache cache = this.cacheManager.getCache(binding.cacheName());
        LOGGER.debugf("Invalidating all entries from cache [%s]", (Object)binding.cacheName());
        return Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<? extends Void>>(){

            @Override
            public CompletionStage<Void> get() {
                return cache.clearAsync();
            }
        });
    }
}

