/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime.cache;

import io.quarkus.infinispan.client.CacheResult;
import io.quarkus.infinispan.client.runtime.cache.CacheInterceptionContext;
import io.quarkus.infinispan.client.runtime.cache.CacheInterceptor;
import io.quarkus.infinispan.client.runtime.cache.InfinispanGetWrapper;
import io.quarkus.infinispan.client.runtime.cache.SynchronousInfinispanGet;
import io.quarkus.infinispan.client.runtime.cache.UnresolvedUniValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.CacheException;
import org.jboss.logging.Logger;

@CacheResult(cacheName="")
@Interceptor
@Priority(value=2)
public class CacheResultInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheResultInterceptor.class);
    private static final String INTERCEPTOR_BINDING_ERROR_MSG = "The Quarkus Infinispan Client extension is not working properly (CacheResult interceptor binding retrieval failed), please create a GitHub issue in the Quarkus repository to help the maintainers fix this bug";
    @Inject
    SynchronousInfinispanGet syncronousInfinispanGet;

    @AroundInvoke
    public Object intercept(final InvocationContext invocationContext) throws Throwable {
        Object value;
        if (Multi.class.isAssignableFrom(invocationContext.getMethod().getReturnType())) {
            return invocationContext.proceed();
        }
        CacheInterceptionContext<CacheResult> interceptionContext = this.getInterceptionContext(invocationContext, CacheResult.class);
        if (interceptionContext.getInterceptorBindings().isEmpty()) {
            LOGGER.warn((Object)INTERCEPTOR_BINDING_ERROR_MSG);
            return invocationContext.proceed();
        }
        final CacheResult binding = interceptionContext.getInterceptorBindings().get(0);
        final RemoteCache remoteCache = this.getRemoteCacheManager().getCache(binding.cacheName());
        final Object key = this.getCacheKey(invocationContext.getParameters());
        InfinispanGetWrapper cache = new InfinispanGetWrapper(remoteCache, this.syncronousInfinispanGet.get(remoteCache.getName()));
        LOGGER.debugf("Loading entry with key [%s] from cache [%s]", key, (Object)binding.cacheName());
        final CacheInterceptor.ReturnType returnType = CacheResultInterceptor.determineReturnType(invocationContext.getMethod().getReturnType());
        if (returnType != CacheInterceptor.ReturnType.NonAsync) {
            Uni cacheValue = cache.get(key, new Function<Object, Object>(){

                @Override
                public Object apply(Object k) {
                    LOGGER.debugf("Loading entry with key [%s] from cache [%s]", key, (Object)binding.cacheName());
                    return UnresolvedUniValue.INSTANCE;
                }
            }).onItem().transformToUni(new Function<Object, Uni<?>>(){

                @Override
                public Uni<?> apply(Object value) {
                    if (value == UnresolvedUniValue.INSTANCE) {
                        try {
                            return CacheResultInterceptor.this.asyncInvocationResultToUni(invocationContext.proceed(), returnType).call(new Function<Object, Uni<?>>(){

                                @Override
                                public Uni<?> apply(Object emittedValue) {
                                    return Uni.createFrom().completionStage((CompletionStage)remoteCache.replaceAsync(key, emittedValue));
                                }
                            });
                        }
                        catch (CacheException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new CacheException((Throwable)e);
                        }
                    }
                    return Uni.createFrom().item(value);
                }
            });
            if (binding.lockTimeout() <= 0L) {
                return this.createAsyncResult((Uni<Object>)cacheValue, returnType);
            }
            cacheValue = cacheValue.ifNoItem().after(Duration.ofMillis(binding.lockTimeout())).recoverWithUni(new Supplier<Uni<?>>(){

                @Override
                public Uni<?> get() {
                    try {
                        return CacheResultInterceptor.this.asyncInvocationResultToUni(invocationContext.proceed(), returnType);
                    }
                    catch (CacheException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new CacheException((Throwable)e);
                    }
                }
            });
            return this.createAsyncResult((Uni<Object>)cacheValue, returnType);
        }
        Uni<Object> cacheValue = cache.get(key, new Function<Object, Object>(){

            @Override
            public Object apply(Object k) {
                try {
                    return invocationContext.proceed();
                }
                catch (CacheException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new CacheException(e);
                }
            }
        });
        if (binding.lockTimeout() <= 0L) {
            value = cacheValue.await().indefinitely();
        } else {
            try {
                value = cacheValue.await().atMost(Duration.ofMillis(binding.lockTimeout()));
            }
            catch (TimeoutException e) {
                return invocationContext.proceed();
            }
        }
        return value;
    }
}

