/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.TransactionMode;

@ConfigGroup
public interface InfinispanClientRuntimeConfig {
    public Optional<String> uri();

    public Optional<String> hosts();

    @Deprecated
    public Optional<String> serverList();

    @WithDefault(value="HASH_DISTRIBUTION_AWARE")
    public Optional<String> clientIntelligence();

    @WithDefault(value="true")
    public Optional<Boolean> useAuth();

    public Optional<String> username();

    @Deprecated
    public Optional<String> authUsername();

    public Optional<String> password();

    @Deprecated
    public Optional<String> authPassword();

    @WithDefault(value="default")
    public Optional<String> authRealm();

    @WithDefault(value="infinispan")
    public Optional<String> authServerName();

    @WithDefault(value="DIGEST-SHA-512")
    public Optional<String> saslMechanism();

    public Optional<String> keyStore();

    public Optional<String> keyStorePassword();

    public Optional<String> keyStoreType();

    public Optional<String> keyAlias();

    public Optional<String> trustStore();

    public Optional<String> trustStorePassword();

    public Optional<String> trustStoreType();

    public Optional<String> sslProtocol();

    public Optional<String> sslProvider();

    public Optional<List<String>> sslCiphers();

    public Optional<Boolean> sslHostNameValidation();

    public Optional<String> sniHostName();

    public Optional<Integer> socketTimeout();

    @WithName(value="tracing.propagation.enabled")
    public Optional<Boolean> tracingPropagationEnabled();

    public Map<String, RemoteCacheConfig> cache();

    public Map<String, BackupClusterConfig> backupCluster();

    @ConfigGroup
    public static interface BackupClusterConfig {
        public String hosts();

        @WithDefault(value="HASH_DISTRIBUTION_AWARE")
        public Optional<ClientIntelligence> clientIntelligence();

        @WithDefault(value="true")
        public Optional<Boolean> useSchemaRegistration();
    }

    @ConfigGroup
    public static interface RemoteCacheConfig {
        public Optional<String> configuration();

        public Optional<String> configurationUri();

        public Optional<Integer> nearCacheMaxEntries();

        public Optional<NearCacheMode> nearCacheMode();

        public Optional<Boolean> nearCacheUseBloomFilter();

        public Optional<TransactionMode> transactionMode();
    }
}

