/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.infinispan.client.runtime.InfinispanClientBuildTimeConfig;
import io.quarkus.infinispan.client.runtime.InfinispanClientRuntimeConfig;
import io.quarkus.infinispan.client.runtime.InfinispanClientUtil;
import io.quarkus.infinispan.client.runtime.InfinispanClientsBuildTimeConfig;
import io.quarkus.infinispan.client.runtime.InfinispanClientsRuntimeConfig;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ClusterConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.StringConfiguration;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;

@Singleton
public class InfinispanClientProducer {
    private static final Log log = LogFactory.getLog(InfinispanClientProducer.class);
    public static final StringConfiguration DEFAULT_CONFIG = new StringConfiguration("<distributed-cache><encoding media-type=\"application/x-protostream\"/></distributed-cache>");
    public static final String PROTOBUF_FILE_PREFIX = "infinispan.client.hotrod.protofile.";
    public static final String PROTOBUF_INITIALIZERS = "infinispan.client.hotrod.proto-initializers";
    private final Map<String, RemoteCacheManager> remoteCacheManagers = new HashMap<String, RemoteCacheManager>();
    @Inject
    private BeanManager beanManager;
    @Inject
    private Instance<InfinispanClientsRuntimeConfig> infinispanClientsRuntimeConfigHandle;
    @Inject
    private Instance<InfinispanClientsBuildTimeConfig> infinispanClientsBuildTimeConfigHandle;
    Map<String, Properties> properties;

    private void registerSchemaInServer(String infinispanConfigName, Map<String, Properties> properties, RemoteCacheManager cacheManager) {
        RemoteCache protobufMetadataCache = null;
        Properties namedProperties = properties.get(infinispanConfigName);
        Set initializers = (Set)namedProperties.remove(PROTOBUF_INITIALIZERS);
        if (initializers != null) {
            for (SerializationContextInitializer serializationContextInitializer : initializers) {
                if (protobufMetadataCache == null) {
                    protobufMetadataCache = cacheManager.getCache("___protobuf_metadata");
                }
                protobufMetadataCache.put((Object)serializationContextInitializer.getProtoFileName(), (Object)serializationContextInitializer.getProtoFile());
            }
        }
        for (Map.Entry entry : namedProperties.entrySet()) {
            String keyString;
            Object key = entry.getKey();
            if (!(key instanceof String) || !(keyString = (String)key).startsWith(PROTOBUF_FILE_PREFIX)) continue;
            String fileName = keyString.substring(PROTOBUF_FILE_PREFIX.length());
            String fileContents = (String)entry.getValue();
            if (protobufMetadataCache == null) {
                protobufMetadataCache = cacheManager.getCache("___protobuf_metadata");
            }
            protobufMetadataCache.put((Object)fileName, (Object)fileContents);
        }
    }

    private void initialize(String infinispanConfigName, Map<String, Properties> properties) {
        log.debug((Object)"Initializing default RemoteCacheManager");
        if (properties.isEmpty()) {
            return;
        }
        ConfigurationBuilder conf = this.builderFromProperties(infinispanConfigName, properties);
        if (conf.servers().isEmpty()) {
            return;
        }
        RemoteCacheManager cacheManager = new RemoteCacheManager(conf.build());
        this.remoteCacheManagers.put(infinispanConfigName, cacheManager);
        InfinispanClientsRuntimeConfig infinispanClientsRuntimeConfig = (InfinispanClientsRuntimeConfig)this.infinispanClientsRuntimeConfigHandle.get();
        if (infinispanClientsRuntimeConfig.useSchemaRegistration.orElse(Boolean.TRUE).booleanValue()) {
            this.registerSchemaInServer(infinispanConfigName, properties, cacheManager);
        }
    }

    private ConfigurationBuilder builderFromProperties(String infinispanClientName, Map<String, Properties> propertiesMap) {
        URL configFile;
        String cacheName;
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Properties properties = propertiesMap.get(infinispanClientName);
        Object marshallerInstance = properties.remove("infinispan.client.hotrod.marshaller");
        if (marshallerInstance != null) {
            if (marshallerInstance instanceof ProtoStreamMarshaller) {
                InfinispanClientProducer.handleProtoStreamMarshaller((ProtoStreamMarshaller)marshallerInstance, properties, this.beanManager);
            }
            builder.marshaller((Marshaller)marshallerInstance);
        }
        InfinispanClientRuntimeConfig infinispanClientRuntimeConfig = ((InfinispanClientsRuntimeConfig)this.infinispanClientsRuntimeConfigHandle.get()).getInfinispanClientRuntimeConfig(infinispanClientName);
        InfinispanClientBuildTimeConfig infinispanClientBuildTimeConfig = ((InfinispanClientsBuildTimeConfig)this.infinispanClientsBuildTimeConfigHandle.get()).getInfinispanClientBuildTimeConfig(infinispanClientName);
        if (infinispanClientRuntimeConfig == null) {
            return builder;
        }
        if (infinispanClientRuntimeConfig.uri.isPresent()) {
            properties.put("infinispan.client.hotrod.uri", infinispanClientRuntimeConfig.uri.get());
        } else {
            if (infinispanClientRuntimeConfig.serverList.isPresent()) {
                log.warn((Object)"Use 'quarkus.infinispan-client.hosts' instead of the deprecated 'quarkus.infinispan-client.server-list'");
                properties.put("infinispan.client.hotrod.server_list", infinispanClientRuntimeConfig.serverList.get());
            }
            if (infinispanClientRuntimeConfig.hosts.isPresent()) {
                properties.put("infinispan.client.hotrod.server_list", infinispanClientRuntimeConfig.hosts.get());
            }
            if (infinispanClientRuntimeConfig.authUsername.isPresent()) {
                log.warn((Object)"Use 'quarkus.infinispan-client.username' instead of the deprecated 'quarkus.infinispan-client.auth-username'");
                properties.put("infinispan.client.hotrod.auth_username", infinispanClientRuntimeConfig.authUsername.get());
            }
            if (infinispanClientRuntimeConfig.username.isPresent()) {
                properties.put("infinispan.client.hotrod.auth_username", infinispanClientRuntimeConfig.username.get());
            }
            if (infinispanClientRuntimeConfig.authPassword.isPresent()) {
                log.warn((Object)"Use 'quarkus.infinispan-client.password' instead of the deprecated 'quarkus.infinispan-client.auth-password'");
                properties.put("infinispan.client.hotrod.auth_password", infinispanClientRuntimeConfig.authPassword.get());
            }
            if (infinispanClientRuntimeConfig.password.isPresent()) {
                properties.put("infinispan.client.hotrod.auth_password", infinispanClientRuntimeConfig.password.get());
            }
        }
        if (infinispanClientRuntimeConfig.clientIntelligence.isPresent()) {
            properties.put("infinispan.client.hotrod.client_intelligence", infinispanClientRuntimeConfig.clientIntelligence.get());
        }
        if (infinispanClientRuntimeConfig.useAuth.isPresent()) {
            properties.put("infinispan.client.hotrod.use_auth", infinispanClientRuntimeConfig.useAuth.get());
        }
        if (infinispanClientRuntimeConfig.authRealm.isPresent()) {
            properties.put("infinispan.client.hotrod.auth_realm", infinispanClientRuntimeConfig.authRealm.get());
        }
        if (infinispanClientRuntimeConfig.authServerName.isPresent()) {
            properties.put("infinispan.client.hotrod.auth_server_name", infinispanClientRuntimeConfig.authServerName.get());
        }
        if (infinispanClientRuntimeConfig.saslMechanism.isPresent()) {
            properties.put("infinispan.client.hotrod.sasl_mechanism", infinispanClientRuntimeConfig.saslMechanism.get());
        }
        if (infinispanClientRuntimeConfig.trustStore.isPresent()) {
            properties.put("infinispan.client.hotrod.trust_store_file_name", infinispanClientRuntimeConfig.trustStore.get());
        }
        if (infinispanClientRuntimeConfig.trustStorePassword.isPresent()) {
            properties.put("infinispan.client.hotrod.trust_store_password", infinispanClientRuntimeConfig.trustStorePassword.get());
        }
        if (infinispanClientRuntimeConfig.trustStoreType.isPresent()) {
            properties.put("infinispan.client.hotrod.trust_store_type", infinispanClientRuntimeConfig.trustStoreType.get());
        }
        if (infinispanClientRuntimeConfig.sslProvider.isPresent()) {
            properties.put("infinispan.client.hotrod.ssl_provider", infinispanClientRuntimeConfig.sslProvider.get());
        }
        if (infinispanClientRuntimeConfig.sslProtocol.isPresent()) {
            properties.put("infinispan.client.hotrod.ssl_protocol", infinispanClientRuntimeConfig.sslProtocol.get());
        }
        if (infinispanClientRuntimeConfig.sslCiphers.isPresent()) {
            properties.put("infinispan.client.hotrod.ssl_ciphers", infinispanClientRuntimeConfig.sslCiphers.get().stream().collect(Collectors.joining(" ")));
        }
        builder.withProperties(properties);
        if (infinispanClientRuntimeConfig.tracingPropagationEnabled.isPresent() && !infinispanClientRuntimeConfig.tracingPropagationEnabled.get().booleanValue()) {
            builder.disableTracingPropagation();
        }
        if (infinispanClientBuildTimeConfig != null) {
            for (Map.Entry<String, Object> entry : infinispanClientBuildTimeConfig.cache.entrySet()) {
                cacheName = entry.getKey();
                if (infinispanClientRuntimeConfig.cache.containsKey(cacheName)) continue;
                InfinispanClientBuildTimeConfig.RemoteCacheConfig buildCacheConfigValue = (InfinispanClientBuildTimeConfig.RemoteCacheConfig)entry.getValue();
                if (!((InfinispanClientBuildTimeConfig.RemoteCacheConfig)entry.getValue()).configurationResource.isPresent()) continue;
                configFile = Thread.currentThread().getContextClassLoader().getResource(buildCacheConfigValue.configurationResource.get());
                this.configureRemoteCacheConfigurationURI(builder, cacheName, configFile);
            }
        }
        for (Map.Entry<String, Object> entry : infinispanClientRuntimeConfig.cache.entrySet()) {
            InfinispanClientBuildTimeConfig.RemoteCacheConfig buildtimeCacheConfig;
            cacheName = entry.getKey();
            InfinispanClientRuntimeConfig.RemoteCacheConfig runtimeCacheConfig = (InfinispanClientRuntimeConfig.RemoteCacheConfig)entry.getValue();
            configFile = null;
            if (infinispanClientBuildTimeConfig != null && (buildtimeCacheConfig = infinispanClientBuildTimeConfig.cache.get(cacheName)) != null && buildtimeCacheConfig.configurationResource.isPresent()) {
                configFile = Thread.currentThread().getContextClassLoader().getResource(buildtimeCacheConfig.configurationResource.get());
            }
            if (runtimeCacheConfig.configurationUri.isPresent()) {
                configFile = Thread.currentThread().getContextClassLoader().getResource(runtimeCacheConfig.configurationUri.get());
            }
            if (configFile != null) {
                this.configureRemoteCacheConfigurationURI(builder, cacheName, configFile);
            } else if (runtimeCacheConfig.configuration.isPresent()) {
                builder.remoteCache(cacheName).configuration(runtimeCacheConfig.configuration.get());
            }
            if (runtimeCacheConfig.nearCacheMaxEntries.isPresent()) {
                builder.remoteCache(cacheName).nearCacheMaxEntries(runtimeCacheConfig.nearCacheMaxEntries.get().intValue());
            }
            if (runtimeCacheConfig.nearCacheMode.isPresent()) {
                builder.remoteCache(cacheName).nearCacheMode(runtimeCacheConfig.nearCacheMode.get());
            }
            if (!runtimeCacheConfig.nearCacheUseBloomFilter.isPresent()) continue;
            builder.remoteCache(cacheName).nearCacheUseBloomFilter(runtimeCacheConfig.nearCacheUseBloomFilter.get().booleanValue());
        }
        for (Map.Entry<String, Object> entry : infinispanClientRuntimeConfig.backupCluster.entrySet()) {
            InfinispanClientRuntimeConfig.BackupClusterConfig backupClusterConfig = (InfinispanClientRuntimeConfig.BackupClusterConfig)entry.getValue();
            ClusterConfigurationBuilder clusterConfigurationBuilder = builder.addCluster(entry.getKey());
            clusterConfigurationBuilder.addClusterNodes(backupClusterConfig.hosts);
            if (!backupClusterConfig.clientIntelligence.isPresent()) continue;
            clusterConfigurationBuilder.clusterClientIntelligence(ClientIntelligence.valueOf((String)backupClusterConfig.clientIntelligence.get()));
        }
        return builder;
    }

    private void configureRemoteCacheConfigurationURI(ConfigurationBuilder builder, String cacheName, URL configFile) {
        try {
            builder.remoteCache(cacheName).configurationURI(configFile.toURI());
        }
        catch (Exception e) {
            log.errorf("Provided configuration-resource or configuration-uri can't be loaded. %s", (Object)configFile.getPath());
            throw new IllegalStateException(e);
        }
    }

    private static void handleProtoStreamMarshaller(ProtoStreamMarshaller marshaller, Properties properties, BeanManager beanManager) {
        SerializationContext serializationContext = marshaller.getSerializationContext();
        Set initializers = (Set)properties.get(PROTOBUF_INITIALIZERS);
        if (initializers != null) {
            for (SerializationContextInitializer initializer : initializers) {
                initializer.registerSchema(serializationContext);
                initializer.registerMarshallers(serializationContext);
            }
        }
        FileDescriptorSource fileDescriptorSource = null;
        for (Map.Entry entry : properties.entrySet()) {
            String keyString;
            Object key = entry.getKey();
            if (!(key instanceof String) || !(keyString = (String)key).startsWith(PROTOBUF_FILE_PREFIX)) continue;
            String fileName = keyString.substring(PROTOBUF_FILE_PREFIX.length());
            String fileContents = (String)entry.getValue();
            if (fileDescriptorSource == null) {
                fileDescriptorSource = new FileDescriptorSource();
            }
            fileDescriptorSource.addProtoFile(fileName, fileContents);
        }
        if (fileDescriptorSource != null) {
            serializationContext.registerProtoFiles(fileDescriptorSource);
        }
        Set protoFileBeans = beanManager.getBeans(FileDescriptorSource.class, new Annotation[0]);
        for (Bean bean : protoFileBeans) {
            CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
            FileDescriptorSource fds = (FileDescriptorSource)beanManager.getReference(bean, FileDescriptorSource.class, ctx);
            serializationContext.registerProtoFiles(fds);
            for (Map.Entry entry : fds.getFileDescriptors().entrySet()) {
                properties.put(PROTOBUF_FILE_PREFIX + (String)entry.getKey(), new String((char[])entry.getValue()));
            }
        }
        Set set = beanManager.getBeans(BaseMarshaller.class, new Annotation[0]);
        for (Bean bean : set) {
            CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
            BaseMarshaller messageMarshaller = (BaseMarshaller)beanManager.getReference(bean, BaseMarshaller.class, ctx);
            serializationContext.registerMarshaller(messageMarshaller);
        }
    }

    @PreDestroy
    public void destroy() {
        this.remoteCacheManagers.values().forEach(rcm -> rcm.stop());
    }

    public <K, V> RemoteCache<K, V> getRemoteCache(String clientName, String cacheName) {
        RemoteCacheManager cacheManager = InfinispanClientUtil.isDefault(clientName) ? (RemoteCacheManager)Arc.container().instance(RemoteCacheManager.class, new Annotation[]{Default.Literal.INSTANCE}).get() : (RemoteCacheManager)Arc.container().instance(RemoteCacheManager.class, new Annotation[]{NamedLiteral.of((String)clientName)}).get();
        if (cacheManager != null && cacheName != null && !cacheName.isEmpty()) {
            RemoteCache cache = cacheManager.getCache(cacheName);
            if (cache == null) {
                log.warn((Object)"Attempt to create cache using minimal default config");
                return cacheManager.administration().getOrCreateCache(cacheName, (BasicConfiguration)DEFAULT_CONFIG);
            }
            return cache;
        }
        if (cacheManager != null) {
            RemoteCache cache = cacheManager.getCache();
            if (cache == null) {
                log.warn((Object)"Attempt to create cache using minimal default config");
                return cacheManager.administration().getOrCreateCache(cacheName, (BasicConfiguration)DEFAULT_CONFIG);
            }
            return cache;
        }
        log.error((Object)("Unable to produce RemoteCache. RemoteCacheManager is null. Client: " + cacheName));
        throw new IllegalStateException("Unable to produce RemoteCache. RemoteCacheManager is null. Client: " + cacheName);
    }

    public void setProperties(Map<String, Properties> properties) {
        this.properties = properties;
    }

    public RemoteCacheManager getNamedRemoteCacheManager(String clientName) {
        if (!this.remoteCacheManagers.containsKey(clientName)) {
            this.initialize(clientName, this.properties);
        }
        return this.remoteCacheManagers.get(clientName);
    }

    public CounterManager getNamedCounterManager(String clientName) {
        RemoteCacheManager cacheManager = this.getNamedRemoteCacheManager(clientName);
        return RemoteCounterManagerFactory.asCounterManager((RemoteCacheManager)cacheManager);
    }
}

