/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.info.deployment;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.info.deployment.BuildInInfoEndpointEnabled;
import io.quarkus.info.deployment.GitInInfoEndpointEnabled;
import io.quarkus.info.deployment.InfoBuildTimeConfig;
import io.quarkus.info.deployment.InfoEndpointEnabled;
import io.quarkus.info.deployment.JavaInInfoEndpointEnabled;
import io.quarkus.info.deployment.OsInInfoEndpointEnabled;
import io.quarkus.info.deployment.spi.InfoBuildTimeContributorBuildItem;
import io.quarkus.info.deployment.spi.InfoBuildTimeValuesBuildItem;
import io.quarkus.info.runtime.InfoRecorder;
import io.quarkus.info.runtime.spi.InfoContributor;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import java.io.File;
import java.net.InetAddress;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jboss.logging.Logger;

public class InfoProcessor {
    private static final Logger log = Logger.getLogger(InfoProcessor.class);

    @BuildStep(onlyIf={GitInInfoEndpointEnabled.class})
    InfoBuildTimeValuesBuildItem gitInfo(InfoBuildTimeConfig config, CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem) {
        InfoBuildTimeValuesBuildItem infoBuildTimeValuesBuildItem;
        block12: {
            File projectRoot = this.highestKnownProjectDirectory(curateOutcomeBuildItem, outputTargetBuildItem);
            if (projectRoot == null) {
                log.debug((Object)"Unable to determine project directory");
                return null;
            }
            RepositoryBuilder repositoryBuilder = (RepositoryBuilder)new RepositoryBuilder().findGitDir(projectRoot);
            if (repositoryBuilder.getGitDir() == null) {
                log.debug((Object)"Project is not checked in to git");
                return null;
            }
            Repository repository = repositoryBuilder.build();
            try {
                RevCommit latestCommit = (RevCommit)new Git(repository).log().setMaxCount(1).call().iterator().next();
                Date commitDate = new Date((long)latestCommit.getCommitTime() * 1000L);
                TimeZone commitTimeZone = TimeZone.getDefault();
                boolean addFullInfo = config.git().mode() == InfoBuildTimeConfig.Git.Mode.FULL;
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                data.put("branch", repository.getBranch());
                LinkedHashMap<String, Object> commit = new LinkedHashMap<String, Object>();
                commit.put("id", latestCommit.getName());
                commit.put("time", this.formatDate(commitDate, commitTimeZone));
                if (addFullInfo) {
                    PersonIdent authorIdent = latestCommit.getAuthorIdent();
                    commit.put("author", Map.of("time", this.formatDate(authorIdent.getWhen(), authorIdent.getTimeZone())));
                    PersonIdent committerIdent = latestCommit.getCommitterIdent();
                    commit.put("committer", Map.of("time", this.formatDate(committerIdent.getWhen(), committerIdent.getTimeZone())));
                    LinkedHashMap<String, String> user = new LinkedHashMap<String, String>();
                    user.put("email", authorIdent.getEmailAddress());
                    user.put("name", authorIdent.getName());
                    commit.put("user", user);
                    LinkedHashMap<String, Object> id = new LinkedHashMap<String, Object>();
                    id.put("full", latestCommit.getName());
                    id.put("abbrev", latestCommit.abbreviate(13).name());
                    LinkedHashMap<String, String> message = new LinkedHashMap<String, String>();
                    message.put("full", latestCommit.getFullMessage().trim());
                    message.put("short", latestCommit.getShortMessage().trim());
                    id.put("message", message);
                    commit.put("id", id);
                    data.put("tags", this.getTags(repository, (ObjectId)latestCommit));
                }
                data.put("commit", commit);
                if (addFullInfo) {
                    data.put("build", this.obtainBuildInfo(curateOutcomeBuildItem, repository));
                }
                infoBuildTimeValuesBuildItem = new InfoBuildTimeValuesBuildItem("git", data);
                if (repository == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.debug((Object)"Unable to determine git information", (Throwable)e);
                    return null;
                }
            }
            repository.close();
        }
        return infoBuildTimeValuesBuildItem;
    }

    private String formatDate(Date date, TimeZone timeZone) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.ofInstant(date.toInstant(), timeZone.toZoneId()));
    }

    private Map<String, Object> obtainBuildInfo(CurateOutcomeBuildItem curateOutcomeBuildItem, Repository repository) {
        LinkedHashMap<String, Object> build = new LinkedHashMap<String, Object>();
        String userName = repository.getConfig().getString("user", null, "name");
        String userEmail = repository.getConfig().getString("user", null, "email");
        LinkedHashMap<String, String> user = new LinkedHashMap<String, String>();
        user.put("email", userEmail);
        user.put("name", userName);
        build.put("user", user);
        ApplicationModel applicationModel = curateOutcomeBuildItem.getApplicationModel();
        ResolvedDependency appArtifact = applicationModel.getAppArtifact();
        build.put("version", appArtifact.getVersion());
        try {
            String buildHost = InetAddress.getLocalHost().getHostName();
            build.put("host", buildHost);
        }
        catch (Exception e) {
            log.debug((Object)"Unable to determine localhost name");
        }
        return build;
    }

    public Collection<String> getTags(Repository repo, ObjectId objectId) throws GitAPIException {
        try (Git git = Git.wrap((Repository)repo);){
            Collection<String> collection;
            try (RevWalk walk = new RevWalk(repo);){
                Collection<String> tags = this.getTags(git, objectId, walk);
                walk.dispose();
                collection = tags;
            }
            return collection;
        }
    }

    private Collection<String> getTags(Git git, ObjectId objectId, RevWalk finalWalk) throws GitAPIException {
        return git.tagList().call().stream().filter(tagRef -> {
            try {
                RevCommit tagCommit = finalWalk.parseCommit((AnyObjectId)tagRef.getObjectId());
                RevCommit objectCommit = finalWalk.parseCommit((AnyObjectId)objectId);
                if (finalWalk.isMergedInto(objectCommit, tagCommit)) {
                    return true;
                }
            }
            catch (Exception ignored) {
                log.debug((Object)String.format("Failed while getTags [%s] -- ", tagRef));
            }
            return false;
        }).map(tagRef -> this.trimFullTagName(tagRef.getName())).collect(Collectors.toList());
    }

    private String trimFullTagName(String tagName) {
        return tagName.replaceFirst("refs/tags/", "");
    }

    private File highestKnownProjectDirectory(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem) {
        ApplicationModel applicationModel = curateOutcomeBuildItem.getApplicationModel();
        WorkspaceModule workspaceModule = applicationModel.getAppArtifact().getWorkspaceModule();
        if (workspaceModule != null) {
            return workspaceModule.getModuleDir();
        }
        return outputTargetBuildItem.getOutputDirectory().toFile();
    }

    @BuildStep(onlyIf={BuildInInfoEndpointEnabled.class})
    InfoBuildTimeValuesBuildItem buildInfo(CurateOutcomeBuildItem curateOutcomeBuildItem, InfoBuildTimeConfig config) {
        ApplicationModel applicationModel = curateOutcomeBuildItem.getApplicationModel();
        ResolvedDependency appArtifact = applicationModel.getAppArtifact();
        LinkedHashMap<String, Object> buildData = new LinkedHashMap<String, Object>();
        buildData.put("group", appArtifact.getGroupId());
        buildData.put("artifact", appArtifact.getArtifactId());
        buildData.put("version", appArtifact.getVersion());
        buildData.put("time", DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.now()));
        return new InfoBuildTimeValuesBuildItem("build", this.finalBuildData(buildData, config.build()));
    }

    private Map<String, Object> finalBuildData(Map<String, Object> buildData, InfoBuildTimeConfig.Build buildConfig) {
        if (buildConfig.additionalProperties().isEmpty()) {
            return buildData;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(buildData);
        result.putAll(buildConfig.additionalProperties());
        return result;
    }

    @BuildStep(onlyIf={OsInInfoEndpointEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    InfoBuildTimeContributorBuildItem osInfo(InfoRecorder recorder) {
        return new InfoBuildTimeContributorBuildItem((InfoContributor)recorder.osInfoContributor());
    }

    @BuildStep(onlyIf={JavaInInfoEndpointEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    InfoBuildTimeContributorBuildItem javaInfo(InfoRecorder recorder) {
        return new InfoBuildTimeContributorBuildItem((InfoContributor)recorder.javaInfoContributor());
    }

    @BuildStep(onlyIf={InfoEndpointEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    RouteBuildItem defineRoute(InfoBuildTimeConfig buildTimeConfig, List<InfoBuildTimeValuesBuildItem> buildTimeValues, List<InfoBuildTimeContributorBuildItem> contributors, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, InfoRecorder recorder) {
        Map buildTimeInfo = buildTimeValues.stream().collect(Collectors.toMap(InfoBuildTimeValuesBuildItem::getName, InfoBuildTimeValuesBuildItem::getValue, (x, y) -> y, LinkedHashMap::new));
        List infoContributors = contributors.stream().map(InfoBuildTimeContributorBuildItem::getInfoContributor).collect(Collectors.toList());
        return nonApplicationRootPathBuildItem.routeBuilder().management().route(buildTimeConfig.path()).routeConfigKey("quarkus.info.path").handler(recorder.handler(buildTimeInfo, infoContributors)).displayOnNotFoundPage().blockingRoute().build();
    }
}

