/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.info.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.info.BuildInfo;
import io.quarkus.info.GitInfo;
import io.quarkus.info.JavaInfo;
import io.quarkus.info.OsInfo;
import io.quarkus.info.deployment.BuildInInfoEndpointEnabled;
import io.quarkus.info.deployment.GitInInfoEndpointEnabled;
import io.quarkus.info.deployment.InfoBuildTimeConfig;
import io.quarkus.info.deployment.InfoEndpointEnabled;
import io.quarkus.info.deployment.JavaInInfoEndpointEnabled;
import io.quarkus.info.deployment.OsInInfoEndpointEnabled;
import io.quarkus.info.deployment.spi.InfoBuildTimeContributorBuildItem;
import io.quarkus.info.deployment.spi.InfoBuildTimeValuesBuildItem;
import io.quarkus.info.runtime.InfoRecorder;
import io.quarkus.info.runtime.spi.InfoContributor;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import jakarta.inject.Singleton;
import java.io.File;
import java.net.InetAddress;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jboss.logging.Logger;

public class InfoProcessor {
    private static final Logger log = Logger.getLogger(InfoProcessor.class);

    @BuildStep(onlyIf={GitInInfoEndpointEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void gitInfo(InfoBuildTimeConfig config, CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, BuildProducer<InfoBuildTimeValuesBuildItem> valuesProducer, BuildProducer<SyntheticBeanBuildItem> beanProducer, InfoRecorder recorder) {
        File projectRoot = this.highestKnownProjectDirectory(curateOutcomeBuildItem, outputTargetBuildItem);
        if (projectRoot == null) {
            log.debug((Object)"Unable to determine project directory");
            return;
        }
        RepositoryBuilder repositoryBuilder = (RepositoryBuilder)new RepositoryBuilder().findGitDir(projectRoot);
        if (repositoryBuilder.getGitDir() == null) {
            log.debug((Object)"Project is not checked in to git");
            return;
        }
        try (Repository repository = repositoryBuilder.build();){
            RevCommit latestCommit = (RevCommit)new Git(repository).log().setMaxCount(1).call().iterator().next();
            Date commitDate = new Date((long)latestCommit.getCommitTime() * 1000L);
            TimeZone commitTimeZone = TimeZone.getDefault();
            boolean addFullInfo = config.git().mode() == InfoBuildTimeConfig.Git.Mode.FULL;
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            String branch = repository.getBranch();
            data.put("branch", branch);
            LinkedHashMap<String, Object> commit = new LinkedHashMap<String, Object>();
            String latestCommitId = latestCommit.getName();
            commit.put("id", latestCommitId);
            String latestCommitTime = this.formatDate(commitDate, commitTimeZone);
            commit.put("time", latestCommitTime);
            if (addFullInfo) {
                PersonIdent authorIdent = latestCommit.getAuthorIdent();
                commit.put("author", Map.of("time", this.formatDate(authorIdent.getWhen(), authorIdent.getTimeZone())));
                PersonIdent committerIdent = latestCommit.getCommitterIdent();
                commit.put("committer", Map.of("time", this.formatDate(committerIdent.getWhen(), committerIdent.getTimeZone())));
                LinkedHashMap<String, String> user = new LinkedHashMap<String, String>();
                user.put("email", authorIdent.getEmailAddress());
                user.put("name", authorIdent.getName());
                commit.put("user", user);
                LinkedHashMap<String, Object> id = new LinkedHashMap<String, Object>();
                id.put("full", latestCommitId);
                id.put("abbrev", latestCommit.abbreviate(13).name());
                LinkedHashMap<String, String> message = new LinkedHashMap<String, String>();
                message.put("full", latestCommit.getFullMessage().trim());
                message.put("short", latestCommit.getShortMessage().trim());
                id.put("message", message);
                commit.put("id", id);
                data.put("tags", this.getTags(repository, (ObjectId)latestCommit));
            }
            data.put("commit", commit);
            if (addFullInfo) {
                data.put("build", this.obtainBuildInfo(curateOutcomeBuildItem, repository));
            }
            valuesProducer.produce((BuildItem)new InfoBuildTimeValuesBuildItem("git", data));
            beanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(GitInfo.class).supplier(recorder.gitInfoSupplier(branch, latestCommitId, latestCommitTime)).scope(Singleton.class)).setRuntimeInit().done());
        }
        catch (Exception e) {
            log.debug((Object)"Unable to determine git information", (Throwable)e);
        }
    }

    private String formatDate(Date date, TimeZone timeZone) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.ofInstant(date.toInstant(), timeZone.toZoneId()));
    }

    private Map<String, Object> obtainBuildInfo(CurateOutcomeBuildItem curateOutcomeBuildItem, Repository repository) {
        LinkedHashMap<String, Object> build = new LinkedHashMap<String, Object>();
        String userName = repository.getConfig().getString("user", null, "name");
        String userEmail = repository.getConfig().getString("user", null, "email");
        LinkedHashMap<String, String> user = new LinkedHashMap<String, String>();
        user.put("email", userEmail);
        user.put("name", userName);
        build.put("user", user);
        ApplicationModel applicationModel = curateOutcomeBuildItem.getApplicationModel();
        ResolvedDependency appArtifact = applicationModel.getAppArtifact();
        build.put("version", appArtifact.getVersion());
        try {
            String buildHost = InetAddress.getLocalHost().getHostName();
            build.put("host", buildHost);
        }
        catch (Exception e) {
            log.debug((Object)"Unable to determine localhost name");
        }
        return build;
    }

    public Collection<String> getTags(Repository repo, ObjectId objectId) throws GitAPIException {
        try (Git git = Git.wrap((Repository)repo);){
            Collection<String> collection;
            try (RevWalk walk = new RevWalk(repo);){
                Collection<String> tags = this.getTags(git, objectId, walk);
                walk.dispose();
                collection = tags;
            }
            return collection;
        }
    }

    private Collection<String> getTags(Git git, ObjectId objectId, RevWalk finalWalk) throws GitAPIException {
        return git.tagList().call().stream().filter(tagRef -> {
            try {
                RevCommit tagCommit = finalWalk.parseCommit((AnyObjectId)tagRef.getObjectId());
                RevCommit objectCommit = finalWalk.parseCommit((AnyObjectId)objectId);
                if (finalWalk.isMergedInto(objectCommit, tagCommit)) {
                    return true;
                }
            }
            catch (Exception ignored) {
                log.debug((Object)String.format("Failed while getTags [%s] -- ", tagRef));
            }
            return false;
        }).map(tagRef -> this.trimFullTagName(tagRef.getName())).collect(Collectors.toList());
    }

    private String trimFullTagName(String tagName) {
        return tagName.replaceFirst("refs/tags/", "");
    }

    private File highestKnownProjectDirectory(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem) {
        ApplicationModel applicationModel = curateOutcomeBuildItem.getApplicationModel();
        WorkspaceModule workspaceModule = applicationModel.getAppArtifact().getWorkspaceModule();
        if (workspaceModule != null) {
            return workspaceModule.getModuleDir();
        }
        return outputTargetBuildItem.getOutputDirectory().toFile();
    }

    @BuildStep(onlyIf={BuildInInfoEndpointEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void buildInfo(CurateOutcomeBuildItem curateOutcomeBuildItem, InfoBuildTimeConfig config, BuildProducer<InfoBuildTimeValuesBuildItem> valuesProducer, BuildProducer<SyntheticBeanBuildItem> beanProducer, InfoRecorder recorder) {
        ApplicationModel applicationModel = curateOutcomeBuildItem.getApplicationModel();
        ResolvedDependency appArtifact = applicationModel.getAppArtifact();
        LinkedHashMap<String, Object> buildData = new LinkedHashMap<String, Object>();
        String group = appArtifact.getGroupId();
        buildData.put("group", group);
        String artifact = appArtifact.getArtifactId();
        buildData.put("artifact", artifact);
        String version = appArtifact.getVersion();
        buildData.put("version", version);
        String time = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.now());
        buildData.put("time", time);
        Map<String, Object> data = this.finalBuildData(buildData, config.build());
        valuesProducer.produce((BuildItem)new InfoBuildTimeValuesBuildItem("build", data));
        beanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(BuildInfo.class).supplier(recorder.buildInfoSupplier(group, artifact, version, time)).scope(Singleton.class)).setRuntimeInit().done());
    }

    private Map<String, Object> finalBuildData(Map<String, Object> buildData, InfoBuildTimeConfig.Build buildConfig) {
        if (buildConfig.additionalProperties().isEmpty()) {
            return buildData;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(buildData);
        result.putAll(buildConfig.additionalProperties());
        return result;
    }

    @BuildStep(onlyIf={OsInInfoEndpointEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void osInfo(InfoRecorder recorder, BuildProducer<InfoBuildTimeContributorBuildItem> valuesProducer, BuildProducer<SyntheticBeanBuildItem> beanProducer) {
        valuesProducer.produce((BuildItem)new InfoBuildTimeContributorBuildItem((InfoContributor)recorder.osInfoContributor()));
        beanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(OsInfo.class).supplier(recorder.osInfoSupplier()).scope(Singleton.class)).setRuntimeInit().done());
    }

    @BuildStep(onlyIf={JavaInInfoEndpointEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void javaInfo(InfoRecorder recorder, BuildProducer<InfoBuildTimeContributorBuildItem> valuesProducer, BuildProducer<SyntheticBeanBuildItem> beanProducer) {
        valuesProducer.produce((BuildItem)new InfoBuildTimeContributorBuildItem((InfoContributor)recorder.javaInfoContributor()));
        beanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(JavaInfo.class).supplier(recorder.javaInfoSupplier()).scope(Singleton.class)).setRuntimeInit().done());
    }

    @BuildStep(onlyIf={InfoEndpointEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    RouteBuildItem defineRoute(InfoBuildTimeConfig buildTimeConfig, List<InfoBuildTimeValuesBuildItem> buildTimeValues, List<InfoBuildTimeContributorBuildItem> contributors, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, InfoRecorder recorder) {
        Map buildTimeInfo = buildTimeValues.stream().collect(Collectors.toMap(InfoBuildTimeValuesBuildItem::getName, InfoBuildTimeValuesBuildItem::getValue, (x, y) -> y, LinkedHashMap::new));
        List infoContributors = contributors.stream().map(InfoBuildTimeContributorBuildItem::getInfoContributor).collect(Collectors.toList());
        return nonApplicationRootPathBuildItem.routeBuilder().management().route(buildTimeConfig.path()).routeConfigKey("quarkus.info.path").handler(recorder.handler(buildTimeInfo, infoContributors)).displayOnNotFoundPage().blockingRoute().build();
    }
}

