/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.info.runtime;

import io.quarkus.info.runtime.JavaInfoContributor;
import io.quarkus.info.runtime.OsInfoContributor;
import io.quarkus.info.runtime.spi.InfoContributor;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Recorder
public class InfoRecorder {
    public Handler<RoutingContext> handler(Map<String, Object> buildTimeInfo, List<InfoContributor> knownContributors) {
        return new InfoHandler(buildTimeInfo, knownContributors);
    }

    public OsInfoContributor osInfoContributor() {
        return new OsInfoContributor();
    }

    public JavaInfoContributor javaInfoContributor() {
        return new JavaInfoContributor();
    }

    private static class InfoHandler
    implements Handler<RoutingContext> {
        private final Map<String, Object> finalBuildInfo;

        public InfoHandler(Map<String, Object> buildTimeInfo, List<InfoContributor> knownContributors) {
            this.finalBuildInfo = new HashMap<String, Object>(buildTimeInfo);
            for (InfoContributor contributor : knownContributors) {
                this.finalBuildInfo.put(contributor.name(), contributor.data());
            }
        }

        public void handle(RoutingContext ctx) {
            HttpServerResponse resp = ctx.response();
            resp.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
            JsonObject jsonObject = new JsonObject(this.finalBuildInfo);
            ctx.end(Json.encodePrettily((Object)jsonObject));
        }
    }
}

