/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jackson.deployment;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveHierarchyBuildItem;
import io.quarkus.jackson.deployment.IgnoreJsonDeserializeClassBuildItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class JacksonProcessor {
    private static final DotName JSON_DESERIALIZE = DotName.createSimple((String)JsonDeserialize.class.getName());
    private static final DotName BUILDER_VOID = DotName.createSimple((String)Void.class.getName());
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    @Inject
    BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;
    @Inject
    List<IgnoreJsonDeserializeClassBuildItem> ignoreJsonDeserializeClassBuildItems;

    @BuildStep
    void register() {
        this.addReflectiveClass(true, false, "com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector", "com.fasterxml.jackson.databind.ser.std.SqlDateSerializer");
        IndexView index = this.combinedIndexBuildItem.getIndex();
        HashSet<DotName> ignoredDotNames = new HashSet<DotName>();
        for (IgnoreJsonDeserializeClassBuildItem ignoreJsonDeserializeClassBuildItem : this.ignoreJsonDeserializeClassBuildItems) {
            ignoredDotNames.add(ignoreJsonDeserializeClassBuildItem.getDotName());
        }
        Collection pojoBuilderInstances = index.getAnnotations(JSON_DESERIALIZE);
        for (AnnotationInstance pojoBuilderInstance : pojoBuilderInstances) {
            DotName builderClassName;
            AnnotationValue annotationValue;
            if (!AnnotationTarget.Kind.CLASS.equals((Object)pojoBuilderInstance.target().kind())) continue;
            DotName dotName = pojoBuilderInstance.target().asClass().name();
            if (!ignoredDotNames.contains(dotName)) {
                this.addReflectiveHierarchyClass(dotName);
            }
            if (null == (annotationValue = pojoBuilderInstance.value("builder")) || !AnnotationValue.Kind.CLASS.equals((Object)annotationValue.kind()) || BUILDER_VOID.equals((Object)(builderClassName = annotationValue.asClass().name()))) continue;
            this.addReflectiveHierarchyClass(builderClassName);
        }
    }

    private void addReflectiveHierarchyClass(DotName className) {
        Type jandexType = Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS);
        this.reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem(jandexType));
    }

    private void addReflectiveClass(boolean methods, boolean fields, String ... className) {
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(methods, fields, className));
    }
}

