/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jacoco.deployment;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.model.QuarkusModel;
import io.quarkus.bootstrap.resolver.model.WorkspaceModule;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.jacoco.runtime.JacocoConfig;
import io.quarkus.jacoco.runtime.ReportCreator;
import io.quarkus.jacoco.runtime.ReportInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiFunction;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;
import org.jacoco.report.MultiSourceFileLocator;
import org.jboss.jandex.ClassInfo;

public class JacocoProcessor {
    @BuildStep(onlyIf={IsTest.class})
    FeatureBuildItem feature() {
        return new FeatureBuildItem("jacoco");
    }

    @BuildStep(onlyIf={IsTest.class})
    void transformerBuildItem(BuildProducer<BytecodeTransformerBuildItem> transformers, CombinedIndexBuildItem indexBuildItem, OutputTargetBuildItem outputTargetBuildItem, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildSystemTargetBuildItem buildSystemTargetBuildItem, ShutdownContextBuildItem shutdownContextBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, JacocoConfig config) throws Exception {
        String dataFile = outputTargetBuildItem.getOutputDirectory().toAbsolutePath().toString() + File.separator + config.dataFile;
        System.setProperty("jacoco-agent.destfile", dataFile);
        Files.deleteIfExists(Paths.get(dataFile, new String[0]));
        final Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
        HashSet<String> seen = new HashSet<String>();
        for (ApplicationArchive archive : applicationArchivesBuildItem.getAllApplicationArchives()) {
            for (ClassInfo i : archive.getIndex().getKnownClasses()) {
                String className = i.name().toString();
                if (seen.contains(className)) continue;
                seen.add(className);
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem.Builder().setClassToTransform(className).setCacheable(true).setEager(true).setInputTransformer((BiFunction)new BiFunction<String, byte[], byte[]>(){

                    @Override
                    public byte[] apply(String className, byte[] bytes) {
                        try {
                            byte[] enhanced = instrumenter.instrument(bytes, className);
                            if (enhanced == null) {
                                return bytes;
                            }
                            return enhanced;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }).build());
            }
        }
        if (config.report) {
            HashSet<String> classes;
            ReportInfo info = new ReportInfo();
            info.dataFile = dataFile;
            File targetdir = new File(outputTargetBuildItem.getOutputDirectory().toAbsolutePath().toString() + File.separator + config.reportLocation);
            info.reportDir = targetdir.getAbsolutePath();
            String includes = StringUtils.join(config.includes.iterator(), (String)",");
            String excludes = StringUtils.join(config.excludes.orElse(Collections.emptyList()).iterator(), (String)",");
            info.classFiles = classes = new HashSet<String>();
            HashSet<String> sources = new HashSet<String>();
            MultiSourceFileLocator sourceFileLocator = new MultiSourceFileLocator(4);
            if (BuildToolHelper.isMavenProject((Path)targetdir.toPath())) {
                HashSet<AppArtifactKey> runtimeDeps = new HashSet<AppArtifactKey>();
                for (Object i : curateOutcomeBuildItem.getEffectiveModel().getUserDependencies()) {
                    runtimeDeps.add(i.getArtifact().getKey());
                }
                LocalProject project = LocalProject.loadWorkspace((Path)targetdir.toPath());
                runtimeDeps.add(project.getKey());
                for (Map.Entry entry : project.getWorkspace().getProjects().entrySet()) {
                    if (!runtimeDeps.contains(entry.getKey())) continue;
                    info.savedData.add(((LocalProject)entry.getValue()).getOutputDir().resolve(config.dataFile).toAbsolutePath().toString());
                    sources.add(((LocalProject)entry.getValue()).getSourcesSourcesDir().toFile().getAbsolutePath());
                    File classesDir = ((LocalProject)entry.getValue()).getClassesDir().toFile();
                    if (!classesDir.isDirectory()) continue;
                    for (File file : FileUtils.getFiles((File)classesDir, (String)includes, (String)excludes, (boolean)true)) {
                        if (!file.getName().endsWith(".class")) continue;
                        classes.add(file.getAbsolutePath());
                    }
                }
            } else if (BuildToolHelper.isGradleProject((Path)targetdir.toPath())) {
                QuarkusModel model = BuildToolHelper.enableGradleAppModelForDevMode((Path)targetdir.toPath());
                for (WorkspaceModule i : model.getWorkspace().getAllModules()) {
                    info.savedData.add(new File(i.getBuildDir(), config.dataFile).getAbsolutePath());
                    for (File src : i.getSourceSourceSet().getSourceDirectories()) {
                        sources.add(src.getAbsolutePath());
                    }
                    for (File classesDir : i.getSourceSet().getSourceDirectories()) {
                        if (!classesDir.isDirectory()) continue;
                        for (File file : FileUtils.getFiles((File)classesDir, (String)includes, (String)excludes, (boolean)true)) {
                            if (!file.getName().endsWith(".class")) continue;
                            classes.add(file.getAbsolutePath());
                        }
                    }
                }
            } else {
                throw new RuntimeException("Cannot determine project type generating Jacoco report");
            }
            info.sourceDirectories = sources;
            info.artifactId = buildSystemTargetBuildItem.getBaseName();
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new ReportCreator(info, config)));
        }
    }
}

