/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jacoco.runtime;

import io.quarkus.jacoco.runtime.JacocoConfig;
import io.quarkus.jacoco.runtime.ReportInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.MultiSourceFileLocator;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

public class ReportCreator
implements Runnable {
    private final ReportInfo reportInfo;
    private final JacocoConfig config;

    public ReportCreator(ReportInfo reportInfo, JacocoConfig config) {
        this.reportInfo = reportInfo;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Class<ExecFileLoader> clazz = ExecFileLoader.class;
        synchronized (ExecFileLoader.class) {
            this.doRun();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void doRun() {
        File targetdir = new File(this.reportInfo.reportDir);
        targetdir.mkdirs();
        try {
            long abortTime = System.currentTimeMillis() + 10000L;
            Path datafile = Paths.get(this.reportInfo.dataFile, new String[0]);
            while (!(System.currentTimeMillis() >= abortTime || Files.exists(datafile, new LinkOption[0]) && Files.size(datafile) > 0L)) {
                Thread.sleep(100L);
            }
            while (true) {
                boolean running = false;
                for (Thread entry : Thread.getAllStackTraces().keySet()) {
                    if (!entry.getClass().getName().startsWith("org.jacoco")) continue;
                    running = true;
                    break;
                }
                if (!running) break;
                Thread.sleep(100L);
            }
            ExecFileLoader loader = new ExecFileLoader();
            for (String i : this.reportInfo.savedData) {
                File file = new File(i);
                if (!file.exists()) continue;
                loader.load(file);
            }
            CoverageBuilder builder = new CoverageBuilder();
            Analyzer analyzer = new Analyzer(loader.getExecutionDataStore(), (ICoverageVisitor)builder);
            for (String i : this.reportInfo.classFiles) {
                File file = new File(i);
                if (!file.exists()) continue;
                analyzer.analyzeAll(file);
            }
            ArrayList<IReportVisitor> formatters = new ArrayList<IReportVisitor>();
            this.addXmlFormatter(new File(targetdir, "jacoco.xml"), this.config.outputEncoding(), formatters);
            this.addCsvFormatter(new File(targetdir, "jacoco.csv"), this.config.outputEncoding(), formatters);
            this.addHtmlFormatter(targetdir, this.config.outputEncoding(), this.config.footer().orElse(""), Locale.getDefault(), formatters);
            MultiReportVisitor visitor = new MultiReportVisitor(formatters);
            visitor.visitInfo(loader.getSessionInfoStore().getInfos(), loader.getExecutionDataStore().getContents());
            MultiSourceFileLocator sourceFileLocator = new MultiSourceFileLocator(4);
            for (String i : this.reportInfo.sourceDirectories) {
                sourceFileLocator.add((ISourceFileLocator)new DirectorySourceFileLocator(new File(i), this.config.sourceEncoding(), 4));
            }
            IBundleCoverage bundle = builder.getBundle(this.config.title().orElse(this.reportInfo.artifactId));
            visitor.visitBundle(bundle, (ISourceFileLocator)sourceFileLocator);
            visitor.visitEnd();
            System.out.println("Generated Jacoco reports in " + targetdir);
            System.out.flush();
        }
        catch (Exception e) {
            System.err.println("Failed to generate Jacoco reports");
            e.printStackTrace();
            System.err.flush();
            File error = new File(targetdir, "error.txt");
            try (FileOutputStream out = new FileOutputStream(error);){
                PrintStream ps = new PrintStream(out);
                ps.println("Failed to generate Jacoco reports");
                e.printStackTrace(ps);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addXmlFormatter(File targetfile, String encoding, List<IReportVisitor> formatters) throws IOException {
        XMLFormatter xml = new XMLFormatter();
        xml.setOutputEncoding(encoding);
        formatters.add(xml.createVisitor((OutputStream)new FileOutputStream(targetfile)));
    }

    public void addCsvFormatter(File targetfile, String encoding, List<IReportVisitor> formatters) throws IOException {
        CSVFormatter csv = new CSVFormatter();
        csv.setOutputEncoding(encoding);
        formatters.add(csv.createVisitor((OutputStream)new FileOutputStream(targetfile)));
    }

    public void addHtmlFormatter(File targetdir, String encoding, String footer, Locale locale, List<IReportVisitor> formatters) throws IOException {
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        htmlFormatter.setOutputEncoding(encoding);
        htmlFormatter.setLocale(locale);
        if (footer != null) {
            htmlFormatter.setFooterText(footer);
        }
        formatters.add(htmlFormatter.createVisitor((IMultiReportOutput)new FileMultiReportOutput(targetdir)));
    }
}

