/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.jaeger.runtime.JaegerBuildTimeConfig;
import io.quarkus.jaeger.runtime.JaegerConfig;
import io.quarkus.jaeger.runtime.JaegerDeploymentRecorder;
import io.quarkus.jaeger.runtime.QuarkusJaegerMetricsFactory;
import io.quarkus.runtime.ApplicationConfig;
import io.quarkus.smallrye.metrics.deployment.spi.MetricBuildItem;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

public class JaegerProcessor {
    @Inject
    BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport;

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupTracer(JaegerDeploymentRecorder jdr, JaegerBuildTimeConfig buildTimeConfig, JaegerConfig jaeger, ApplicationConfig appConfig, Capabilities capabilities, BuildProducer<MetricBuildItem> metricProducer) {
        this.extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem("jaeger"));
        if (buildTimeConfig.enabled) {
            boolean metricsEnabled;
            boolean bl = metricsEnabled = capabilities.isCapabilityPresent("io.quarkus.metrics") && buildTimeConfig.metricsEnabled;
            if (metricsEnabled) {
                this.produceMetrics(metricProducer);
                jdr.registerTracerWithMetrics(jaeger, appConfig);
            } else {
                jdr.registerTracerWithoutMetrics(jaeger, appConfig);
            }
        }
    }

    @BuildStep
    public void build(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem("jaeger"));
    }

    @BuildStep
    public void reflectiveClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.jaegertracing.internal.samplers.http.SamplingStrategyResponse", "io.jaegertracing.internal.samplers.http.ProbabilisticSamplingStrategy"}).finalFieldsWritable(true).build());
    }

    private void produceMetrics(BuildProducer<MetricBuildItem> producer) {
        producer.produce((BuildItem)this.metric("jaeger_tracer_baggage_restrictions_updates", MetricType.COUNTER, null, new Tag("result", "err")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_baggage_restrictions_updates", MetricType.COUNTER, null, new Tag("result", "ok")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_baggage_truncations", MetricType.COUNTER, null, new Tag[0]));
        producer.produce((BuildItem)this.metric("jaeger_tracer_baggage_updates", MetricType.COUNTER, null, new Tag("result", "err")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_baggage_updates", MetricType.COUNTER, null, new Tag("result", "ok")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_finished_spans", MetricType.COUNTER, null, new Tag[0]));
        producer.produce((BuildItem)this.metric("jaeger_tracer_reporter_spans", MetricType.COUNTER, null, new Tag("result", "dropped")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_reporter_spans", MetricType.COUNTER, null, new Tag("result", "err")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_reporter_spans", MetricType.COUNTER, null, new Tag("result", "ok")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_sampler_queries", MetricType.COUNTER, null, new Tag("result", "err")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_sampler_queries", MetricType.COUNTER, null, new Tag("result", "ok")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_sampler_updates", MetricType.COUNTER, null, new Tag("result", "ok")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_sampler_updates", MetricType.COUNTER, null, new Tag("result", "err")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_span_context_decoding_errors", MetricType.COUNTER, null, new Tag[0]));
        producer.produce((BuildItem)this.metric("jaeger_tracer_started_spans", MetricType.COUNTER, null, new Tag("sampled", "n")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_started_spans", MetricType.COUNTER, null, new Tag("sampled", "y")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_traces", MetricType.COUNTER, null, new Tag("sampled", "y"), new Tag("state", "joined")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_traces", MetricType.COUNTER, null, new Tag("sampled", "y"), new Tag("state", "started")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_traces", MetricType.COUNTER, null, new Tag("sampled", "n"), new Tag("state", "joined")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_traces", MetricType.COUNTER, null, new Tag("sampled", "n"), new Tag("state", "started")));
        producer.produce((BuildItem)this.metric("jaeger_tracer_reporter_queue_length", MetricType.GAUGE, new QuarkusJaegerMetricsFactory.JaegerGauge(), new Tag[0]));
    }

    private MetricBuildItem metric(String name, MetricType type, Object implementor, Tag ... tags) {
        Metadata metadata = Metadata.builder().withName(name).withDisplayName(name).withType(type).withUnit("none").withDescription(name).reusable().build();
        if (implementor == null) {
            return new MetricBuildItem(metadata, true, "jaeger", tags);
        }
        return new MetricBuildItem(metadata, implementor, true, "jaeger", tags);
    }
}

