/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.deployment;

import io.jaegertracing.internal.JaegerTracer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.jaeger.runtime.JaegerBuildTimeConfig;
import io.quarkus.jaeger.runtime.JaegerConfig;
import io.quarkus.jaeger.runtime.JaegerDeploymentRecorder;
import io.quarkus.runtime.ApplicationConfig;
import java.util.Optional;
import javax.inject.Inject;

public class JaegerProcessor {
    @Inject
    BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport;

    @BuildStep(onlyIf={NativeBuild.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void setVersion(JaegerDeploymentRecorder jdr) {
        jdr.setJaegerVersion(JaegerTracer.getVersionFromProperties());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupTracer(JaegerDeploymentRecorder jdr, JaegerBuildTimeConfig buildTimeConfig, JaegerConfig jaeger, ApplicationConfig appConfig, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        this.extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.JAEGER.getName()));
        if (buildTimeConfig.enabled) {
            if (buildTimeConfig.metricsEnabled && metricsCapability.isPresent()) {
                if (metricsCapability.get().metricsSupported("micrometer")) {
                    jdr.registerTracerWithMicrometerMetrics(jaeger, appConfig);
                } else {
                    jdr.registerTracerWithMpMetrics(jaeger, appConfig);
                }
            } else {
                jdr.registerTracerWithoutMetrics(jaeger, appConfig);
            }
        }
    }

    @BuildStep
    public void build(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.JAEGER));
    }

    @BuildStep
    public void capability(JaegerBuildTimeConfig buildTimeConfig, BuildProducer<CapabilityBuildItem> capability) {
        if (buildTimeConfig.enabled) {
            capability.produce((BuildItem)new CapabilityBuildItem(Capability.OPENTRACING));
        }
    }

    @BuildStep
    public void reflectiveClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.jaegertracing.internal.samplers.http.SamplingStrategyResponse", "io.jaegertracing.internal.samplers.http.ProbabilisticSamplingStrategy"}).finalFieldsWritable(true).build());
    }
}

