/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.deployment;

import io.jaegertracing.internal.JaegerTracer;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.jaeger.runtime.JaegerBuildTimeConfig;
import io.quarkus.jaeger.runtime.JaegerConfig;
import io.quarkus.jaeger.runtime.JaegerDeploymentRecorder;
import io.quarkus.runtime.ApplicationConfig;
import java.util.Optional;

public class JaegerProcessor {
    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void setVersion(JaegerDeploymentRecorder jdr) {
        jdr.setJaegerVersion(JaegerTracer.getVersionFromProperties());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ExtensionSslNativeSupportBuildItem setupTracer(JaegerDeploymentRecorder jdr, JaegerBuildTimeConfig buildTimeConfig, JaegerConfig jaeger, ApplicationConfig appConfig, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (buildTimeConfig.enabled) {
            if (buildTimeConfig.metricsEnabled && metricsCapability.isPresent()) {
                if (metricsCapability.get().metricsSupported("micrometer")) {
                    jdr.registerTracerWithMicrometerMetrics(jaeger, appConfig);
                } else {
                    jdr.registerTracerWithMpMetrics(jaeger, appConfig);
                }
            } else {
                jdr.registerTracerWithoutMetrics(jaeger, appConfig);
            }
        }
        return new ExtensionSslNativeSupportBuildItem(Feature.JAEGER.getName());
    }

    @BuildStep
    public FeatureBuildItem build() {
        return new FeatureBuildItem(Feature.JAEGER);
    }

    @BuildStep
    public ReflectiveClassBuildItem reflectiveClasses() {
        return ReflectiveClassBuildItem.builder((String[])new String[]{"io.jaegertracing.internal.samplers.http.SamplingStrategyResponse", "io.jaegertracing.internal.samplers.http.ProbabilisticSamplingStrategy"}).finalFieldsWritable(true).build();
    }
}

