/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.runtime;

import io.jaegertracing.internal.JaegerSpanContext;
import io.opentracing.Scope;
import io.opentracing.Span;
import org.jboss.logging.MDC;

public class MDCScope
implements Scope {
    private static final String TRACE_ID = "traceId";
    private static final String SPAN_ID = "spanId";
    private static final String SAMPLED = "sampled";
    private final Scope wrapped;
    private final Object originalTraceId;
    private final Object originalSpanId;
    private final Object originalSampled;

    public MDCScope(Scope scope) {
        this.wrapped = scope;
        this.originalTraceId = MDC.get((String)TRACE_ID);
        this.originalSpanId = MDC.get((String)SPAN_ID);
        this.originalSampled = MDC.get((String)SAMPLED);
        if (scope.span().context() instanceof JaegerSpanContext) {
            this.putContext((JaegerSpanContext)scope.span().context());
        }
    }

    public void close() {
        this.wrapped.close();
        MDC.remove((String)TRACE_ID);
        MDC.remove((String)SPAN_ID);
        MDC.remove((String)SAMPLED);
        if (this.originalTraceId != null) {
            MDC.put((String)TRACE_ID, (Object)this.originalTraceId);
        }
        if (this.originalSpanId != null) {
            MDC.put((String)SPAN_ID, (Object)this.originalSpanId);
        }
        if (this.originalSampled != null) {
            MDC.put((String)SAMPLED, (Object)this.originalSampled);
        }
    }

    public Span span() {
        return this.wrapped.span();
    }

    protected void putContext(JaegerSpanContext spanContext) {
        MDC.put((String)TRACE_ID, (Object)spanContext.getTraceId());
        MDC.put((String)SPAN_ID, (Object)String.format("%16x", spanContext.getSpanId()));
        MDC.put((String)SAMPLED, (Object)Boolean.toString(spanContext.isSampled()));
    }
}

