/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.runtime;

import io.jaegertracing.internal.metrics.NoopMetricsFactory;
import io.jaegertracing.spi.MetricsFactory;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import io.quarkus.jaeger.runtime.JaegerConfig;
import io.quarkus.jaeger.runtime.QuarkusJaegerMetricsFactory;
import io.quarkus.jaeger.runtime.QuarkusJaegerTracer;
import io.quarkus.runtime.ApplicationConfig;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Optional;
import java.util.function.Function;
import org.jboss.logging.Logger;

@Recorder
public class JaegerDeploymentRecorder {
    private static final Logger log = Logger.getLogger(JaegerDeploymentRecorder.class);
    private static final Optional UNKNOWN_SERVICE_NAME = Optional.of("quarkus/unknown");
    private static final QuarkusJaegerTracer quarkusTracer = new QuarkusJaegerTracer();
    public static String jaegerVersion;

    public void setJaegerVersion(String version) {
        jaegerVersion = version;
    }

    public synchronized void registerTracerWithoutMetrics(JaegerConfig jaeger, ApplicationConfig appConfig) {
        this.registerTracer(jaeger, appConfig, (MetricsFactory)new NoopMetricsFactory());
    }

    public synchronized void registerTracerWithMetrics(JaegerConfig jaeger, ApplicationConfig appConfig) {
        this.registerTracer(jaeger, appConfig, new QuarkusJaegerMetricsFactory());
    }

    private void registerTracer(JaegerConfig jaeger, ApplicationConfig appConfig, MetricsFactory metricsFactory) {
        if (!jaeger.serviceName.isPresent()) {
            jaeger.serviceName = appConfig.name.isPresent() ? appConfig.name : UNKNOWN_SERVICE_NAME;
        }
        this.initTracerConfig(jaeger);
        quarkusTracer.setMetricsFactory(metricsFactory);
        quarkusTracer.reset();
        if (!GlobalTracer.isRegistered()) {
            log.debugf("Registering tracer to GlobalTracer %s", (Object)quarkusTracer);
            GlobalTracer.register((Tracer)quarkusTracer);
        }
    }

    private void initTracerConfig(JaegerConfig jaeger) {
        this.initTracerProperty("JAEGER_ENDPOINT", jaeger.endpoint, uri -> uri.toString());
        this.initTracerProperty("JAEGER_AUTH_TOKEN", jaeger.authToken, token -> token);
        this.initTracerProperty("JAEGER_USER", jaeger.user, user -> user);
        this.initTracerProperty("JAEGER_PASSWORD", jaeger.password, pw -> pw);
        this.initTracerProperty("JAEGER_AGENT_HOST", jaeger.agentHostPort, address -> address.getHostName());
        this.initTracerProperty("JAEGER_AGENT_PORT", jaeger.agentHostPort, address -> String.valueOf(address.getPort()));
        this.initTracerProperty("JAEGER_REPORTER_LOG_SPANS", jaeger.reporterLogSpans, log -> log.toString());
        this.initTracerProperty("JAEGER_REPORTER_MAX_QUEUE_SIZE", jaeger.reporterMaxQueueSize, size -> size.toString());
        this.initTracerProperty("JAEGER_REPORTER_FLUSH_INTERVAL", jaeger.reporterFlushInterval, duration -> String.valueOf(duration.toMillis()));
        this.initTracerProperty("JAEGER_SAMPLER_TYPE", jaeger.samplerType, type -> type);
        this.initTracerProperty("JAEGER_SAMPLER_PARAM", jaeger.samplerParam, param -> param.toString());
        this.initTracerProperty("JAEGER_SAMPLER_MANAGER_HOST_PORT", jaeger.samplerManagerHostPort, hostPort -> hostPort.toString());
        this.initTracerProperty("JAEGER_SERVICE_NAME", jaeger.serviceName, name -> name);
        this.initTracerProperty("JAEGER_TAGS", jaeger.tags, tags -> tags.toString());
        this.initTracerProperty("JAEGER_PROPAGATION", jaeger.propagation, format -> format.toString());
        this.initTracerProperty("JAEGER_SENDER_FACTORY", jaeger.senderFactory, sender -> sender);
        quarkusTracer.setLogTraceContext(jaeger.logTraceContext);
    }

    private <T> void initTracerProperty(String property, Optional<T> value, Function<T, String> accessor) {
        if (value.isPresent()) {
            System.setProperty(property, accessor.apply(value.get()));
        }
    }
}

