/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.runtime;

import io.jaegertracing.internal.metrics.Counter;
import io.jaegertracing.spi.MetricsFactory;
import io.smallrye.metrics.MetricRegistries;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public class QuarkusJaegerMetricsFactory
implements MetricsFactory {
    MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR);

    public Counter createCounter(String name, Map<String, String> tags) {
        final org.eclipse.microprofile.metrics.Counter counter = this.registry.counter(name, this.toTagArray(tags));
        return new Counter(){

            public void inc(long delta) {
                counter.inc(delta);
            }
        };
    }

    public io.jaegertracing.internal.metrics.Timer createTimer(String name, Map<String, String> tags) {
        final Timer timer = this.registry.timer(name, this.toTagArray(tags));
        return new io.jaegertracing.internal.metrics.Timer(){

            public void durationMicros(long time) {
                timer.update(time, TimeUnit.MICROSECONDS);
            }
        };
    }

    public io.jaegertracing.internal.metrics.Gauge createGauge(String name, Map<String, String> tags) {
        final JaegerGauge gauge = (JaegerGauge)this.registry.getGauges().get(new MetricID(name, this.toTagArray(tags)));
        return new io.jaegertracing.internal.metrics.Gauge(){

            public void update(long amount) {
                gauge.update(amount);
            }
        };
    }

    private Tag[] toTagArray(Map<String, String> tags) {
        return (Tag[])tags.entrySet().stream().map(entry -> new Tag((String)entry.getKey(), (String)entry.getValue())).toArray(Tag[]::new);
    }

    static Metadata meta(String name, MetricType type) {
        return Metadata.builder().withName(name).withDisplayName(name).withType(type).withUnit("none").withDescription(name).reusable().build();
    }

    public static class JaegerGauge
    implements Gauge<Long> {
        private AtomicLong value = new AtomicLong();

        public void update(long value) {
            this.value.set(value);
        }

        public Long getValue() {
            return this.value.get();
        }
    }
}

