/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.runtime;

import io.jaegertracing.Configuration;
import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.spi.MetricsFactory;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.util.ThreadLocalScopeManager;
import io.quarkus.jaeger.runtime.MDCScopeManager;

public class QuarkusJaegerTracer
implements Tracer {
    private volatile JaegerTracer tracer;
    private boolean logTraceContext;
    private MetricsFactory metricsFactory;
    private final ScopeManager scopeManager = new ScopeManager(){
        volatile ScopeManager delegate;

        public Scope activate(Span span) {
            return this.sm().activate(span);
        }

        public Span activeSpan() {
            if (this.delegate == null) {
                return null;
            }
            return this.sm().activeSpan();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ScopeManager sm() {
            if (this.delegate == null) {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.delegate == null) {
                        this.delegate = QuarkusJaegerTracer.this.getScopeManager();
                    }
                }
            }
            return this.delegate;
        }
    };

    void setLogTraceContext(boolean logTraceContext) {
        this.logTraceContext = logTraceContext;
    }

    void setMetricsFactory(MetricsFactory metricsFactory) {
        this.metricsFactory = metricsFactory;
    }

    public String toString() {
        return this.tracer().toString();
    }

    synchronized void reset() {
        if (this.tracer != null) {
            this.tracer.close();
        }
        this.tracer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tracer tracer() {
        if (this.tracer == null) {
            QuarkusJaegerTracer quarkusJaegerTracer = this;
            synchronized (quarkusJaegerTracer) {
                if (this.tracer == null) {
                    this.tracer = Configuration.fromEnv().withMetricsFactory(this.metricsFactory).getTracerBuilder().withScopeManager(this.scopeManager).build();
                }
            }
        }
        return this.tracer;
    }

    private ScopeManager getScopeManager() {
        Object scopeManager = new ThreadLocalScopeManager();
        if (this.logTraceContext) {
            scopeManager = new MDCScopeManager((ScopeManager)scopeManager);
        }
        return scopeManager;
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return this.tracer().buildSpan(operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        this.tracer().inject(spanContext, format, carrier);
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        return this.tracer().extract(format, carrier);
    }

    public void close() {
        this.tracer.close();
    }

    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    public Span activeSpan() {
        return this.tracer().activeSpan();
    }

    public Scope activateSpan(Span span) {
        return this.tracer.activateSpan(span);
    }
}

