/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.runtime;

import io.jaegertracing.internal.metrics.Gauge;
import io.jaegertracing.spi.MetricsFactory;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class QuarkusJaegerMicrometerFactory
implements MetricsFactory {
    MeterRegistry registry = Metrics.globalRegistry;

    public io.jaegertracing.internal.metrics.Counter createCounter(final String name, final Map<String, String> tags) {
        return new io.jaegertracing.internal.metrics.Counter(){
            private final Counter counter;
            {
                this.counter = QuarkusJaegerMicrometerFactory.this.registry.counter(name, QuarkusJaegerMicrometerFactory.this.translateTags(tags));
            }

            public void inc(long amount) {
                this.counter.increment((double)amount);
            }
        };
    }

    public io.jaegertracing.internal.metrics.Timer createTimer(final String name, final Map<String, String> tags) {
        return new io.jaegertracing.internal.metrics.Timer(){
            private final Timer timer;
            {
                this.timer = QuarkusJaegerMicrometerFactory.this.registry.timer(name, QuarkusJaegerMicrometerFactory.this.translateTags(tags));
            }

            public void durationMicros(long amount) {
                this.timer.record(amount, TimeUnit.MICROSECONDS);
            }
        };
    }

    public Gauge createGauge(final String name, final Map<String, String> tags) {
        return new Gauge(){
            private final Iterable<Tag> tagList;
            {
                this.tagList = QuarkusJaegerMicrometerFactory.this.translateTags(tags);
            }

            public void update(long amount) {
                QuarkusJaegerMicrometerFactory.this.registry.gauge(name, this.tagList, (Number)amount);
            }
        };
    }

    private Iterable<Tag> translateTags(Map<String, String> tags) {
        ArrayList<Tag> tagList = new ArrayList<Tag>(tags.size());
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            tagList.add(Tag.of((String)tag.getKey(), (String)tag.getValue()));
        }
        return tagList;
    }
}

