/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxb.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBundleBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateSystemPropertyBuildItem;
import io.quarkus.jaxb.deployment.JaxbEnabledBuildItem;
import io.quarkus.jaxb.deployment.JaxbFileRootBuildItem;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlInlineBinaryData;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSchemaTypes;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

class JaxbProcessor {
    private static final List<Class<?>> JAXB_REFLECTIVE_CLASSES = Arrays.asList(XmlAccessOrder.class, XmlAccessorType.class, XmlAnyAttribute.class, XmlAnyElement.class, XmlAttachmentRef.class, XmlAttribute.class, XmlElement.class, XmlElementDecl.class, XmlElementRef.class, XmlElementRefs.class, XmlElements.class, XmlElementWrapper.class, XmlEnum.class, XmlEnumValue.class, XmlID.class, XmlIDREF.class, XmlInlineBinaryData.class, XmlList.class, XmlMimeType.class, XmlMixed.class, XmlNs.class, XmlRegistry.class, XmlRootElement.class, XmlSchema.class, XmlSchemaType.class, XmlSchemaTypes.class, XmlSeeAlso.class, XmlTransient.class, XmlType.class, XmlValue.class, XmlJavaTypeAdapter.class, XmlJavaTypeAdapters.class);
    private static final List<String> JAXB_SERIALIZERS = Arrays.asList("html", "text", "xml", "unknown");
    private static final DotName XML_ROOT = DotName.createSimple((String)"javax.xml.bind.annotation.XmlRootElement");
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    @Inject
    BuildProducer<SubstrateResourceBuildItem> resource;
    @Inject
    BuildProducer<SubstrateResourceBundleBuildItem> resourceBundle;
    @Inject
    BuildProducer<RuntimeInitializedClassBuildItem> runtimeClasses;
    @Inject
    ApplicationArchivesBuildItem applicationArchivesBuildItem;

    JaxbProcessor() {
    }

    @BuildStep
    void process(BuildProducer<SubstrateSystemPropertyBuildItem> substrateProps, CombinedIndexBuildItem combinedIndexBuildItem, List<JaxbFileRootBuildItem> fileRoots, List<JaxbEnabledBuildItem> enabled) {
        if (enabled.isEmpty()) {
            return;
        }
        Collection xmlRoot = combinedIndexBuildItem.getIndex().getAnnotations(XML_ROOT);
        for (AnnotationInstance annotationInstance : xmlRoot) {
            this.addReflectiveClass(false, true, annotationInstance.target().asClass().name().toString());
        }
        if (xmlRoot.isEmpty() && fileRoots.isEmpty()) {
            return;
        }
        this.addReflectiveClass(false, false, "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
        this.addReflectiveClass(false, false, "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        this.addReflectiveClass(false, false, "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        this.addReflectiveClass(true, false, "com.sun.xml.bind.v2.ContextFactory");
        this.addReflectiveClass(true, false, "com.sun.xml.internal.bind.v2.ContextFactory");
        this.addResourceBundle("javax.xml.bind.Messages");
        this.addResourceBundle("javax.xml.bind.helpers.Messages");
        this.addResourceBundle("com.sun.org.apache.xml.internal.serializer.utils.SerializerMessages");
        this.addResourceBundle("com.sun.org.apache.xml.internal.res.XMLErrorResources");
        substrateProps.produce((BuildItem)new SubstrateSystemPropertyBuildItem("com.sun.xml.bind.v2.bytecode.ClassTailor.noOptimize", "true"));
        JAXB_REFLECTIVE_CLASSES.stream().map(Class::getName).forEach(clazz -> this.addReflectiveClass(true, false, (String)clazz));
        JAXB_SERIALIZERS.stream().map(s -> "com/sun/org/apache/xml/internal/serializer/output_" + s + ".properties").forEach(this::addResource);
        for (JaxbFileRootBuildItem jaxbFileRootBuildItem : fileRoots) {
            this.iterateResources(jaxbFileRootBuildItem.getFileRoot()).filter(p -> p.getFileName().toString().equals("jaxb.index")).forEach(this::handleJaxbFile);
        }
    }

    private void handleJaxbFile(Path p) {
        try {
            String path = p.toAbsolutePath().toString().substring(1);
            String pkg = p.toAbsolutePath().getParent().toString().substring(1).replace("/", ".") + ".";
            this.addResource(path);
            for (String line : Files.readAllLines(p)) {
                if (line.startsWith("#")) continue;
                String clazz = pkg + line.trim();
                for (Class<?> cl = Class.forName(clazz); cl != Object.class; cl = cl.getSuperclass()) {
                    this.addReflectiveClass(true, true, cl.getName());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Stream<Path> iterateResources(String path) {
        return this.applicationArchivesBuildItem.getAllApplicationArchives().stream().map(arch -> arch.getArchiveRoot().resolve(path)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(JaxbProcessor::safeWalk).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
    }

    public static Stream<Path> safeWalk(Path p) {
        try {
            return Files.walk(p, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private void addResource(String r) {
        this.resource.produce((BuildItem)new SubstrateResourceBuildItem(new String[]{r}));
    }

    private void addReflectiveClass(boolean methods, boolean fields, String ... className) {
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(methods, fields, className));
    }

    private void addResourceBundle(String bundle) {
        this.resourceBundle.produce((BuildItem)new SubstrateResourceBundleBuildItem(bundle));
    }
}

