/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxb.deployment;

import com.sun.xml.bind.v2.model.annotation.Locatable;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.jaxb.deployment.JaxbFileRootBuildItem;
import java.io.IOError;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlInlineBinaryData;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSchemaTypes;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class JaxbProcessor {
    private static final List<Class<? extends Annotation>> JAXB_ANNOTATIONS = Arrays.asList(XmlAccessorType.class, XmlAnyAttribute.class, XmlAnyElement.class, XmlAttachmentRef.class, XmlAttribute.class, XmlElement.class, XmlElementDecl.class, XmlElementRef.class, XmlElementRefs.class, XmlElements.class, XmlElementWrapper.class, XmlEnum.class, XmlEnumValue.class, XmlID.class, XmlIDREF.class, XmlInlineBinaryData.class, XmlList.class, XmlMimeType.class, XmlMixed.class, XmlNs.class, XmlRegistry.class, XmlRootElement.class, XmlSchema.class, XmlSchemaType.class, XmlSchemaTypes.class, XmlSeeAlso.class, XmlTransient.class, XmlType.class, XmlValue.class, XmlJavaTypeAdapter.class, XmlJavaTypeAdapters.class);
    private static final List<Class<?>> JAXB_REFLECTIVE_CLASSES = Collections.singletonList(XmlAccessOrder.class);
    private static final DotName XML_ROOT_ELEMENT = DotName.createSimple((String)XmlRootElement.class.getName());
    private static final DotName XML_TYPE = DotName.createSimple((String)XmlType.class.getName());
    private static final DotName XML_REGISTRY = DotName.createSimple((String)XmlRegistry.class.getName());
    private static final DotName XML_SCHEMA = DotName.createSimple((String)XmlSchema.class.getName());
    private static final DotName XML_JAVA_TYPE_ADAPTER = DotName.createSimple((String)XmlJavaTypeAdapter.class.getName());
    private static final DotName XML_ANY_ELEMENT = DotName.createSimple((String)XmlAnyElement.class.getName());
    private static final List<DotName> JAXB_ROOT_ANNOTATIONS = Arrays.asList(XML_ROOT_ELEMENT, XML_TYPE, XML_REGISTRY);
    private static final List<DotName> IGNORE_TYPES = Collections.singletonList(DotName.createSimple((String)"javax.xml.datatype.XMLGregorianCalendar"));
    @Inject
    ApplicationArchivesBuildItem applicationArchivesBuildItem;

    JaxbProcessor() {
    }

    @BuildStep
    void processAnnotationsAndIndexFiles(BuildProducer<NativeImageSystemPropertyBuildItem> nativeImageProps, BuildProducer<ServiceProviderBuildItem> providerItem, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinitions, CombinedIndexBuildItem combinedIndexBuildItem, List<JaxbFileRootBuildItem> fileRoots, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle, BuildProducer<RuntimeInitializedClassBuildItem> runtimeClasses) {
        IndexView index = combinedIndexBuildItem.getIndex();
        boolean jaxbRootAnnotationsDetected = false;
        for (DotName jaxbRootAnnotation : JAXB_ROOT_ANNOTATIONS) {
            for (AnnotationInstance jaxbRootAnnotationInstance : index.getAnnotations(jaxbRootAnnotation)) {
                if (jaxbRootAnnotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                this.addReflectiveClass(reflectiveClass, true, true, jaxbRootAnnotationInstance.target().asClass().name().toString());
                jaxbRootAnnotationsDetected = true;
            }
        }
        if (!jaxbRootAnnotationsDetected && fileRoots.isEmpty()) {
            return;
        }
        for (AnnotationInstance xmlSchemaInstance : index.getAnnotations(XML_SCHEMA)) {
            if (xmlSchemaInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{xmlSchemaInstance.target().asClass().name().toString()}));
        }
        for (AnnotationInstance xmlJavaTypeAdapterInstance : index.getAnnotations(XML_JAVA_TYPE_ADAPTER)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{xmlJavaTypeAdapterInstance.value().asClass().name().toString()}));
        }
        if (!index.getAnnotations(XML_ANY_ELEMENT).isEmpty()) {
            this.addReflectiveClass(reflectiveClass, false, false, "javax.xml.bind.annotation.W3CDomHandler");
        }
        JAXB_ANNOTATIONS.stream().map(Class::getName).forEach(className -> {
            proxyDefinitions.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{className, Locatable.class.getName()}));
            this.addReflectiveClass(reflectiveClass, true, false, (String)className);
        });
        for (JaxbFileRootBuildItem i : fileRoots) {
            Stream<Path> stream = this.iterateResources(i.getFileRoot());
            Throwable throwable = null;
            try {
                stream.filter(p -> p.getFileName().toString().equals("jaxb.index")).forEach(p1 -> this.handleJaxbFile((Path)p1, resource, reflectiveClass));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
    }

    @BuildStep
    void ignoreWarnings(BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarningProducer) {
        for (DotName type : IGNORE_TYPES) {
            ignoreWarningProducer.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(type));
        }
    }

    @BuildStep
    void registerClasses(BuildProducer<NativeImageSystemPropertyBuildItem> nativeImageProps, BuildProducer<ServiceProviderBuildItem> providerItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle) {
        this.addReflectiveClass(reflectiveClass, true, false, "com.sun.xml.bind.v2.ContextFactory");
        this.addReflectiveClass(reflectiveClass, true, false, "com.sun.xml.internal.bind.v2.ContextFactory");
        this.addReflectiveClass(reflectiveClass, true, false, "com.sun.xml.internal.stream.XMLInputFactoryImpl");
        this.addReflectiveClass(reflectiveClass, true, false, "com.sun.xml.internal.stream.XMLOutputFactoryImpl");
        this.addReflectiveClass(reflectiveClass, true, false, "com.sun.org.apache.xpath.internal.functions.FuncNot");
        this.addReflectiveClass(reflectiveClass, true, false, "com.sun.org.apache.xerces.internal.impl.dv.xs.SchemaDVFactoryImpl");
        this.addResourceBundle(resourceBundle, "javax.xml.bind.Messages");
        this.addResourceBundle(resourceBundle, "javax.xml.bind.helpers.Messages");
        nativeImageProps.produce((BuildItem)new NativeImageSystemPropertyBuildItem("com.sun.xml.bind.v2.bytecode.ClassTailor.noOptimize", "true"));
        JAXB_REFLECTIVE_CLASSES.stream().map(Class::getName).forEach(className -> this.addReflectiveClass(reflectiveClass, true, false, (String)className));
        providerItem.produce((BuildItem)new ServiceProviderBuildItem(JAXBContext.class.getName(), new String[]{"com.sun.xml.bind.v2.ContextFactory"}));
    }

    private void handleJaxbFile(Path p, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        try {
            String path = p.toAbsolutePath().toString().substring(1);
            String pkg = p.toAbsolutePath().getParent().toString().substring(1).replace("/", ".") + ".";
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{path}));
            for (String line : Files.readAllLines(p)) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                String clazz = pkg + line;
                for (Class<?> cl = Class.forName(clazz, false, Thread.currentThread().getContextClassLoader()); cl != Object.class; cl = cl.getSuperclass()) {
                    this.addReflectiveClass(reflectiveClass, true, true, cl.getName());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Stream<Path> iterateResources(String path) {
        return this.applicationArchivesBuildItem.getAllApplicationArchives().stream().map(arch -> arch.getChildPath(path)).filter(p -> p != null && Files.isDirectory(p, new LinkOption[0])).flatMap(JaxbProcessor::safeWalk).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
    }

    public static Stream<Path> safeWalk(Path p) {
        try {
            return Files.walk(p, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private void addReflectiveClass(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, boolean methods, boolean fields, String ... className) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(methods, fields, className));
    }

    private void addResourceBundle(BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle, String bundle) {
        resourceBundle.produce((BuildItem)new NativeImageResourceBundleBuildItem(bundle));
    }
}

