/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxb.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SynthesisFinishedBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.jaxb.deployment.FilteredJaxbClassesToBeBoundBuildItem;
import io.quarkus.jaxb.deployment.JaxbClassesToBeBoundBuildItem;
import io.quarkus.jaxb.deployment.JaxbFileRootBuildItem;
import io.quarkus.jaxb.runtime.JaxbConfig;
import io.quarkus.jaxb.runtime.JaxbContextConfigRecorder;
import io.quarkus.jaxb.runtime.JaxbContextProducer;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlAccessOrder;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttachmentRef;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementDecl;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlInlineBinaryData;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlMimeType;
import jakarta.xml.bind.annotation.XmlMixed;
import jakarta.xml.bind.annotation.XmlNs;
import jakarta.xml.bind.annotation.XmlRegistry;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchema;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSchemaTypes;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import java.io.IOError;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class JaxbProcessor {
    private static Logger LOG = Logger.getLogger(JaxbProcessor.class);
    private static final List<Class<? extends Annotation>> JAXB_ANNOTATIONS = List.of(XmlAccessorType.class, XmlAnyAttribute.class, XmlAnyElement.class, XmlAttachmentRef.class, XmlAttribute.class, XmlElement.class, XmlElementDecl.class, XmlElementRef.class, XmlElementRefs.class, XmlElements.class, XmlElementWrapper.class, XmlEnum.class, XmlEnumValue.class, XmlID.class, XmlIDREF.class, XmlInlineBinaryData.class, XmlList.class, XmlMimeType.class, XmlMixed.class, XmlNs.class, XmlRegistry.class, XmlRootElement.class, XmlSchema.class, XmlSchemaType.class, XmlSchemaTypes.class, XmlSeeAlso.class, XmlTransient.class, XmlType.class, XmlValue.class, XmlJavaTypeAdapter.class, XmlJavaTypeAdapters.class);
    private static final List<Class<?>> JAXB_REFLECTIVE_CLASSES = List.of(XmlAccessOrder.class);
    private static final DotName XML_ROOT_ELEMENT = DotName.createSimple((String)XmlRootElement.class.getName());
    private static final DotName XML_TYPE = DotName.createSimple((String)XmlType.class.getName());
    private static final DotName XML_REGISTRY = DotName.createSimple((String)XmlRegistry.class.getName());
    private static final DotName XML_SCHEMA = DotName.createSimple((String)XmlSchema.class.getName());
    private static final DotName XML_JAVA_TYPE_ADAPTER = DotName.createSimple((String)XmlJavaTypeAdapter.class.getName());
    private static final DotName XML_ANY_ELEMENT = DotName.createSimple((String)XmlAnyElement.class.getName());
    private static final DotName XML_SEE_ALSO = DotName.createSimple((String)XmlSeeAlso.class.getName());
    private static final DotName XML_TRANSIENT = DotName.createSimple((String)XmlTransient.class.getName());
    private static final DotName XML_ACCESSOR_TYPE = DotName.createSimple((String)XmlAccessorType.class.getName());
    private static final List<DotName> JAXB_ROOT_ANNOTATIONS = List.of(XML_ROOT_ELEMENT, XML_TYPE, XML_REGISTRY);
    private static final List<DotName> IGNORE_TYPES = List.of(DotName.createSimple((String)"javax.xml.datatype.XMLGregorianCalendar"));
    private static final List<String> NATIVE_PROXY_DEFINITIONS = List.of("org.glassfish.jaxb.core.marshaller.CharacterEscapeHandler", "com.sun.xml.txw2.output.CharacterEscapeHandler", "org.glassfish.jaxb.core.v2.schemagen.episode.Bindings", "org.glassfish.jaxb.core.v2.schemagen.episode.SchemaBindings", "org.glassfish.jaxb.core.v2.schemagen.episode.Klass", "org.glassfish.jaxb.core.v2.schemagen.episode.Package", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Annotated", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Annotation", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Any", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Appinfo", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.AttrDecls", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.AttributeType", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ComplexContent", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ComplexExtension", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ComplexRestriction", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ComplexType", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ComplexTypeHost", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ComplexTypeModel", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ContentModelContainer", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Documentation", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Element", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ExplicitGroup", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ExtensionType", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.FixedOrDefault", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Import", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.List", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.LocalAttribute", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.LocalElement", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.NestedParticle", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.NoFixedFacet", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Occurs", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Particle", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Redefinable", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Schema", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SchemaTop", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleContent", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleDerivation", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleExtension", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleRestriction", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleRestrictionModel", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleType", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleTypeHost", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.TopLevelAttribute", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.TopLevelElement", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.TypeDefParticle", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.TypeHost", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Union", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Wildcard", "com.sun.xml.txw2.TypedXmlWriter");

    @BuildStep
    void processAnnotationsAndIndexFiles(BuildProducer<NativeImageSystemPropertyBuildItem> nativeImageProps, BuildProducer<ServiceProviderBuildItem> providerItem, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinitions, CombinedIndexBuildItem combinedIndexBuildItem, List<JaxbFileRootBuildItem> fileRoots, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle, BuildProducer<RuntimeInitializedClassBuildItem> runtimeClasses, BuildProducer<JaxbClassesToBeBoundBuildItem> classesToBeBoundProducer, ApplicationArchivesBuildItem applicationArchivesBuildItem) throws ClassNotFoundException {
        ArrayList<String> classesToBeBound = new ArrayList<String>();
        IndexView index = combinedIndexBuildItem.getIndex();
        boolean jaxbRootAnnotationsDetected = false;
        for (DotName jaxbRootAnnotation : JAXB_ROOT_ANNOTATIONS) {
            for (AnnotationInstance jaxbRootAnnotationInstance : index.getAnnotations(jaxbRootAnnotation)) {
                if (jaxbRootAnnotationInstance.target().kind() != AnnotationTarget.Kind.CLASS || JAXB_ANNOTATIONS.contains(jaxbRootAnnotationInstance.target().asClass().getClass())) continue;
                ClassInfo targetClassInfo = jaxbRootAnnotationInstance.target().asClass();
                this.addReflectiveHierarchyClass(targetClassInfo, reflectiveHierarchies, index);
                classesToBeBound.add(targetClassInfo.name().toString());
                jaxbRootAnnotationsDetected = true;
            }
        }
        if (!jaxbRootAnnotationsDetected && fileRoots.isEmpty()) {
            return;
        }
        for (AnnotationInstance xmlSchemaInstance : index.getAnnotations(XML_SCHEMA)) {
            if (xmlSchemaInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            String className2 = xmlSchemaInstance.target().asClass().name().toString();
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className2}).build());
        }
        for (AnnotationInstance xmlJavaTypeAdapterInstance : index.getAnnotations(XML_JAVA_TYPE_ADAPTER)) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{xmlJavaTypeAdapterInstance.value().asClass().name().toString()}).methods().fields().build());
        }
        if (!index.getAnnotations(XML_ANY_ELEMENT).isEmpty()) {
            this.addReflectiveClass(reflectiveClass, false, false, "jakarta.xml.bind.annotation.W3CDomHandler");
        }
        JAXB_ANNOTATIONS.stream().map(Class::getName).forEach(className -> this.addReflectiveClass(reflectiveClass, true, false, (String)className));
        proxyDefinitions.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{XmlSeeAlso.class.getName(), "org.glassfish.jaxb.core.v2.model.annotation.Locatable"}));
        for (AnnotationInstance xmlSeeAlsoAnn : index.getAnnotations(XML_SEE_ALSO)) {
            Type[] types;
            AnnotationValue value = xmlSeeAlsoAnn.value();
            for (Type t : types = value.asClassArray()) {
                this.addReflectiveClass(reflectiveClass, false, false, t.name().toString());
            }
        }
        for (String s : NATIVE_PROXY_DEFINITIONS) {
            proxyDefinitions.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{s}));
        }
        for (JaxbFileRootBuildItem i : fileRoots) {
            this.iterateResources(applicationArchivesBuildItem, i.getFileRoot(), resource, reflectiveClass, classesToBeBound);
        }
        classesToBeBoundProducer.produce((BuildItem)new JaxbClassesToBeBoundBuildItem(classesToBeBound));
    }

    @BuildStep
    void ignoreWarnings(BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarningProducer) {
        for (DotName type : IGNORE_TYPES) {
            ignoreWarningProducer.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(type));
        }
    }

    @BuildStep
    void registerClasses(BuildProducer<NativeImageSystemPropertyBuildItem> nativeImageProps, BuildProducer<ServiceProviderBuildItem> providerItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle) {
        this.addReflectiveClass(reflectiveClass, true, false, "org.glassfish.jaxb.runtime.v2.ContextFactory");
        this.addReflectiveClass(reflectiveClass, true, false, "com.sun.xml.internal.stream.XMLInputFactoryImpl");
        this.addReflectiveClass(reflectiveClass, true, false, "com.sun.xml.internal.stream.XMLOutputFactoryImpl");
        this.addReflectiveClass(reflectiveClass, true, false, "com.sun.org.apache.xpath.internal.functions.FuncNot");
        this.addReflectiveClass(reflectiveClass, true, false, "com.sun.org.apache.xerces.internal.impl.dv.xs.SchemaDVFactoryImpl");
        this.addResourceBundle(resourceBundle, "jakarta.xml.bind.Messages");
        this.addResourceBundle(resourceBundle, "jakarta.xml.bind.helpers.Messages");
        nativeImageProps.produce((BuildItem)new NativeImageSystemPropertyBuildItem("com.sun.xml.bind.v2.bytecode.ClassTailor.noOptimize", "true"));
        JAXB_REFLECTIVE_CLASSES.stream().map(Class::getName).forEach(className -> this.addReflectiveClass(reflectiveClass, true, false, (String)className));
        providerItem.produce((BuildItem)new ServiceProviderBuildItem(JAXBContext.class.getName(), new String[]{"org.glassfish.jaxb.runtime.v2.ContextFactory"}));
    }

    @BuildStep
    FilteredJaxbClassesToBeBoundBuildItem filterBoundClasses(JaxbConfig config, List<JaxbClassesToBeBoundBuildItem> classesToBeBoundBuildItems) {
        FilteredJaxbClassesToBeBoundBuildItem.Builder builder = FilteredJaxbClassesToBeBoundBuildItem.builder();
        classesToBeBoundBuildItems.stream().map(JaxbClassesToBeBoundBuildItem::getClasses).forEach(builder::classNames);
        if (config.excludeClasses.isPresent()) {
            builder.classNameExcludes((Collection)config.excludeClasses.get());
        }
        return builder.build();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void bindClassesToJaxbContext(JaxbConfig config, FilteredJaxbClassesToBeBoundBuildItem filteredClassesToBeBound, SynthesisFinishedBuildItem beanContainerState, JaxbContextConfigRecorder jaxbContextConfig) {
        jaxbContextConfig.reset();
        BeanResolver beanResolver = beanContainerState.getBeanResolver();
        Set beans = beanResolver.resolveBeans(Type.create((DotName)DotName.createSimple(JAXBContext.class), (Type.Kind)Type.Kind.CLASS), new AnnotationInstance[0]);
        if (!beans.isEmpty()) {
            jaxbContextConfig.addClassesToBeBound(filteredClassesToBeBound.getClasses());
            if (config.validateJaxbContext) {
                this.validateJaxbContext(filteredClassesToBeBound, beanResolver, beans);
            }
        }
    }

    @BuildStep
    void registerProduces(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{JaxbContextProducer.class}));
    }

    private void validateJaxbContext(FilteredJaxbClassesToBeBoundBuildItem filteredClassesToBeBound, BeanResolver beanResolver, Set<BeanInfo> beans) {
        BeanInfo bean = beanResolver.resolveAmbiguity(beans);
        if (bean.isDefaultBean()) {
            try {
                JAXBContext.newInstance((Class[])filteredClassesToBeBound.getClasses().toArray(new Class[0]));
            }
            catch (JAXBException e) {
                throw new DeploymentException("Failed to create or validate the default JAXBContext", (Throwable)e);
            }
        }
    }

    private void handleJaxbFile(Path p, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, List<String> classesToBeBound) {
        try {
            String path = p.toAbsolutePath().toString().substring(1);
            String pkg = p.toAbsolutePath().getParent().toString().substring(1).replace(p.getFileSystem().getSeparator(), ".") + ".";
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{path}));
            for (String line : Files.readAllLines(p)) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                String clazz = pkg + line;
                classesToBeBound.add(clazz);
                for (Class<?> cl = Class.forName(clazz, false, Thread.currentThread().getContextClassLoader()); cl != Object.class; cl = cl.getSuperclass()) {
                    reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{cl}).methods().fields().build());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void iterateResources(ApplicationArchivesBuildItem applicationArchivesBuildItem, String path, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, List<String> classesToBeBound) {
        for (ApplicationArchive archive : applicationArchivesBuildItem.getAllApplicationArchives()) {
            archive.accept(tree -> {
                Path arch = tree.getPath(path);
                if (arch != null && Files.isDirectory(arch, new LinkOption[0])) {
                    JaxbProcessor.safeWalk(arch).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().equals("jaxb.index")).forEach(p1 -> this.handleJaxbFile((Path)p1, resource, reflectiveClass, classesToBeBound));
                }
            });
        }
    }

    public static Stream<Path> safeWalk(Path p) {
        try {
            return Files.walk(p, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private void addReflectiveHierarchyClass(ClassInfo classInfo, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, IndexView index) {
        DotName name = classInfo.name();
        reflectiveHierarchy.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((DotName)name).index(index).ignoreTypePredicate(t -> ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate.INSTANCE.test(t) || IGNORE_TYPES.contains(t)).ignoreFieldPredicate(JaxbProcessor::isFieldIgnored).ignoreMethodPredicate(JaxbProcessor::isMethodIgnored).source(this.getClass().getSimpleName() + " > " + name).build());
    }

    private void addReflectiveClass(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, boolean methods, boolean fields, String ... className) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])className).methods(methods).fields(fields).build());
    }

    private void addResourceBundle(BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle, String bundle) {
        resourceBundle.produce((BuildItem)new NativeImageResourceBundleBuildItem(bundle));
    }

    private static boolean isFieldIgnored(FieldInfo fieldInfo) {
        if (fieldInfo.hasAnnotation(XML_TRANSIENT)) {
            return true;
        }
        if (Modifier.isStatic(fieldInfo.flags())) {
            return true;
        }
        for (Class<? extends Annotation> jaxbAnnotation : JAXB_ANNOTATIONS) {
            if (!fieldInfo.hasAnnotation(jaxbAnnotation)) continue;
            return true;
        }
        ClassInfo declaringClass = fieldInfo.declaringClass();
        XmlAccessType xmlAccessType = JaxbProcessor.getXmlAccessType(declaringClass);
        switch (xmlAccessType) {
            case FIELD: {
                return false;
            }
            case PROPERTY: {
                return true;
            }
            case PUBLIC_MEMBER: {
                return !Modifier.isPublic(fieldInfo.flags());
            }
            case NONE: {
                return true;
            }
        }
        return true;
    }

    private static boolean isMethodIgnored(MethodInfo methodInfo) {
        MethodInfo getterSetterCounterpart = JaxbProcessor.getGetterSetterCounterPart(methodInfo);
        if (methodInfo.hasAnnotation(XML_TRANSIENT) || getterSetterCounterpart != null && getterSetterCounterpart.hasAnnotation(XML_TRANSIENT)) {
            return true;
        }
        if (Modifier.isStatic(methodInfo.flags())) {
            return true;
        }
        for (Class<? extends Annotation> jaxbAnnotation : JAXB_ANNOTATIONS) {
            if (!methodInfo.hasAnnotation(jaxbAnnotation)) continue;
            return false;
        }
        ClassInfo declaringClass = methodInfo.declaringClass();
        XmlAccessType xmlAccessType = JaxbProcessor.getXmlAccessType(declaringClass);
        switch (xmlAccessType) {
            case FIELD: {
                return true;
            }
            case PROPERTY: 
            case PUBLIC_MEMBER: {
                return !Modifier.isPublic(methodInfo.flags());
            }
            case NONE: {
                return true;
            }
        }
        return true;
    }

    private static MethodInfo getGetterSetterCounterPart(MethodInfo methodInfo) {
        if (!methodInfo.name().startsWith("get") || methodInfo.parametersCount() > 0) {
            return null;
        }
        return methodInfo.declaringClass().method(methodInfo.name().replaceFirst("get", "set"), new Type[]{methodInfo.returnType()});
    }

    private static XmlAccessType getXmlAccessType(ClassInfo classInfo) {
        AnnotationInstance xmlAccessorTypeAi = classInfo.annotation(XML_ACCESSOR_TYPE);
        if (xmlAccessorTypeAi == null) {
            return XmlAccessType.PUBLIC_MEMBER;
        }
        AnnotationValue xmlAccessorType = xmlAccessorTypeAi.value();
        if (xmlAccessorType == null) {
            return XmlAccessType.PUBLIC_MEMBER;
        }
        return XmlAccessType.valueOf((String)xmlAccessorTypeAi.value().asEnum());
    }
}

