/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.client.deployment;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.model.InjectableBean;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.model.RestClientInterface;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaderWriter;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.IndexedParameter;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonArrayHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonObjectHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonStructureHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonValueHandler;

public class ClientEndpointIndexer
extends EndpointIndexer<ClientEndpointIndexer, ClientIndexedParam, ResourceMethod> {
    ClientEndpointIndexer(Builder builder) {
        super((EndpointIndexer.Builder)builder);
    }

    public RestClientInterface createClientProxy(ClassInfo classInfo, String path) {
        try {
            RestClientInterface clazz = new RestClientInterface();
            clazz.setClassName(classInfo.name().toString());
            if (path != null) {
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                clazz.setPath(path);
            }
            List methods = this.createEndpoints(classInfo, classInfo, new HashSet(), clazz.getPathParameters());
            clazz.getMethods().addAll(methods);
            return clazz;
        }
        catch (Exception e) {
            log.debug((Object)("Ignoring interface for creating client proxy" + classInfo.name()), (Throwable)e);
            return null;
        }
    }

    protected ResourceMethod createResourceMethod() {
        return new ResourceMethod();
    }

    protected InjectableBean scanInjectableBean(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, Map<String, String> existingConverters, AdditionalReaders additionalReaders, Map<String, InjectableBean> injectableBeans, boolean hasRuntimeConverters) {
        throw new RuntimeException("Injectable beans not supported in client");
    }

    protected MethodParameter createMethodParameter(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, boolean encoded, Type paramType, ClientIndexedParam parameterResult, String name, String defaultValue, ParameterType type, String elementType, boolean single, String signature) {
        return new MethodParameter(name, elementType, ClientEndpointIndexer.toClassName((Type)paramType, (ClassInfo)currentClassInfo, (ClassInfo)actualEndpointInfo, (IndexView)this.index), signature, type, single, defaultValue, parameterResult.isObtainedAsCollection(), encoded);
    }

    protected void addWriterForType(AdditionalWriters additionalWriters, Type paramType) {
        this.addReaderWriterForType((AdditionalReaderWriter)additionalWriters, paramType);
    }

    protected void addReaderForType(AdditionalReaders additionalReaders, Type paramType) {
        this.addReaderWriterForType((AdditionalReaderWriter)additionalReaders, paramType);
    }

    private void addReaderWriterForType(AdditionalReaderWriter additionalReaderWriter, Type paramType) {
        DotName dotName = paramType.name();
        if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_NUMBER) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_VALUE) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRING)) {
            additionalReaderWriter.add(JsonValueHandler.class, "application/json", JsonValue.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_ARRAY)) {
            additionalReaderWriter.add(JsonArrayHandler.class, "application/json", JsonArray.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_OBJECT)) {
            additionalReaderWriter.add(JsonObjectHandler.class, "application/json", JsonObject.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRUCTURE)) {
            additionalReaderWriter.add(JsonStructureHandler.class, "application/json", JsonStructure.class);
        }
    }

    protected ClientIndexedParam createIndexedParam() {
        return new ClientIndexedParam();
    }

    public static final class Builder
    extends EndpointIndexer.Builder<ClientEndpointIndexer, Builder, ResourceMethod> {
        public ClientEndpointIndexer build() {
            return new ClientEndpointIndexer(this);
        }
    }

    public static class ClientIndexedParam
    extends IndexedParameter<ClientIndexedParam> {
    }
}

