/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxrs.client.reactive.deployment;

import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.Types;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.jaxrs.client.reactive.deployment.JaxrsClientReactiveEnricherBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.MediaTypeWithPriority;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDefaultConsumesBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDefaultProducesBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDisableSmartDefaultProduces;
import io.quarkus.jaxrs.client.reactive.runtime.ClientResponseBuilderFactory;
import io.quarkus.jaxrs.client.reactive.runtime.JaxrsClientReactiveRecorder;
import io.quarkus.jaxrs.client.reactive.runtime.ToObjectArray;
import io.quarkus.resteasy.reactive.common.deployment.ApplicationResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusFactoryCreator;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusResteasyReactiveDotNames;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.SerializersUtil;
import io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveCommonRecorder;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderOverrideBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterOverrideBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.buffer.Buffer;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.CompletionStageRxInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.handlers.ClientObservabilityHandler;
import org.jboss.resteasy.reactive.client.impl.AbstractRxInvoker;
import org.jboss.resteasy.reactive.client.impl.AsyncInvokerImpl;
import org.jboss.resteasy.reactive.client.impl.ClientBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.MultiInvoker;
import org.jboss.resteasy.reactive.client.impl.UniInvoker;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartForm;
import org.jboss.resteasy.reactive.client.processor.beanparam.BeanParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.ClientBeanParamInfo;
import org.jboss.resteasy.reactive.client.processor.beanparam.CookieParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.HeaderParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.Item;
import org.jboss.resteasy.reactive.client.processor.beanparam.PathParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.QueryParamItem;
import org.jboss.resteasy.reactive.client.processor.scanning.ClientEndpointIndexer;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.core.GenericTypeMapping;
import org.jboss.resteasy.reactive.common.core.ResponseBuilderFactory;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.model.MaybeRestClientInterface;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.common.model.RestClientInterface;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaderWriter;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.HashUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;

public class JaxrsClientReactiveProcessor {
    private static final Logger log = Logger.getLogger(JaxrsClientReactiveProcessor.class);
    private static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");
    private static final MethodDescriptor WEB_TARGET_RESOLVE_TEMPLATE_METHOD = MethodDescriptor.ofMethod(WebTarget.class, (String)"resolveTemplate", WebTarget.class, (Class[])new Class[]{String.class, Object.class});
    private static final MethodDescriptor MULTIVALUED_MAP_ADD = MethodDescriptor.ofMethod(MultivaluedMap.class, (String)"add", Void.TYPE, (Class[])new Class[]{Object.class, Object.class});
    private static final MethodDescriptor PATH_GET_FILENAME = MethodDescriptor.ofMethod(Path.class, (String)"getFileName", Path.class, (Class[])new Class[0]);
    private static final MethodDescriptor OBJECT_TO_STRING = MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]);
    static final DotName CONTINUATION = DotName.createSimple((String)"kotlin.coroutines.Continuation");
    private static final DotName UNI_KT = DotName.createSimple((String)"io.smallrye.mutiny.coroutines.UniKt");
    private static final DotName FILE = DotName.createSimple((String)File.class.getName());
    private static final DotName PATH = DotName.createSimple((String)Path.class.getName());
    private static final DotName BUFFER = DotName.createSimple((String)Buffer.class.getName());
    private static final Set<DotName> ASYNC_RETURN_TYPES = Set.of(ResteasyReactiveDotNames.COMPLETION_STAGE, ResteasyReactiveDotNames.UNI, ResteasyReactiveDotNames.MULTI);

    @BuildStep
    void addFeature(BuildProducer<FeatureBuildItem> features) {
        features.produce((BuildItem)new FeatureBuildItem(Feature.JAXRS_CLIENT_REACTIVE));
    }

    @BuildStep
    void registerClientResponseBuilder(BuildProducer<ServiceProviderBuildItem> serviceProviders) {
        serviceProviders.produce((BuildItem)new ServiceProviderBuildItem(ResponseBuilderFactory.class.getName(), new String[]{ClientResponseBuilderFactory.class.getName()}));
        serviceProviders.produce((BuildItem)new ServiceProviderBuildItem(ClientBuilder.class.getName(), new String[]{ClientBuilderImpl.class.getName()}));
    }

    @BuildStep
    void initializeRuntimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses) {
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(AsyncInvokerImpl.class.getName()));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupClientProxies(JaxrsClientReactiveRecorder recorder, BeanContainerBuildItem beanContainerBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, final BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyBuildItemBuildProducer, List<MessageBodyReaderBuildItem> messageBodyReaderBuildItems, List<MessageBodyWriterBuildItem> messageBodyWriterBuildItems, List<MessageBodyReaderOverrideBuildItem> messageBodyReaderOverrideBuildItems, List<MessageBodyWriterOverrideBuildItem> messageBodyWriterOverrideBuildItems, List<JaxrsClientReactiveEnricherBuildItem> enricherBuildItems, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability, io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveConfig config, RecorderContext recorderContext, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerBuildItemBuildProducer, List<RestClientDefaultProducesBuildItem> defaultConsumes, List<RestClientDefaultConsumesBuildItem> defaultProduces, List<RestClientDisableSmartDefaultProduces> disableSmartDefaultProduces) {
        String defaultConsumesType = this.defaultMediaType(defaultConsumes, "application/octet-stream");
        String defaultProducesType = this.defaultMediaType(defaultProduces, "text/plain");
        Serialisers serialisers = recorder.createSerializers();
        SerializersUtil.setupSerializers((ResteasyReactiveCommonRecorder)recorder, reflectiveClassBuildItemBuildProducer, messageBodyReaderBuildItems, messageBodyWriterBuildItems, messageBodyReaderOverrideBuildItems, messageBodyWriterOverrideBuildItems, (BeanContainerBuildItem)beanContainerBuildItem, (ApplicationResultBuildItem)applicationResultBuildItem, (Serialisers)serialisers, (RuntimeType)RuntimeType.CLIENT);
        if (resourceScanningResultBuildItem.isEmpty() || resourceScanningResultBuildItem.get().getResult().getClientInterfaces().isEmpty()) {
            recorder.setupClientProxies(new HashMap(), Collections.emptyMap());
            return;
        }
        ResourceScanningResult result = resourceScanningResultBuildItem.get().getResult();
        AdditionalReaders additionalReaders = new AdditionalReaders();
        AdditionalWriters additionalWriters = new AdditionalWriters();
        final IndexView index = beanArchiveIndexBuildItem.getIndex();
        ClientEndpointIndexer clientEndpointIndexer = ((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)new ClientEndpointIndexer.Builder().setIndex(index)).setExistingConverters(new HashMap())).setScannedResourcePaths(result.getScannedResourcePaths())).setConfig(this.createRestReactiveConfig(config))).setAdditionalReaders(additionalReaders)).setHttpAnnotationToMethod(result.getHttpAnnotationToMethod())).setInjectableBeans(new HashMap())).setFactoryCreator((Function)new QuarkusFactoryCreator((ResteasyReactiveCommonRecorder)recorder, beanContainerBuildItem.getValue()))).setAdditionalWriters(additionalWriters)).setDefaultBlocking(applicationResultBuildItem.getResult().getBlockingDefault())).setHasRuntimeConverters(false)).setDefaultProduces(defaultProducesType).setSmartDefaultProduces(disableSmartDefaultProduces.isEmpty()).setResourceMethodCallback((Consumer)new Consumer<EndpointIndexer.ResourceMethodCallbackData>(){

            @Override
            public void accept(EndpointIndexer.ResourceMethodCallbackData entry) {
                MethodInfo method = entry.getMethodInfo();
                String source = JaxrsClientReactiveProcessor.class.getSimpleName() + " > " + method.declaringClass() + "[" + method + "]";
                reflectiveHierarchyBuildItemBuildProducer.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(method.returnType()).index(index).ignoreTypePredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
            }
        })).build();
        boolean observabilityIntegrationNeeded = capabilities.isPresent("io.quarkus.opentelemetry.tracer") || metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer");
        HashMap clientImplementations = new HashMap();
        HashMap<String, String> failures = new HashMap<String, String>();
        for (Map.Entry i : result.getClientInterfaces().entrySet()) {
            ClassInfo clazz = index.getClassByName((DotName)i.getKey());
            MaybeRestClientInterface maybeClientProxy = clientEndpointIndexer.createClientProxy(clazz, (String)i.getValue());
            if (maybeClientProxy.exists()) {
                RestClientInterface clientProxy = maybeClientProxy.getRestClientInterface();
                try {
                    RuntimeValue<Function<WebTarget, ?>> proxyProvider = this.generateClientInvoker(recorderContext, clientProxy, enricherBuildItems, generatedClassBuildItemBuildProducer, clazz, index, defaultConsumesType, result.getHttpAnnotationToMethod(), observabilityIntegrationNeeded);
                    if (proxyProvider == null) continue;
                    clientImplementations.put(clientProxy.getClassName(), proxyProvider);
                }
                catch (Exception any) {
                    log.debugv((Throwable)any, "Failed to create client proxy for {0} this can usually be safely ignored", (Object)clazz.name());
                    failures.put(clazz.name().toString(), any.getMessage());
                }
                continue;
            }
            failures.put(clazz.name().toString(), maybeClientProxy.getFailure());
        }
        recorder.setupClientProxies(clientImplementations, failures);
        for (AdditionalReaderWriter.Entry additionalReader : additionalReaders.get()) {
            Class readerClass = additionalReader.getHandlerClass();
            ResourceReader reader = new ResourceReader();
            reader.setBuiltin(true);
            reader.setFactory(recorder.factory(readerClass.getName(), beanContainerBuildItem.getValue()));
            reader.setMediaTypeStrings(Collections.singletonList(additionalReader.getMediaType()));
            recorder.registerReader(serialisers, additionalReader.getEntityClass().getName(), reader);
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{readerClass.getName()}));
        }
        for (AdditionalReaderWriter.Entry entry : additionalWriters.get()) {
            Class writerClass = entry.getHandlerClass();
            ResourceWriter writer = new ResourceWriter();
            writer.setBuiltin(true);
            writer.setFactory(recorder.factory(writerClass.getName(), beanContainerBuildItem.getValue()));
            writer.setMediaTypeStrings(Collections.singletonList(entry.getMediaType()));
            recorder.registerWriter(serialisers, entry.getEntityClass().getName(), writer);
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{writerClass.getName()}));
        }
    }

    private ResteasyReactiveConfig createRestReactiveConfig(io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveConfig config) {
        Config mpConfig = ConfigProvider.getConfig();
        return new ResteasyReactiveConfig(this.getEffectivePropertyValue("input-buffer-size", config.inputBufferSize.asLongValue(), Long.class, mpConfig).longValue(), this.getEffectivePropertyValue("single-default-produces", config.singleDefaultProduces, Boolean.class, mpConfig).booleanValue(), this.getEffectivePropertyValue("default-produces", config.defaultProduces, Boolean.class, mpConfig).booleanValue());
    }

    private <T> T getEffectivePropertyValue(String legacyPropertyName, T newPropertyValue, Class<T> propertyType, Config mpConfig) {
        Optional legacyPropertyValue = mpConfig.getOptionalValue("quarkus.rest." + legacyPropertyName, propertyType);
        if (legacyPropertyValue.isPresent()) {
            return legacyPropertyValue.get();
        }
        return newPropertyValue;
    }

    private String defaultMediaType(List<? extends MediaTypeWithPriority> defaultMediaTypes, String defaultMediaType) {
        if (defaultMediaTypes == null || defaultMediaTypes.isEmpty()) {
            return defaultMediaType;
        }
        defaultMediaTypes.sort(Comparator.comparingInt(MediaTypeWithPriority::getPriority));
        return defaultMediaTypes.get(0).getMediaType();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void registerInvocationCallbacks(CombinedIndexBuildItem index, JaxrsClientReactiveRecorder recorder) {
        Collection invocationCallbacks = index.getComputingIndex().getAllKnownImplementors(ResteasyReactiveDotNames.INVOCATION_CALLBACK);
        GenericTypeMapping genericTypeMapping = new GenericTypeMapping();
        for (ClassInfo invocationCallback : invocationCallbacks) {
            try {
                List typeParameters = JandexUtil.resolveTypeParameters((DotName)invocationCallback.name(), (DotName)ResteasyReactiveDotNames.INVOCATION_CALLBACK, (IndexView)index.getComputingIndex());
                recorder.registerInvocationHandlerGenericType(genericTypeMapping, invocationCallback.name().toString(), ((org.jboss.jandex.Type)typeParameters.get(0)).name().toString());
            }
            catch (Exception exception) {}
        }
        recorder.setGenericTypeMapping(genericTypeMapping);
    }

    /*
     * Could not resolve type clashes
     */
    private RuntimeValue<Function<WebTarget, ?>> generateClientInvoker(RecorderContext recorderContext, RestClientInterface restClientInterface, List<JaxrsClientReactiveEnricherBuildItem> enrichers, BuildProducer<GeneratedClassBuildItem> generatedClasses, ClassInfo interfaceClass, IndexView index, String defaultMediaType, Map<DotName, String> httpAnnotationToMethod, boolean observabilityIntegrationNeeded) {
        String name = restClientInterface.getClassName() + "$$QuarkusRestClientInterface";
        MethodDescriptor ctorDesc = MethodDescriptor.ofConstructor((String)name, (String[])new String[]{WebTarget.class.getName()});
        try (ClassCreator c = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true), name, null, Object.class.getName(), new String[]{Closeable.class.getName(), restClientInterface.getClassName()});){
            MethodCreator constructor = c.getMethodCreator(ctorDesc);
            constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
            MethodCreator clinit = c.getMethodCreator(MethodDescriptor.ofMethod((Object)name, (String)"<clinit>", Void.TYPE, (Object[])new Object[0]));
            clinit.setModifiers(8);
            AssignableResultHandle baseTarget = constructor.createVariable(WebTarget.class);
            constructor.assign(baseTarget, constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"path", WebTarget.class, (Class[])new Class[]{String.class}), constructor.getMethodParam(0), new ResultHandle[]{constructor.load(restClientInterface.getPath())}));
            for (JaxrsClientReactiveEnricherBuildItem enricher : enrichers) {
                enricher.getEnricher().forClass(constructor, baseTarget, interfaceClass, index);
            }
            int methodIndex = 0;
            ArrayList<FieldDescriptor> webTargets = new ArrayList<FieldDescriptor>();
            for (ResourceMethod method : restClientInterface.getMethods()) {
                MethodCreator methodCreator;
                ++methodIndex;
                String[] javaMethodParameters = new String[method.getParameters().length];
                for (int i = 0; i < method.getParameters().length; ++i) {
                    MethodParameter param = method.getParameters()[i];
                    javaMethodParameters[i] = param.declaredType != null ? param.declaredType : param.type;
                }
                MethodInfo jandexMethod = this.getJavaMethod(interfaceClass, method, method.getParameters(), index).orElseThrow(() -> new RuntimeException("Failed to find matching java method for " + method + " on " + interfaceClass + ". It may have unresolved parameter types (generics)"));
                if (!Modifier.isAbstract(jandexMethod.flags())) continue;
                if (method.getHttpMethod() == null) {
                    org.jboss.jandex.Type returnType = jandexMethod.returnType();
                    if (returnType.kind() != Type.Kind.CLASS) {
                        throw new IllegalArgumentException("Sub resource type is not a class: " + returnType.name().toString());
                    }
                    ClassInfo subResourceInterface = index.getClassByName(returnType.name());
                    if (!Modifier.isInterface(subResourceInterface.flags())) {
                        throw new IllegalArgumentException("Client interface method: " + jandexMethod.declaringClass().name() + "#" + jandexMethod + " has no HTTP method annotation  (@GET, @POST, etc) and it's return type: " + returnType.name().toString() + " is not an interface. If it's a sub resource method, it has to return an interface. If it's not, it has to have one of the HTTP method annotations.");
                    }
                    methodCreator = c.getMethodCreator(method.getName(), method.getSimpleReturnType(), javaMethodParameters);
                    String subName = subResourceInterface.name().toString() + HashUtil.sha1((String)name) + methodIndex;
                    ClassCreator sub = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true), subName, null, Object.class.getName(), new String[]{subResourceInterface.name().toString()});
                    try {
                        ResultHandle subInstance = methodCreator.newInstance(MethodDescriptor.ofConstructor((String)subName, (String[])new String[0]), new ResultHandle[0]);
                        MethodCreator subConstructor = null;
                        MethodCreator subClinit = null;
                        if (!enrichers.isEmpty()) {
                            subConstructor = sub.getMethodCreator(MethodDescriptor.ofConstructor((String)subName, (String[])new String[0]));
                            subConstructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), subConstructor.getThis(), new ResultHandle[0]);
                            subClinit = sub.getMethodCreator(MethodDescriptor.ofMethod((Object)subName, (String)"<clinit>", Void.TYPE, (Object[])new Object[0]));
                            subClinit.setModifiers(8);
                        }
                        HashMap<Integer, FieldDescriptor> paramFields = new HashMap<Integer, FieldDescriptor>();
                        for (int i = 0; i < method.getParameters().length; ++i) {
                            FieldDescriptor paramField = ((FieldCreator)sub.getFieldCreator("param" + i, method.getParameters()[i].type).setModifiers(1)).getFieldDescriptor();
                            methodCreator.writeInstanceField(paramField, subInstance, methodCreator.getMethodParam(i));
                            paramFields.put(i, paramField);
                        }
                        ResultHandle multipartForm = null;
                        int subMethodIndex = 0;
                        for (ResourceMethod subMethod : method.getSubResourceMethods()) {
                            AssignableResultHandle invocationBuilderRef;
                            MethodParameter param;
                            int paramIdx;
                            if (subMethod.getHttpMethod() == null) continue;
                            MethodInfo jandexSubMethod = this.getJavaMethod(subResourceInterface, subMethod, subMethod.getParameters(), index).orElseThrow(() -> new RuntimeException("Failed to find matching java method for " + method + " on " + interfaceClass + ". It may have unresolved parameter types (generics)"));
                            FieldDescriptor webTargetForSubMethod = FieldDescriptor.of((String)name, (String)("target" + methodIndex + "_" + ++subMethodIndex), WebTarget.class);
                            c.getFieldCreator(webTargetForSubMethod).setModifiers(16);
                            webTargets.add(webTargetForSubMethod);
                            AssignableResultHandle constructorTarget = this.createWebTargetForMethod(constructor, baseTarget, method);
                            if (subMethod.getPath() != null) {
                                this.appendPath(constructor, subMethod.getPath(), constructorTarget);
                            }
                            constructor.writeInstanceField(webTargetForSubMethod, constructor.getThis(), (ResultHandle)constructorTarget);
                            FieldDescriptor subWebTarget = ((FieldCreator)sub.getFieldCreator("target" + subMethodIndex, WebTarget.class).setModifiers(1)).getFieldDescriptor();
                            methodCreator.writeInstanceField(subWebTarget, subInstance, methodCreator.readInstanceField(webTargetForSubMethod, methodCreator.getThis()));
                            MethodCreator subMethodCreator = sub.getMethodCreator(subMethod.getName(), jandexSubMethod.returnType().name().toString(), this.parametersAsStringArray(jandexSubMethod));
                            AssignableResultHandle methodTarget = subMethodCreator.createVariable(WebTarget.class);
                            subMethodCreator.assign(methodTarget, subMethodCreator.readInstanceField(subWebTarget, subMethodCreator.getThis()));
                            ResultHandle bodyParameterValue = null;
                            AssignableResultHandle formParams = null;
                            HashMap<MethodDescriptor, ResultHandle> invocationBuilderEnrichers = new HashMap<MethodDescriptor, ResultHandle>();
                            for (paramIdx = 0; paramIdx < method.getParameters().length; ++paramIdx) {
                                param = method.getParameters()[paramIdx];
                                ResultHandle paramValue = subMethodCreator.readInstanceField((FieldDescriptor)paramFields.get(paramIdx), subMethodCreator.getThis());
                                if (param.parameterType == ParameterType.QUERY) {
                                    subMethodCreator.assign(methodTarget, this.addQueryParam((BytecodeCreator)subMethodCreator, (ResultHandle)methodTarget, param.name, paramValue, (org.jboss.jandex.Type)jandexMethod.parameters().get(paramIdx), index));
                                    continue;
                                }
                                if (param.parameterType == ParameterType.BEAN) {
                                    ClientBeanParamInfo beanParam = (ClientBeanParamInfo)param;
                                    MethodDescriptor handleBeanParamDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + methodIndex + "$$handleBeanParam$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                                    MethodCreator handleBeanParamMethod = sub.getMethodCreator(handleBeanParamDescriptor);
                                    AssignableResultHandle invocationBuilderRef2 = handleBeanParamMethod.createVariable(Invocation.Builder.class);
                                    handleBeanParamMethod.assign(invocationBuilderRef2, handleBeanParamMethod.getMethodParam(0));
                                    this.addBeanParamData((BytecodeCreator)subMethodCreator, (BytecodeCreator)handleBeanParamMethod, invocationBuilderRef2, beanParam.getItems(), paramValue, methodTarget, index);
                                    handleBeanParamMethod.returnValue((ResultHandle)invocationBuilderRef2);
                                    invocationBuilderEnrichers.put(handleBeanParamDescriptor, paramValue);
                                    continue;
                                }
                                if (param.parameterType == ParameterType.PATH) {
                                    subMethodCreator.assign(methodTarget, subMethodCreator.invokeInterfaceMethod(WEB_TARGET_RESOLVE_TEMPLATE_METHOD, (ResultHandle)methodTarget, new ResultHandle[]{subMethodCreator.load(param.name), paramValue}));
                                    continue;
                                }
                                if (param.parameterType == ParameterType.BODY) {
                                    bodyParameterValue = paramValue;
                                    continue;
                                }
                                if (param.parameterType == ParameterType.HEADER) {
                                    MethodDescriptor handleHeaderDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleHeader$$param" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                                    MethodCreator handleHeaderMethod = sub.getMethodCreator(handleHeaderDescriptor);
                                    invocationBuilderRef = handleHeaderMethod.createVariable(Invocation.Builder.class);
                                    handleHeaderMethod.assign(invocationBuilderRef, handleHeaderMethod.getMethodParam(0));
                                    this.addHeaderParam((BytecodeCreator)handleHeaderMethod, invocationBuilderRef, param.name, handleHeaderMethod.getMethodParam(1));
                                    handleHeaderMethod.returnValue((ResultHandle)invocationBuilderRef);
                                    invocationBuilderEnrichers.put(handleHeaderDescriptor, paramValue);
                                    continue;
                                }
                                if (param.parameterType == ParameterType.COOKIE) {
                                    MethodDescriptor handleCookieDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleCookie$$param" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                                    MethodCreator handleCookieMethod = sub.getMethodCreator(handleCookieDescriptor);
                                    invocationBuilderRef = handleCookieMethod.createVariable(Invocation.Builder.class);
                                    handleCookieMethod.assign(invocationBuilderRef, handleCookieMethod.getMethodParam(0));
                                    this.addCookieParam((BytecodeCreator)handleCookieMethod, invocationBuilderRef, param.name, handleCookieMethod.getMethodParam(1));
                                    handleCookieMethod.returnValue((ResultHandle)invocationBuilderRef);
                                    invocationBuilderEnrichers.put(handleCookieDescriptor, paramValue);
                                    continue;
                                }
                                if (param.parameterType == ParameterType.FORM) {
                                    formParams = this.createIfAbsent(subMethodCreator, formParams);
                                    subMethodCreator.invokeInterfaceMethod(MULTIVALUED_MAP_ADD, (ResultHandle)formParams, new ResultHandle[]{subMethodCreator.load(param.name), paramValue});
                                    continue;
                                }
                                if (param.parameterType != ParameterType.MULTI_PART_FORM) continue;
                                if (multipartForm != null) {
                                    throw new IllegalArgumentException("MultipartForm data set twice for method " + jandexSubMethod.declaringClass().name() + "#" + jandexSubMethod.name());
                                }
                                multipartForm = this.createMultipartForm(subMethodCreator, paramValue, (org.jboss.jandex.Type)((org.jboss.jandex.Type)jandexMethod.parameters().get(paramIdx)).asClassType(), index);
                            }
                            for (paramIdx = 0; paramIdx < subMethod.getParameters().length; ++paramIdx) {
                                AssignableResultHandle invocationBuilderRef3;
                                MethodDescriptor handleHeaderDescriptor;
                                param = subMethod.getParameters()[paramIdx];
                                if (param.parameterType == ParameterType.QUERY) {
                                    subMethodCreator.assign(methodTarget, this.addQueryParam((BytecodeCreator)subMethodCreator, (ResultHandle)methodTarget, param.name, subMethodCreator.getMethodParam(paramIdx), (org.jboss.jandex.Type)jandexSubMethod.parameters().get(paramIdx), index));
                                    continue;
                                }
                                if (param.parameterType == ParameterType.BEAN) {
                                    ClientBeanParamInfo beanParam = (ClientBeanParamInfo)param;
                                    MethodDescriptor handleBeanParamDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleBeanParam$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                                    MethodCreator handleBeanParamMethod = c.getMethodCreator(handleBeanParamDescriptor);
                                    invocationBuilderRef = handleBeanParamMethod.createVariable(Invocation.Builder.class);
                                    handleBeanParamMethod.assign(invocationBuilderRef, handleBeanParamMethod.getMethodParam(0));
                                    this.addBeanParamData((BytecodeCreator)subMethodCreator, (BytecodeCreator)handleBeanParamMethod, invocationBuilderRef, beanParam.getItems(), subMethodCreator.getMethodParam(paramIdx), methodTarget, index);
                                    handleBeanParamMethod.returnValue((ResultHandle)invocationBuilderRef);
                                    invocationBuilderEnrichers.put(handleBeanParamDescriptor, subMethodCreator.getMethodParam(paramIdx));
                                    continue;
                                }
                                if (param.parameterType == ParameterType.PATH) {
                                    subMethodCreator.assign(methodTarget, subMethodCreator.invokeInterfaceMethod(WEB_TARGET_RESOLVE_TEMPLATE_METHOD, (ResultHandle)methodTarget, new ResultHandle[]{subMethodCreator.load(param.name), subMethodCreator.getMethodParam(paramIdx)}));
                                    continue;
                                }
                                if (param.parameterType == ParameterType.BODY) {
                                    bodyParameterValue = subMethodCreator.getMethodParam(paramIdx);
                                    continue;
                                }
                                if (param.parameterType == ParameterType.HEADER) {
                                    handleHeaderDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleHeader$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                                    MethodCreator handleHeaderMethod = sub.getMethodCreator(handleHeaderDescriptor);
                                    invocationBuilderRef3 = handleHeaderMethod.createVariable(Invocation.Builder.class);
                                    handleHeaderMethod.assign(invocationBuilderRef3, handleHeaderMethod.getMethodParam(0));
                                    this.addHeaderParam((BytecodeCreator)handleHeaderMethod, invocationBuilderRef3, param.name, handleHeaderMethod.getMethodParam(1));
                                    handleHeaderMethod.returnValue((ResultHandle)invocationBuilderRef3);
                                    invocationBuilderEnrichers.put(handleHeaderDescriptor, subMethodCreator.getMethodParam(paramIdx));
                                    continue;
                                }
                                if (param.parameterType == ParameterType.COOKIE) {
                                    handleHeaderDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleCookie$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                                    MethodCreator handleCookieMethod = sub.getMethodCreator(handleHeaderDescriptor);
                                    invocationBuilderRef3 = handleCookieMethod.createVariable(Invocation.Builder.class);
                                    handleCookieMethod.assign(invocationBuilderRef3, handleCookieMethod.getMethodParam(0));
                                    this.addCookieParam((BytecodeCreator)handleCookieMethod, invocationBuilderRef3, param.name, handleCookieMethod.getMethodParam(1));
                                    handleCookieMethod.returnValue((ResultHandle)invocationBuilderRef3);
                                    invocationBuilderEnrichers.put(handleHeaderDescriptor, subMethodCreator.getMethodParam(paramIdx));
                                    continue;
                                }
                                if (param.parameterType == ParameterType.FORM) {
                                    formParams = this.createIfAbsent(subMethodCreator, formParams);
                                    subMethodCreator.invokeInterfaceMethod(MULTIVALUED_MAP_ADD, (ResultHandle)formParams, new ResultHandle[]{subMethodCreator.load(param.name), subMethodCreator.getMethodParam(paramIdx)});
                                    continue;
                                }
                                if (param.parameterType != ParameterType.MULTI_PART_FORM) continue;
                                if (multipartForm != null) {
                                    throw new IllegalArgumentException("MultipartForm data set twice for method " + jandexSubMethod.declaringClass().name() + "#" + jandexSubMethod.name());
                                }
                                multipartForm = this.createMultipartForm(subMethodCreator, subMethodCreator.getMethodParam(paramIdx), (org.jboss.jandex.Type)jandexSubMethod.parameters().get(paramIdx), index);
                            }
                            AssignableResultHandle builder = subMethodCreator.createVariable(Invocation.Builder.class);
                            if (method.getProduces() == null || method.getProduces().length == 0) {
                                subMethodCreator.assign(builder, subMethodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"request", Invocation.Builder.class, (Class[])new Class[0]), (ResultHandle)methodTarget, new ResultHandle[0]));
                            } else {
                                ResultHandle array = subMethodCreator.newArray(String.class, subMethod.getProduces().length);
                                for (int i = 0; i < subMethod.getProduces().length; ++i) {
                                    subMethodCreator.writeArrayValue(array, i, subMethodCreator.load(subMethod.getProduces()[i]));
                                }
                                subMethodCreator.assign(builder, subMethodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"request", Invocation.Builder.class, (Class[])new Class[]{String[].class}), (ResultHandle)methodTarget, new ResultHandle[]{array}));
                            }
                            for (Map.Entry invocationBuilderEnricher : invocationBuilderEnrichers.entrySet()) {
                                subMethodCreator.assign(builder, subMethodCreator.invokeVirtualMethod((MethodDescriptor)invocationBuilderEnricher.getKey(), subMethodCreator.getThis(), new ResultHandle[]{builder, (ResultHandle)invocationBuilderEnricher.getValue()}));
                            }
                            for (JaxrsClientReactiveEnricherBuildItem enricher : enrichers) {
                                enricher.getEnricher().forSubResourceMethod(sub, subConstructor, subClinit, subMethodCreator, interfaceClass, subResourceInterface, jandexSubMethod, jandexMethod, builder, index, generatedClasses, methodIndex, subMethodIndex);
                            }
                            String[] consumes = EndpointIndexer.extractProducesConsumesValues((AnnotationInstance)jandexSubMethod.declaringClass().classAnnotation(ResteasyReactiveDotNames.CONSUMES), (String[])method.getConsumes());
                            consumes = EndpointIndexer.extractProducesConsumesValues((AnnotationInstance)jandexSubMethod.annotation(ResteasyReactiveDotNames.CONSUMES), (String[])consumes);
                            this.handleReturn(subResourceInterface, defaultMediaType, this.getHttpMethod(jandexSubMethod, subMethod.getHttpMethod(), httpAnnotationToMethod), consumes, jandexSubMethod, subMethodCreator, (ResultHandle)formParams, multipartForm, bodyParameterValue, builder);
                        }
                        if (subConstructor != null) {
                            subConstructor.returnValue(null);
                            subClinit.returnValue(null);
                        }
                        methodCreator.returnValue(subInstance);
                        continue;
                    }
                    finally {
                        sub.close();
                        continue;
                    }
                }
                FieldDescriptor webTargetForMethod = FieldDescriptor.of((String)name, (String)("target" + methodIndex), WebTargetImpl.class);
                c.getFieldCreator(webTargetForMethod).setModifiers(16);
                webTargets.add(webTargetForMethod);
                AssignableResultHandle constructorTarget = this.createWebTargetForMethod(constructor, baseTarget, method);
                constructor.writeInstanceField(webTargetForMethod, constructor.getThis(), (ResultHandle)constructorTarget);
                if (observabilityIntegrationNeeded) {
                    String templatePath = MULTIPLE_SLASH_PATTERN.matcher(restClientInterface.getPath() + method.getPath()).replaceAll("/");
                    constructor.invokeVirtualMethod(MethodDescriptor.ofMethod(WebTargetImpl.class, (String)"setPreClientSendHandler", Void.TYPE, (Class[])new Class[]{ClientRestHandler.class}), constructor.readInstanceField(webTargetForMethod, constructor.getThis()), new ResultHandle[]{constructor.newInstance(MethodDescriptor.ofConstructor(ClientObservabilityHandler.class, (Class[])new Class[]{String.class}), new ResultHandle[]{constructor.load(templatePath)})});
                }
                methodCreator = c.getMethodCreator(method.getName(), method.getSimpleReturnType(), javaMethodParameters);
                AssignableResultHandle methodTarget = methodCreator.createVariable(WebTarget.class);
                methodCreator.assign(methodTarget, methodCreator.readInstanceField(webTargetForMethod, methodCreator.getThis()));
                Integer bodyParameterIdx = null;
                HashMap<MethodDescriptor, ResultHandle> invocationBuilderEnrichers = new HashMap<MethodDescriptor, ResultHandle>();
                ResultHandle multipartForm = null;
                AssignableResultHandle formParams = null;
                for (int paramIdx = 0; paramIdx < method.getParameters().length; ++paramIdx) {
                    AssignableResultHandle invocationBuilderRef;
                    MethodDescriptor handleHeaderDescriptor;
                    MethodParameter param = method.getParameters()[paramIdx];
                    if (param.parameterType == ParameterType.QUERY) {
                        methodCreator.assign(methodTarget, this.addQueryParam((BytecodeCreator)methodCreator, (ResultHandle)methodTarget, param.name, methodCreator.getMethodParam(paramIdx), (org.jboss.jandex.Type)jandexMethod.parameters().get(paramIdx), index));
                        continue;
                    }
                    if (param.parameterType == ParameterType.BEAN) {
                        ClientBeanParamInfo beanParam = (ClientBeanParamInfo)param;
                        MethodDescriptor handleBeanParamDescriptor = MethodDescriptor.ofMethod((Object)name, (String)(method.getName() + "$$" + methodIndex + "$$handleBeanParam$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleBeanParamMethod = c.getMethodCreator(handleBeanParamDescriptor);
                        AssignableResultHandle invocationBuilderRef4 = handleBeanParamMethod.createVariable(Invocation.Builder.class);
                        handleBeanParamMethod.assign(invocationBuilderRef4, handleBeanParamMethod.getMethodParam(0));
                        this.addBeanParamData((BytecodeCreator)methodCreator, (BytecodeCreator)handleBeanParamMethod, invocationBuilderRef4, beanParam.getItems(), methodCreator.getMethodParam(paramIdx), methodTarget, index);
                        handleBeanParamMethod.returnValue((ResultHandle)invocationBuilderRef4);
                        invocationBuilderEnrichers.put(handleBeanParamDescriptor, methodCreator.getMethodParam(paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.PATH) {
                        methodCreator.assign(methodTarget, methodCreator.invokeInterfaceMethod(WEB_TARGET_RESOLVE_TEMPLATE_METHOD, (ResultHandle)methodTarget, new ResultHandle[]{methodCreator.load(param.name), methodCreator.getMethodParam(paramIdx)}));
                        continue;
                    }
                    if (param.parameterType == ParameterType.BODY) {
                        bodyParameterIdx = paramIdx;
                        continue;
                    }
                    if (param.parameterType == ParameterType.HEADER) {
                        handleHeaderDescriptor = MethodDescriptor.ofMethod((Object)name, (String)(method.getName() + "$$" + methodIndex + "$$handleHeader$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleHeaderMethod = c.getMethodCreator(handleHeaderDescriptor);
                        invocationBuilderRef = handleHeaderMethod.createVariable(Invocation.Builder.class);
                        handleHeaderMethod.assign(invocationBuilderRef, handleHeaderMethod.getMethodParam(0));
                        this.addHeaderParam((BytecodeCreator)handleHeaderMethod, invocationBuilderRef, param.name, handleHeaderMethod.getMethodParam(1));
                        handleHeaderMethod.returnValue((ResultHandle)invocationBuilderRef);
                        invocationBuilderEnrichers.put(handleHeaderDescriptor, methodCreator.getMethodParam(paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.COOKIE) {
                        handleHeaderDescriptor = MethodDescriptor.ofMethod((Object)name, (String)(method.getName() + "$$" + methodIndex + "$$handleCookie$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleCookieMethod = c.getMethodCreator(handleHeaderDescriptor);
                        invocationBuilderRef = handleCookieMethod.createVariable(Invocation.Builder.class);
                        handleCookieMethod.assign(invocationBuilderRef, handleCookieMethod.getMethodParam(0));
                        this.addCookieParam((BytecodeCreator)handleCookieMethod, invocationBuilderRef, param.name, handleCookieMethod.getMethodParam(1));
                        handleCookieMethod.returnValue((ResultHandle)invocationBuilderRef);
                        invocationBuilderEnrichers.put(handleHeaderDescriptor, methodCreator.getMethodParam(paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.FORM) {
                        formParams = this.createIfAbsent(methodCreator, formParams);
                        methodCreator.invokeInterfaceMethod(MULTIVALUED_MAP_ADD, (ResultHandle)formParams, new ResultHandle[]{methodCreator.load(param.name), methodCreator.getMethodParam(paramIdx)});
                        continue;
                    }
                    if (param.parameterType != ParameterType.MULTI_PART_FORM) continue;
                    if (multipartForm != null) {
                        throw new IllegalArgumentException("MultipartForm data set twice for method " + jandexMethod.declaringClass().name() + "#" + jandexMethod.name());
                    }
                    multipartForm = this.createMultipartForm(methodCreator, methodCreator.getMethodParam(paramIdx), (org.jboss.jandex.Type)jandexMethod.parameters().get(paramIdx), index);
                }
                AssignableResultHandle builder = methodCreator.createVariable(Invocation.Builder.class);
                if (method.getProduces() == null || method.getProduces().length == 0) {
                    methodCreator.assign(builder, methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"request", Invocation.Builder.class, (Class[])new Class[0]), (ResultHandle)methodTarget, new ResultHandle[0]));
                } else {
                    ResultHandle array = methodCreator.newArray(String.class, method.getProduces().length);
                    for (int i = 0; i < method.getProduces().length; ++i) {
                        methodCreator.writeArrayValue(array, i, methodCreator.load(method.getProduces()[i]));
                    }
                    methodCreator.assign(builder, methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"request", Invocation.Builder.class, (Class[])new Class[]{String[].class}), (ResultHandle)methodTarget, new ResultHandle[]{array}));
                }
                for (Map.Entry invocationBuilderEnricher : invocationBuilderEnrichers.entrySet()) {
                    methodCreator.assign(builder, methodCreator.invokeVirtualMethod((MethodDescriptor)invocationBuilderEnricher.getKey(), methodCreator.getThis(), new ResultHandle[]{builder, (ResultHandle)invocationBuilderEnricher.getValue()}));
                }
                for (JaxrsClientReactiveEnricherBuildItem enricher : enrichers) {
                    enricher.getEnricher().forMethod(c, constructor, clinit, methodCreator, interfaceClass, jandexMethod, builder, index, generatedClasses, methodIndex);
                }
                this.handleReturn(interfaceClass, defaultMediaType, method.getHttpMethod(), method.getConsumes(), jandexMethod, methodCreator, (ResultHandle)formParams, multipartForm, bodyParameterIdx == null ? null : methodCreator.getMethodParam(bodyParameterIdx.intValue()), builder);
            }
            constructor.returnValue(null);
            clinit.returnValue(null);
            MethodCreator closeCreator = c.getMethodCreator(MethodDescriptor.ofMethod(Closeable.class, (String)"close", Void.TYPE, (Class[])new Class[0]));
            for (FieldDescriptor target : webTargets) {
                ResultHandle webTarget = closeCreator.readInstanceField(target, closeCreator.getThis());
                ResultHandle webTargetImpl = closeCreator.checkCast(webTarget, WebTargetImpl.class);
                ResultHandle restClient = closeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(WebTargetImpl.class, (String)"getRestClient", ClientImpl.class, (Class[])new Class[0]), webTargetImpl, new ResultHandle[0]);
                closeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(ClientImpl.class, (String)"close", Void.TYPE, (Class[])new Class[0]), restClient, new ResultHandle[0]);
            }
            closeCreator.returnValue(null);
        }
        String creatorName = restClientInterface.getClassName() + "$$QuarkusRestClientInterfaceCreator";
        try (ClassCreator c = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true), creatorName, null, Object.class.getName(), new String[]{Function.class.getName()});){
            MethodCreator apply = c.getMethodCreator(MethodDescriptor.ofMethod((Object)creatorName, (String)"apply", Object.class, (Object[])new Object[]{Object.class}));
            apply.returnValue(apply.newInstance(ctorDesc, new ResultHandle[]{apply.getMethodParam(0)}));
        }
        return recorderContext.newInstance(creatorName);
    }

    private ResultHandle createMultipartForm(MethodCreator methodCreator, ResultHandle methodParam, org.jboss.jandex.Type formClassType, IndexView index) {
        AssignableResultHandle multipartForm = methodCreator.createVariable(QuarkusMultipartForm.class);
        methodCreator.assign(multipartForm, methodCreator.newInstance(MethodDescriptor.ofConstructor(QuarkusMultipartForm.class, (Class[])new Class[0]), new ResultHandle[0]));
        ClassInfo formClass = index.getClassByName(formClassType.name());
        for (FieldInfo field : formClass.fields()) {
            if (Modifier.isStatic(field.flags())) continue;
            String fieldName = field.name();
            ResultHandle fieldValue = null;
            String getterName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            for (MethodInfo method : formClass.methods()) {
                if (!method.name().equals(getterName) || !method.returnType().name().equals((Object)field.type().name()) || !method.parameters().isEmpty() || !Modifier.isPublic(method.flags()) || Modifier.isStatic(method.flags())) continue;
                fieldValue = methodCreator.invokeVirtualMethod(method, methodParam, new ResultHandle[0]);
                break;
            }
            if (fieldValue == null && Modifier.isPublic(field.flags())) {
                fieldValue = methodCreator.readInstanceField(field, methodParam);
            }
            if (fieldValue == null) {
                throw new IllegalArgumentException("Non-public field '" + fieldName + "' without a getter, found in a multipart form data class '" + formClassType.name() + "'. Rest Client Reactive only supports multipart form classes with fields that are public or have public getters.");
            }
            String formParamName = this.formParamName(field);
            String partType = this.formPartType(field);
            org.jboss.jandex.Type fieldType = field.type();
            switch (fieldType.kind()) {
                case CLASS: {
                    ClassInfo fieldClass = index.getClassByName(fieldType.name());
                    if (DotNames.STRING.equals((Object)fieldClass.name())) {
                        this.addString(methodCreator, multipartForm, formParamName, fieldValue);
                        break;
                    }
                    if (this.is(FILE, fieldClass, index)) {
                        if (partType == null) {
                            throw new IllegalArgumentException("No @PartType annotation found on multipart form field of type File: " + formClass.name() + "." + field.name());
                        }
                        BytecodeCreator ifFileNotNull = methodCreator.ifNotNull(fieldValue).trueBranch();
                        ResultHandle filePath = ifFileNotNull.invokeVirtualMethod(MethodDescriptor.ofMethod(File.class, (String)"toPath", Path.class, (Class[])new Class[0]), fieldValue, new ResultHandle[0]);
                        this.addFile(ifFileNotNull, multipartForm, formParamName, partType, filePath);
                        break;
                    }
                    if (this.is(PATH, fieldClass, index)) {
                        if (partType == null) {
                            throw new IllegalArgumentException("No @PartType annotation found on multipart form field of type Path: " + formClass.name() + "." + field.name());
                        }
                        BytecodeCreator ifPathNotNull = methodCreator.ifNotNull(fieldValue).trueBranch();
                        this.addFile(ifPathNotNull, multipartForm, formParamName, partType, fieldValue);
                        break;
                    }
                    if (this.is(BUFFER, fieldClass, index)) {
                        BytecodeCreator ifBufferNotNull = methodCreator.ifNotNull(fieldValue).trueBranch();
                        this.addBuffer(ifBufferNotNull, multipartForm, formParamName, partType, fieldValue, field);
                        break;
                    }
                    this.addPojo(methodCreator, multipartForm, formParamName, partType, fieldValue, field);
                    break;
                }
                case ARRAY: {
                    org.jboss.jandex.Type componentType = fieldType.asArrayType().component();
                    if (componentType.kind() != Type.Kind.PRIMITIVE || !Byte.TYPE.getName().equals(componentType.name().toString())) {
                        throw new IllegalArgumentException("Array of unsupported type: " + componentType.name() + " on " + formClassType.name() + "." + field.name());
                    }
                    BytecodeCreator ifArrayNotNull = methodCreator.ifNotNull(fieldValue).trueBranch();
                    ResultHandle buffer = ifArrayNotNull.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{byte[].class}), new ResultHandle[]{fieldValue});
                    this.addBuffer(ifArrayNotNull, multipartForm, formParamName, partType, buffer, field);
                    break;
                }
                case PRIMITIVE: {
                    ResultHandle string = this.primitiveToString(methodCreator, fieldValue, field);
                    this.addString(methodCreator, multipartForm, formParamName, string);
                    break;
                }
                case VOID: 
                case TYPE_VARIABLE: 
                case UNRESOLVED_TYPE_VARIABLE: 
                case WILDCARD_TYPE: 
                case PARAMETERIZED_TYPE: {
                    throw new IllegalArgumentException("Unsupported multipart form field type: " + fieldType + " in field class " + formClassType.name());
                }
            }
        }
        return multipartForm;
    }

    private void addPojo(MethodCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partType, ResultHandle fieldValue, FieldInfo field) {
        methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"entity", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, Object.class, String.class, Class.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(field.name()), fieldValue, methodCreator.load(partType), methodCreator.loadClass(field.type().name().toString())}));
    }

    private void addFile(BytecodeCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partType, ResultHandle filePath) {
        ResultHandle fileNamePath = methodCreator.invokeInterfaceMethod(PATH_GET_FILENAME, filePath, new ResultHandle[0]);
        ResultHandle fileName = methodCreator.invokeVirtualMethod(OBJECT_TO_STRING, fileNamePath, new ResultHandle[0]);
        ResultHandle pathString = methodCreator.invokeVirtualMethod(OBJECT_TO_STRING, filePath, new ResultHandle[0]);
        if (partType.equalsIgnoreCase("application/octet-stream")) {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"binaryFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, String.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), fileName, pathString, methodCreator.load(partType)}));
        } else {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"textFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, String.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), fileName, pathString, methodCreator.load(partType)}));
        }
    }

    private ResultHandle primitiveToString(MethodCreator methodCreator, ResultHandle fieldValue, FieldInfo field) {
        PrimitiveType primitiveType = field.type().asPrimitiveType();
        switch (primitiveType.primitive()) {
            case BOOLEAN: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Boolean.TYPE}), new ResultHandle[]{fieldValue});
            }
            case CHAR: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Character.TYPE}), new ResultHandle[]{fieldValue});
            }
            case DOUBLE: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Double.TYPE}), new ResultHandle[]{fieldValue});
            }
            case FLOAT: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Float.TYPE}), new ResultHandle[]{fieldValue});
            }
            case INT: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{fieldValue});
            }
            case LONG: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Long.TYPE}), new ResultHandle[]{fieldValue});
            }
        }
        throw new IllegalArgumentException("Unsupported primitive type in mulitpart form field: " + field.declaringClass().name() + "." + field.name());
    }

    private void addString(MethodCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, ResultHandle fieldValue) {
        methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"attribute", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), fieldValue}));
    }

    private void addBuffer(BytecodeCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partType, ResultHandle buffer, FieldInfo field) {
        if (partType == null) {
            throw new IllegalArgumentException("No @PartType annotation found on multipart form field " + field.declaringClass().name() + "." + field.name());
        }
        if (partType.equalsIgnoreCase("application/octet-stream")) {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"binaryFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, Buffer.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), methodCreator.load(formParamName), buffer, methodCreator.load(partType)}));
        } else {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"textFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, Buffer.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), methodCreator.load(formParamName), buffer, methodCreator.load(partType)}));
        }
    }

    private String formPartType(FieldInfo field) {
        AnnotationInstance partType = field.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME);
        if (partType != null) {
            return partType.value().asString();
        }
        return null;
    }

    private String formParamName(FieldInfo field) {
        AnnotationInstance restFormParam = field.annotation(ResteasyReactiveDotNames.REST_FORM_PARAM);
        AnnotationInstance formParam = field.annotation(ResteasyReactiveDotNames.FORM_PARAM);
        if (restFormParam != null && formParam != null) {
            throw new IllegalArgumentException("Only one of @RestFormParam, @FormParam annotations expected on a field. Found both on " + field.declaringClass() + "." + field.name());
        }
        if (restFormParam != null) {
            AnnotationValue value = restFormParam.value();
            if (value == null || "".equals(value.asString())) {
                return field.name();
            }
            return value.asString();
        }
        if (formParam != null) {
            return formParam.value().asString();
        }
        throw new IllegalArgumentException("One of @RestFormParam, @FormParam annotations expected on a field. No annotation found on " + field.declaringClass() + "." + field.name());
    }

    private boolean is(DotName desiredClass, ClassInfo fieldClass, IndexView index) {
        ClassInfo superClass;
        if (fieldClass.name().equals((Object)desiredClass)) {
            return true;
        }
        if (fieldClass.name().toString().equals(Object.class.getName()) || (superClass = index.getClassByName(fieldClass.superName())) == null) {
            return false;
        }
        return this.is(desiredClass, superClass, index);
    }

    private AssignableResultHandle createIfAbsent(MethodCreator methodCreator, AssignableResultHandle formValues) {
        if (formValues == null) {
            formValues = methodCreator.createVariable(MultivaluedMap.class);
            methodCreator.assign(formValues, methodCreator.newInstance(MethodDescriptor.ofConstructor(MultivaluedHashMap.class, (Class[])new Class[0]), new ResultHandle[0]));
        }
        return formValues;
    }

    private String[] parametersAsStringArray(MethodInfo subMethod) {
        List params = subMethod.parameters();
        String[] result = new String[params.size()];
        int i = 0;
        for (org.jboss.jandex.Type param : params) {
            result[i++] = param.name().toString();
        }
        return result;
    }

    private String getHttpMethod(MethodInfo subMethod, String defaultMethod, Map<DotName, String> httpAnnotationToMethod) {
        for (Map.Entry<DotName, String> annoToMethod : httpAnnotationToMethod.entrySet()) {
            if (subMethod.annotation(annoToMethod.getKey()) == null) continue;
            return annoToMethod.getValue();
        }
        for (Map.Entry<DotName, String> annoToMethod : httpAnnotationToMethod.entrySet()) {
            if (subMethod.declaringClass().classAnnotation(annoToMethod.getKey()) == null) continue;
            return annoToMethod.getValue();
        }
        return defaultMethod;
    }

    private void handleReturn(ClassInfo restClientInterface, String defaultMediaType, String httpMethod, String[] consumes, MethodInfo jandexMethod, MethodCreator methodCreator, ResultHandle formParams, ResultHandle multipartForm, ResultHandle bodyValue, AssignableResultHandle builder) {
        ResultHandle rx;
        ResultHandle result;
        Integer continuationIndex;
        ResultHandle genericReturnType;
        String simpleReturnType;
        ReturnCategory returnCategory;
        block35: {
            org.jboss.jandex.Type lastParamType;
            List parameters;
            org.jboss.jandex.Type returnType = jandexMethod.returnType();
            returnCategory = ReturnCategory.BLOCKING;
            simpleReturnType = returnType.name().toString();
            genericReturnType = null;
            if (returnType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                ParameterizedType paramType = returnType.asParameterizedType();
                if (ASYNC_RETURN_TYPES.contains(paramType.name())) {
                    ReturnCategory returnCategory2 = paramType.name().equals((Object)ResteasyReactiveDotNames.COMPLETION_STAGE) ? ReturnCategory.COMPLETION_STAGE : (returnCategory = paramType.name().equals((Object)ResteasyReactiveDotNames.MULTI) ? ReturnCategory.MULTI : ReturnCategory.UNI);
                    if (paramType.arguments().isEmpty()) {
                        simpleReturnType = Object.class.getName();
                    } else {
                        org.jboss.jandex.Type type = (org.jboss.jandex.Type)paramType.arguments().get(0);
                        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                            genericReturnType = this.createGenericTypeFromParameterizedType(methodCreator, type.asParameterizedType());
                        } else {
                            simpleReturnType = type.toString();
                        }
                    }
                } else {
                    genericReturnType = this.createGenericTypeFromParameterizedType(methodCreator, paramType);
                }
            }
            continuationIndex = null;
            if (returnCategory == ReturnCategory.BLOCKING && !(parameters = jandexMethod.parameters()).isEmpty() && (lastParamType = (org.jboss.jandex.Type)parameters.get(parameters.size() - 1)).name().equals((Object)CONTINUATION)) {
                continuationIndex = parameters.size() - 1;
                returnCategory = ReturnCategory.COROUTINE;
                try {
                    Thread.currentThread().getContextClassLoader().loadClass(UNI_KT.toString());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Suspendable rest client method" + jandexMethod + " is present on class " + jandexMethod.declaringClass() + " however io.smallrye.reactive:mutiny-kotlin is not detected. Please add a dependency on this artifact.");
                }
                org.jboss.jandex.Type type = (org.jboss.jandex.Type)lastParamType.asParameterizedType().arguments().get(0);
                while (true) {
                    if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        genericReturnType = this.createGenericTypeFromParameterizedType(methodCreator, type.asParameterizedType());
                        break block35;
                    }
                    if (type.kind() != Type.Kind.WILDCARD_TYPE) break;
                    if (type.asWildcardType().extendsBound().name().equals((Object)ResteasyReactiveDotNames.OBJECT)) {
                        type = type.asWildcardType().superBound();
                        continue;
                    }
                    type = type.asWildcardType().extendsBound();
                }
                simpleReturnType = type.toString();
            }
        }
        String mediaTypeValue = defaultMediaType;
        TryBlock tryBlock = methodCreator.tryBlock();
        List exceptionTypes = jandexMethod.exceptions();
        LinkedHashSet<String> exceptions = new LinkedHashSet<String>();
        for (org.jboss.jandex.Type exceptionType : exceptionTypes) {
            exceptions.add(exceptionType.name().toString());
        }
        if (!exceptions.contains(Exception.class.getName()) && !exceptions.contains(Throwable.class.getName())) {
            exceptions.add(RuntimeException.class.getName());
        }
        CatchBlockCreator catchBlock = tryBlock.addCatch(ProcessingException.class);
        ResultHandle caughtException = catchBlock.getCaughtException();
        ResultHandle cause = catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"getCause", Throwable.class, (Class[])new Class[0]), caughtException, new ResultHandle[0]);
        for (String exception : exceptions) {
            catchBlock.ifTrue(catchBlock.instanceOf(cause, exception)).trueBranch().throwException(cause);
        }
        catchBlock.throwException(caughtException);
        if (bodyValue != null || formParams != null || multipartForm != null) {
            if (this.countNonNulls(bodyValue, formParams, multipartForm) > 1) {
                throw new IllegalArgumentException("Attempt to pass at least two of form, multipart form or regular entity as a request body in " + restClientInterface.name().toString() + "#" + jandexMethod.name());
            }
            if (consumes != null && consumes.length > 0) {
                if (consumes.length > 1) {
                    throw new IllegalArgumentException("Multiple `@Consumes` values used in a MicroProfile Rest Client: " + restClientInterface.name().toString() + " Unable to determine a single `Content-Type`.");
                }
                mediaTypeValue = consumes[0];
            }
            ResultHandle mediaType = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(MediaType.class, (String)"valueOf", MediaType.class, (Class[])new Class[]{String.class}), new ResultHandle[]{tryBlock.load(mediaTypeValue)});
            ResultHandle entity = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Entity.class, (String)"entity", Entity.class, (Class[])new Class[]{Object.class, MediaType.class}), new ResultHandle[]{bodyValue != null ? bodyValue : (formParams != null ? formParams : multipartForm), mediaType});
            if (returnCategory == ReturnCategory.COMPLETION_STAGE) {
                ResultHandle async = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"async", AsyncInvoker.class, (Class[])new Class[0]), (ResultHandle)builder, new ResultHandle[0]);
                result = genericReturnType != null ? tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStageRxInvoker.class, (String)"method", CompletionStage.class, (Class[])new Class[]{String.class, Entity.class, GenericType.class}), async, new ResultHandle[]{tryBlock.load(httpMethod), entity, genericReturnType}) : tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStageRxInvoker.class, (String)"method", CompletionStage.class, (Class[])new Class[]{String.class, Entity.class, Class.class}), async, new ResultHandle[]{tryBlock.load(httpMethod), entity, tryBlock.loadClass(simpleReturnType)});
            } else if (returnCategory == ReturnCategory.UNI || returnCategory == ReturnCategory.COROUTINE) {
                ResultHandle rx2 = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"rx", RxInvoker.class, (Class[])new Class[]{Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.loadClass(UniInvoker.class)});
                ResultHandle uniInvoker = tryBlock.checkCast(rx2, UniInvoker.class);
                result = genericReturnType != null ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniInvoker.class, (String)"method", Uni.class, (Class[])new Class[]{String.class, Entity.class, GenericType.class}), uniInvoker, new ResultHandle[]{tryBlock.load(httpMethod), entity, genericReturnType}) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniInvoker.class, (String)"method", Uni.class, (Class[])new Class[]{String.class, Entity.class, Class.class}), uniInvoker, new ResultHandle[]{tryBlock.load(httpMethod), entity, tryBlock.loadClass(simpleReturnType)});
                if (returnCategory == ReturnCategory.COROUTINE) {
                    result = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod((Object)UNI_KT.toString(), (String)"awaitSuspending", Object.class, (Object[])new Object[]{Uni.class, CONTINUATION.toString()}), new ResultHandle[]{result, tryBlock.getMethodParam(continuationIndex.intValue())});
                }
            } else if (returnCategory == ReturnCategory.MULTI) {
                ResultHandle rx3 = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"rx", RxInvoker.class, (Class[])new Class[]{Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.loadClass(MultiInvoker.class)});
                ResultHandle multiInvoker = tryBlock.checkCast(rx3, MultiInvoker.class);
                result = genericReturnType != null ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(MultiInvoker.class, (String)"method", Multi.class, (Class[])new Class[]{String.class, Entity.class, GenericType.class}), multiInvoker, new ResultHandle[]{tryBlock.load(httpMethod), entity, genericReturnType}) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractRxInvoker.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Entity.class, Class.class}), multiInvoker, new ResultHandle[]{tryBlock.load(httpMethod), entity, tryBlock.loadClass(simpleReturnType)});
            } else {
                result = genericReturnType != null ? tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Entity.class, GenericType.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.load(httpMethod), entity, genericReturnType}) : tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Entity.class, Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.load(httpMethod), entity, tryBlock.loadClass(simpleReturnType)});
            }
        } else if (returnCategory == ReturnCategory.COMPLETION_STAGE) {
            ResultHandle async = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"async", AsyncInvoker.class, (Class[])new Class[0]), (ResultHandle)builder, new ResultHandle[0]);
            result = genericReturnType != null ? tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStageRxInvoker.class, (String)"method", CompletionStage.class, (Class[])new Class[]{String.class, GenericType.class}), async, new ResultHandle[]{tryBlock.load(httpMethod), genericReturnType}) : tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStageRxInvoker.class, (String)"method", CompletionStage.class, (Class[])new Class[]{String.class, Class.class}), async, new ResultHandle[]{tryBlock.load(httpMethod), tryBlock.loadClass(simpleReturnType)});
        } else if (returnCategory == ReturnCategory.UNI || returnCategory == ReturnCategory.COROUTINE) {
            rx = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"rx", RxInvoker.class, (Class[])new Class[]{Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.loadClass(UniInvoker.class)});
            ResultHandle uniInvoker = tryBlock.checkCast(rx, UniInvoker.class);
            result = genericReturnType != null ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniInvoker.class, (String)"method", Uni.class, (Class[])new Class[]{String.class, GenericType.class}), uniInvoker, new ResultHandle[]{tryBlock.load(httpMethod), genericReturnType}) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniInvoker.class, (String)"method", Uni.class, (Class[])new Class[]{String.class, Class.class}), uniInvoker, new ResultHandle[]{tryBlock.load(httpMethod), tryBlock.loadClass(simpleReturnType)});
            if (returnCategory == ReturnCategory.COROUTINE) {
                result = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod((Object)UNI_KT.toString(), (String)"awaitSuspending", Object.class, (Object[])new Object[]{Uni.class, CONTINUATION.toString()}), new ResultHandle[]{result, tryBlock.getMethodParam(continuationIndex.intValue())});
            }
        } else if (returnCategory == ReturnCategory.MULTI) {
            rx = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"rx", RxInvoker.class, (Class[])new Class[]{Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.loadClass(MultiInvoker.class)});
            ResultHandle multiInvoker = tryBlock.checkCast(rx, MultiInvoker.class);
            result = genericReturnType != null ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractRxInvoker.class, (String)"method", Object.class, (Class[])new Class[]{String.class, GenericType.class}), multiInvoker, new ResultHandle[]{tryBlock.load(httpMethod), genericReturnType}) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractRxInvoker.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Class.class}), multiInvoker, new ResultHandle[]{tryBlock.load(httpMethod), tryBlock.loadClass(simpleReturnType)});
        } else {
            result = genericReturnType != null ? tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"method", Object.class, (Class[])new Class[]{String.class, GenericType.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.load(httpMethod), genericReturnType}) : tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.load(httpMethod), tryBlock.loadClass(simpleReturnType)});
        }
        tryBlock.returnValue(result);
    }

    private int countNonNulls(Object ... objects) {
        int result = 0;
        for (Object object : objects) {
            if (object == null) continue;
            ++result;
        }
        return result;
    }

    private ResultHandle createGenericTypeFromParameterizedType(MethodCreator methodCreator, ParameterizedType parameterizedType2) {
        ResultHandle currentThread = methodCreator.invokeStaticMethod(MethodDescriptors.THREAD_CURRENT_THREAD, new ResultHandle[0]);
        ResultHandle tccl = methodCreator.invokeVirtualMethod(MethodDescriptors.THREAD_GET_TCCL, currentThread, new ResultHandle[0]);
        ResultHandle parameterizedType = Types.getParameterizedType((BytecodeCreator)methodCreator, (ResultHandle)tccl, (ParameterizedType)parameterizedType2);
        ResultHandle genericReturnType = methodCreator.newInstance(MethodDescriptor.ofConstructor(GenericType.class, (Class[])new Class[]{Type.class}), new ResultHandle[]{parameterizedType});
        return genericReturnType;
    }

    private AssignableResultHandle createWebTargetForMethod(MethodCreator constructor, AssignableResultHandle baseTarget, ResourceMethod method) {
        AssignableResultHandle target = constructor.createVariable(WebTarget.class);
        constructor.assign(target, (ResultHandle)baseTarget);
        if (method.getPath() != null) {
            this.appendPath(constructor, method.getPath(), target);
        }
        return target;
    }

    private void appendPath(MethodCreator constructor, String pathPart, AssignableResultHandle target) {
        AssignableResultHandle path = constructor.createVariable(String.class);
        constructor.assign(path, constructor.load(pathPart));
        constructor.assign(target, constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"path", WebTarget.class, (Class[])new Class[]{String.class}), (ResultHandle)target, new ResultHandle[]{path}));
    }

    private Optional<MethodInfo> getJavaMethod(ClassInfo interfaceClass, ResourceMethod method, MethodParameter[] parameters, IndexView index) {
        DotName interfaceName;
        for (MethodInfo methodInfo : interfaceClass.methods()) {
            if (!methodInfo.name().equals(method.getName()) || methodInfo.parameters().size() != parameters.length) continue;
            boolean matches = true;
            for (int i = 0; i < parameters.length; ++i) {
                String declaredType;
                MethodParameter actualParam = parameters[i];
                org.jboss.jandex.Type parameterType = (org.jboss.jandex.Type)methodInfo.parameters().get(i);
                String string = declaredType = actualParam.declaredType != null ? actualParam.declaredType : actualParam.type;
                if (declaredType.equals(parameterType.name().toString())) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return Optional.of(methodInfo);
        }
        Optional<MethodInfo> maybeMethod = Optional.empty();
        Iterator iterator = interfaceClass.interfaceNames().iterator();
        while (iterator.hasNext() && !(maybeMethod = this.getJavaMethod(index.getClassByName(interfaceName = (DotName)iterator.next()), method, parameters, index)).isPresent()) {
        }
        return maybeMethod;
    }

    private void addBeanParamData(BytecodeCreator methodCreator, BytecodeCreator invocationBuilderEnricher, AssignableResultHandle invocationBuilder, List<Item> beanParamItems, ResultHandle param, AssignableResultHandle target, IndexView index) {
        BytecodeCreator creator = methodCreator.ifNotNull(param).trueBranch();
        BytecodeCreator invoEnricher = invocationBuilderEnricher.ifNotNull(invocationBuilderEnricher.getMethodParam(1)).trueBranch();
        block7: for (Item item : beanParamItems) {
            switch (item.type()) {
                case BEAN_PARAM: {
                    BeanParamItem beanParamItem = (BeanParamItem)item;
                    ResultHandle beanParamElementHandle = beanParamItem.extract(creator, param);
                    this.addBeanParamData(creator, invoEnricher, invocationBuilder, beanParamItem.items(), beanParamElementHandle, target, index);
                    continue block7;
                }
                case QUERY_PARAM: {
                    QueryParamItem queryParam = (QueryParamItem)item;
                    creator.assign(target, this.addQueryParam(creator, (ResultHandle)target, queryParam.name(), queryParam.extract(creator, param), queryParam.getValueType(), index));
                    continue block7;
                }
                case COOKIE: {
                    CookieParamItem cookieParam = (CookieParamItem)item;
                    this.addCookieParam(invoEnricher, invocationBuilder, cookieParam.getCookieName(), cookieParam.extract(invoEnricher, invoEnricher.getMethodParam(1)));
                    continue block7;
                }
                case HEADER_PARAM: {
                    HeaderParamItem headerParam = (HeaderParamItem)item;
                    this.addHeaderParam(invoEnricher, invocationBuilder, headerParam.getHeaderName(), headerParam.extract(invoEnricher, invoEnricher.getMethodParam(1)));
                    continue block7;
                }
                case PATH_PARAM: {
                    PathParamItem pathParam = (PathParamItem)item;
                    this.addPathParam(creator, target, pathParam.getPathParamName(), pathParam.extract(creator, param));
                    continue block7;
                }
            }
            throw new IllegalStateException("Unimplemented");
        }
    }

    private ResultHandle addQueryParam(BytecodeCreator methodCreator, ResultHandle target, String paramName, ResultHandle queryParamHandle, org.jboss.jandex.Type type, IndexView index) {
        ResultHandle paramArray = type.kind() == Type.Kind.ARRAY ? methodCreator.checkCast(queryParamHandle, Object[].class) : (this.isCollection(type, index) ? methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(ToObjectArray.class, (String)"collection", Object[].class, (Class[])new Class[]{Collection.class}), new ResultHandle[]{queryParamHandle}) : methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(ToObjectArray.class, (String)"value", Object[].class, (Class[])new Class[]{Object.class}), new ResultHandle[]{queryParamHandle}));
        return methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"queryParam", WebTarget.class, (Class[])new Class[]{String.class, Object[].class}), target, new ResultHandle[]{methodCreator.load(paramName), paramArray});
    }

    private boolean isCollection(org.jboss.jandex.Type type, IndexView index) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return false;
        }
        ClassInfo classInfo = index.getClassByName(type.name());
        if (classInfo == null) {
            return false;
        }
        return classInfo.interfaceNames().stream().anyMatch(arg_0 -> ((DotName)DotName.createSimple((String)Collection.class.getName())).equals(arg_0));
    }

    private void addHeaderParam(BytecodeCreator invoBuilderEnricher, AssignableResultHandle invocationBuilder, String paramName, ResultHandle headerParamHandle) {
        invoBuilderEnricher.assign(invocationBuilder, invoBuilderEnricher.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"header", Invocation.Builder.class, (Class[])new Class[]{String.class, Object.class}), (ResultHandle)invocationBuilder, new ResultHandle[]{invoBuilderEnricher.load(paramName), headerParamHandle}));
    }

    private void addPathParam(BytecodeCreator methodCreator, AssignableResultHandle methodTarget, String paramName, ResultHandle pathParamHandle) {
        methodCreator.assign(methodTarget, methodCreator.invokeInterfaceMethod(WEB_TARGET_RESOLVE_TEMPLATE_METHOD, (ResultHandle)methodTarget, new ResultHandle[]{methodCreator.load(paramName), pathParamHandle}));
    }

    private void addCookieParam(BytecodeCreator invoBuilderEnricher, AssignableResultHandle invocationBuilder, String paramName, ResultHandle cookieParamHandle) {
        invoBuilderEnricher.assign(invocationBuilder, invoBuilderEnricher.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"cookie", Invocation.Builder.class, (Class[])new Class[]{String.class, String.class}), (ResultHandle)invocationBuilder, new ResultHandle[]{invoBuilderEnricher.load(paramName), cookieParamHandle}));
    }

    private static enum ReturnCategory {
        BLOCKING,
        COMPLETION_STAGE,
        UNI,
        MULTI,
        COROUTINE;

    }
}

