/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxrs.client.reactive.deployment;

import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;

class ClassRestClientContext
implements AutoCloseable {
    public final ClassCreator classCreator;
    public final MethodCreator constructor;
    public final MethodCreator clinit;
    public final Map<Integer, FieldDescriptor> methodStaticFields = new HashMap<Integer, FieldDescriptor>();
    public final Map<Integer, FieldDescriptor> methodParamAnnotationsStaticFields = new HashMap<Integer, FieldDescriptor>();
    public final Map<Integer, FieldDescriptor> methodGenericParametersStaticFields = new HashMap<Integer, FieldDescriptor>();

    public ClassRestClientContext(String name, BuildProducer<GeneratedClassBuildItem> generatedClasses, String ... interfaces) {
        this(name, MethodDescriptor.ofConstructor((String)name, (String[])new String[0]), generatedClasses, Object.class, interfaces);
    }

    public ClassRestClientContext(String name, MethodDescriptor constructorDesc, BuildProducer<GeneratedClassBuildItem> generatedClasses, Class<?> superClass, String ... interfaces) {
        this.classCreator = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true), name, null, superClass.getName(), interfaces);
        this.constructor = this.classCreator.getMethodCreator(constructorDesc);
        this.clinit = this.classCreator.getMethodCreator(MethodDescriptor.ofMethod((Object)name, (String)"<clinit>", Void.TYPE, (Object[])new Object[0]));
        this.clinit.setModifiers(8);
    }

    @Override
    public void close() {
        this.classCreator.close();
    }

    protected FieldDescriptor createJavaMethodField(ClassInfo interfaceClass, MethodInfo method, int methodIndex) {
        ResultHandle interfaceClassHandle = this.clinit.loadClassFromTCCL(interfaceClass.toString());
        ResultHandle parameterArray = this.clinit.newArray(Class.class, method.parameters().size());
        for (int i = 0; i < method.parameters().size(); ++i) {
            String parameterClass = ((org.jboss.jandex.Type)method.parameters().get(i)).name().toString();
            this.clinit.writeArrayValue(parameterArray, i, this.clinit.loadClassFromTCCL(parameterClass));
        }
        ResultHandle javaMethodHandle = this.clinit.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), interfaceClassHandle, new ResultHandle[]{this.clinit.load(method.name()), parameterArray});
        FieldDescriptor javaMethodField = FieldDescriptor.of((String)this.classCreator.getClassName(), (String)("javaMethod" + methodIndex), Method.class);
        this.classCreator.getFieldCreator(javaMethodField).setModifiers(26);
        this.clinit.writeStaticField(javaMethodField, javaMethodHandle);
        this.methodStaticFields.put(methodIndex, javaMethodField);
        return javaMethodField;
    }

    protected Supplier<FieldDescriptor> getLazyJavaMethodParamAnnotationsField(int methodIndex) {
        return () -> {
            FieldDescriptor methodParamAnnotationsField = this.methodParamAnnotationsStaticFields.get(methodIndex);
            if (methodParamAnnotationsField != null) {
                return methodParamAnnotationsField;
            }
            ResultHandle javaMethodParamAnnotationsHandle = this.clinit.invokeVirtualMethod(MethodDescriptor.ofMethod(Method.class, (String)"getParameterAnnotations", Annotation[][].class, (Class[])new Class[0]), this.clinit.readStaticField(this.methodStaticFields.get(methodIndex)), new ResultHandle[0]);
            FieldDescriptor javaMethodParamAnnotationsField = FieldDescriptor.of((String)this.classCreator.getClassName(), (String)("javaMethodParameterAnnotations" + methodIndex), Annotation[][].class);
            this.classCreator.getFieldCreator(javaMethodParamAnnotationsField).setModifiers(25);
            this.clinit.writeStaticField(javaMethodParamAnnotationsField, javaMethodParamAnnotationsHandle);
            this.methodParamAnnotationsStaticFields.put(methodIndex, javaMethodParamAnnotationsField);
            return javaMethodParamAnnotationsField;
        };
    }

    protected Supplier<FieldDescriptor> getLazyJavaMethodGenericParametersField(int methodIndex) {
        return () -> {
            FieldDescriptor methodGenericTypeField = this.methodGenericParametersStaticFields.get(methodIndex);
            if (methodGenericTypeField != null) {
                return methodGenericTypeField;
            }
            ResultHandle javaMethodGenericParametersHandle = this.clinit.invokeVirtualMethod(MethodDescriptor.ofMethod(Method.class, (String)"getGenericParameterTypes", Type[].class, (Class[])new Class[0]), this.clinit.readStaticField(this.methodStaticFields.get(methodIndex)), new ResultHandle[0]);
            FieldDescriptor javaMethodGenericParametersField = FieldDescriptor.of((String)this.classCreator.getClassName(), (String)("javaMethodGenericParameters" + methodIndex), Type[].class);
            this.classCreator.getFieldCreator(javaMethodGenericParametersField).setModifiers(25);
            this.clinit.writeStaticField(javaMethodGenericParametersField, javaMethodGenericParametersHandle);
            this.methodGenericParametersStaticFields.put(methodIndex, javaMethodGenericParametersField);
            return javaMethodGenericParametersField;
        };
    }
}

