/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxrs.client.reactive.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.Types;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.jaxrs.client.reactive.deployment.ClassRestClientContext;
import io.quarkus.jaxrs.client.reactive.deployment.JaxrsClientReactiveEnricherBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.MediaTypeWithPriority;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDefaultConsumesBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDefaultProducesBuildItem;
import io.quarkus.jaxrs.client.reactive.deployment.RestClientDisableSmartDefaultProduces;
import io.quarkus.jaxrs.client.reactive.runtime.ClientResponseBuilderFactory;
import io.quarkus.jaxrs.client.reactive.runtime.JaxrsClientReactiveRecorder;
import io.quarkus.jaxrs.client.reactive.runtime.ParameterDescriptorFromClassSupplier;
import io.quarkus.jaxrs.client.reactive.runtime.RestClientBase;
import io.quarkus.jaxrs.client.reactive.runtime.ToObjectArray;
import io.quarkus.jaxrs.client.reactive.runtime.impl.MultipartResponseDataBase;
import io.quarkus.resteasy.reactive.common.deployment.ApplicationResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ParameterContainersBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusFactoryCreator;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusResteasyReactiveDotNames;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.SerializersUtil;
import io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveCommonRecorder;
import io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveConfig;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderOverrideBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterOverrideBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.buffer.Buffer;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.AsyncInvoker;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.CompletionStageRxInvoker;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.RxInvoker;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.handlers.ClientObservabilityHandler;
import org.jboss.resteasy.reactive.client.impl.AbstractRxInvoker;
import org.jboss.resteasy.reactive.client.impl.AsyncInvokerImpl;
import org.jboss.resteasy.reactive.client.impl.ClientBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.MultiInvoker;
import org.jboss.resteasy.reactive.client.impl.StorkClientRequestFilter;
import org.jboss.resteasy.reactive.client.impl.UniInvoker;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartForm;
import org.jboss.resteasy.reactive.client.processor.beanparam.BeanParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.ClientBeanParamInfo;
import org.jboss.resteasy.reactive.client.processor.beanparam.CookieParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.FormParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.HeaderParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.Item;
import org.jboss.resteasy.reactive.client.processor.beanparam.PathParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.QueryParamItem;
import org.jboss.resteasy.reactive.client.processor.scanning.ClientEndpointIndexer;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.client.spi.FieldFiller;
import org.jboss.resteasy.reactive.client.spi.MultipartResponseData;
import org.jboss.resteasy.reactive.common.core.GenericTypeMapping;
import org.jboss.resteasy.reactive.common.core.ResponseBuilderFactory;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.jaxrs.UriBuilderImpl;
import org.jboss.resteasy.reactive.common.model.MaybeRestClientInterface;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.common.model.RestClientInterface;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaderWriter;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.HashUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;
import org.jboss.resteasy.reactive.multipart.FileDownload;

public class JaxrsClientReactiveProcessor {
    private static final String MULTI_BYTE_SIGNATURE = "L" + Multi.class.getName().replace('.', '/') + "<Ljava/lang/Byte;>;";
    private static final String FILE_SIGNATURE = "L" + File.class.getName().replace('.', '/') + ";";
    private static final String PATH_SIGNATURE = "L" + Path.class.getName().replace('.', '/') + ";";
    private static final String BUFFER_SIGNATURE = "L" + Buffer.class.getName().replace('.', '/') + ";";
    private static final String BYTE_ARRAY_SIGNATURE = "[B";
    private static final Logger log = Logger.getLogger(JaxrsClientReactiveProcessor.class);
    private static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");
    private static final MethodDescriptor WEB_TARGET_RESOLVE_TEMPLATE_METHOD = MethodDescriptor.ofMethod(WebTarget.class, (String)"resolveTemplate", WebTarget.class, (Class[])new Class[]{String.class, Object.class});
    private static final MethodDescriptor MULTIVALUED_MAP_ADD = MethodDescriptor.ofMethod(MultivaluedMap.class, (String)"add", Void.TYPE, (Class[])new Class[]{Object.class, Object.class});
    private static final MethodDescriptor PATH_GET_FILENAME = MethodDescriptor.ofMethod(Path.class, (String)"getFileName", Path.class, (Class[])new Class[0]);
    private static final MethodDescriptor OBJECT_TO_STRING = MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]);
    static final DotName CONTINUATION = DotName.createSimple((String)"kotlin.coroutines.Continuation");
    private static final DotName UNI_KT = DotName.createSimple((String)"io.smallrye.mutiny.coroutines.UniKt");
    private static final DotName FILE = DotName.createSimple((String)File.class.getName());
    private static final DotName PATH = DotName.createSimple((String)Path.class.getName());
    private static final DotName BUFFER = DotName.createSimple((String)Buffer.class.getName());
    private static final DotName NOT_BODY = DotName.createSimple((String)"io.quarkus.rest.client.reactive.NotBody");
    private static final Set<DotName> ASYNC_RETURN_TYPES = Set.of(ResteasyReactiveDotNames.COMPLETION_STAGE, ResteasyReactiveDotNames.UNI, ResteasyReactiveDotNames.MULTI, ResteasyReactiveDotNames.REST_MULTI);
    public static final DotName BYTE = DotName.createSimple((String)Byte.class.getName());
    public static final MethodDescriptor MULTIPART_RESPONSE_DATA_ADD_FILLER = MethodDescriptor.ofMethod(MultipartResponseDataBase.class, (String)"addFiller", Void.TYPE, (Class[])new Class[]{FieldFiller.class});
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";

    @BuildStep
    void registerClientResponseBuilder(BuildProducer<ServiceProviderBuildItem> serviceProviders) {
        serviceProviders.produce((BuildItem)new ServiceProviderBuildItem(ResponseBuilderFactory.class.getName(), new String[]{ClientResponseBuilderFactory.class.getName()}));
        serviceProviders.produce((BuildItem)new ServiceProviderBuildItem(ClientBuilder.class.getName(), new String[]{ClientBuilderImpl.class.getName()}));
    }

    @BuildStep
    void initializeRuntimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses) {
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(AsyncInvokerImpl.class.getName()));
    }

    @BuildStep
    void initializeStorkFilter(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClassesBuildItem) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(StorkClientRequestFilter.class));
        additionalIndexedClassesBuildItem.produce((BuildItem)new AdditionalIndexedClassesBuildItem(StorkClientRequestFilter.class.getName()));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{StorkClientRequestFilter.class}).methods().fields().build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupClientProxies(JaxrsClientReactiveRecorder recorder, BeanContainerBuildItem beanContainerBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, final BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyBuildItemBuildProducer, List<MessageBodyReaderBuildItem> messageBodyReaderBuildItems, List<MessageBodyWriterBuildItem> messageBodyWriterBuildItems, List<MessageBodyReaderOverrideBuildItem> messageBodyReaderOverrideBuildItems, List<MessageBodyWriterOverrideBuildItem> messageBodyWriterOverrideBuildItems, List<JaxrsClientReactiveEnricherBuildItem> enricherBuildItems, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, ApplicationIndexBuildItem applicationIndexBuildItem, Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability, ResteasyReactiveConfig config, RecorderContext recorderContext, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerBuildItemBuildProducer, List<RestClientDefaultProducesBuildItem> defaultConsumes, List<RestClientDefaultConsumesBuildItem> defaultProduces, List<RestClientDisableSmartDefaultProduces> disableSmartDefaultProduces, List<ParameterContainersBuildItem> parameterContainersBuildItems) {
        String defaultConsumesType = this.defaultMediaType(defaultConsumes, "application/octet-stream");
        String defaultProducesType = this.defaultMediaType(defaultProduces, "text/plain");
        Serialisers serialisers = recorder.createSerializers();
        SerializersUtil.setupSerializers((ResteasyReactiveCommonRecorder)recorder, reflectiveClassBuildItemBuildProducer, messageBodyReaderBuildItems, messageBodyWriterBuildItems, messageBodyReaderOverrideBuildItems, messageBodyWriterOverrideBuildItems, (BeanContainerBuildItem)beanContainerBuildItem, (ApplicationResultBuildItem)applicationResultBuildItem, (Serialisers)serialisers, (RuntimeType)RuntimeType.CLIENT);
        HashSet scannedParameterContainers = new HashSet();
        for (ParameterContainersBuildItem parameterContainersBuildItem : parameterContainersBuildItems) {
            scannedParameterContainers.addAll(parameterContainersBuildItem.getClassNames());
        }
        reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])scannedParameterContainers.stream().map(name -> name.toString()).collect(Collectors.toSet()).toArray(new String[0])).fields().build());
        if (resourceScanningResultBuildItem.isEmpty() || resourceScanningResultBuildItem.get().getResult().getClientInterfaces().isEmpty()) {
            recorder.setupClientProxies(new HashMap(), Collections.emptyMap());
            return;
        }
        ResourceScanningResult result = resourceScanningResultBuildItem.get().getResult();
        AdditionalReaders additionalReaders = new AdditionalReaders();
        AdditionalWriters additionalWriters = new AdditionalWriters();
        final IndexView index = beanArchiveIndexBuildItem.getIndex();
        ClientEndpointIndexer clientEndpointIndexer = ((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)((ClientEndpointIndexer.Builder)new ClientEndpointIndexer.Builder().setIndex(index)).setApplicationIndex((IndexView)applicationIndexBuildItem.getIndex())).setExistingConverters(new HashMap())).addParameterContainerTypes(scannedParameterContainers)).setScannedResourcePaths(result.getScannedResourcePaths())).setConfig(this.createRestReactiveConfig(config))).setAdditionalReaders(additionalReaders)).setHttpAnnotationToMethod(result.getHttpAnnotationToMethod())).setInjectableBeans(new HashMap())).setFactoryCreator((Function)new QuarkusFactoryCreator((ResteasyReactiveCommonRecorder)recorder, beanContainerBuildItem.getValue()))).setAdditionalWriters(additionalWriters)).setDefaultBlocking(applicationResultBuildItem.getResult().getBlockingDefault())).setHasRuntimeConverters(false)).setDefaultProduces(defaultProducesType).setSmartDefaultProduces(disableSmartDefaultProduces.isEmpty()).setSkipMethodParameter((Predicate)new Predicate<Map<DotName, AnnotationInstance>>(){

            @Override
            public boolean test(Map<DotName, AnnotationInstance> anns) {
                return anns.containsKey(NOT_BODY);
            }
        })).setResourceMethodCallback((Consumer)new Consumer<EndpointIndexer.ResourceMethodCallbackEntry>(){

            @Override
            public void accept(EndpointIndexer.ResourceMethodCallbackEntry entry) {
                MethodInfo method = entry.getMethodInfo();
                String source = JaxrsClientReactiveProcessor.class.getSimpleName() + " > " + method.declaringClass() + "[" + method + "]";
                reflectiveHierarchyBuildItemBuildProducer.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(method.returnType()).index(index).ignoreTypePredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
                ResourceMethod resourceMethod = entry.getResourceMethod();
                MethodParameter[] methodParameters = resourceMethod.getParameters();
                if (methodParameters != null) {
                    for (int i = 0; i < methodParameters.length; ++i) {
                        MethodParameter methodParameter = methodParameters[i];
                        if (methodParameter.getParameterType() != ParameterType.BODY) continue;
                        reflectiveHierarchyBuildItemBuildProducer.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(method.parameterType(i)).index(index).ignoreTypePredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
                    }
                }
            }
        })).build();
        boolean observabilityIntegrationNeeded = capabilities.isPresent("io.quarkus.opentelemetry.tracer") || metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer");
        HashMap clientImplementations = new HashMap();
        HashMap<String, String> failures = new HashMap<String, String>();
        HashSet<ClassInfo> multipartResponseTypes = new HashSet<ClassInfo>();
        for (AnnotationInstance annotationInstance : index.getAnnotations(ResteasyReactiveDotNames.MULTI_PART_FORM_PARAM)) {
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            multipartResponseTypes.add(annotationInstance.target().asClass());
        }
        for (Map.Entry entry : result.getClientInterfaces().entrySet()) {
            ClassInfo clazz = index.getClassByName((DotName)entry.getKey());
            MaybeRestClientInterface maybeClientProxy = clientEndpointIndexer.createClientProxy(clazz, (String)entry.getValue());
            if (maybeClientProxy.exists()) {
                RestClientInterface clientProxy = maybeClientProxy.getRestClientInterface();
                try {
                    RuntimeValue<BiFunction<WebTarget, List<ParamConverterProvider>, ?>> proxyProvider = this.generateClientInvoker(recorderContext, clientProxy, enricherBuildItems, generatedClassBuildItemBuildProducer, clazz, index, defaultConsumesType, result.getHttpAnnotationToMethod(), observabilityIntegrationNeeded, multipartResponseTypes);
                    if (proxyProvider == null) continue;
                    clientImplementations.put(clientProxy.getClassName(), proxyProvider);
                }
                catch (Exception any) {
                    log.debugv((Throwable)any, "Failed to create client proxy for {0} this can usually be safely ignored", (Object)clazz.name());
                    failures.put(clazz.name().toString(), any.getMessage());
                }
                continue;
            }
            failures.put(clazz.name().toString(), maybeClientProxy.getFailure());
        }
        recorder.setupClientProxies(clientImplementations, failures);
        for (AdditionalReaderWriter.Entry entry : additionalReaders.get()) {
            String readerClass = entry.getHandlerClass();
            ResourceReader reader = new ResourceReader();
            reader.setBuiltin(true);
            reader.setFactory(recorder.factory(readerClass, beanContainerBuildItem.getValue()));
            reader.setMediaTypeStrings(Collections.singletonList(entry.getMediaType()));
            recorder.registerReader(serialisers, entry.getEntityClass(), reader);
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{readerClass}).build());
        }
        for (AdditionalReaderWriter.Entry entry : additionalWriters.get()) {
            String writerClass = entry.getHandlerClass();
            ResourceWriter writer = new ResourceWriter();
            writer.setBuiltin(true);
            writer.setFactory(recorder.factory(writerClass, beanContainerBuildItem.getValue()));
            writer.setMediaTypeStrings(Collections.singletonList(entry.getMediaType()));
            recorder.registerWriter(serialisers, entry.getEntityClass(), writer);
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{writerClass}).build());
        }
        HashMap<String, RuntimeValue<MultipartResponseData>> responsesData = new HashMap<String, RuntimeValue<MultipartResponseData>>();
        for (ClassInfo multipartResponseType : multipartResponseTypes) {
            responsesData.put(multipartResponseType.toString(), this.createMultipartResponseData(multipartResponseType, generatedClassBuildItemBuildProducer, recorderContext));
        }
        recorder.setMultipartResponsesData(responsesData);
    }

    private RuntimeValue<MultipartResponseData> createMultipartResponseData(ClassInfo multipartResponseTypeInfo, BuildProducer<GeneratedClassBuildItem> generatedClasses, RecorderContext context) {
        String multipartResponseType = multipartResponseTypeInfo.toString();
        String dataClassName = multipartResponseType + "$$MultipartData";
        try (ClassCreator c = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true), dataClassName, null, MultipartResponseDataBase.class.getName(), new String[0]);){
            MethodCreator newInstance = c.getMethodCreator("newInstance", Object.class, new Class[0]);
            newInstance.returnValue(newInstance.newInstance(MethodDescriptor.ofConstructor((String)multipartResponseType, (String[])new String[0]), new ResultHandle[0]));
            MethodCreator constructor = c.getMethodCreator(MethodDescriptor.ofConstructor((String)multipartResponseType, (String[])new String[0]));
            constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(MultipartResponseDataBase.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
            HashMap<String, AnnotationInstance> nonPublicPartTypeFields = new HashMap<String, AnnotationInstance>();
            for (FieldInfo field : multipartResponseTypeInfo.fields()) {
                AnnotationInstance partType = field.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME);
                if (partType == null) {
                    log.debugf("Skipping field %s.%s from multipart mapping because it is not annotated with @PartType", (Object)multipartResponseType, (Object)field.name());
                    continue;
                }
                if (!Modifier.isPublic(field.flags())) {
                    nonPublicPartTypeFields.put(field.name(), partType);
                    continue;
                }
                String partName = this.extractPartName(partType.target(), field.name());
                String fillerName = this.createFieldFillerForField(partType, field, partName, generatedClasses, dataClassName);
                constructor.invokeVirtualMethod(MULTIPART_RESPONSE_DATA_ADD_FILLER, constructor.getThis(), new ResultHandle[]{constructor.newInstance(MethodDescriptor.ofConstructor((String)fillerName, (String[])new String[0]), new ResultHandle[0])});
            }
            for (MethodInfo method : multipartResponseTypeInfo.methods()) {
                String methodName = method.name();
                if (!methodName.startsWith("set") || method.parametersCount() != 1) continue;
                String fieldName = this.setterToFieldName(methodName);
                AnnotationInstance partType = this.partTypeFromGetterOrSetter(method);
                if (partType != null || (partType = (AnnotationInstance)nonPublicPartTypeFields.get(fieldName)) != null) {
                    String partName = this.extractPartName(partType.target(), fieldName);
                    String fillerName = this.createFieldFillerForSetter(partType, method, partName, generatedClasses, dataClassName);
                    constructor.invokeVirtualMethod(MULTIPART_RESPONSE_DATA_ADD_FILLER, constructor.getThis(), new ResultHandle[]{constructor.newInstance(MethodDescriptor.ofConstructor((String)fillerName, (String[])new String[0]), new ResultHandle[0])});
                    continue;
                }
                log.debugf("Ignoring possible setter " + methodName + ", no part type annotation found", new Object[0]);
            }
            constructor.returnValue(null);
        }
        return context.newInstance(dataClassName);
    }

    private String extractPartName(AnnotationTarget target, String fieldName) {
        AnnotationInstance formParam;
        AnnotationInstance restForm;
        switch (target.kind()) {
            case FIELD: {
                restForm = target.asField().annotation(ResteasyReactiveDotNames.REST_FORM_PARAM);
                formParam = target.asField().annotation(ResteasyReactiveDotNames.FORM_PARAM);
                break;
            }
            case METHOD: {
                restForm = target.asMethod().annotation(ResteasyReactiveDotNames.REST_FORM_PARAM);
                formParam = target.asMethod().annotation(ResteasyReactiveDotNames.FORM_PARAM);
                break;
            }
            default: {
                throw new IllegalArgumentException("PartType annotation is only supported on fields and (setter/getter) methods for multipart responses, found one on " + target);
            }
        }
        return this.getAnnotationValueOrDefault(fieldName, restForm, formParam);
    }

    private String getAnnotationValueOrDefault(String fieldName, AnnotationInstance restForm, AnnotationInstance formParam) {
        if (restForm != null) {
            AnnotationValue restFormValue = restForm.value();
            return restFormValue == null ? fieldName : restFormValue.asString();
        }
        if (formParam != null) {
            return formParam.value().asString();
        }
        return fieldName;
    }

    private String createFieldFillerForSetter(AnnotationInstance partType, MethodInfo setter, String partName, BuildProducer<GeneratedClassBuildItem> generatedClasses, String dataClassName) {
        String fillerClassName = dataClassName + "$$" + setter.name();
        try (ClassCreator c = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true), fillerClassName, null, FieldFiller.class.getName(), new String[0]);){
            Type parameter = setter.parameterType(0);
            this.createFieldFillerConstructor(partType, parameter, partName, fillerClassName, c);
            MethodCreator set = c.getMethodCreator(MethodDescriptor.ofMethod((Object)fillerClassName, (String)"set", Void.TYPE, (Object[])new Object[]{Object.class, Object.class}));
            ResultHandle value = set.getMethodParam(1);
            value = this.performValueConversion(parameter, set, value);
            set.invokeVirtualMethod(setter, set.getMethodParam(0), new ResultHandle[]{value});
            set.returnValue(null);
        }
        return fillerClassName;
    }

    private ResultHandle performValueConversion(Type parameter, MethodCreator set, ResultHandle value) {
        if (parameter.kind() == Type.Kind.CLASS) {
            if (parameter.asClassType().name().equals((Object)FILE)) {
                value = set.invokeStaticMethod(MethodDescriptor.ofMethod(FieldFiller.class, (String)"fileDownloadToFile", File.class, (Class[])new Class[]{FileDownload.class}), new ResultHandle[]{value});
            } else if (parameter.asClassType().name().equals((Object)PATH)) {
                value = set.invokeStaticMethod(MethodDescriptor.ofMethod(FieldFiller.class, (String)"fileDownloadToPath", Path.class, (Class[])new Class[]{FileDownload.class}), new ResultHandle[]{value});
            }
        }
        return value;
    }

    private String createFieldFillerForField(AnnotationInstance partType, FieldInfo field, String partName, BuildProducer<GeneratedClassBuildItem> generatedClasses, String dataClassName) {
        String fillerClassName = dataClassName + "$$" + field.name();
        try (ClassCreator c = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true), fillerClassName, null, FieldFiller.class.getName(), new String[0]);){
            this.createFieldFillerConstructor(partType, field.type(), partName, fillerClassName, c);
            MethodCreator set = c.getMethodCreator(MethodDescriptor.ofMethod((Object)fillerClassName, (String)"set", Void.TYPE, (Object[])new Object[]{Object.class, Object.class}));
            ResultHandle value = set.getMethodParam(1);
            value = this.performValueConversion(field.type(), set, value);
            set.writeInstanceField(field, set.getMethodParam(0), value);
            set.returnValue(null);
        }
        return fillerClassName;
    }

    private void createFieldFillerConstructor(AnnotationInstance partType, Type type, String partName, String fillerClassName, ClassCreator c) {
        ResultHandle genericType;
        MethodCreator ctor = c.getMethodCreator(MethodDescriptor.ofConstructor((String)fillerClassName, (String[])new String[0]));
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            genericType = this.createGenericTypeFromParameterizedType(ctor, type.asParameterizedType());
        } else if (type.kind() == Type.Kind.CLASS) {
            genericType = ctor.newInstance(MethodDescriptor.ofConstructor(GenericType.class, (Class[])new Class[]{java.lang.reflect.Type.class}), new ResultHandle[]{ctor.loadClassFromTCCL(type.asClassType().name().toString())});
        } else if (type.kind() == Type.Kind.ARRAY) {
            genericType = ctor.newInstance(MethodDescriptor.ofConstructor(GenericType.class, (Class[])new Class[]{java.lang.reflect.Type.class}), new ResultHandle[]{ctor.loadClassFromTCCL(type.asArrayType().name().toString())});
        } else {
            if (type.kind() == Type.Kind.PRIMITIVE) {
                throw new IllegalArgumentException("Primitive types are not supported for multipart response mapping. Please use a wrapper class instead");
            }
            throw new IllegalArgumentException("Unsupported field type for multipart response mapping: " + type + ". Only classes, arrays and parameterized types are supported");
        }
        ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(FieldFiller.class, (Class[])new Class[]{GenericType.class, String.class, String.class}), ctor.getThis(), new ResultHandle[]{genericType, ctor.load(partName), ctor.load(partType.value().asString())});
        ctor.returnValue(null);
    }

    private AnnotationInstance partTypeFromGetterOrSetter(MethodInfo setter) {
        AnnotationInstance partTypeAnno = setter.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME);
        if (partTypeAnno != null) {
            return partTypeAnno;
        }
        String getterName = setter.name().replaceFirst("s", "g");
        MethodInfo getter = setter.declaringClass().method(getterName, new Type[0]);
        if (getter != null && null != (partTypeAnno = getter.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME))) {
            return partTypeAnno;
        }
        return null;
    }

    private String setterToFieldName(String methodName) {
        if (methodName.length() <= 3) {
            return "";
        }
        char[] nameArray = methodName.toCharArray();
        nameArray[3] = Character.toLowerCase(nameArray[3]);
        return new String(nameArray, 3, nameArray.length - 3);
    }

    private org.jboss.resteasy.reactive.common.ResteasyReactiveConfig createRestReactiveConfig(ResteasyReactiveConfig config) {
        Config mpConfig = ConfigProvider.getConfig();
        return new org.jboss.resteasy.reactive.common.ResteasyReactiveConfig(this.getEffectivePropertyValue("input-buffer-size", config.inputBufferSize().asLongValue(), Long.class, mpConfig).longValue(), this.getEffectivePropertyValue("min-chunk-size", config.minChunkSize(), Integer.class, mpConfig).intValue(), this.getEffectivePropertyValue("output-buffer-size", config.outputBufferSize(), Integer.class, mpConfig).intValue(), this.getEffectivePropertyValue("single-default-produces", config.singleDefaultProduces(), Boolean.class, mpConfig).booleanValue(), this.getEffectivePropertyValue("default-produces", config.defaultProduces(), Boolean.class, mpConfig).booleanValue());
    }

    private <T> T getEffectivePropertyValue(String legacyPropertyName, T newPropertyValue, Class<T> propertyType, Config mpConfig) {
        Optional legacyPropertyValue = mpConfig.getOptionalValue("quarkus.rest." + legacyPropertyName, propertyType);
        if (legacyPropertyValue.isPresent()) {
            return legacyPropertyValue.get();
        }
        return newPropertyValue;
    }

    private String defaultMediaType(List<? extends MediaTypeWithPriority> defaultMediaTypes, String defaultMediaType) {
        if (defaultMediaTypes == null || defaultMediaTypes.isEmpty()) {
            return defaultMediaType;
        }
        defaultMediaTypes.sort(Comparator.comparingInt(MediaTypeWithPriority::getPriority));
        return defaultMediaTypes.get(0).getMediaType();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void registerInvocationCallbacks(CombinedIndexBuildItem index, JaxrsClientReactiveRecorder recorder) {
        Collection invocationCallbacks = index.getComputingIndex().getAllKnownImplementors(ResteasyReactiveDotNames.INVOCATION_CALLBACK);
        GenericTypeMapping genericTypeMapping = new GenericTypeMapping();
        for (ClassInfo invocationCallback : invocationCallbacks) {
            try {
                List typeParameters = JandexUtil.resolveTypeParameters((DotName)invocationCallback.name(), (DotName)ResteasyReactiveDotNames.INVOCATION_CALLBACK, (IndexView)index.getComputingIndex());
                recorder.registerInvocationHandlerGenericType(genericTypeMapping, invocationCallback.name().toString(), ((Type)typeParameters.get(0)).name().toString());
            }
            catch (Exception exception) {}
        }
        recorder.setGenericTypeMapping(genericTypeMapping);
    }

    private RuntimeValue<BiFunction<WebTarget, List<ParamConverterProvider>, ?>> generateClientInvoker(RecorderContext recorderContext, RestClientInterface restClientInterface, List<JaxrsClientReactiveEnricherBuildItem> enrichers, BuildProducer<GeneratedClassBuildItem> generatedClasses, ClassInfo interfaceClass, IndexView index, String defaultMediaType, Map<DotName, String> httpAnnotationToMethod, boolean observabilityIntegrationNeeded, Set<ClassInfo> multipartResponseTypes) {
        String creatorName = restClientInterface.getClassName() + "$$QuarkusRestClientInterfaceCreator";
        String name = restClientInterface.getClassName() + "$$QuarkusRestClientInterface";
        MethodDescriptor constructorDesc = MethodDescriptor.ofConstructor((Object)name, (Object[])new Object[]{WebTarget.class.getName(), List.class});
        try (ClassRestClientContext classContext = new ClassRestClientContext(name, constructorDesc, generatedClasses, RestClientBase.class, Closeable.class.getName(), restClientInterface.getClassName());){
            classContext.constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(RestClientBase.class, (Class[])new Class[]{List.class}), classContext.constructor.getThis(), new ResultHandle[]{classContext.constructor.getMethodParam(1)});
            AssignableResultHandle baseTarget = classContext.constructor.createVariable(WebTargetImpl.class);
            if (restClientInterface.isEncoded()) {
                classContext.constructor.assign(baseTarget, this.disableEncodingForWebTarget((BytecodeCreator)classContext.constructor, classContext.constructor.getMethodParam(0)));
            } else {
                classContext.constructor.assign(baseTarget, classContext.constructor.getMethodParam(0));
            }
            classContext.constructor.assign(baseTarget, classContext.constructor.invokeVirtualMethod(MethodDescriptor.ofMethod(WebTargetImpl.class, (String)"path", WebTargetImpl.class, (Class[])new Class[]{String.class}), (ResultHandle)baseTarget, new ResultHandle[]{classContext.constructor.load(restClientInterface.getPath())}));
            FieldDescriptor baseTargetField = classContext.classCreator.getFieldCreator("baseTarget", WebTargetImpl.class.getName()).getFieldDescriptor();
            classContext.constructor.writeInstanceField(baseTargetField, classContext.constructor.getThis(), (ResultHandle)baseTarget);
            for (JaxrsClientReactiveEnricherBuildItem jaxrsClientReactiveEnricherBuildItem : enrichers) {
                jaxrsClientReactiveEnricherBuildItem.getEnricher().forClass(classContext.constructor, baseTarget, interfaceClass, index);
            }
            int methodIndex = 0;
            for (ResourceMethod method : restClientInterface.getMethods()) {
                ++methodIndex;
                String[] javaMethodParameters = new String[method.getParameters().length];
                for (int i = 0; i < method.getParameters().length; ++i) {
                    MethodParameter param = method.getParameters()[i];
                    javaMethodParameters[i] = param.declaredType != null ? param.declaredType : param.type;
                }
                MethodInfo jandexMethod = this.getJavaMethod(interfaceClass, method, method.getParameters(), index).orElseThrow(() -> new RuntimeException("Failed to find matching java method for " + method + " on " + interfaceClass + ". It may have unresolved parameter types (generics)"));
                if (!Modifier.isAbstract(jandexMethod.flags())) continue;
                if (method.getHttpMethod() == null) {
                    this.handleSubResourceMethod(enrichers, generatedClasses, interfaceClass, index, defaultMediaType, httpAnnotationToMethod, name, classContext, (ResultHandle)baseTarget, methodIndex, method, javaMethodParameters, jandexMethod, multipartResponseTypes, Collections.emptyList());
                    continue;
                }
                FieldDescriptor methodField = classContext.createJavaMethodField(interfaceClass, jandexMethod, methodIndex);
                Supplier<FieldDescriptor> methodParamAnnotationsField = classContext.getLazyJavaMethodParamAnnotationsField(methodIndex);
                Supplier<FieldDescriptor> methodGenericParametersField = classContext.getLazyJavaMethodGenericParametersField(methodIndex);
                this.addResponseTypeIfMultipart(multipartResponseTypes, jandexMethod, index);
                FieldDescriptor webTargetForMethod = FieldDescriptor.of((String)name, (String)("target" + methodIndex), WebTargetImpl.class);
                classContext.classCreator.getFieldCreator(webTargetForMethod).setModifiers(16);
                AssignableResultHandle constructorTarget = this.createWebTargetForMethod(classContext.constructor, (ResultHandle)baseTarget, method);
                classContext.constructor.writeInstanceField(webTargetForMethod, classContext.constructor.getThis(), (ResultHandle)constructorTarget);
                if (observabilityIntegrationNeeded) {
                    String templatePath = MULTIPLE_SLASH_PATTERN.matcher(restClientInterface.getPath() + method.getPath()).replaceAll("/");
                    classContext.constructor.invokeVirtualMethod(MethodDescriptor.ofMethod(WebTargetImpl.class, (String)"setPreClientSendHandler", Void.TYPE, (Class[])new Class[]{ClientRestHandler.class}), classContext.constructor.readInstanceField(webTargetForMethod, classContext.constructor.getThis()), new ResultHandle[]{classContext.constructor.newInstance(MethodDescriptor.ofConstructor(ClientObservabilityHandler.class, (Class[])new Class[]{String.class}), new ResultHandle[]{classContext.constructor.load(templatePath)})});
                }
                MethodCreator methodCreator = classContext.classCreator.getMethodCreator(method.getName(), method.getSimpleReturnType(), javaMethodParameters);
                AssignableResultHandle methodTarget = methodCreator.createVariable(WebTarget.class);
                methodCreator.assign(methodTarget, methodCreator.readInstanceField(webTargetForMethod, methodCreator.getThis()));
                if (!restClientInterface.isEncoded() && method.isEncoded()) {
                    methodCreator.assign(methodTarget, this.disableEncodingForWebTarget((BytecodeCreator)methodCreator, (ResultHandle)methodTarget));
                }
                Integer bodyParameterIdx = null;
                HashMap<MethodDescriptor, ResultHandle> invocationBuilderEnrichers = new HashMap<MethodDescriptor, ResultHandle>();
                String[] consumes = EndpointIndexer.extractProducesConsumesValues((AnnotationInstance)jandexMethod.declaringClass().declaredAnnotation(ResteasyReactiveDotNames.CONSUMES), (String[])method.getConsumes());
                boolean multipart = this.isMultipart(consumes, method.getParameters());
                AssignableResultHandle formParams = null;
                boolean lastEncodingEnabledByParam = true;
                for (int paramIdx = 0; paramIdx < method.getParameters().length; ++paramIdx) {
                    AssignableResultHandle invocationBuilderRef;
                    MethodParameter param = method.getParameters()[paramIdx];
                    if (!restClientInterface.isEncoded() && !method.isEncoded()) {
                        boolean needsDisabling = this.isParamAlreadyEncoded(param);
                        if (lastEncodingEnabledByParam && needsDisabling) {
                            methodCreator.assign(methodTarget, this.disableEncodingForWebTarget((BytecodeCreator)methodCreator, (ResultHandle)methodTarget));
                            lastEncodingEnabledByParam = false;
                        } else if (!lastEncodingEnabledByParam && !needsDisabling) {
                            methodCreator.assign(methodTarget, this.enableEncodingForWebTarget((BytecodeCreator)methodCreator, (ResultHandle)methodTarget));
                            lastEncodingEnabledByParam = true;
                        }
                    }
                    if (param.parameterType == ParameterType.QUERY) {
                        methodCreator.assign(methodTarget, this.addQueryParam(jandexMethod, (BytecodeCreator)methodCreator, (ResultHandle)methodTarget, param.name, methodCreator.getMethodParam(paramIdx), jandexMethod.parameterType(paramIdx), index, methodCreator.getThis(), this.getGenericTypeFromArray((BytecodeCreator)methodCreator, methodGenericParametersField, paramIdx), this.getAnnotationsFromArray((BytecodeCreator)methodCreator, methodParamAnnotationsField, paramIdx)));
                        continue;
                    }
                    if (param.parameterType == ParameterType.BEAN || param.parameterType == ParameterType.MULTI_PART_FORM) {
                        ClientBeanParamInfo beanParam = (ClientBeanParamInfo)param;
                        MethodDescriptor handleBeanParamDescriptor = MethodDescriptor.ofMethod((Object)name, (String)(method.getName() + "$$" + methodIndex + "$$handleBeanParam$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleBeanParamMethod = (MethodCreator)classContext.classCreator.getMethodCreator(handleBeanParamDescriptor).setModifiers(2);
                        AssignableResultHandle invocationBuilderRef2 = handleBeanParamMethod.createVariable(Invocation.Builder.class);
                        handleBeanParamMethod.assign(invocationBuilderRef2, handleBeanParamMethod.getMethodParam(0));
                        Supplier<FieldDescriptor> beanParamDescriptorsField = classContext.getLazyBeanParameterDescriptors(beanParam.type);
                        formParams = this.addBeanParamData(jandexMethod, (BytecodeCreator)methodCreator, (BytecodeCreator)handleBeanParamMethod, invocationBuilderRef2, classContext, beanParam.getItems(), methodCreator.getMethodParam(paramIdx), methodTarget, index, restClientInterface.getClassName(), methodCreator.getThis(), handleBeanParamMethod.getThis(), formParams, beanParamDescriptorsField, multipart, beanParam.type);
                        handleBeanParamMethod.returnValue((ResultHandle)invocationBuilderRef2);
                        invocationBuilderEnrichers.put(handleBeanParamDescriptor, methodCreator.getMethodParam(paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.PATH) {
                        this.addPathParam((BytecodeCreator)methodCreator, methodTarget, param.name, methodCreator.getMethodParam(paramIdx), param.type, methodCreator.getThis(), this.getGenericTypeFromArray((BytecodeCreator)methodCreator, methodGenericParametersField, paramIdx), this.getAnnotationsFromArray((BytecodeCreator)methodCreator, methodParamAnnotationsField, paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.BODY) {
                        bodyParameterIdx = paramIdx;
                        continue;
                    }
                    if (param.parameterType == ParameterType.HEADER) {
                        MethodDescriptor handleHeaderDescriptor = MethodDescriptor.ofMethod((Object)name, (String)(method.getName() + "$$" + methodIndex + "$$handleHeader$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.declaredType});
                        MethodCreator handleHeaderMethod = (MethodCreator)classContext.classCreator.getMethodCreator(handleHeaderDescriptor).setModifiers(2);
                        invocationBuilderRef = handleHeaderMethod.createVariable(Invocation.Builder.class);
                        handleHeaderMethod.assign(invocationBuilderRef, handleHeaderMethod.getMethodParam(0));
                        this.addHeaderParam((BytecodeCreator)handleHeaderMethod, invocationBuilderRef, param.name, handleHeaderMethod.getMethodParam(1), param.type, handleHeaderMethod.getThis(), this.getGenericTypeFromArray((BytecodeCreator)handleHeaderMethod, methodGenericParametersField, paramIdx), this.getAnnotationsFromArray((BytecodeCreator)handleHeaderMethod, methodParamAnnotationsField, paramIdx));
                        handleHeaderMethod.returnValue((ResultHandle)invocationBuilderRef);
                        invocationBuilderEnrichers.put(handleHeaderDescriptor, methodCreator.getMethodParam(paramIdx));
                        continue;
                    }
                    if (param.parameterType == ParameterType.COOKIE) {
                        MethodDescriptor handleHeaderDescriptor = MethodDescriptor.ofMethod((Object)name, (String)(method.getName() + "$$" + methodIndex + "$$handleCookie$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                        MethodCreator handleCookieMethod = (MethodCreator)classContext.classCreator.getMethodCreator(handleHeaderDescriptor).setModifiers(2);
                        invocationBuilderRef = handleCookieMethod.createVariable(Invocation.Builder.class);
                        handleCookieMethod.assign(invocationBuilderRef, handleCookieMethod.getMethodParam(0));
                        this.addCookieParam((BytecodeCreator)handleCookieMethod, invocationBuilderRef, param.name, handleCookieMethod.getMethodParam(1), param.type, handleCookieMethod.getThis(), this.getGenericTypeFromArray((BytecodeCreator)handleCookieMethod, methodGenericParametersField, paramIdx), this.getAnnotationsFromArray((BytecodeCreator)handleCookieMethod, methodParamAnnotationsField, paramIdx));
                        handleCookieMethod.returnValue((ResultHandle)invocationBuilderRef);
                        invocationBuilderEnrichers.put(handleHeaderDescriptor, methodCreator.getMethodParam(paramIdx));
                        continue;
                    }
                    if (param.parameterType != ParameterType.FORM) continue;
                    formParams = this.createFormDataIfAbsent((BytecodeCreator)methodCreator, formParams, multipart);
                    this.addFormParam((BytecodeCreator)methodCreator, param.name, methodCreator.getMethodParam(paramIdx), param.declaredType, param.signature, restClientInterface.getClassName(), methodCreator.getThis(), formParams, this.getGenericTypeFromArray((BytecodeCreator)methodCreator, methodGenericParametersField, paramIdx), this.getAnnotationsFromArray((BytecodeCreator)methodCreator, methodParamAnnotationsField, paramIdx), multipart, param.mimeType, param.partFileName, jandexMethod.declaringClass().name() + "." + jandexMethod.name());
                }
                for (JaxrsClientReactiveEnricherBuildItem enricher : enrichers) {
                    enricher.getEnricher().forWebTarget(methodCreator, index, interfaceClass, jandexMethod, methodTarget, generatedClasses);
                    formParams = enricher.getEnricher().handleFormParams(methodCreator, index, interfaceClass, jandexMethod, generatedClasses, formParams, multipart);
                }
                AssignableResultHandle builder = methodCreator.createVariable(Invocation.Builder.class);
                if (method.getProduces() == null || method.getProduces().length == 0) {
                    methodCreator.assign(builder, methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"request", Invocation.Builder.class, (Class[])new Class[0]), (ResultHandle)methodTarget, new ResultHandle[0]));
                } else {
                    ResultHandle array = methodCreator.newArray(String.class, method.getProduces().length);
                    for (int i = 0; i < method.getProduces().length; ++i) {
                        methodCreator.writeArrayValue(array, i, methodCreator.load(method.getProduces()[i]));
                    }
                    methodCreator.assign(builder, methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"request", Invocation.Builder.class, (Class[])new Class[]{String[].class}), (ResultHandle)methodTarget, new ResultHandle[]{array}));
                }
                for (Map.Entry invocationBuilderEnricher : invocationBuilderEnrichers.entrySet()) {
                    methodCreator.assign(builder, methodCreator.invokeVirtualMethod((MethodDescriptor)invocationBuilderEnricher.getKey(), methodCreator.getThis(), new ResultHandle[]{builder, (ResultHandle)invocationBuilderEnricher.getValue()}));
                }
                for (JaxrsClientReactiveEnricherBuildItem enricher : enrichers) {
                    enricher.getEnricher().forMethod(classContext.classCreator, classContext.constructor, classContext.clinit, methodCreator, interfaceClass, jandexMethod, builder, index, generatedClasses, methodIndex, methodField);
                }
                this.handleReturn(interfaceClass, defaultMediaType, method.getHttpMethod(), method.getConsumes(), jandexMethod, methodCreator, (ResultHandle)formParams, bodyParameterIdx == null ? null : methodCreator.getMethodParam(bodyParameterIdx.intValue()), builder, multipart);
            }
            classContext.constructor.returnValue(null);
            classContext.clinit.returnValue(null);
            MethodCreator methodCreator = classContext.classCreator.getMethodCreator(MethodDescriptor.ofMethod(Closeable.class, (String)"close", Void.TYPE, (Class[])new Class[0]));
            ResultHandle webTarget = methodCreator.readInstanceField(baseTargetField, methodCreator.getThis());
            ResultHandle webTargetImpl = methodCreator.checkCast(webTarget, WebTargetImpl.class);
            ResultHandle restClient = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(WebTargetImpl.class, (String)"getRestClient", ClientImpl.class, (Class[])new Class[0]), webTargetImpl, new ResultHandle[0]);
            methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(ClientImpl.class, (String)"close", Void.TYPE, (Class[])new Class[0]), restClient, new ResultHandle[0]);
            methodCreator.returnValue(null);
        }
        try (ClassCreator c = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, true), creatorName, null, Object.class.getName(), new String[]{BiFunction.class.getName()});){
            MethodCreator apply = c.getMethodCreator(MethodDescriptor.ofMethod((Object)creatorName, (String)"apply", Object.class, (Object[])new Object[]{Object.class, Object.class}));
            apply.returnValue(apply.newInstance(constructorDesc, new ResultHandle[]{apply.getMethodParam(0), apply.getMethodParam(1)}));
        }
        return recorderContext.newInstance(creatorName);
    }

    private boolean isParamAlreadyEncoded(MethodParameter param) {
        return param.encoded && (param.parameterType == ParameterType.PATH || param.parameterType == ParameterType.QUERY || param.parameterType == ParameterType.FORM || param.parameterType == ParameterType.MATRIX);
    }

    private ResultHandle disableEncodingForWebTarget(BytecodeCreator creator, ResultHandle baseTarget) {
        return this.setEncodingForWebTarget(creator, baseTarget, false);
    }

    private ResultHandle enableEncodingForWebTarget(BytecodeCreator creator, ResultHandle baseTarget) {
        return this.setEncodingForWebTarget(creator, baseTarget, true);
    }

    private ResultHandle setEncodingForWebTarget(BytecodeCreator creator, ResultHandle baseTarget, boolean encode) {
        ResultHandle webTarget = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(WebTargetImpl.class, (String)"clone", WebTargetImpl.class, (Class[])new Class[0]), baseTarget, new ResultHandle[0]);
        ResultHandle uriBuilderImpl = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(WebTargetImpl.class, (String)"getUriBuilderUnsafe", UriBuilderImpl.class, (Class[])new Class[0]), webTarget, new ResultHandle[0]);
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod(UriBuilderImpl.class, (String)"encode", UriBuilder.class, (Class[])new Class[]{Boolean.TYPE}), uriBuilderImpl, new ResultHandle[]{creator.load(encode)});
        return webTarget;
    }

    private boolean isMultipart(String[] consumes, MethodParameter[] methodParameters) {
        if (consumes != null) {
            for (String string : consumes) {
                if (!string.startsWith(MULTIPART_FORM_DATA)) continue;
                return true;
            }
        }
        for (String string : methodParameters) {
            ClientBeanParamInfo beanParam;
            if (!(((MethodParameter)string).parameterType == ParameterType.FORM ? this.isMultipartRequiringType(((MethodParameter)string).signature, ((MethodParameter)string).mimeType) : (((MethodParameter)string).parameterType == ParameterType.BEAN || ((MethodParameter)string).parameterType == ParameterType.MULTI_PART_FORM) && this.isMultipartRequiringBeanParam((beanParam = (ClientBeanParamInfo)string).getItems()))) continue;
            return true;
        }
        return false;
    }

    private boolean isMultipartRequiringType(String signature, String partType) {
        return signature.equals(FILE_SIGNATURE) || signature.equals(PATH_SIGNATURE) || signature.equals(BUFFER_SIGNATURE) || signature.equals(BYTE_ARRAY_SIGNATURE) || signature.equals(MULTI_BYTE_SIGNATURE) || partType != null;
    }

    private boolean isMultipartRequiringBeanParam(List<Item> beanItems) {
        for (Item beanItem : beanItems) {
            BeanParamItem beanParamItem;
            FormParamItem formParamItem;
            if (!(beanItem instanceof FormParamItem ? this.isMultipartRequiringType((formParamItem = (FormParamItem)beanItem).getParamSignature(), formParamItem.getMimeType()) : beanItem instanceof BeanParamItem && this.isMultipartRequiringBeanParam((beanParamItem = (BeanParamItem)beanItem).items()))) continue;
            return true;
        }
        return false;
    }

    private void addResponseTypeIfMultipart(Set<ClassInfo> multipartResponseTypes, MethodInfo method, IndexView index) {
        AnnotationInstance produces = method.annotation(ResteasyReactiveDotNames.PRODUCES);
        if (produces == null) {
            produces = method.annotation(ResteasyReactiveDotNames.PRODUCES);
        }
        if (produces != null) {
            String[] producesValues;
            for (String producesValue : producesValues = produces.value().asStringArray()) {
                if (!producesValue.toLowerCase(Locale.ROOT).startsWith(MULTIPART_FORM_DATA)) continue;
                multipartResponseTypes.add(this.returnTypeAsClass(method, index));
            }
        }
    }

    private ClassInfo returnTypeAsClass(MethodInfo jandexMethod, IndexView index) {
        Type result = jandexMethod.returnType();
        if (result.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            Type firstArgument;
            if ((result.name().equals((Object)ResteasyReactiveDotNames.COMPLETION_STAGE) || result.name().equals((Object)ResteasyReactiveDotNames.UNI)) && (firstArgument = (Type)result.asParameterizedType().arguments().get(0)).kind() == Type.Kind.CLASS) {
                return index.getClassByName(firstArgument.asClassType().name());
            }
        } else if (result.kind() == Type.Kind.CLASS) {
            return index.getClassByName(result.asClassType().name());
        }
        throw new IllegalArgumentException("multipart responses can only be mapped to non-generic classes, got " + result + " of type: " + result.kind());
    }

    private void handleSubResourceMethod(List<JaxrsClientReactiveEnricherBuildItem> enrichers, BuildProducer<GeneratedClassBuildItem> generatedClasses, ClassInfo interfaceClass, IndexView index, String defaultMediaType, Map<DotName, String> httpAnnotationToMethod, String name, ClassRestClientContext ownerContext, ResultHandle ownerTarget, int methodIndex, ResourceMethod method, String[] javaMethodParameters, MethodInfo jandexMethod, Set<ClassInfo> multipartResponseTypes, List<SubResourceParameter> ownerSubResourceParameters) {
        Type returnType = jandexMethod.returnType();
        if (returnType.kind() != Type.Kind.CLASS) {
            throw new IllegalArgumentException("Sub resource type is not a class: " + returnType.name().toString());
        }
        ClassInfo subInterface = index.getClassByName(returnType.name());
        if (!Modifier.isInterface(subInterface.flags())) {
            throw new IllegalArgumentException("Client interface method: " + jandexMethod.declaringClass().name() + "#" + jandexMethod + " has no HTTP method annotation  (@GET, @POST, etc) and it's return type: " + returnType.name().toString() + " is not an interface. If it's a sub resource method, it has to return an interface. If it's not, it has to have one of the HTTP method annotations.");
        }
        ownerContext.createJavaMethodField(interfaceClass, jandexMethod, methodIndex);
        MethodCreator ownerMethod = ownerContext.classCreator.getMethodCreator(method.getName(), method.getSimpleReturnType(), javaMethodParameters);
        String subName = subInterface.name().toString() + HashUtil.sha1((String)name) + methodIndex;
        MethodDescriptor subConstructorDescriptor = MethodDescriptor.ofConstructor((String)subName, (String[])new String[]{WebTargetImpl.class.getName()});
        try (ClassRestClientContext subContext = new ClassRestClientContext(subName, subConstructorDescriptor, generatedClasses, Object.class, subInterface.name().toString());){
            subContext.constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), subContext.constructor.getThis(), new ResultHandle[0]);
            AssignableResultHandle constructorTarget = this.createWebTargetForMethod(ownerContext.constructor, ownerTarget, method);
            boolean encodingEnabled = true;
            FieldDescriptor forMethodTargetDesc = ownerContext.classCreator.getFieldCreator("targetInOwner" + methodIndex, WebTargetImpl.class).getFieldDescriptor();
            if (subInterface.hasDeclaredAnnotation(ResteasyReactiveDotNames.ENCODED)) {
                ownerContext.constructor.assign(constructorTarget, this.disableEncodingForWebTarget((BytecodeCreator)ownerContext.constructor, (ResultHandle)constructorTarget));
                encodingEnabled = false;
            }
            ownerContext.constructor.writeInstanceField(forMethodTargetDesc, ownerContext.constructor.getThis(), (ResultHandle)constructorTarget);
            Supplier<FieldDescriptor> methodParamAnnotationsField = ownerContext.getLazyJavaMethodParamAnnotationsField(methodIndex);
            Supplier<FieldDescriptor> methodGenericParametersField = ownerContext.getLazyJavaMethodGenericParametersField(methodIndex);
            AssignableResultHandle client = this.createRestClientField(name, ownerContext.classCreator, ownerMethod);
            AssignableResultHandle webTarget = ownerMethod.createVariable(WebTarget.class);
            ownerMethod.assign(webTarget, ownerMethod.readInstanceField(forMethodTargetDesc, ownerMethod.getThis()));
            if (encodingEnabled && method.isEncoded()) {
                ownerMethod.assign(webTarget, this.disableEncodingForWebTarget((BytecodeCreator)ownerMethod, (ResultHandle)webTarget));
            }
            boolean lastEncodingEnabledByParam = true;
            for (int i = 0; i < method.getParameters().length; ++i) {
                MethodParameter param = method.getParameters()[i];
                if (encodingEnabled && !method.isEncoded()) {
                    boolean needsDisabling = this.isParamAlreadyEncoded(param);
                    if (lastEncodingEnabledByParam && needsDisabling) {
                        ownerMethod.assign(webTarget, this.disableEncodingForWebTarget((BytecodeCreator)ownerMethod, (ResultHandle)webTarget));
                        lastEncodingEnabledByParam = false;
                    } else if (!lastEncodingEnabledByParam && !needsDisabling) {
                        ownerMethod.assign(webTarget, this.enableEncodingForWebTarget((BytecodeCreator)ownerMethod, (ResultHandle)webTarget));
                        lastEncodingEnabledByParam = true;
                    }
                }
                if (param.parameterType != ParameterType.PATH) continue;
                ResultHandle paramValue = ownerMethod.getMethodParam(i);
                this.addPathParam((BytecodeCreator)ownerMethod, webTarget, param.name, paramValue, param.type, (ResultHandle)client, this.getGenericTypeFromArray((BytecodeCreator)ownerMethod, methodGenericParametersField, i), this.getAnnotationsFromArray((BytecodeCreator)ownerMethod, methodParamAnnotationsField, i));
            }
            ResultHandle subInstance = ownerMethod.newInstance(subConstructorDescriptor, new ResultHandle[]{webTarget});
            ArrayList<SubResourceParameter> subParamFields = new ArrayList<SubResourceParameter>();
            for (SubResourceParameter ownerParameter : ownerSubResourceParameters) {
                FieldDescriptor paramField = ((FieldCreator)subContext.classCreator.getFieldCreator(ownerParameter.field.getName() + "$_", ownerParameter.typeName).setModifiers(1)).getFieldDescriptor();
                ownerMethod.writeInstanceField(paramField, subInstance, ownerMethod.readInstanceField(ownerParameter.field, ownerMethod.getThis()));
                subParamFields.add(new SubResourceParameter(ownerParameter.methodParameter, ownerParameter.typeName, ownerParameter.type, paramField, ownerParameter.paramAnnotationsField, ownerParameter.genericsParametersField, ownerParameter.paramIndex));
            }
            FieldDescriptor clientField = ((FieldCreator)subContext.classCreator.getFieldCreator("client", RestClientBase.class).setModifiers(1)).getFieldDescriptor();
            ownerMethod.writeInstanceField(clientField, subInstance, (ResultHandle)client);
            for (int i = 0; i < method.getParameters().length; ++i) {
                MethodParameter param = method.getParameters()[i];
                if (param.parameterType == ParameterType.PATH) continue;
                FieldDescriptor paramField = ((FieldCreator)subContext.classCreator.getFieldCreator("param" + i, param.type).setModifiers(1)).getFieldDescriptor();
                ownerMethod.writeInstanceField(paramField, subInstance, ownerMethod.getMethodParam(i));
                subParamFields.add(new SubResourceParameter(method.getParameters()[i], param.type, jandexMethod.parameterType(i), paramField, methodParamAnnotationsField, methodGenericParametersField, i));
            }
            int subMethodIndex = 0;
            for (ResourceMethod subMethod : method.getSubResourceMethods()) {
                boolean isSubResourceMethod;
                MethodInfo jandexSubMethod = this.getJavaMethod(subInterface, subMethod, subMethod.getParameters(), index).orElseThrow(() -> new RuntimeException("Failed to find matching java method for " + subMethod + " on " + subInterface + ". It may have unresolved parameter types (generics)"));
                ++subMethodIndex;
                String[] consumes = EndpointIndexer.extractProducesConsumesValues((AnnotationInstance)jandexSubMethod.declaringClass().declaredAnnotation(ResteasyReactiveDotNames.CONSUMES), (String[])method.getConsumes());
                consumes = EndpointIndexer.extractProducesConsumesValues((AnnotationInstance)jandexSubMethod.annotation(ResteasyReactiveDotNames.CONSUMES), (String[])consumes);
                boolean multipart = this.isMultipart(consumes, subMethod.getParameters());
                boolean bl = isSubResourceMethod = subMethod.getHttpMethod() == null;
                if (!isSubResourceMethod) {
                    AssignableResultHandle invocationBuilderRef;
                    FieldDescriptor subMethodField = subContext.createJavaMethodField(subInterface, jandexSubMethod, subMethodIndex);
                    Supplier<FieldDescriptor> subMethodParamAnnotationsField = subContext.getLazyJavaMethodParamAnnotationsField(subMethodIndex);
                    Supplier<FieldDescriptor> subMethodGenericParametersField = subContext.getLazyJavaMethodGenericParametersField(subMethodIndex);
                    MethodCreator subMethodCreator = subContext.classCreator.getMethodCreator(subMethod.getName(), jandexSubMethod.returnType().name().toString(), this.parametersAsStringArray(jandexSubMethod));
                    FieldDescriptor subMethodTarget = FieldDescriptor.of((String)subName, (String)("target" + subMethodIndex), WebTarget.class);
                    subContext.classCreator.getFieldCreator(subMethodTarget).setModifiers(16);
                    AssignableResultHandle subMethodTargetV = subContext.constructor.createVariable(WebTargetImpl.class);
                    subContext.constructor.assign(subMethodTargetV, subContext.constructor.getMethodParam(0));
                    if (subMethod.getPath() != null) {
                        this.appendPath(subContext.constructor, subMethod.getPath(), subMethodTargetV);
                    }
                    subContext.constructor.writeInstanceField(subMethodTarget, subContext.constructor.getThis(), (ResultHandle)subMethodTargetV);
                    AssignableResultHandle methodTarget = subMethodCreator.createVariable(WebTarget.class);
                    subMethodCreator.assign(methodTarget, subMethodCreator.readInstanceField(subMethodTarget, subMethodCreator.getThis()));
                    if (encodingEnabled && subMethod.isEncoded()) {
                        subMethodCreator.assign(methodTarget, this.disableEncodingForWebTarget((BytecodeCreator)subMethodCreator, (ResultHandle)methodTarget));
                    }
                    ResultHandle bodyParameterValue = null;
                    AssignableResultHandle formParams = null;
                    HashMap<MethodDescriptor, ResultHandle> invocationBuilderEnrichers = new HashMap<MethodDescriptor, ResultHandle>();
                    boolean lastEncodingEnabledBySubParam = true;
                    int inheritedParamIndex = 0;
                    for (SubResourceParameter subParamField : subParamFields) {
                        ++inheritedParamIndex;
                        MethodParameter param = subParamField.methodParameter;
                        ResultHandle paramValue = subMethodCreator.readInstanceField(subParamField.field, subMethodCreator.getThis());
                        if (encodingEnabled && !subMethod.isEncoded()) {
                            boolean needsDisabling = this.isParamAlreadyEncoded(param);
                            if (lastEncodingEnabledBySubParam && needsDisabling) {
                                subMethodCreator.assign(methodTarget, this.disableEncodingForWebTarget((BytecodeCreator)subMethodCreator, (ResultHandle)methodTarget));
                                lastEncodingEnabledBySubParam = false;
                            } else if (!lastEncodingEnabledBySubParam && !needsDisabling) {
                                subMethodCreator.assign(methodTarget, this.enableEncodingForWebTarget((BytecodeCreator)subMethodCreator, (ResultHandle)methodTarget));
                                lastEncodingEnabledBySubParam = true;
                            }
                        }
                        if (param.parameterType == ParameterType.QUERY) {
                            subMethodCreator.assign(methodTarget, this.addQueryParam(jandexMethod, (BytecodeCreator)subMethodCreator, (ResultHandle)methodTarget, param.name, paramValue, subParamField.type, index, subMethodCreator.readInstanceField(clientField, subMethodCreator.getThis()), this.getGenericTypeFromArray((BytecodeCreator)subMethodCreator, subParamField.genericsParametersField, subParamField.paramIndex), this.getAnnotationsFromArray((BytecodeCreator)subMethodCreator, subParamField.paramAnnotationsField, subParamField.paramIndex)));
                            continue;
                        }
                        if (param.parameterType == ParameterType.BEAN || param.parameterType == ParameterType.MULTI_PART_FORM) {
                            ClientBeanParamInfo beanParam = (ClientBeanParamInfo)param;
                            MethodDescriptor handleBeanParamDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + methodIndex + "$$handleBeanParam$$" + inheritedParamIndex + "$" + subParamField.paramIndex), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                            MethodCreator handleBeanParamMethod = (MethodCreator)subContext.classCreator.getMethodCreator(handleBeanParamDescriptor).setModifiers(2);
                            Supplier<FieldDescriptor> beanParamDescriptors = subContext.getLazyBeanParameterDescriptors(beanParam.type);
                            AssignableResultHandle invocationBuilderRef2 = handleBeanParamMethod.createVariable(Invocation.Builder.class);
                            handleBeanParamMethod.assign(invocationBuilderRef2, handleBeanParamMethod.getMethodParam(0));
                            formParams = this.addBeanParamData(jandexMethod, (BytecodeCreator)subMethodCreator, (BytecodeCreator)handleBeanParamMethod, invocationBuilderRef2, subContext, beanParam.getItems(), paramValue, methodTarget, index, interfaceClass.name().toString(), subMethodCreator.readInstanceField(clientField, subMethodCreator.getThis()), handleBeanParamMethod.readInstanceField(clientField, handleBeanParamMethod.getThis()), formParams, beanParamDescriptors, multipart, beanParam.type);
                            handleBeanParamMethod.returnValue((ResultHandle)invocationBuilderRef2);
                            invocationBuilderEnrichers.put(handleBeanParamDescriptor, paramValue);
                            continue;
                        }
                        if (param.parameterType == ParameterType.PATH) {
                            this.addPathParam((BytecodeCreator)subMethodCreator, methodTarget, param.name, paramValue, param.type, subMethodCreator.readInstanceField(clientField, subMethodCreator.getThis()), this.getGenericTypeFromArray((BytecodeCreator)subMethodCreator, subParamField.genericsParametersField, subParamField.paramIndex), this.getAnnotationsFromArray((BytecodeCreator)subMethodCreator, subParamField.paramAnnotationsField, subParamField.paramIndex));
                            continue;
                        }
                        if (param.parameterType == ParameterType.BODY) {
                            bodyParameterValue = paramValue;
                            continue;
                        }
                        if (param.parameterType == ParameterType.HEADER) {
                            MethodDescriptor handleHeaderDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleHeader$$param" + inheritedParamIndex + "$" + subParamField.paramIndex), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.declaredType});
                            MethodCreator handleHeaderMethod = (MethodCreator)subContext.classCreator.getMethodCreator(handleHeaderDescriptor).setModifiers(2);
                            invocationBuilderRef = handleHeaderMethod.createVariable(Invocation.Builder.class);
                            handleHeaderMethod.assign(invocationBuilderRef, handleHeaderMethod.getMethodParam(0));
                            this.addHeaderParam((BytecodeCreator)handleHeaderMethod, invocationBuilderRef, param.name, handleHeaderMethod.getMethodParam(1), param.type, handleHeaderMethod.readInstanceField(clientField, handleHeaderMethod.getThis()), this.getGenericTypeFromArray((BytecodeCreator)handleHeaderMethod, subParamField.genericsParametersField, subParamField.paramIndex), this.getAnnotationsFromArray((BytecodeCreator)handleHeaderMethod, subParamField.paramAnnotationsField, subParamField.paramIndex));
                            handleHeaderMethod.returnValue((ResultHandle)invocationBuilderRef);
                            invocationBuilderEnrichers.put(handleHeaderDescriptor, paramValue);
                            continue;
                        }
                        if (param.parameterType == ParameterType.COOKIE) {
                            MethodDescriptor handleCookieDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleCookie$$param" + inheritedParamIndex + "$" + subParamField.paramIndex), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                            MethodCreator handleCookieMethod = (MethodCreator)subContext.classCreator.getMethodCreator(handleCookieDescriptor).setModifiers(2);
                            invocationBuilderRef = handleCookieMethod.createVariable(Invocation.Builder.class);
                            handleCookieMethod.assign(invocationBuilderRef, handleCookieMethod.getMethodParam(0));
                            this.addCookieParam((BytecodeCreator)handleCookieMethod, invocationBuilderRef, param.name, handleCookieMethod.getMethodParam(1), param.type, handleCookieMethod.readInstanceField(clientField, handleCookieMethod.getThis()), this.getGenericTypeFromArray((BytecodeCreator)handleCookieMethod, subParamField.genericsParametersField, subParamField.paramIndex), this.getAnnotationsFromArray((BytecodeCreator)handleCookieMethod, subParamField.paramAnnotationsField, subParamField.paramIndex));
                            handleCookieMethod.returnValue((ResultHandle)invocationBuilderRef);
                            invocationBuilderEnrichers.put(handleCookieDescriptor, paramValue);
                            continue;
                        }
                        if (param.parameterType != ParameterType.FORM) continue;
                        formParams = this.createFormDataIfAbsent((BytecodeCreator)subMethodCreator, formParams, multipart);
                        subMethodCreator.invokeInterfaceMethod(MULTIVALUED_MAP_ADD, (ResultHandle)formParams, new ResultHandle[]{subMethodCreator.load(param.name), paramValue});
                    }
                    for (int paramIdx = 0; paramIdx < subMethod.getParameters().length; ++paramIdx) {
                        AssignableResultHandle invocationBuilderRef3;
                        MethodParameter param = subMethod.getParameters()[paramIdx];
                        if (encodingEnabled && !subMethod.isEncoded()) {
                            boolean needsDisabling = this.isParamAlreadyEncoded(param);
                            if (lastEncodingEnabledBySubParam && needsDisabling) {
                                subMethodCreator.assign(methodTarget, this.disableEncodingForWebTarget((BytecodeCreator)subMethodCreator, (ResultHandle)methodTarget));
                                lastEncodingEnabledBySubParam = false;
                            } else if (!lastEncodingEnabledBySubParam && !needsDisabling) {
                                subMethodCreator.assign(methodTarget, this.enableEncodingForWebTarget((BytecodeCreator)subMethodCreator, (ResultHandle)methodTarget));
                                lastEncodingEnabledBySubParam = true;
                            }
                        }
                        if (param.parameterType == ParameterType.QUERY) {
                            subMethodCreator.assign(methodTarget, this.addQueryParam(jandexMethod, (BytecodeCreator)subMethodCreator, (ResultHandle)methodTarget, param.name, subMethodCreator.getMethodParam(paramIdx), jandexSubMethod.parameterType(paramIdx), index, subMethodCreator.readInstanceField(clientField, subMethodCreator.getThis()), this.getGenericTypeFromArray((BytecodeCreator)subMethodCreator, subMethodGenericParametersField, paramIdx), this.getAnnotationsFromArray((BytecodeCreator)subMethodCreator, subMethodParamAnnotationsField, paramIdx)));
                            continue;
                        }
                        if (param.parameterType == ParameterType.BEAN || param.parameterType == ParameterType.MULTI_PART_FORM) {
                            ClientBeanParamInfo beanParam = (ClientBeanParamInfo)param;
                            MethodDescriptor handleBeanParamDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleBeanParam$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                            MethodCreator handleBeanParamMethod = (MethodCreator)subContext.classCreator.getMethodCreator(handleBeanParamDescriptor).setModifiers(2);
                            Supplier<FieldDescriptor> beanParamDescriptors = subContext.getLazyBeanParameterDescriptors(beanParam.type);
                            invocationBuilderRef = handleBeanParamMethod.createVariable(Invocation.Builder.class);
                            handleBeanParamMethod.assign(invocationBuilderRef, handleBeanParamMethod.getMethodParam(0));
                            formParams = this.addBeanParamData(jandexMethod, (BytecodeCreator)subMethodCreator, (BytecodeCreator)handleBeanParamMethod, invocationBuilderRef, subContext, beanParam.getItems(), subMethodCreator.getMethodParam(paramIdx), methodTarget, index, interfaceClass.name().toString(), subMethodCreator.readInstanceField(clientField, subMethodCreator.getThis()), handleBeanParamMethod.readInstanceField(clientField, handleBeanParamMethod.getThis()), formParams, beanParamDescriptors, multipart, beanParam.type);
                            handleBeanParamMethod.returnValue((ResultHandle)invocationBuilderRef);
                            invocationBuilderEnrichers.put(handleBeanParamDescriptor, subMethodCreator.getMethodParam(paramIdx));
                            continue;
                        }
                        if (param.parameterType == ParameterType.PATH) {
                            this.addPathParam((BytecodeCreator)subMethodCreator, methodTarget, param.name, subMethodCreator.getMethodParam(paramIdx), param.type, subMethodCreator.readInstanceField(clientField, subMethodCreator.getThis()), this.getGenericTypeFromArray((BytecodeCreator)subMethodCreator, subMethodGenericParametersField, paramIdx), this.getAnnotationsFromArray((BytecodeCreator)subMethodCreator, subMethodParamAnnotationsField, paramIdx));
                            continue;
                        }
                        if (param.parameterType == ParameterType.BODY) {
                            bodyParameterValue = subMethodCreator.getMethodParam(paramIdx);
                            continue;
                        }
                        if (param.parameterType == ParameterType.HEADER) {
                            MethodDescriptor handleHeaderDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleHeader$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.declaredType});
                            MethodCreator handleHeaderMethod = (MethodCreator)subContext.classCreator.getMethodCreator(handleHeaderDescriptor).setModifiers(2);
                            invocationBuilderRef3 = handleHeaderMethod.createVariable(Invocation.Builder.class);
                            handleHeaderMethod.assign(invocationBuilderRef3, handleHeaderMethod.getMethodParam(0));
                            this.addHeaderParam((BytecodeCreator)handleHeaderMethod, invocationBuilderRef3, param.name, handleHeaderMethod.getMethodParam(1), param.type, handleHeaderMethod.readInstanceField(clientField, handleHeaderMethod.getThis()), this.getGenericTypeFromArray((BytecodeCreator)handleHeaderMethod, subMethodGenericParametersField, paramIdx), this.getAnnotationsFromArray((BytecodeCreator)handleHeaderMethod, subMethodParamAnnotationsField, paramIdx));
                            handleHeaderMethod.returnValue((ResultHandle)invocationBuilderRef3);
                            invocationBuilderEnrichers.put(handleHeaderDescriptor, subMethodCreator.getMethodParam(paramIdx));
                            continue;
                        }
                        if (param.parameterType == ParameterType.COOKIE) {
                            MethodDescriptor handleCookieDescriptor = MethodDescriptor.ofMethod((Object)subName, (String)(subMethod.getName() + "$$" + subMethodIndex + "$$handleCookie$$" + paramIdx), Invocation.Builder.class, (Object[])new Object[]{Invocation.Builder.class, param.type});
                            MethodCreator handleCookieMethod = (MethodCreator)subContext.classCreator.getMethodCreator(handleCookieDescriptor).setModifiers(2);
                            invocationBuilderRef3 = handleCookieMethod.createVariable(Invocation.Builder.class);
                            handleCookieMethod.assign(invocationBuilderRef3, handleCookieMethod.getMethodParam(0));
                            this.addCookieParam((BytecodeCreator)handleCookieMethod, invocationBuilderRef3, param.name, handleCookieMethod.getMethodParam(1), param.type, handleCookieMethod.readInstanceField(clientField, handleCookieMethod.getThis()), this.getGenericTypeFromArray((BytecodeCreator)handleCookieMethod, subMethodGenericParametersField, paramIdx), this.getAnnotationsFromArray((BytecodeCreator)handleCookieMethod, subMethodParamAnnotationsField, paramIdx));
                            handleCookieMethod.returnValue((ResultHandle)invocationBuilderRef3);
                            invocationBuilderEnrichers.put(handleCookieDescriptor, subMethodCreator.getMethodParam(paramIdx));
                            continue;
                        }
                        if (param.parameterType != ParameterType.FORM) continue;
                        formParams = this.createFormDataIfAbsent((BytecodeCreator)subMethodCreator, formParams, multipart);
                        subMethodCreator.invokeInterfaceMethod(MULTIVALUED_MAP_ADD, (ResultHandle)formParams, new ResultHandle[]{subMethodCreator.load(param.name), subMethodCreator.getMethodParam(paramIdx)});
                    }
                    this.addResponseTypeIfMultipart(multipartResponseTypes, jandexSubMethod, index);
                    for (JaxrsClientReactiveEnricherBuildItem enricher : enrichers) {
                        enricher.getEnricher().forSubResourceWebTarget(subMethodCreator, index, interfaceClass, subInterface, jandexMethod, jandexSubMethod, methodTarget, generatedClasses);
                        formParams = enricher.getEnricher().handleFormParamsForSubResource(subMethodCreator, index, interfaceClass, subInterface, jandexMethod, jandexSubMethod, methodTarget, generatedClasses, formParams, multipart);
                    }
                    AssignableResultHandle builder = subMethodCreator.createVariable(Invocation.Builder.class);
                    if (method.getProduces() == null || method.getProduces().length == 0) {
                        subMethodCreator.assign(builder, subMethodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"request", Invocation.Builder.class, (Class[])new Class[0]), (ResultHandle)methodTarget, new ResultHandle[0]));
                    } else {
                        ResultHandle array = subMethodCreator.newArray(String.class, subMethod.getProduces().length);
                        for (int i = 0; i < subMethod.getProduces().length; ++i) {
                            subMethodCreator.writeArrayValue(array, i, subMethodCreator.load(subMethod.getProduces()[i]));
                        }
                        subMethodCreator.assign(builder, subMethodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"request", Invocation.Builder.class, (Class[])new Class[]{String[].class}), (ResultHandle)methodTarget, new ResultHandle[]{array}));
                    }
                    for (Map.Entry invocationBuilderEnricher : invocationBuilderEnrichers.entrySet()) {
                        subMethodCreator.assign(builder, subMethodCreator.invokeVirtualMethod((MethodDescriptor)invocationBuilderEnricher.getKey(), subMethodCreator.getThis(), new ResultHandle[]{builder, (ResultHandle)invocationBuilderEnricher.getValue()}));
                    }
                    for (JaxrsClientReactiveEnricherBuildItem enricher : enrichers) {
                        enricher.getEnricher().forSubResourceMethod(subContext.classCreator, subContext.constructor, subContext.clinit, subMethodCreator, interfaceClass, subInterface, jandexSubMethod, jandexMethod, builder, index, generatedClasses, methodIndex, subMethodIndex, subMethodField);
                    }
                    this.handleReturn(subInterface, defaultMediaType, this.getHttpMethod(jandexSubMethod, subMethod.getHttpMethod(), httpAnnotationToMethod), consumes, jandexSubMethod, subMethodCreator, (ResultHandle)formParams, bodyParameterValue, builder, multipart);
                    continue;
                }
                String[] subJavaMethodParameters = new String[subMethod.getParameters().length];
                for (int i = 0; i < subMethod.getParameters().length; ++i) {
                    MethodParameter param = subMethod.getParameters()[i];
                    subJavaMethodParameters[i] = param.declaredType != null ? param.declaredType : param.type;
                }
                ResultHandle subMethodTarget = subContext.constructor.getMethodParam(0);
                this.handleSubResourceMethod(enrichers, generatedClasses, subInterface, index, defaultMediaType, httpAnnotationToMethod, subName, subContext, subMethodTarget, subMethodIndex, subMethod, subJavaMethodParameters, jandexSubMethod, multipartResponseTypes, subParamFields);
            }
            subContext.constructor.returnValue(null);
            subContext.clinit.returnValue(null);
            ownerMethod.returnValue(subInstance);
        }
    }

    private AssignableResultHandle createWebTargetForMethod(MethodCreator constructor, ResultHandle baseTarget, ResourceMethod method) {
        AssignableResultHandle target = constructor.createVariable(WebTarget.class);
        constructor.assign(target, baseTarget);
        if (method.getPath() != null) {
            this.appendPath(constructor, method.getPath(), target);
        }
        return target;
    }

    private void appendPath(MethodCreator constructor, String pathPart, AssignableResultHandle target) {
        AssignableResultHandle path = constructor.createVariable(String.class);
        constructor.assign(path, constructor.load(pathPart));
        constructor.assign(target, constructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"path", WebTarget.class, (Class[])new Class[]{String.class}), (ResultHandle)target, new ResultHandle[]{path}));
    }

    private AssignableResultHandle createRestClientField(String name, ClassCreator c, MethodCreator methodCreator) {
        AssignableResultHandle client = methodCreator.createVariable(RestClientBase.class);
        if (c.getSuperClass().contains(RestClientBase.class.getSimpleName())) {
            methodCreator.assign(client, methodCreator.getThis());
        } else {
            FieldDescriptor subClientField = FieldDescriptor.of((String)name, (String)"client", RestClientBase.class);
            methodCreator.assign(client, methodCreator.readInstanceField(subClientField, methodCreator.getThis()));
        }
        return client;
    }

    private void handleMultipartField(String formParamName, String partType, String partFilename, String type, String parameterGenericType, ResultHandle fieldValue, AssignableResultHandle multipartForm, BytecodeCreator methodCreator, ResultHandle client, String restClientInterfaceClassName, ResultHandle parameterAnnotations, ResultHandle genericType, String errorLocation) {
        BytecodeCreator ifValueNotNull = methodCreator.ifNotNull(fieldValue).trueBranch();
        if (type.equals(String.class.getName())) {
            this.addString(ifValueNotNull, multipartForm, formParamName, partType, partFilename, fieldValue);
        } else if (type.equals(File.class.getName())) {
            ResultHandle filePath = ifValueNotNull.invokeVirtualMethod(MethodDescriptor.ofMethod(File.class, (String)"toPath", Path.class, (Class[])new Class[0]), fieldValue, new ResultHandle[0]);
            this.addFile(ifValueNotNull, multipartForm, formParamName, partType, partFilename, filePath);
        } else if (type.equals(Path.class.getName())) {
            this.addFile(ifValueNotNull, multipartForm, formParamName, partType, partFilename, fieldValue);
        } else if (type.equals(InputStream.class.getName())) {
            this.addInputStream(ifValueNotNull, multipartForm, formParamName, partType, partFilename, fieldValue, type);
        } else if (type.equals(Buffer.class.getName())) {
            this.addBuffer(ifValueNotNull, multipartForm, formParamName, partType, partFilename, fieldValue, errorLocation);
        } else if (type.startsWith("[")) {
            if (!type.equals(BYTE_ARRAY_SIGNATURE)) {
                throw new IllegalArgumentException("Array of unsupported type: " + type + " on " + errorLocation);
            }
            ResultHandle buffer = ifValueNotNull.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{byte[].class}), new ResultHandle[]{fieldValue});
            this.addBuffer(ifValueNotNull, multipartForm, formParamName, partType, partFilename, buffer, errorLocation);
        } else if (parameterGenericType.equals(MULTI_BYTE_SIGNATURE)) {
            this.addMultiAsFile(ifValueNotNull, multipartForm, formParamName, partType, partFilename, fieldValue, errorLocation);
        } else if (partType != null) {
            if (partFilename != null) {
                log.warnf("Using the @PartFilename annotation is unsupported on the type '%s'. Problematic field is: '%s'", (Object)partType, (Object)formParamName);
            }
            this.addPojo(ifValueNotNull, multipartForm, formParamName, partType, fieldValue, type);
        } else {
            ResultHandle convertedFormParam = this.convertParamToString(ifValueNotNull, client, fieldValue, type, genericType, parameterAnnotations);
            BytecodeCreator parameterIsStringBranch = this.checkStringParam(ifValueNotNull, convertedFormParam, restClientInterfaceClassName, errorLocation);
            this.addString(parameterIsStringBranch, multipartForm, formParamName, null, partFilename, convertedFormParam);
        }
    }

    private void addInputStream(BytecodeCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partType, String partFilename, ResultHandle fieldValue, String type) {
        ResultHandle formParamResult = methodCreator.load(formParamName);
        ResultHandle partFilenameResult = partFilename == null ? formParamResult : methodCreator.load(partFilename);
        methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"entity", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, Object.class, String.class, Class.class}), (ResultHandle)multipartForm, new ResultHandle[]{formParamResult, partFilenameResult, fieldValue, methodCreator.load(partType), methodCreator.loadClassFromTCCL(type)}));
    }

    private void addPojo(BytecodeCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partType, ResultHandle fieldValue, String type) {
        methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"entity", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, Object.class, String.class, Class.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), fieldValue, methodCreator.load(partType), methodCreator.loadClassFromTCCL(type)}));
    }

    private void addFile(BytecodeCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partType, String partFilename, ResultHandle filePath) {
        ResultHandle fileNamePath = methodCreator.invokeInterfaceMethod(PATH_GET_FILENAME, filePath, new ResultHandle[0]);
        ResultHandle fileName = partFilename != null ? methodCreator.load(partFilename) : methodCreator.invokeVirtualMethod(OBJECT_TO_STRING, fileNamePath, new ResultHandle[0]);
        ResultHandle pathString = methodCreator.invokeVirtualMethod(OBJECT_TO_STRING, filePath, new ResultHandle[0]);
        if (partType == null) {
            partType = "application/octet-stream";
        }
        if (partType.equalsIgnoreCase("application/octet-stream")) {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"binaryFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, String.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), fileName, pathString, methodCreator.load(partType)}));
        } else {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"textFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, String.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), fileName, pathString, methodCreator.load(partType)}));
        }
    }

    private ResultHandle primitiveToString(BytecodeCreator methodCreator, ResultHandle fieldValue, FieldInfo field) {
        PrimitiveType primitiveType = field.type().asPrimitiveType();
        switch (primitiveType.primitive()) {
            case BOOLEAN: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Boolean.TYPE}), new ResultHandle[]{fieldValue});
            }
            case CHAR: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Character.TYPE}), new ResultHandle[]{fieldValue});
            }
            case DOUBLE: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Double.TYPE}), new ResultHandle[]{fieldValue});
            }
            case FLOAT: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Float.TYPE}), new ResultHandle[]{fieldValue});
            }
            case INT: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{fieldValue});
            }
            case LONG: {
                return methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"valueOf", String.class, (Class[])new Class[]{Long.TYPE}), new ResultHandle[]{fieldValue});
            }
        }
        throw new IllegalArgumentException("Unsupported primitive type in multipart form field: " + field.declaringClass().name() + "." + field.name());
    }

    private ResultHandle partFilenameHandle(BytecodeCreator methodCreator, String partFilename) {
        return partFilename != null ? methodCreator.load(partFilename) : methodCreator.loadNull();
    }

    private void addString(BytecodeCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partType, String partFilename, ResultHandle fieldValue) {
        if ("application/octet-stream".equalsIgnoreCase(partType)) {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"stringFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, String.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), partFilename != null ? methodCreator.load(partFilename) : methodCreator.loadNull(), fieldValue, methodCreator.load(partType)}));
        } else {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"attribute", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), fieldValue, this.partFilenameHandle(methodCreator, partFilename)}));
        }
    }

    private void addMultiAsFile(BytecodeCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partType, String partFilename, ResultHandle multi, String errorLocation) {
        String filename;
        if (partType == null) {
            partType = "application/octet-stream";
        }
        if ((filename = partFilename) == null) {
            filename = formParamName;
        }
        if (partType.equalsIgnoreCase("application/octet-stream")) {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"multiAsBinaryFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, Multi.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), methodCreator.load(filename), multi, methodCreator.load(partType)}));
        } else {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"multiAsTextFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, Multi.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), methodCreator.load(filename), multi, methodCreator.load(partType)}));
        }
    }

    private void addBuffer(BytecodeCreator methodCreator, AssignableResultHandle multipartForm, String formParamName, String partType, String partFilename, ResultHandle buffer, String errorLocation) {
        ResultHandle filenameHandle;
        ResultHandle resultHandle = filenameHandle = partFilename != null ? methodCreator.load(partFilename) : methodCreator.load(formParamName);
        if (partType == null) {
            partType = "application/octet-stream";
        }
        if (partType.equalsIgnoreCase("application/octet-stream")) {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"binaryFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, Buffer.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), filenameHandle, buffer, methodCreator.load(partType)}));
        } else {
            methodCreator.assign(multipartForm, methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusMultipartForm.class, (String)"textFileUpload", QuarkusMultipartForm.class, (Class[])new Class[]{String.class, String.class, Buffer.class, String.class}), (ResultHandle)multipartForm, new ResultHandle[]{methodCreator.load(formParamName), filenameHandle, buffer, methodCreator.load(partType)}));
        }
    }

    private AssignableResultHandle createFormDataIfAbsent(BytecodeCreator methodCreator, AssignableResultHandle formValues, boolean multipart) {
        if (formValues == null) {
            if (multipart) {
                formValues = methodCreator.createVariable(QuarkusMultipartForm.class);
                methodCreator.assign(formValues, methodCreator.newInstance(MethodDescriptor.ofConstructor(QuarkusMultipartForm.class, (Class[])new Class[0]), new ResultHandle[0]));
            } else {
                formValues = methodCreator.createVariable(MultivaluedMap.class);
                methodCreator.assign(formValues, methodCreator.newInstance(MethodDescriptor.ofConstructor(MultivaluedHashMap.class, (Class[])new Class[0]), new ResultHandle[0]));
            }
        }
        return formValues;
    }

    private String[] parametersAsStringArray(MethodInfo subMethod) {
        List params = subMethod.parameterTypes();
        String[] result = new String[params.size()];
        int i = 0;
        for (Type param : params) {
            result[i++] = param.name().toString();
        }
        return result;
    }

    private String getHttpMethod(MethodInfo subMethod, String defaultMethod, Map<DotName, String> httpAnnotationToMethod) {
        for (Map.Entry<DotName, String> annoToMethod : httpAnnotationToMethod.entrySet()) {
            if (subMethod.annotation(annoToMethod.getKey()) == null) continue;
            return annoToMethod.getValue();
        }
        for (Map.Entry<DotName, String> annoToMethod : httpAnnotationToMethod.entrySet()) {
            if (subMethod.declaringClass().declaredAnnotation(annoToMethod.getKey()) == null) continue;
            return annoToMethod.getValue();
        }
        return defaultMethod;
    }

    private void handleReturn(ClassInfo restClientInterface, String defaultMediaType, String httpMethod, String[] consumes, MethodInfo jandexMethod, MethodCreator methodCreator, ResultHandle formParams, ResultHandle bodyValue, AssignableResultHandle builder, boolean multipart) {
        ResultHandle rx;
        ResultHandle result;
        Integer continuationIndex;
        ResultHandle genericReturnType;
        String simpleReturnType;
        ReturnCategory returnCategory;
        block37: {
            Type lastParamType;
            List parameters;
            Type returnType = jandexMethod.returnType();
            returnCategory = ReturnCategory.BLOCKING;
            simpleReturnType = returnType.name().toString();
            genericReturnType = null;
            if (returnType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                ParameterizedType paramType = returnType.asParameterizedType();
                if (ASYNC_RETURN_TYPES.contains(paramType.name())) {
                    ReturnCategory returnCategory2 = paramType.name().equals((Object)ResteasyReactiveDotNames.COMPLETION_STAGE) ? ReturnCategory.COMPLETION_STAGE : (returnCategory = paramType.name().equals((Object)ResteasyReactiveDotNames.MULTI) || paramType.name().equals((Object)ResteasyReactiveDotNames.REST_MULTI) ? ReturnCategory.MULTI : ReturnCategory.UNI);
                    if (paramType.arguments().isEmpty()) {
                        simpleReturnType = Object.class.getName();
                    } else {
                        Type type = (Type)paramType.arguments().get(0);
                        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                            genericReturnType = this.createGenericTypeFromParameterizedType(methodCreator, type.asParameterizedType());
                        } else {
                            simpleReturnType = type.name().toString();
                        }
                    }
                } else {
                    genericReturnType = this.createGenericTypeFromParameterizedType(methodCreator, paramType);
                }
            }
            continuationIndex = null;
            if (returnCategory == ReturnCategory.BLOCKING && !(parameters = jandexMethod.parameterTypes()).isEmpty() && (lastParamType = (Type)parameters.get(parameters.size() - 1)).name().equals((Object)CONTINUATION)) {
                continuationIndex = parameters.size() - 1;
                returnCategory = ReturnCategory.COROUTINE;
                if (!QuarkusClassLoader.isClassPresentAtRuntime((String)UNI_KT.toString())) {
                    throw new RuntimeException("Suspendable rest client method" + jandexMethod + " is present on class " + jandexMethod.declaringClass() + " however io.smallrye.reactive:mutiny-kotlin is not detected. Please add a dependency on this artifact.");
                }
                Type type = (Type)lastParamType.asParameterizedType().arguments().get(0);
                while (true) {
                    if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        genericReturnType = this.createGenericTypeFromParameterizedType(methodCreator, type.asParameterizedType());
                        break block37;
                    }
                    if (type.kind() != Type.Kind.WILDCARD_TYPE) break;
                    if (type.asWildcardType().extendsBound().name().equals((Object)ResteasyReactiveDotNames.OBJECT)) {
                        type = type.asWildcardType().superBound();
                        continue;
                    }
                    type = type.asWildcardType().extendsBound();
                }
                simpleReturnType = type.name().toString();
            }
        }
        String mediaTypeValue = defaultMediaType;
        TryBlock tryBlock = methodCreator.tryBlock();
        List exceptionTypes = jandexMethod.exceptions();
        LinkedHashSet<String> exceptions = new LinkedHashSet<String>();
        for (Type exceptionType : exceptionTypes) {
            exceptions.add(exceptionType.name().toString());
        }
        if (!exceptions.contains(Exception.class.getName()) && !exceptions.contains(Throwable.class.getName())) {
            exceptions.add(RuntimeException.class.getName());
        }
        CatchBlockCreator catchBlock = tryBlock.addCatch(ProcessingException.class);
        ResultHandle caughtException = catchBlock.getCaughtException();
        ResultHandle cause = catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"getCause", Throwable.class, (Class[])new Class[0]), caughtException, new ResultHandle[0]);
        for (String exception : exceptions) {
            catchBlock.ifTrue(catchBlock.instanceOf(cause, exception)).trueBranch().throwException(cause);
        }
        catchBlock.throwException(caughtException);
        if (bodyValue != null || formParams != null) {
            if (this.countNonNulls(bodyValue, formParams) > 1) {
                throw new IllegalArgumentException("Attempt to pass at least two of form or regular entity as a request body in " + restClientInterface.name().toString() + "#" + jandexMethod.name());
            }
            if (consumes != null && consumes.length > 0) {
                if (consumes.length > 1) {
                    throw new IllegalArgumentException("Multiple `@Consumes` values used in a MicroProfile Rest Client: " + restClientInterface.name().toString() + " Unable to determine a single `Content-Type`.");
                }
                mediaTypeValue = consumes[0];
            } else if (formParams != null) {
                String string = mediaTypeValue = multipart ? MULTIPART_FORM_DATA : "application/x-www-form-urlencoded";
            }
            if (mediaTypeValue.equals(defaultMediaType)) {
                tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"property", Invocation.Builder.class, (Class[])new Class[]{String.class, Object.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.load("io.quarkus.rest.client.defaultContentType"), tryBlock.load(mediaTypeValue)});
            }
            ResultHandle mediaType = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(MediaType.class, (String)"valueOf", MediaType.class, (Class[])new Class[]{String.class}), new ResultHandle[]{tryBlock.load(mediaTypeValue)});
            ResultHandle entity = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Entity.class, (String)"entity", Entity.class, (Class[])new Class[]{Object.class, MediaType.class}), new ResultHandle[]{bodyValue != null ? bodyValue : formParams, mediaType});
            if (returnCategory == ReturnCategory.COMPLETION_STAGE) {
                ResultHandle async = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"async", AsyncInvoker.class, (Class[])new Class[0]), (ResultHandle)builder, new ResultHandle[0]);
                result = genericReturnType != null ? tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStageRxInvoker.class, (String)"method", CompletionStage.class, (Class[])new Class[]{String.class, Entity.class, GenericType.class}), async, new ResultHandle[]{tryBlock.load(httpMethod), entity, genericReturnType}) : tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStageRxInvoker.class, (String)"method", CompletionStage.class, (Class[])new Class[]{String.class, Entity.class, Class.class}), async, new ResultHandle[]{tryBlock.load(httpMethod), entity, tryBlock.loadClassFromTCCL(simpleReturnType)});
            } else if (returnCategory == ReturnCategory.UNI || returnCategory == ReturnCategory.COROUTINE) {
                ResultHandle rx2 = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"rx", RxInvoker.class, (Class[])new Class[]{Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.loadClassFromTCCL(UniInvoker.class)});
                ResultHandle uniInvoker = tryBlock.checkCast(rx2, UniInvoker.class);
                result = genericReturnType != null ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniInvoker.class, (String)"method", Uni.class, (Class[])new Class[]{String.class, Entity.class, GenericType.class}), uniInvoker, new ResultHandle[]{tryBlock.load(httpMethod), entity, genericReturnType}) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniInvoker.class, (String)"method", Uni.class, (Class[])new Class[]{String.class, Entity.class, Class.class}), uniInvoker, new ResultHandle[]{tryBlock.load(httpMethod), entity, tryBlock.loadClassFromTCCL(simpleReturnType)});
                if (returnCategory == ReturnCategory.COROUTINE) {
                    result = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod((Object)UNI_KT.toString(), (String)"awaitSuspending", Object.class, (Object[])new Object[]{Uni.class, CONTINUATION.toString()}), new ResultHandle[]{result, tryBlock.getMethodParam(continuationIndex.intValue())});
                }
            } else if (returnCategory == ReturnCategory.MULTI) {
                ResultHandle rx3 = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"rx", RxInvoker.class, (Class[])new Class[]{Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.loadClassFromTCCL(MultiInvoker.class)});
                ResultHandle multiInvoker = tryBlock.checkCast(rx3, MultiInvoker.class);
                result = genericReturnType != null ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(MultiInvoker.class, (String)"method", Multi.class, (Class[])new Class[]{String.class, Entity.class, GenericType.class}), multiInvoker, new ResultHandle[]{tryBlock.load(httpMethod), entity, genericReturnType}) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractRxInvoker.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Entity.class, Class.class}), multiInvoker, new ResultHandle[]{tryBlock.load(httpMethod), entity, tryBlock.loadClassFromTCCL(simpleReturnType)});
            } else {
                result = genericReturnType != null ? tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Entity.class, GenericType.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.load(httpMethod), entity, genericReturnType}) : tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Entity.class, Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.load(httpMethod), entity, tryBlock.loadClassFromTCCL(simpleReturnType)});
            }
        } else if (returnCategory == ReturnCategory.COMPLETION_STAGE) {
            ResultHandle async = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"async", AsyncInvoker.class, (Class[])new Class[0]), (ResultHandle)builder, new ResultHandle[0]);
            result = genericReturnType != null ? tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStageRxInvoker.class, (String)"method", CompletionStage.class, (Class[])new Class[]{String.class, GenericType.class}), async, new ResultHandle[]{tryBlock.load(httpMethod), genericReturnType}) : tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStageRxInvoker.class, (String)"method", CompletionStage.class, (Class[])new Class[]{String.class, Class.class}), async, new ResultHandle[]{tryBlock.load(httpMethod), tryBlock.loadClassFromTCCL(simpleReturnType)});
        } else if (returnCategory == ReturnCategory.UNI || returnCategory == ReturnCategory.COROUTINE) {
            rx = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"rx", RxInvoker.class, (Class[])new Class[]{Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.loadClassFromTCCL(UniInvoker.class)});
            ResultHandle uniInvoker = tryBlock.checkCast(rx, UniInvoker.class);
            result = genericReturnType != null ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniInvoker.class, (String)"method", Uni.class, (Class[])new Class[]{String.class, GenericType.class}), uniInvoker, new ResultHandle[]{tryBlock.load(httpMethod), genericReturnType}) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniInvoker.class, (String)"method", Uni.class, (Class[])new Class[]{String.class, Class.class}), uniInvoker, new ResultHandle[]{tryBlock.load(httpMethod), tryBlock.loadClassFromTCCL(simpleReturnType)});
            if (returnCategory == ReturnCategory.COROUTINE) {
                result = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod((Object)UNI_KT.toString(), (String)"awaitSuspending", Object.class, (Object[])new Object[]{Uni.class, CONTINUATION.toString()}), new ResultHandle[]{result, tryBlock.getMethodParam(continuationIndex.intValue())});
            }
        } else if (returnCategory == ReturnCategory.MULTI) {
            rx = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"rx", RxInvoker.class, (Class[])new Class[]{Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.loadClassFromTCCL(MultiInvoker.class)});
            ResultHandle multiInvoker = tryBlock.checkCast(rx, MultiInvoker.class);
            result = genericReturnType != null ? tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractRxInvoker.class, (String)"method", Object.class, (Class[])new Class[]{String.class, GenericType.class}), multiInvoker, new ResultHandle[]{tryBlock.load(httpMethod), genericReturnType}) : tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractRxInvoker.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Class.class}), multiInvoker, new ResultHandle[]{tryBlock.load(httpMethod), tryBlock.loadClassFromTCCL(simpleReturnType)});
        } else {
            result = genericReturnType != null ? tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"method", Object.class, (Class[])new Class[]{String.class, GenericType.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.load(httpMethod), genericReturnType}) : tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"method", Object.class, (Class[])new Class[]{String.class, Class.class}), (ResultHandle)builder, new ResultHandle[]{tryBlock.load(httpMethod), tryBlock.loadClassFromTCCL(simpleReturnType)});
        }
        tryBlock.returnValue(result);
    }

    private int countNonNulls(Object ... objects) {
        int result = 0;
        for (Object object : objects) {
            if (object == null) continue;
            ++result;
        }
        return result;
    }

    private ResultHandle createGenericTypeFromParameterizedType(MethodCreator methodCreator, ParameterizedType parameterizedType2) {
        ResultHandle currentThread = methodCreator.invokeStaticMethod(MethodDescriptors.THREAD_CURRENT_THREAD, new ResultHandle[0]);
        ResultHandle tccl = methodCreator.invokeVirtualMethod(MethodDescriptors.THREAD_GET_TCCL, currentThread, new ResultHandle[0]);
        ResultHandle parameterizedType = Types.getParameterizedType((BytecodeCreator)methodCreator, (ResultHandle)tccl, (ParameterizedType)parameterizedType2);
        ResultHandle genericReturnType = methodCreator.newInstance(MethodDescriptor.ofConstructor(GenericType.class, (Class[])new Class[]{java.lang.reflect.Type.class}), new ResultHandle[]{parameterizedType});
        return genericReturnType;
    }

    private Optional<MethodInfo> getJavaMethod(ClassInfo interfaceClass, ResourceMethod method, MethodParameter[] parameters, IndexView index) {
        DotName interfaceName;
        for (MethodInfo methodInfo : interfaceClass.methods()) {
            if (!methodInfo.name().equals(method.getName()) || methodInfo.parametersCount() != parameters.length) continue;
            boolean matches = true;
            for (int i = 0; i < parameters.length; ++i) {
                String declaredType;
                MethodParameter actualParam = parameters[i];
                Type parameterType = methodInfo.parameterType(i);
                String string = declaredType = actualParam.declaredType != null ? actualParam.declaredType : actualParam.type;
                if (declaredType.equals(parameterType.name().toString())) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return Optional.of(methodInfo);
        }
        Optional<MethodInfo> maybeMethod = Optional.empty();
        Iterator iterator = interfaceClass.interfaceNames().iterator();
        while (iterator.hasNext() && !(maybeMethod = this.getJavaMethod(index.getClassByName(interfaceName = (DotName)iterator.next()), method, parameters, index)).isPresent()) {
        }
        return maybeMethod;
    }

    private AssignableResultHandle addBeanParamData(MethodInfo jandexMethod, BytecodeCreator methodCreator, BytecodeCreator invocationBuilderEnricher, AssignableResultHandle invocationBuilder, ClassRestClientContext classContext, List<Item> beanParamItems, ResultHandle param, AssignableResultHandle target, IndexView index, String restClientInterfaceClassName, ResultHandle client, ResultHandle invocationEnricherClient, AssignableResultHandle formParams, Supplier<FieldDescriptor> descriptorsField, boolean multipart, String beanParamClass) {
        if (this.areFormParamsDefinedIn(beanParamItems)) {
            formParams = this.createFormDataIfAbsent(methodCreator, formParams, multipart);
        }
        this.addSubBeanParamData(jandexMethod, methodCreator, invocationBuilderEnricher, invocationBuilder, classContext, beanParamItems, param, target, index, restClientInterfaceClassName, client, invocationEnricherClient, formParams, descriptorsField, multipart, beanParamClass);
        return formParams;
    }

    private void addSubBeanParamData(MethodInfo jandexMethod, BytecodeCreator methodCreator, BytecodeCreator invocationBuilderEnricher, AssignableResultHandle invocationBuilder, ClassRestClientContext classContext, List<Item> beanParamItems, ResultHandle param, AssignableResultHandle target, IndexView index, String restClientInterfaceClassName, ResultHandle client, ResultHandle invocationEnricherClient, AssignableResultHandle formParams, Supplier<FieldDescriptor> beanParamDescriptorField, boolean multipart, String beanParamClass) {
        BytecodeCreator creator = methodCreator.ifNotNull(param).trueBranch();
        BytecodeCreator invoEnricher = invocationBuilderEnricher.ifNotNull(invocationBuilderEnricher.getMethodParam(1)).trueBranch();
        boolean encodingEnabled = true;
        block8: for (Item item : beanParamItems) {
            if (encodingEnabled && item.isEncoded()) {
                creator.assign(target, this.disableEncodingForWebTarget(creator, (ResultHandle)target));
                encodingEnabled = false;
            } else if (!encodingEnabled && !item.isEncoded()) {
                creator.assign(target, this.enableEncodingForWebTarget(creator, (ResultHandle)target));
                encodingEnabled = true;
            }
            switch (item.type()) {
                case BEAN_PARAM: {
                    BeanParamItem beanParamItem = (BeanParamItem)item;
                    ResultHandle beanParamElementHandle = beanParamItem.extract(creator, param);
                    Supplier<FieldDescriptor> newBeanParamDescriptorField = classContext.getLazyBeanParameterDescriptors(beanParamItem.className());
                    this.addSubBeanParamData(jandexMethod, creator, invoEnricher, invocationBuilder, classContext, beanParamItem.items(), beanParamElementHandle, target, index, restClientInterfaceClassName, client, invocationEnricherClient, formParams, newBeanParamDescriptorField, multipart, beanParamItem.className());
                    continue block8;
                }
                case QUERY_PARAM: {
                    QueryParamItem queryParam = (QueryParamItem)item;
                    creator.assign(target, this.addQueryParam(jandexMethod, creator, (ResultHandle)target, queryParam.name(), queryParam.extract(creator, param), queryParam.getValueType(), index, client, this.getGenericTypeFromParameter(creator, beanParamDescriptorField, item.fieldName()), this.getAnnotationsFromParameter(creator, beanParamDescriptorField, item.fieldName())));
                    continue block8;
                }
                case COOKIE: {
                    CookieParamItem cookieParam = (CookieParamItem)item;
                    this.addCookieParam(invoEnricher, invocationBuilder, cookieParam.getCookieName(), cookieParam.extract(invoEnricher, invoEnricher.getMethodParam(1)), cookieParam.getParamType(), invocationEnricherClient, this.getGenericTypeFromParameter(invoEnricher, beanParamDescriptorField, item.fieldName()), this.getAnnotationsFromParameter(invoEnricher, beanParamDescriptorField, item.fieldName()));
                    continue block8;
                }
                case HEADER_PARAM: {
                    HeaderParamItem headerParam = (HeaderParamItem)item;
                    this.addHeaderParam(invoEnricher, invocationBuilder, headerParam.getHeaderName(), headerParam.extract(invoEnricher, invoEnricher.getMethodParam(1)), headerParam.getParamType(), invocationEnricherClient, this.getGenericTypeFromParameter(invoEnricher, beanParamDescriptorField, item.fieldName()), this.getAnnotationsFromParameter(invoEnricher, beanParamDescriptorField, item.fieldName()));
                    continue block8;
                }
                case PATH_PARAM: {
                    PathParamItem pathParam = (PathParamItem)item;
                    this.addPathParam(creator, target, pathParam.getPathParamName(), pathParam.extract(creator, param), pathParam.getParamType(), client, this.getGenericTypeFromParameter(creator, beanParamDescriptorField, item.fieldName()), this.getAnnotationsFromParameter(creator, beanParamDescriptorField, item.fieldName()));
                    continue block8;
                }
                case FORM_PARAM: {
                    FormParamItem formParam = (FormParamItem)item;
                    this.addFormParam(creator, formParam.getFormParamName(), formParam.extract(creator, param), formParam.getParamType(), formParam.getParamSignature(), restClientInterfaceClassName, client, formParams, this.getGenericTypeFromParameter(creator, beanParamDescriptorField, item.fieldName()), this.getAnnotationsFromParameter(creator, beanParamDescriptorField, item.fieldName()), multipart, formParam.getMimeType(), formParam.getFileName(), beanParamClass + "." + formParam.getSourceName());
                    continue block8;
                }
            }
            throw new IllegalStateException("Unimplemented");
        }
    }

    private ResultHandle getGenericTypeFromParameter(BytecodeCreator creator, Supplier<FieldDescriptor> supplier, String name) {
        ResultHandle map = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Supplier.class, (String)"get", Object.class, (Class[])new Class[0]), creator.readStaticField(supplier.get()), new ResultHandle[0]);
        ResultHandle value = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"get", Object.class, (Class[])new Class[]{Object.class}), map, new ResultHandle[]{creator.load(name)});
        AssignableResultHandle genericType = creator.createVariable(java.lang.reflect.Type.class);
        BranchResult ifBranch = creator.ifNotNull(value);
        BytecodeCreator ifNotNull = ifBranch.trueBranch();
        ifNotNull.assign(genericType, ifNotNull.readInstanceField(FieldDescriptor.of(ParameterDescriptorFromClassSupplier.ParameterDescriptor.class, (String)"genericType", java.lang.reflect.Type.class), value));
        BytecodeCreator ifNull = ifBranch.falseBranch();
        ifNull.assign(genericType, ifNull.loadNull());
        return genericType;
    }

    private ResultHandle getGenericTypeFromArray(BytecodeCreator creator, Supplier<FieldDescriptor> supplier, int paramIdx) {
        ResultHandle value = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Supplier.class, (String)"get", Object.class, (Class[])new Class[0]), creator.readStaticField(supplier.get()), new ResultHandle[0]);
        return creator.readArrayValue(creator.checkCast(value, java.lang.reflect.Type[].class), paramIdx);
    }

    private ResultHandle getAnnotationsFromParameter(BytecodeCreator creator, Supplier<FieldDescriptor> supplier, String name) {
        ResultHandle map = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Supplier.class, (String)"get", Object.class, (Class[])new Class[0]), creator.readStaticField(supplier.get()), new ResultHandle[0]);
        ResultHandle value = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"get", Object.class, (Class[])new Class[]{Object.class}), map, new ResultHandle[]{creator.load(name)});
        AssignableResultHandle annotations = creator.createVariable(Annotation[].class);
        BranchResult ifBranch = creator.ifNotNull(value);
        BytecodeCreator ifNotNull = ifBranch.trueBranch();
        ifNotNull.assign(annotations, ifNotNull.readInstanceField(FieldDescriptor.of(ParameterDescriptorFromClassSupplier.ParameterDescriptor.class, (String)"annotations", Annotation[].class), value));
        BytecodeCreator ifNull = ifBranch.falseBranch();
        ifNull.assign(annotations, ifNull.loadNull());
        return annotations;
    }

    private ResultHandle getAnnotationsFromArray(BytecodeCreator creator, Supplier<FieldDescriptor> supplier, int paramIdx) {
        ResultHandle value = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Supplier.class, (String)"get", Object.class, (Class[])new Class[0]), creator.readStaticField(supplier.get()), new ResultHandle[0]);
        return creator.readArrayValue(creator.checkCast(value, Annotation[][].class), paramIdx);
    }

    private boolean areFormParamsDefinedIn(List<Item> beanParamItems) {
        for (Item item : beanParamItems) {
            switch (item.type()) {
                case FORM_PARAM: {
                    return true;
                }
                case BEAN_PARAM: {
                    if (!this.areFormParamsDefinedIn(((BeanParamItem)item).items())) break;
                    return true;
                }
            }
        }
        return false;
    }

    private ResultHandle addQueryParam(MethodInfo jandexMethod, BytecodeCreator methodCreator, ResultHandle webTarget, String paramName, ResultHandle queryParamHandle, Type type, IndexView index, ResultHandle client, ResultHandle genericType, ResultHandle paramAnnotations) {
        AssignableResultHandle result = methodCreator.createVariable(WebTarget.class);
        BranchResult isParamNull = methodCreator.ifNull(queryParamHandle);
        BytecodeCreator notNullParam = isParamNull.falseBranch();
        if (this.isMap(type, index)) {
            ResultHandle paramArray;
            Map.Entry<Type, Type> resolvesTypes = this.resolveMapTypes(type, index, jandexMethod);
            Type keyType = resolvesTypes.getKey();
            if (!ResteasyReactiveDotNames.STRING.equals((Object)keyType.name())) {
                throw new IllegalArgumentException("Map parameter types must have String keys. Offending method is: " + jandexMethod);
            }
            notNullParam.assign(result, webTarget);
            ResultHandle keySet = notNullParam.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"keySet", Set.class, (Class[])new Class[0]), queryParamHandle, new ResultHandle[0]);
            ResultHandle keysIterator = notNullParam.invokeInterfaceMethod(MethodDescriptor.ofMethod(Set.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), keySet, new ResultHandle[0]);
            BytecodeCreator loopCreator = notNullParam.whileLoop(c -> this.iteratorHasNext((BytecodeCreator)c, keysIterator)).block();
            ResultHandle key = loopCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), keysIterator, new ResultHandle[0]);
            ResultHandle value = loopCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"get", Object.class, (Class[])new Class[]{Object.class}), queryParamHandle, new ResultHandle[]{key});
            Type valueType = resolvesTypes.getValue();
            String componentType = valueType.name().toString();
            if (this.isCollection(valueType, index)) {
                Type paramType;
                if (valueType.kind() == Type.Kind.PARAMETERIZED_TYPE && (paramType = (Type)valueType.asParameterizedType().arguments().get(0)).kind() == Type.Kind.CLASS) {
                    componentType = paramType.name().toString();
                }
                if (componentType == null) {
                    componentType = DotNames.OBJECT.toString();
                }
                paramArray = loopCreator.invokeStaticMethod(MethodDescriptor.ofMethod(ToObjectArray.class, (String)"collection", Object[].class, (Class[])new Class[]{Collection.class}), new ResultHandle[]{value});
            } else {
                paramArray = loopCreator.invokeStaticMethod(MethodDescriptor.ofMethod(ToObjectArray.class, (String)"value", Object[].class, (Class[])new Class[]{Object.class}), new ResultHandle[]{value});
            }
            this.addQueryParamToWebTarget(loopCreator, key, (ResultHandle)result, client, genericType, paramAnnotations, paramArray, componentType, result);
        } else {
            ResultHandle paramArray;
            String componentType = null;
            if (type.kind() == Type.Kind.ARRAY) {
                componentType = type.asArrayType().constituent().name().toString();
                paramArray = notNullParam.checkCast(queryParamHandle, Object[].class);
            } else if (this.isCollection(type, index)) {
                Type paramType;
                if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && (paramType = (Type)type.asParameterizedType().arguments().get(0)).kind() == Type.Kind.CLASS) {
                    componentType = paramType.name().toString();
                }
                if (componentType == null) {
                    componentType = DotNames.OBJECT.toString();
                }
                paramArray = notNullParam.invokeStaticMethod(MethodDescriptor.ofMethod(ToObjectArray.class, (String)"collection", Object[].class, (Class[])new Class[]{Collection.class}), new ResultHandle[]{queryParamHandle});
            } else {
                componentType = type.name().toString();
                paramArray = notNullParam.invokeStaticMethod(MethodDescriptor.ofMethod(ToObjectArray.class, (String)"value", Object[].class, (Class[])new Class[]{Object.class}), new ResultHandle[]{queryParamHandle});
            }
            this.addQueryParamToWebTarget(notNullParam, notNullParam.load(paramName), webTarget, client, genericType, paramAnnotations, paramArray, componentType, result);
        }
        isParamNull.trueBranch().assign(result, webTarget);
        return result;
    }

    private Map.Entry<Type, Type> resolveMapTypes(Type type, IndexView index, MethodInfo jandexMethod) {
        if (type.name().equals((Object)ResteasyReactiveDotNames.MAP)) {
            if (type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
                throw new IllegalArgumentException("Raw Map parameter types are not supported. Offending method is: " + jandexMethod);
            }
            ParameterizedType parameterizedType = type.asParameterizedType();
            List arguments = parameterizedType.arguments();
            return new AbstractMap.SimpleEntry<Type, Type>((Type)arguments.get(0), (Type)arguments.get(1));
        }
        if (type.name().equals((Object)ResteasyReactiveDotNames.MULTI_VALUED_MAP)) {
            if (type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
                throw new IllegalArgumentException("Raw MultivaluedMap parameter types are not supported. Offending method is: " + jandexMethod);
            }
            ParameterizedType parameterizedType = type.asParameterizedType();
            List arguments = parameterizedType.arguments();
            return new AbstractMap.SimpleEntry<Type, ParameterizedType>((Type)arguments.get(0), ParameterizedType.create((DotName)ResteasyReactiveDotNames.LIST, (Type[])new Type[]{(Type)arguments.get(1)}, null));
        }
        throw new IllegalArgumentException("Unsupported Map type '" + type.name() + "'. Offending method is: " + jandexMethod);
    }

    private BranchResult iteratorHasNext(BytecodeCreator creator, ResultHandle iterator) {
        return creator.ifTrue(creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]));
    }

    private void addQueryParamToWebTarget(BytecodeCreator creator, ResultHandle paramName, ResultHandle webTarget, ResultHandle client, ResultHandle genericType, ResultHandle paramAnnotations, ResultHandle paramArray, String componentType, AssignableResultHandle resultVariable) {
        ResultHandle convertedParamArray = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientBase.class, (String)"convertParamArray", Object[].class, (Class[])new Class[]{Object[].class, Class.class, java.lang.reflect.Type.class, Annotation[].class}), client, new ResultHandle[]{paramArray, creator.loadClassFromTCCL(componentType), genericType, paramAnnotations});
        creator.assign(resultVariable, creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(WebTarget.class, (String)"queryParam", WebTarget.class, (Class[])new Class[]{String.class, Object[].class}), webTarget, new ResultHandle[]{paramName, convertedParamArray}));
    }

    private boolean isCollection(Type type, IndexView index) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return false;
        }
        ClassInfo classInfo = index.getClassByName(type.name());
        if (classInfo == null) {
            return false;
        }
        return classInfo.interfaceNames().stream().anyMatch(arg_0 -> ((DotName)DotName.createSimple((String)Collection.class.getName())).equals(arg_0));
    }

    private boolean isMap(Type type, IndexView index) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return false;
        }
        ClassInfo classInfo = index.getClassByName(type.name());
        if (classInfo == null) {
            return false;
        }
        if (ResteasyReactiveDotNames.MAP.equals((Object)classInfo.name())) {
            return true;
        }
        return classInfo.interfaceNames().stream().anyMatch(arg_0 -> ((DotName)DotName.createSimple((String)Map.class.getName())).equals(arg_0));
    }

    private void addHeaderParam(BytecodeCreator invoBuilderEnricher, AssignableResultHandle invocationBuilder, String paramName, ResultHandle headerParamHandle, String paramType, ResultHandle client, ResultHandle genericType, ResultHandle annotations) {
        BytecodeCreator notNullValue = invoBuilderEnricher.ifNull(headerParamHandle).falseBranch();
        headerParamHandle = notNullValue.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientBase.class, (String)"convertParam", Object.class, (Class[])new Class[]{Object.class, Class.class, java.lang.reflect.Type.class, Annotation[].class}), client, new ResultHandle[]{headerParamHandle, notNullValue.loadClassFromTCCL(paramType), genericType, annotations});
        notNullValue.assign(invocationBuilder, notNullValue.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"header", Invocation.Builder.class, (Class[])new Class[]{String.class, Object.class}), (ResultHandle)invocationBuilder, new ResultHandle[]{notNullValue.load(paramName), headerParamHandle}));
    }

    private void addPathParam(BytecodeCreator methodCreator, AssignableResultHandle methodTarget, String paramName, ResultHandle pathParamHandle, String parameterType, ResultHandle client, ResultHandle genericType, ResultHandle parameterAnnotations) {
        ResultHandle handle = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientBase.class, (String)"convertParam", Object.class, (Class[])new Class[]{Object.class, Class.class, java.lang.reflect.Type.class, Annotation[].class}), client, new ResultHandle[]{pathParamHandle, methodCreator.loadClassFromTCCL(parameterType), genericType, parameterAnnotations});
        methodCreator.assign(methodTarget, methodCreator.invokeInterfaceMethod(WEB_TARGET_RESOLVE_TEMPLATE_METHOD, (ResultHandle)methodTarget, new ResultHandle[]{methodCreator.load(paramName), handle}));
    }

    private void addFormParam(BytecodeCreator methodCreator, String paramName, ResultHandle formParamHandle, String parameterType, String parameterGenericType, String restClientInterfaceClassName, ResultHandle client, AssignableResultHandle formParams, ResultHandle genericType, ResultHandle parameterAnnotations, boolean multipart, String partType, String partFilename, String errorLocation) {
        if (multipart) {
            this.handleMultipartField(paramName, partType, partFilename, parameterType, parameterGenericType, formParamHandle, formParams, methodCreator, client, restClientInterfaceClassName, parameterAnnotations, genericType, errorLocation);
        } else {
            BytecodeCreator notNullValue = methodCreator.ifNull(formParamHandle).falseBranch();
            ResultHandle convertedFormParam = this.convertParamToString(notNullValue, client, formParamHandle, parameterType, genericType, parameterAnnotations);
            BytecodeCreator parameterIsStringBranch = this.checkStringParam(notNullValue, convertedFormParam, restClientInterfaceClassName, errorLocation);
            parameterIsStringBranch.invokeInterfaceMethod(MULTIVALUED_MAP_ADD, (ResultHandle)formParams, new ResultHandle[]{notNullValue.load(paramName), convertedFormParam});
        }
    }

    private BytecodeCreator checkStringParam(BytecodeCreator notNullValue, ResultHandle convertedFormParam, String restClientInterfaceClassName, String errorLocation) {
        ResultHandle isString = notNullValue.instanceOf(convertedFormParam, String.class);
        BranchResult isStringBranch = notNullValue.ifTrue(isString);
        isStringBranch.falseBranch().throwException(IllegalStateException.class, "Form element '" + errorLocation + "' could not be converted to 'String' for REST Client interface '" + restClientInterfaceClassName + "'. A proper implementation of '" + ParamConverter.class.getName() + "' needs to be returned by a '" + ParamConverterProvider.class.getName() + "' that is registered with the client via the @RegisterProvider annotation on the REST Client interface.");
        return isStringBranch.trueBranch();
    }

    private ResultHandle convertParamToString(BytecodeCreator notNullValue, ResultHandle client, ResultHandle formParamHandle, String parameterType, ResultHandle genericType, ResultHandle parameterAnnotations) {
        return notNullValue.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientBase.class, (String)"convertParam", Object.class, (Class[])new Class[]{Object.class, Class.class, java.lang.reflect.Type.class, Annotation[].class}), client, new ResultHandle[]{formParamHandle, notNullValue.loadClassFromTCCL(parameterType), genericType, parameterAnnotations});
    }

    private void addCookieParam(BytecodeCreator invoBuilderEnricher, AssignableResultHandle invocationBuilder, String paramName, ResultHandle cookieParamHandle, String paramType, ResultHandle client, ResultHandle genericType, ResultHandle annotations) {
        BytecodeCreator notNullValue = invoBuilderEnricher.ifNull(cookieParamHandle).falseBranch();
        cookieParamHandle = notNullValue.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientBase.class, (String)"convertParam", Object.class, (Class[])new Class[]{Object.class, Class.class, java.lang.reflect.Type.class, Annotation[].class}), client, new ResultHandle[]{cookieParamHandle, notNullValue.loadClassFromTCCL(paramType), genericType, annotations});
        notNullValue.assign(invocationBuilder, notNullValue.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invocation.Builder.class, (String)"cookie", Invocation.Builder.class, (Class[])new Class[]{String.class, String.class}), (ResultHandle)invocationBuilder, new ResultHandle[]{notNullValue.load(paramName), cookieParamHandle}));
    }

    private static class SubResourceParameter {
        final MethodParameter methodParameter;
        final String typeName;
        final Type type;
        final FieldDescriptor field;
        final Supplier<FieldDescriptor> paramAnnotationsField;
        final Supplier<FieldDescriptor> genericsParametersField;
        final int paramIndex;

        private SubResourceParameter(MethodParameter methodParameter, String typeName, Type type, FieldDescriptor field, Supplier<FieldDescriptor> paramAnnotationsField, Supplier<FieldDescriptor> genericsParametersField, int paramIndex) {
            this.methodParameter = methodParameter;
            this.typeName = typeName;
            this.type = type;
            this.field = field;
            this.paramAnnotationsField = paramAnnotationsField;
            this.genericsParametersField = genericsParametersField;
            this.paramIndex = paramIndex;
        }
    }

    private static enum ReturnCategory {
        BLOCKING,
        COMPLETION_STAGE,
        UNI,
        MULTI,
        REST_MULTI,
        COROUTINE;

    }
}

