/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxrs.client.reactive.deployment;

import io.quarkus.deployment.Capabilities;
import io.quarkus.resteasy.reactive.common.deployment.JsonDefaultProducersHandler;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.processor.scanning.ClientEndpointIndexer;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.processor.DefaultProducesHandler;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationStore;

public class QuarkusClientEndpointIndexer
extends ClientEndpointIndexer {
    private static final Logger LOGGER = Logger.getLogger(QuarkusClientEndpointIndexer.class);
    private final JsonDefaultProducersHandler jsonDefaultProducersHandler;
    private final Capabilities capabilities;
    private DefaultProducesHandler.Context currentDefaultProducesContext;

    QuarkusClientEndpointIndexer(Builder builder, String defaultProduces, boolean smartDefaultProduces) {
        super((ClientEndpointIndexer.AbstractBuilder)builder, defaultProduces, smartDefaultProduces);
        this.capabilities = builder.capabilities;
        this.jsonDefaultProducersHandler = new JsonDefaultProducersHandler();
    }

    protected void setupApplyDefaults(final Type nonAsyncReturnType, final DotName httpMethod) {
        this.currentDefaultProducesContext = new DefaultProducesHandler.Context(){

            public Type nonAsyncReturnType() {
                return nonAsyncReturnType;
            }

            public DotName httpMethod() {
                return httpMethod;
            }

            public IndexView index() {
                return QuarkusClientEndpointIndexer.this.applicationIndex;
            }

            public ResteasyReactiveConfig config() {
                return QuarkusClientEndpointIndexer.this.config;
            }
        };
    }

    protected void handleAdditionalMethodProcessing(ResourceMethod method, ClassInfo currentClassInfo, MethodInfo info, AnnotationStore annotationStore) {
        super.handleAdditionalMethodProcessing(method, currentClassInfo, info, annotationStore);
        if (!this.capabilities.isCapabilityWithPrefixMissing("io.quarkus.rest.client.reactive.json")) {
            return;
        }
        this.warnAboutMissingJsonProviderIfNeeded(method, info, (DefaultProducesHandler)this.jsonDefaultProducersHandler, this.currentDefaultProducesContext);
    }

    protected void logMissingJsonWarning(MethodInfo info) {
        LOGGER.warnf("Quarkus detected the use of JSON in REST Client method '" + String.valueOf(info.declaringClass().name()) + "#" + info.name() + "' but no JSON extension has been added. Consider adding 'quarkus-rest-client-reactive-jackson' (recommended) or 'quarkus-rest-client-reactive-jsonb'.", new Object[0]);
    }

    protected void warnAboutMissUsedBodyParameter(DotName httpMethod, MethodInfo methodInfo) {
    }

    public static final class Builder
    extends ClientEndpointIndexer.AbstractBuilder<Builder> {
        private final Capabilities capabilities;

        public Builder(Capabilities capabilities) {
            this.capabilities = capabilities;
        }
    }
}

