/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxrs.client.reactive.runtime;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

public abstract class RestClientBase
implements Closeable {
    private static final ParamConverter<Byte> BYTE_CONVERTER = new ParamConverter<Byte>(){

        public Byte fromString(String value) {
            return value == null ? null : Byte.valueOf(value);
        }

        public String toString(Byte value) {
            return value == null ? null : value.toString();
        }
    };
    private static final ParamConverter<Short> SHORT_CONVERTER = new ParamConverter<Short>(){

        public Short fromString(String value) {
            return value == null ? null : Short.valueOf(value);
        }

        public String toString(Short value) {
            return value == null ? null : value.toString();
        }
    };
    private static final ParamConverter<Integer> INTEGER_CONVERTER = new ParamConverter<Integer>(){

        public Integer fromString(String value) {
            return value == null ? null : Integer.valueOf(value);
        }

        public String toString(Integer value) {
            return value == null ? null : value.toString();
        }
    };
    private static final ParamConverter<Long> LONG_CONVERTER = new ParamConverter<Long>(){

        public Long fromString(String value) {
            return value == null ? null : Long.valueOf(value);
        }

        public String toString(Long value) {
            return value == null ? null : value.toString();
        }
    };
    private static final ParamConverter<Float> FLOAT_CONVERTER = new ParamConverter<Float>(){

        public Float fromString(String value) {
            return value == null ? null : Float.valueOf(value);
        }

        public String toString(Float value) {
            return value == null ? null : value.toString();
        }
    };
    private static final ParamConverter<Double> DOUBLE_CONVERTER = new ParamConverter<Double>(){

        public Double fromString(String value) {
            return value == null ? null : Double.valueOf(value);
        }

        public String toString(Double value) {
            return value == null ? null : value.toString();
        }
    };
    private static final ParamConverter<Character> CHARACTER_CONVERTER = new ParamConverter<Character>(){

        public Character fromString(String value) {
            return value == null ? null : Character.valueOf(value.charAt(0));
        }

        public String toString(Character value) {
            return value == null ? null : value.toString();
        }
    };
    private static final ParamConverter<Boolean> BOOLEAN_CONVERTER = new ParamConverter<Boolean>(){

        public Boolean fromString(String value) {
            return value == null ? null : Boolean.valueOf(value);
        }

        public String toString(Boolean value) {
            return value == null ? null : value.toString();
        }
    };
    private static final ParamConverter<UUID> UUID_CONVERTER = new ParamConverter<UUID>(){

        public UUID fromString(String value) {
            return value == null ? null : UUID.fromString(value);
        }

        public String toString(UUID value) {
            return value == null ? null : value.toString();
        }
    };
    private final List<ParamConverterProvider> paramConverterProviders;
    private final Map<Class<?>, ParamConverterProvider> providerForClass = new ConcurrentHashMap();
    private static final ParamConverterProvider DEFAULT_PROVIDER = new ParamConverterProvider(){

        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            if (rawType == Byte.TYPE || rawType == Byte.class) {
                return BYTE_CONVERTER;
            }
            if (rawType == Short.TYPE || rawType == Short.class) {
                return SHORT_CONVERTER;
            }
            if (rawType == Integer.TYPE || rawType == Integer.class) {
                return INTEGER_CONVERTER;
            }
            if (rawType == Long.TYPE || rawType == Long.class) {
                return LONG_CONVERTER;
            }
            if (rawType == Float.TYPE || rawType == Float.class) {
                return FLOAT_CONVERTER;
            }
            if (rawType == Double.TYPE || rawType == Double.class) {
                return DOUBLE_CONVERTER;
            }
            if (rawType == Character.TYPE || rawType == Character.class) {
                return CHARACTER_CONVERTER;
            }
            if (rawType == Boolean.TYPE || rawType == Boolean.class) {
                return BOOLEAN_CONVERTER;
            }
            if (rawType == UUID.class) {
                return UUID_CONVERTER;
            }
            return null;
        }
    };
    private static final ParamConverterProvider NO_PROVIDER = new ParamConverterProvider(){

        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            return null;
        }
    };

    public RestClientBase(List<ParamConverterProvider> providers) {
        this.paramConverterProviders = providers;
    }

    public <T> Object[] convertParamArray(T[] value, Class<T> type, Supplier<Type[]> genericType, Supplier<Annotation[][]> methodAnnotations, int paramIndex) {
        ParamConverter<T> converter = this.getConverter(type, genericType, methodAnnotations, paramIndex);
        if (converter == null) {
            return value;
        }
        Object[] result = new Object[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = converter.toString(value[i]);
        }
        return result;
    }

    public <T> Object convertParam(T value, Class<T> type, Supplier<Type[]> genericType, Supplier<Annotation[][]> methodAnnotations, int paramIndex) {
        ParamConverter<T> converter = this.getConverter(type, genericType, methodAnnotations, paramIndex);
        if (converter != null) {
            return converter.toString(value);
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return value;
    }

    private <T> ParamConverter<T> getConverter(Class<T> type, Supplier<Type[]> genericType, Supplier<Annotation[][]> methodAnnotations, int paramIndex) {
        ParamConverterProvider converterProvider = this.providerForClass.get(type);
        if (converterProvider == null) {
            for (ParamConverterProvider provider : this.paramConverterProviders) {
                ParamConverter converter = provider.getConverter(type, genericType.get()[paramIndex], methodAnnotations.get()[paramIndex]);
                if (converter == null) continue;
                this.providerForClass.put(type, provider);
                return converter;
            }
            ParamConverter converter = DEFAULT_PROVIDER.getConverter(type, genericType.get()[paramIndex], methodAnnotations.get()[paramIndex]);
            if (converter != null) {
                this.providerForClass.put(type, DEFAULT_PROVIDER);
                return converter;
            }
            this.providerForClass.put(type, NO_PROVIDER);
        } else if (converterProvider != NO_PROVIDER) {
            return converterProvider.getConverter(type, genericType.get()[paramIndex], methodAnnotations.get()[paramIndex]);
        }
        return null;
    }
}

