/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.h2.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import org.h2.engine.SysProperties;

@TargetClass(value=org.h2.value.CompareMode.class)
public final class CompareMode {
    @Alias
    private static volatile CompareMode lastUsed;

    @Substitute
    public static CompareMode getInstance(String name, int strength, boolean binaryUnsigned) {
        if (name != null || strength != 0 || binaryUnsigned != SysProperties.SORT_BINARY_UNSIGNED) {
            throw new UnsupportedOperationException("Only the default Collator can be currently used in SubstrateVM; see https://github.com/oracle/graal/issues/839");
        }
        CompareMode var3 = lastUsed;
        if (var3 != null) {
            return var3;
        }
        lastUsed = var3 = new CompareMode(name, strength, binaryUnsigned);
        return var3;
    }

    @Alias
    protected CompareMode(String var1, int var2, boolean var3) {
    }
}

