/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.mariadb.deployment;

import io.quarkus.agroal.spi.JdbcDriverBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceConfigurationHandlerBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.jdbc.mariadb.runtime.MariaDBAgroalConnectionConfigurer;
import io.quarkus.jdbc.mariadb.runtime.MariaDBServiceBindingConverter;

public class JDBCMariaDBProcessor {
    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.JDBC_MARIADB);
    }

    @BuildStep
    void registerDriver(BuildProducer<JdbcDriverBuildItem> jdbcDriver, BuildProducer<DefaultDataSourceDbKindBuildItem> dbKind) {
        jdbcDriver.produce((BuildItem)new JdbcDriverBuildItem("mariadb", "org.mariadb.jdbc.Driver", "org.mariadb.jdbc.MariaDbDataSource"));
        dbKind.produce((BuildItem)new DefaultDataSourceDbKindBuildItem("mariadb"));
    }

    @BuildStep
    DevServicesDatasourceConfigurationHandlerBuildItem devDbHandler() {
        return DevServicesDatasourceConfigurationHandlerBuildItem.jdbc((String)"mariadb");
    }

    @BuildStep
    void configureAgroalConnection(BuildProducer<AdditionalBeanBuildItem> additionalBeans, Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.agroal")) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem.Builder().addBeanClass(MariaDBAgroalConnectionConfigurer.class).setDefaultScope(BuiltinScope.APPLICATION.getName()).setUnremovable().build());
        }
    }

    @BuildStep
    void registerAuthenticationPlugins(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"org.mariadb.jdbc.plugin.AuthenticationPlugin"));
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void addNativeImageResources(BuildProducer<NativeImageResourceBuildItem> resources) {
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"mariadb.properties"}));
    }

    @BuildStep
    void registerServiceBinding(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter", new String[]{MariaDBServiceBindingConverter.class.getName()}));
        }
    }
}

