/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.mysql.runtime.graal;

import com.mysql.cj.MysqlConnection;
import com.mysql.cj.jdbc.AbandonedConnectionCleanupThread;
import com.mysql.cj.protocol.NetworkResources;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Substitute
@TargetClass(value=AbandonedConnectionCleanupThread.class)
public final class AbandonedConnectionCleanupThreadSubstitutions
implements Runnable {
    private static Set<ConnectionFinalizerPhantomReference> connectionFinalizerPhantomReferences;
    private static ReferenceQueue<MysqlConnection> mysqlConnectionReferenceQueue;
    private static ExecutorService executorService;

    @Substitute
    private AbandonedConnectionCleanupThreadSubstitutions() {
    }

    public static void startCleanUp() {
        connectionFinalizerPhantomReferences = ConcurrentHashMap.newKeySet();
        mysqlConnectionReferenceQueue = new ReferenceQueue();
        executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.execute(new AbandonedConnectionCleanupThreadSubstitutions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Substitute
    public void run() {
        while (true) {
            try {
                while (true) {
                    Reference<MysqlConnection> reference;
                    if ((reference = mysqlConnectionReferenceQueue.remove(5000L)) == null) {
                        continue;
                    }
                    AbandonedConnectionCleanupThreadSubstitutions.finalizeResourceAndRemoveReference((ConnectionFinalizerPhantomReference)reference);
                }
            }
            catch (InterruptedException e) {
                ReferenceQueue<MysqlConnection> referenceQueue = mysqlConnectionReferenceQueue;
                synchronized (referenceQueue) {
                    Reference<MysqlConnection> reference;
                    while ((reference = mysqlConnectionReferenceQueue.poll()) != null) {
                        AbandonedConnectionCleanupThreadSubstitutions.finalizeResourceAndRemoveReference((ConnectionFinalizerPhantomReference)reference);
                    }
                    connectionFinalizerPhantomReferences.clear();
                }
                return;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    protected static void trackConnection(MysqlConnection conn, NetworkResources io) {
        ReferenceQueue<MysqlConnection> referenceQueue = mysqlConnectionReferenceQueue;
        synchronized (referenceQueue) {
            ConnectionFinalizerPhantomReference reference = new ConnectionFinalizerPhantomReference(conn, io, mysqlConnectionReferenceQueue);
            connectionFinalizerPhantomReferences.add(reference);
        }
    }

    private static void finalizeResourceAndRemoveReference(ConnectionFinalizerPhantomReference reference) {
        try {
            reference.finalizeResources();
            reference.clear();
        }
        finally {
            connectionFinalizerPhantomReferences.remove(reference);
        }
    }

    private static class ConnectionFinalizerPhantomReference
    extends PhantomReference<MysqlConnection> {
        private NetworkResources networkResources;

        ConnectionFinalizerPhantomReference(MysqlConnection conn, NetworkResources networkResources, ReferenceQueue<? super MysqlConnection> refQueue) {
            super(conn, refQueue);
            this.networkResources = networkResources;
        }

        void finalizeResources() {
            if (this.networkResources != null) {
                try {
                    this.networkResources.forceClose();
                }
                finally {
                    this.networkResources = null;
                }
            }
        }
    }
}

