/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.postgresql.runtime.graal;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.transform.dom.DOMResult;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.postgresql.core.BaseConnection;

public final class SQLXMLFeature
implements Feature {
    private final AtomicBoolean triggered = new AtomicBoolean(false);
    private static final boolean log = Boolean.getBoolean("io.quarkus.jdbc.postgresql.graalvm.diagnostics");

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class pgSQLXMLClass = access.findClassByName("io.quarkus.jdbc.postgresql.runtime.graal.PgSQLXML");
        try {
            Method triggerMethod = pgSQLXMLClass.getMethod("setResult", Class.class);
            access.registerReachabilityHandler(this::identifiedXMLProcessingInDriver, new Object[]{triggerMethod});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void identifiedXMLProcessingInDriver(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        boolean needsEnablingYet = this.triggered.compareAndSet(false, true);
        if (needsEnablingYet) {
            if (log) {
                System.out.println("Quarkus' automatic feature for GraalVM native images: enabling support for XML processing in the PostgreSQL JDBC driver");
            }
            this.enableDomXMLProcessingInDriver(duringAnalysisAccess);
        }
    }

    private void enableDomXMLProcessingInDriver(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        Class classByName = duringAnalysisAccess.findClassByName("io.quarkus.jdbc.postgresql.runtime.graal.DomHelper");
        try {
            Method method = classByName.getMethod("reallyProcessDomResult", DOMResult.class, BaseConnection.class);
            RuntimeReflection.register((Executable[])new Executable[]{method});
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

