/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jfr.runtime.http.rest.classic;

import io.quarkus.jfr.runtime.IdProducer;
import io.quarkus.jfr.runtime.http.rest.classic.ClassicServerRecorder;
import io.vertx.core.http.HttpServerRequest;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ResourceInfo;
import java.lang.reflect.Method;

@Dependent
public class ClassicServerRecorderProducer {
    @Inject
    HttpServerRequest vertxRequest;
    @Inject
    ResourceInfo resourceInfo;
    @Inject
    IdProducer idProducer;

    @Produces
    @RequestScoped
    public ClassicServerRecorder create() {
        String httpMethod = this.vertxRequest.method().name();
        String uri = this.vertxRequest.path();
        Class resourceClass = this.resourceInfo.getResourceClass();
        String resourceClassName = resourceClass == null ? null : resourceClass.getName();
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        String resourceMethodName = resourceMethod == null ? null : resourceMethod.getName();
        String client = this.vertxRequest.remoteAddress().toString();
        return new ClassicServerRecorder(httpMethod, uri, resourceClassName, resourceMethodName, client, this.idProducer);
    }
}

