/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jfr.runtime.http.rest.reactive;

import io.quarkus.jfr.runtime.http.rest.reactive.ReactiveServerRecorder;
import io.quarkus.jfr.runtime.http.rest.reactive.ResourceInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;

public class ReactiveServerFilters {
    private static final Logger LOG = Logger.getLogger(ReactiveServerFilters.class);
    private final ReactiveServerRecorder recorder;

    public ReactiveServerFilters(ReactiveServerRecorder recorder) {
        this.recorder = recorder;
    }

    @ServerRequestFilter
    public void requestFilter(SimpleResourceInfo resourceInfo) {
        Class resourceClass = resourceInfo.getResourceClass();
        if (resourceClass != null) {
            String resourceClassName = resourceClass.getName();
            String resourceMethodName = resourceInfo.getMethodName();
            this.recorder.updateResourceInfo(new ResourceInfo(resourceClassName, resourceMethodName)).commitStartEventIfNecessary();
        }
    }

    @ServerResponseFilter
    public void responseFilter() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Enter Jfr Reactive Response Filter");
        }
        this.recorder.recordEndEvent().endPeriodEvent();
    }
}

